/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.integracaohospitais.conexao.ConexaoIntegracaoHospitalServidor;
import jalis.laboratorio.ControlaTempoInativo;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.BeanCriaPdfWeb;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.exportacao.thread.ExportaWeb2;
import jalis.laboratorio.exportacao.thread.ThreadCriaPdfWeb;
import jalis.laboratorio.util.impressao.sql.ValorIn;
import jalis.laboratorio.util.impressao.sql.ValorInException;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.AbstractThreadBean;
import jalis.model.FabricaDao;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import jalis.util.sql.SalvaDadosException;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PGInterval;

public class DBUtil {
    private static final String INICIO_DETALHE = "[";
    private static final String FIM_DETALHE = "]";
    private static final String SEPARADOR_DETALHE = "|";
    public static final String ERRCODE_INSERT_FOREIGN_KEY_NAO_EXISTENTE = "IFKNE";
    public static final String ERRCODE_UPDATE_FOREIGN_KEY_NAO_EXISTENTE = "UFKNE";
    public static final int ALFANUMERICO = 0;
    public static final int NUMERICO = 1;
    public static final String INCLUSAO = "I";
    public static final String ALTERACAO = "A";
    public static final String EXCLUSAO = "E";

    public static boolean resultIsEmpty(ResultSet rst) {
        boolean retorno = true;
        if (rst != null) {
            try {
                retorno = !rst.next();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "resultIsEmpty");
                retorno = true;
            }
        }
        return retorno;
    }

    public static int qtdeRegistros(ResultSet rs) {
        int retorno = 0;
        try {
            rs.last();
            retorno = rs.getRow();
            rs.beforeFirst();
            return retorno;
        }
        catch (SQLException ex) {
            return retorno;
        }
    }

    public static String getSequencia(Statement st, String tabela, boolean checkFilial) throws SQLException {
        if (checkFilial) {
            return DBUtil.getSequencia(st, tabela, Variaveis.filialPadrao);
        }
        return DBUtil.getSequencia(st, tabela, "");
    }

    public static String getSequencia(Statement st, String tabela) throws SQLException {
        return DBUtil.getSequencia(st, tabela, "");
    }

    public static String getSequencia(Statement st, String tabela, String filial) throws SQLException {
        ResultSet rs;
        if (st != null) {
            String sequencia = tabela + (!Funcoes.textoVazio(filial) && Funcoes.isNumeric(filial) ? "_" + String.valueOf(Integer.parseInt(filial)) : "") + "_sequence";
            rs = st.executeQuery("select nextval('" + sequencia + "')");
            if (!rs.next()) {
                throw new SQLException("A sequencia \"" + sequencia + "\" n\u00e3o foi gerada.");
            }
        } else {
            throw new SQLException("O Statement da gera\u00e7\u00e3o da sequencia est\u00e1 NULL.");
        }
        String retorno = rs.getString(1);
        return retorno;
    }

    public static String formatarValorParaIntegracao(String filial, String valor, boolean integrar, int casasFormatacao) {
        return integrar && !Funcoes.textoVazio(filial) ? filial + Funcoes.preencheZero(valor, casasFormatacao) : valor;
    }

    public static String getMaiorCodigo(Statement st, String tabela, String campo, String filtro) {
        String retorno;
        block7: {
            if (ControlaTempoInativo.contando()) {
                ControlaTempoInativo.parar();
            }
            if (st != null) {
                try {
                    ResultSet rs;
                    StringBuilder buf = new StringBuilder("select max(");
                    buf.append(campo);
                    buf.append(") from ");
                    buf.append(tabela);
                    if (filtro != null && !Funcoes.textoVazio(filtro)) {
                        buf.append(" where ");
                        buf.append(filtro);
                    }
                    if ((rs = Conexao.executeQuery(st, buf.toString())) != null && rs.next()) {
                        retorno = String.valueOf(rs.getInt(1) + 1);
                        rs.close();
                        break block7;
                    }
                    retorno = "0";
                }
                catch (SQLException sqlex) {
                    retorno = "0";
                }
            } else {
                retorno = "0";
            }
        }
        ControlaTempoInativo.iniciar();
        return retorno;
    }

    public static boolean checkPK(Component component, Statement statement, String campo, String valor, int tipoCampo, String[] tabelas) {
        return DBUtil.checkPK(component, statement, campo, valor, tipoCampo, "", tabelas);
    }

    public static boolean checkPK(Component component, Statement statement, String campo, String valor, int tipoCampo, String filtro, String[] tabelas) {
        return DBUtil.checkPK(component, true, statement, campo, valor, tipoCampo, filtro, tabelas);
    }

    public static boolean checkPK(Component component, boolean mostrarMensagem, Statement statement, String campo, String valor, int tipoCampo, String filtro, String[] tabelas) {
        boolean retorno = true;
        if (ControlaTempoInativo.contando()) {
            ControlaTempoInativo.parar();
        }
        for (int i = 0; i < tabelas.length; ++i) {
            if (!retorno) continue;
            try {
                ResultSet rs;
                StringBuilder buf = new StringBuilder("select count(*) from ");
                buf.append(tabelas[i]);
                buf.append(" where ");
                if (tipoCampo == 0) {
                    buf.append("upper(");
                    buf.append(campo);
                    buf.append(")");
                } else {
                    buf.append(campo);
                }
                buf.append(" = ");
                if (tipoCampo == 0) {
                    buf.append("upper(");
                    buf.append(StringUtil.textoDBEscape(valor));
                    buf.append(")");
                } else {
                    buf.append(valor);
                }
                if (!Funcoes.textoVazio(filtro)) {
                    buf.append(" and ");
                    buf.append(filtro);
                }
                if ((rs = Conexao.executeQuery(statement, buf.toString())).next()) {
                    retorno = rs.getInt(1) == 0;
                }
                rs.close();
                continue;
            }
            catch (SQLException sqlex) {
                retorno = false;
            }
        }
        if (!retorno && mostrarMensagem) {
            Funcoes.mensagem(component, "O registro n\u00e3o pode ser exclu\u00eddo pois est\u00e1 sendo utilizado em outra tabela", 1);
        }
        ControlaTempoInativo.iniciar();
        return retorno;
    }

    public static boolean campoNull(String campo) {
        return campo == null || campo.equalsIgnoreCase("null");
    }

    public static double campoDouble(Double campo) {
        if (campo == null) {
            return 0.0;
        }
        return campo;
    }

    public static boolean feriado(String data) {
        return DBUtil.feriado(data, Conexao.getStatement());
    }

    public static boolean feriado(String data, Statement st) {
        return DBUtil.feriado(Variaveis.filialPadrao, data, st);
    }

    public static boolean feriado(String filial, String data, Statement st) {
        boolean retorno = false;
        try {
            StringBuilder s = new StringBuilder("select fer_dia from feriados where ");
            s.append("fil_codigo = ");
            s.append(filial);
            s.append(" and (extract(month from fer_dia)=");
            s.append(Funcoes.formataData("MM", data));
            s.append(" and extract(day from fer_dia)=");
            s.append(Funcoes.formataData("dd", data));
            s.append(" and fer_fixo=true) or (fer_dia = '");
            s.append(Funcoes.formataData("MM/dd/yyyy", data));
            s.append("')");
            ResultSet rs = st.executeQuery(s.toString());
            retorno = rs.next();
        }
        catch (SQLException sqlex) {
            ErrorLogger.mostraMensagem(null, sqlex.getMessage(), sqlex.getStackTrace(), "feriado (292)");
        }
        return retorno;
    }

    public static String getDescricao(String sql, String filtro, String campoRetorno) throws SQLException {
        String retorno = "";
        if (ControlaTempoInativo.contando()) {
            ControlaTempoInativo.parar();
        }
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder(sql);
        buf.append(" where ");
        buf.append(filtro);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        retorno = rs.next() ? rs.getString(campoRetorno) : "N\u00e3o cadastrado";
        rs.close();
        Conexao.fecharStatement(st);
        ControlaTempoInativo.iniciar();
        return retorno;
    }

    public static String getDescricao(String campoBusca, String campoRetorno, int valor, String tabela) throws SQLException {
        return DBUtil.getDescricao(campoBusca, campoRetorno, String.valueOf(valor), tabela);
    }

    public static String getDescricao(String campoBusca, String campoRetorno, String valor, String tabela) throws SQLException {
        return DBUtil.getDescricao(campoBusca, campoRetorno, valor, tabela, false);
    }

    public static String getDescricao(String campoBusca, String campoRetorno, String valor, String tabela, String filial) throws SQLException {
        return DBUtil.getDescricao(campoBusca, campoRetorno, valor, tabela, false, filial);
    }

    public static String getDescricao(String campoBusca, String campoRetorno, String valor, String tabela, boolean ignorarFilial, String filial) throws SQLException {
        return DBUtil.getDescricao("select " + campoRetorno + " from " + tabela, (ignorarFilial ? "" : "fil_codigo = " + (Funcoes.textoVazio(filial) ? Variaveis.filialPadrao : filial) + " and ") + campoBusca + " = " + StringUtil.textoDBEscape(String.valueOf(valor)), campoRetorno);
    }

    public static String getDescricao(String campoBusca, String campoRetorno, String valor, String tabela, boolean ignorarFilial) throws SQLException {
        return DBUtil.getDescricao("select " + campoRetorno + " from " + tabela, (ignorarFilial ? "" : "fil_codigo = " + Variaveis.filialPadrao + " and ") + campoBusca + " = " + StringUtil.textoDBEscape(String.valueOf(valor)), campoRetorno);
    }

    public static void insereExportaWeb(Statement st, String tabela, String tipoOperacao, boolean exportaPdfWeb, String ... comando) throws SQLException {
        DBUtil.insereExportaWeb(st, tabela, tipoOperacao, "", exportaPdfWeb, comando);
    }

    public static void insereExportaWeb(Statement st, String tabela, String tipoOperacao, String ... comando) throws SQLException {
        DBUtil.insereExportaWeb(st, tabela, tipoOperacao, "", false, comando);
    }

    public static void insereExportaWeb(String filialOrigem, Statement st, String tabela, String tipoOperacao, boolean exportaPdfWeb, String ... comando) throws SQLException {
        DBUtil.insereExportaWeb(st, filialOrigem, tabela, tipoOperacao, "", exportaPdfWeb, true, comando);
    }

    public static void insereExportaWeb(String filialOrigem, Statement st, String tabela, String tipoOperacao, String ... comando) throws SQLException {
        DBUtil.insereExportaWeb(st, filialOrigem, tabela, tipoOperacao, "", false, true, comando);
    }

    private static void insereExportaWeb(Statement st, String tabela, String tipoOperacao, String filiais, boolean exportaPdfWeb, String ... comando) throws SQLException {
        DBUtil.insereExportaWeb(st, Variaveis.filialPadrao, tabela, tipoOperacao, filiais, exportaPdfWeb, true, comando);
    }

    public static void insereExportaWeb(Statement st, String tabela, String tipoOperacao, String filiais, String ... comando) throws SQLException {
        DBUtil.insereExportaWeb(st, Variaveis.filialPadrao, tabela, tipoOperacao, filiais, false, true, comando);
    }

    public static void insereExportaWebGerarResultadoPDF(String filialOrigem, Statement st, String tabela, String tipoOperacao, boolean exportaPdfWeb, boolean gerarResultadoPDF, String ... comando) throws SQLException {
        DBUtil.insereExportaWeb(st, filialOrigem, tabela, tipoOperacao, "", exportaPdfWeb, gerarResultadoPDF, comando);
    }

    private static Long getUltimoValorSequence(Statement st, String sequence) throws SQLException {
        Long retorno = -1L;
        StringBuilder buf = new StringBuilder();
        buf.append(" select nextval('").append(sequence).append("') ");
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            retorno = rs.getLong("nextval");
        }
        return retorno;
    }

    public static void insereExportaWeb(Statement st, String filialOrigem, String tabela, String tipoOperacao, String filiais, boolean exportaPdfWeb, boolean gerarResultadoPDF, String ... comando) throws SQLException {
        try {
            String[] codigos;
            FilialService filialService = new FilialService();
            String[] stringArray = codigos = new String[]{filialOrigem};
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String requisicaoXml;
                String filial;
                String codigoFilial = filial = stringArray[i];
                if (Funcoes.isNumeric(filial) && filial.startsWith("0")) {
                    codigoFilial = String.valueOf(Integer.parseInt(filial));
                }
                if (!Funcoes.isExportaWeb(st, filial)) continue;
                FilialVOAux filialVO = filialService.getDadosExportaBaseWeb(st, filial);
                String baseWeb = ExportaWeb.getCodigoBaseWeb(st, codigoFilial);
                Long codigoLog = DBUtil.getUltimoValorSequence(st, "exportaweb_" + codigoFilial + "_sequence");
                StringBuilder bufAux = new StringBuilder();
                StringBuilder bufExportaWeb = new StringBuilder();
                StringBuilder bufIntegracaoOffline = new StringBuilder();
                bufAux.append("insert into exportaweb(fil_codigo, ewe_codigo, ewe_datahora, ");
                bufAux.append(" ewe_exportado, ewe_operacao, ewe_tipooperacao) values (");
                bufAux.append(codigoFilial);
                bufAux.append(",");
                bufExportaWeb.append(bufAux.toString());
                bufExportaWeb.append(codigoLog);
                bufIntegracaoOffline.append(bufAux.toString());
                bufIntegracaoOffline.append("nextval('exportaweb_" + codigoFilial + "_sequence')");
                bufAux.setLength(0);
                bufAux.append(", current_timestamp, false, '");
                bufAux.append("<");
                bufAux.append(tabela);
                bufAux.append(">");
                for (int i2 = 0; i2 < comando.length; i2 += 2) {
                    bufAux.append("<");
                    bufAux.append(comando[i2]);
                    bufAux.append(">");
                    bufAux.append(StringUtil.textoXML(StringUtil.tratarUnicode(comando[i2 + 1], true)));
                    bufAux.append("</");
                    bufAux.append(comando[i2]);
                    bufAux.append(">");
                }
                bufAux.append("</");
                bufAux.append(tabela);
                bufAux.append(">");
                bufAux.append("', '");
                bufAux.append(tipoOperacao);
                bufAux.append("')");
                bufExportaWeb.append(bufAux.toString());
                bufIntegracaoOffline.append(bufAux.toString());
                String insert = StringUtil.limpaCdata(bufExportaWeb.toString());
                st.executeUpdate(insert);
                if (DBUtil.geraLogIntegracao(st, filial)) {
                    IntegracaoUtil.insereComandoLog(st, filial, filial, StringUtil.limpaCdata(bufIntegracaoOffline.toString()));
                }
                String operacao = "";
                boolean filialGeraPdf = ExportaWeb2.isGerarPdfResultado(st, codigoFilial);
                if (exportaPdfWeb && filialGeraPdf) {
                    operacao = Laboratorio.isNovaWeb() ? ExportaWeb2.getOperacaoConexaoJalis(st, codigoFilial, "" + codigoLog) : ExportaWeb.getOperacaoConexaoJalis(st, codigoFilial, "" + codigoLog);
                    BeanCriaPdfWeb beanCriaPdfWeb = new BeanCriaPdfWeb(filialOrigem, tipoOperacao, filiais, codigoFilial, "" + codigoLog, operacao, gerarResultadoPDF);
                    ThreadCriaPdfWeb.addLog(beanCriaPdfWeb);
                    continue;
                }
                if (!exportaPdfWeb || filialGeraPdf || Funcoes.textoVazio(operacao = ExportaWeb.getOperacaoConexaoJalis(st, codigoFilial, "" + codigoLog)) || Funcoes.textoVazio(requisicaoXml = StringUtil.getValor(operacao, "codigoRequisicao"))) continue;
                String codigoRequisicao = "";
                codigoRequisicao = requisicaoXml.length() > ParametrosGerais.getDigitosTuboRequisicao() ? StringUtil.removeZerosEsquerda(requisicaoXml.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial())) : requisicaoXml;
                String codigoExame = StringUtil.getValor(operacao, "codigoExameRequisicao");
                String codigoMaterial = StringUtil.getValor(operacao, "materialExameRequisicao");
                String codigoBase = StringUtil.getValor(operacao, "codigoBase");
                if (Funcoes.textoVazio(filialOrigem) || Funcoes.textoVazio(codigoRequisicao) || Funcoes.textoVazio(codigoExame) || Funcoes.textoVazio(codigoMaterial) || Funcoes.textoVazio(codigoBase)) continue;
                ExportaWeb2.atualizaPaginaOrdemExameWeb(null, filialOrigem, codigoRequisicao, codigoExame, codigoMaterial, codigoBase);
            }
        }
        catch (Exception eee) {
            try {
                st.getConnection().rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel processar thread exporta web", eee.getStackTrace());
        }
    }

    public static void insereExportaWebSoInsert(Statement st, String filialOrigem, String tabela, String tipoOperacao, String filiais, boolean exportaPdfWeb, String ... comando) throws SQLException {
        try {
            String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
            FilialService filService = new FilialService();
            if (DBUtil.carregaAutoCopia(filialOrigem, codigos)) {
                codigos = new String[]{filialOrigem};
            }
            String[] stringArray = codigos;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String filial;
                String codigoFilial = filial = stringArray[i];
                if (Funcoes.isNumeric(filial) && filial.startsWith("0")) {
                    codigoFilial = String.valueOf(Integer.parseInt(filial));
                }
                if (!Funcoes.isExportaWeb(st, filial)) continue;
                String baseWeb = ExportaWeb.getCodigoBaseWeb(st, codigoFilial);
                Long codigoLog = DBUtil.getUltimoValorSequence(st, "exportaweb_" + codigoFilial + "_sequence");
                StringBuilder bufAux = new StringBuilder();
                StringBuilder bufExportaWeb = new StringBuilder();
                StringBuilder bufIntegracaoOffline = new StringBuilder();
                bufAux.append("insert into exportaweb(fil_codigo, ewe_codigo, ewe_datahora, ");
                bufAux.append(" ewe_exportado, ewe_operacao, ewe_tipooperacao) values (");
                bufAux.append(codigoFilial);
                bufAux.append(",");
                bufExportaWeb.append(bufAux.toString());
                bufExportaWeb.append(codigoLog);
                bufIntegracaoOffline.append(bufAux.toString());
                bufIntegracaoOffline.append("nextval('exportaweb_" + codigoFilial + "_sequence')");
                bufAux.setLength(0);
                bufAux.append(", current_timestamp, false, '");
                bufAux.append("<");
                bufAux.append(tabela);
                bufAux.append(">");
                for (int i2 = 0; i2 < comando.length; i2 += 2) {
                    bufAux.append("<");
                    bufAux.append(comando[i2]);
                    bufAux.append(">");
                    bufAux.append(StringUtil.textoXML(StringUtil.tratarUnicode(comando[i2 + 1], true)));
                    bufAux.append("</");
                    bufAux.append(comando[i2]);
                    bufAux.append(">");
                }
                bufAux.append("</");
                bufAux.append(tabela);
                bufAux.append(">");
                bufAux.append("', '");
                bufAux.append(tipoOperacao);
                bufAux.append("')");
                bufExportaWeb.append(bufAux.toString());
                bufIntegracaoOffline.append(bufAux.toString());
                String insert = StringUtil.limpaCdata(bufExportaWeb.toString());
                st.executeUpdate(insert);
                if (!DBUtil.geraLogIntegracao(st, filial)) continue;
                IntegracaoUtil.insereComandoLog(st, filial, filial, StringUtil.limpaCdata(bufIntegracaoOffline.toString()));
            }
        }
        catch (Exception eee) {
            try {
                st.getConnection().rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel processar thread exporta web", eee.getStackTrace());
        }
    }

    private static boolean geraLogIntegracao(Statement st, String filial) throws SQLException {
        return IntegracaoUtil.isFilialParaIntegrar(st, filial) && !ParametrosGerais.getTipoIntegracao().equals("W");
    }

    private static boolean carregaAutoCopia(String filialOrigem, String[] codigos) {
        return codigos == null || codigos.length == 0 || DBUtil.localizaFilialCopia(codigos, filialOrigem) < 0;
    }

    public static String getUFCidade(Statement st, String codigoCidade) {
        if (st == null || Funcoes.textoVazio(codigoCidade)) {
            return "";
        }
        String retorno = "";
        StringBuilder buf = new StringBuilder("select cid_uf from cidades where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and cid_codigo = ");
        buf.append(codigoCidade);
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                retorno = rs.getString("cid_uf");
            }
            rs.close();
        }
        catch (SQLException sqlex) {
            retorno = "";
            ErrorLogger.mostraMensagem(null, sqlex.getMessage(), sqlex.getStackTrace(), "getUFCidade");
        }
        return retorno;
    }

    public static boolean procuraRequisicaoPeriodo(int paciente, String exame, int material, int convenio, int prazo) throws SQLException {
        boolean retorno = false;
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select req_codigo from requisicao where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and pac_codigo = ");
        buf.append(paciente);
        buf.append(" and req_data >= '");
        buf.append(Funcoes.formataData("MM/dd/yyyy", Funcoes.subtraiDias(new java.util.Date(), prazo)));
        buf.append("'");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        retorno = rs.next();
        if (retorno) {
            boolean ok = true;
            buf.delete(0, buf.length());
            buf.append("select exa_codigo from examerequisicao where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and req_codigo in (");
            while (ok) {
                buf.append(rs.getInt("req_codigo"));
                ok = rs.next();
                if (!ok) continue;
                buf.append(", ");
            }
            buf.append(") and exa_codigo = ").append(StringUtil.textoDBEscape(exame));
            buf.append(" and mco_codigo = ");
            buf.append(material);
            rs.close();
            rs = Conexao.executeQuery(st, buf.toString());
            retorno = rs.next();
        }
        rs.close();
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static boolean existeFilial(int fil_codigo) {
        boolean retorno = false;
        Statement st = Conexao.getStatement();
        try {
            StringBuilder s = new StringBuilder("select fil_codigo from filiais_postocoleta where ");
            s.append("fil_codigo = ");
            s.append(String.valueOf(fil_codigo));
            ResultSet rs = Conexao.executeQuery(st, s.toString());
            boolean bl = retorno = rs != null && rs.next();
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        catch (SQLException sqlex) {
            ErrorLogger.mostraMensagem(null, sqlex.getMessage(), sqlex.getStackTrace(), "existeFilial");
        }
        return retorno;
    }

    public static void gravaAutoCopia(Statement st, SalvaDados salvar, String campoFilial, String filiais) throws SQLException, SalvaDadosException {
        DBUtil.gravaAutoCopia(st, salvar, campoFilial, filiais, null, 1);
    }

    public static void gravaAutoCopia(Statement st, SalvaDados salvar, String campoFilial, String filiais, SalvaDados selectCondicional) throws SQLException, SalvaDadosException {
        DBUtil.gravaAutoCopia(Variaveis.filialPadrao, st, salvar, campoFilial, filiais, null, 1, false, -1L, selectCondicional);
    }

    public static void gravaAutoCopia(String codigoFilial, Statement st, SalvaDados salvar, String campoFilial, String filiais) throws SQLException, SalvaDadosException {
        DBUtil.gravaAutoCopia(codigoFilial, st, salvar, campoFilial, filiais, null, 1, false, -1L, null);
    }

    public static void gravaAutoCopia(Statement st, SalvaDados salvar, String campoFilial, String filiais, String sequencia, int valorSequencia) throws SQLException, SalvaDadosException {
        DBUtil.gravaAutoCopia(Variaveis.filialPadrao, st, salvar, campoFilial, filiais, sequencia, valorSequencia);
    }

    public static void gravaAutoCopia(String filialPadrao, Statement st, SalvaDados salvar, String campoFilial, String filiais, String sequencia, int valorSequencia) throws SQLException, SalvaDadosException {
        DBUtil.gravaAutoCopia(filialPadrao, st, salvar, campoFilial, filiais, sequencia, valorSequencia, false, -1L, null);
    }

    public static void gravaAutoCopia(String filialPadrao, Statement st, SalvaDados salvar, String campoFilial, String filiais, String sequencia, int valorSequencia, boolean pulaFilialOrigem, long codigoOrigem, SalvaDados selectCondicional) throws SQLException, SalvaDadosException {
        String[] codigos;
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos.length == 0 || DBUtil.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = new String[]{filialPadrao};
        }
        for (String s : codigos) {
            String comando;
            salvar.setValor(campoFilial, s);
            if (selectCondicional != null) {
                selectCondicional.setValor(campoFilial, s);
            }
            if (Funcoes.textoVazio(comando = salvar.getComando()) || pulaFilialOrigem && Integer.parseInt(s) == Integer.parseInt(filialPadrao)) continue;
            boolean podeExecutar = true;
            if (selectCondicional != null) {
                String select = selectCondicional.getSelect();
                ResultSet rs = Conexao.executeQuery(st, select);
                podeExecutar = rs.next();
                rs.close();
            }
            if (podeExecutar) {
                try {
                    Conexao.executeUpdate(s, st, comando);
                }
                catch (SQLException e) {
                    Conexao.anulaSQL();
                    throw new SQLException("Gravando auto-c\u00f3pia da filial \"" + s + "\".\n" + e.getMessage(), e);
                }
            }
            if (sequencia == null || Funcoes.textoVazio(sequencia) || s.equalsIgnoreCase(filialPadrao) || salvar.getOperacao() != 0) continue;
            StringBuilder buf = new StringBuilder("select setval('");
            buf.append(sequencia);
            buf.append("_");
            buf.append(s);
            buf.append("_sequence', ");
            buf.append(codigoOrigem < 0L ? Integer.valueOf(valorSequencia) : String.valueOf(codigoOrigem));
            buf.append(")");
            st.execute(buf.toString());
        }
    }

    public static void gravaAutoCopiaWeb(String chave, String filialOrigem, String filiaisCopia, Statement st, String[] comandoWeb, int campoBaseWeb, String operacaoWeb, boolean pulaFilialOrigem) throws SQLException, SalvaDadosException {
        String[] codigos = filiaisCopia != null ? StringUtil.getValor(filiaisCopia, "filiais").split(",") : new String[]{};
        FilialService filService = new FilialService();
        ArrayList<String> enviar = new ArrayList<String>();
        if (codigos.length > 1 && DBUtil.localizaFilialCopia(codigos, filialOrigem) < 0) {
            return;
        }
        for (String filial : codigos) {
            FilialVOAux filialVO;
            if (pulaFilialOrigem || filial.equals(filialOrigem) || !DBUtil.carregouVO(filialVO = filService.getDadosExportaBaseWeb(st, filial))) continue;
            enviar.add(filialVO.getTipoBase());
        }
        Iterator iterator = enviar.iterator();
        while (iterator.hasNext()) {
            String c;
            comandoWeb[campoBaseWeb] = c = (String)iterator.next();
            DBUtil.insereExportaWeb(st, chave, operacaoWeb, comandoWeb);
        }
    }

    private static boolean carregouVO(FilialVOAux filialVO) {
        return filialVO != null;
    }

    private static int localizaFilialCopia(String[] a, String o) {
        if (a != null) {
            for (int i = 0; i < a.length; ++i) {
                if (!a[i].equals(o)) continue;
                return i;
            }
        }
        return -1;
    }

    public static void gravaLogXML(Statement st, String filial, String sql, String tabela, String tela, String codigoPesquisa, String[] camposPK, String operacao, String motivo) throws Exception {
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            Registro r = new Registro(rs);
            DBUtil.gravaLogXML(st, filial, r, tabela, tela, codigoPesquisa, camposPK, operacao, motivo);
        }
    }

    public static void gravaLogXML(Statement st, String filial, Registro[] regs, String[] tabelas, String tela, String codigoPesquisa, String[] camposPK, String operacao, String motivo) throws Exception {
        if (regs == null || tabelas == null || regs.length != tabelas.length) {
            return;
        }
        String tabela = tabelas[0];
        SalvaDados salvar = new SalvaDados("log", 0);
        String codigo = DBUtil.getSequencia(st, "log", true);
        StringBuilder xml = new StringBuilder();
        xml.append("<registros>");
        for (int i = 0; i < regs.length; ++i) {
            xml.append(DBUtil.criaXML(tabelas[i], regs[i], camposPK));
        }
        xml.append("</registros>");
        salvar.adicionaCampo("fil_codigo", 2, false, true, filial);
        salvar.adicionaCampo("log_codigo", 2, false, true, codigo);
        salvar.adicionaCampo("log_tabela", 0, true, false, tabela);
        salvar.adicionaCampo("log_tela", 0, true, false, tela);
        salvar.adicionaCampo("log_codigopesquisa", 0, true, false, codigoPesquisa);
        salvar.adicionaCampo("usr_codigo", 0, true, false, Variaveis.login);
        salvar.adicionaCampo("log_tipooperacao", 0, true, false, operacao);
        salvar.adicionaCampo("log_operacao", 0, true, false, StringUtil.textoDB(xml.toString()));
        salvar.adicionaCampo("log_motivo", 0, true, false, StringUtil.textoDB(motivo));
        String comando = salvar.getComando();
        if (!Funcoes.textoVazio(comando)) {
            Conexao.execute(filial, st, comando, true);
        }
    }

    public static void gravaLogXML(Statement st, String filial, Registro reg, String tabela, String tela, String codigoPesquisa, String[] camposPK, String operacao, String motivo) throws Exception {
        SalvaDados salvar = new SalvaDados("log", 0);
        String codigo = DBUtil.getSequencia(st, "log", true);
        StringBuilder xml = new StringBuilder();
        xml.append("<registros>");
        xml.append(DBUtil.criaXML(tabela, reg, camposPK));
        xml.append("</registros>");
        salvar.adicionaCampo("fil_codigo", 2, false, true, filial);
        salvar.adicionaCampo("log_codigo", 2, false, true, codigo);
        salvar.adicionaCampo("log_tabela", 0, true, false, tabela);
        salvar.adicionaCampo("log_tela", 0, true, false, tela);
        salvar.adicionaCampo("log_codigopesquisa", 0, true, false, codigoPesquisa);
        salvar.adicionaCampo("usr_codigo", 0, true, false, Variaveis.login);
        salvar.adicionaCampo("log_tipooperacao", 0, true, false, operacao);
        salvar.adicionaCampo("log_operacao", 0, true, false, StringUtil.textoDB(xml.toString()));
        salvar.adicionaCampo("log_motivo", 0, true, false, motivo);
        String comando = salvar.getComando();
        if (!Funcoes.textoVazio(comando)) {
            Conexao.execute(filial, st, comando, true);
        }
    }

    public static String criaXML(String tabela, Registro reg, String[] camposPK) {
        StringBuilder buf = new StringBuilder();
        buf.append("<registro>");
        buf.append("<tabela>").append(tabela).append("</tabela>");
        buf.append("<campos>");
        for (String key : reg.getKeySet()) {
            buf.append("<campo><nome>");
            buf.append(key);
            buf.append("</nome><tipo>");
            int tipoCampo = 0;
            Object valor = reg.getValor(key);
            tipoCampo = valor == null ? 2 : (reg.isBoolean(key) ? 4 : (reg.isNumber(key) ? 2 : (reg.isDate(key) ? 1 : (reg.isTime(key) ? 3 : (reg.isTimestamp(key) ? 5 : 0)))));
            buf.append(tipoCampo);
            buf.append("</tipo><valor>");
            buf.append(valor instanceof String ? DBUtil.trocaSinais(valor.toString(), false) : valor);
            buf.append("</valor><chave>");
            buf.append(DBUtil.isPK(key, camposPK) ? "1" : "0");
            buf.append("</chave></campo>");
        }
        buf.append("</campos></registro>");
        return buf.toString();
    }

    private static boolean isPK(String coluna, String[] camposPK) {
        return ArraysUtil.indice((Object[])camposPK, coluna) > -1;
    }

    public static String trocaSinais(String texto, boolean retornar) {
        if (retornar) {
            return texto.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        }
        return texto.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String testaTipoCampo(Object valor, int tipo, boolean verificarTexto) {
        if (valor == null || valor instanceof String && (Funcoes.textoVazio(valor.toString()) || valor.toString().equalsIgnoreCase("null"))) {
            return "null";
        }
        String retorno = "";
        switch (tipo) {
            case -7: 
            case 16: {
                if (Boolean.valueOf(valor.toString()).booleanValue()) {
                    retorno = "true";
                    break;
                }
                retorno = "false";
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (Funcoes.isNumeric(valor.toString())) {
                    retorno = Funcoes.limpaDecimal(valor.toString());
                    break;
                }
                retorno = "null";
                break;
            }
            case 91: {
                String temp = Funcoes.formataData((Date)valor);
                if (Funcoes.verificaData(temp)) {
                    retorno = "'" + Funcoes.formataData("yyyy-MM-dd", temp) + "'";
                    break;
                }
                retorno = "null";
                break;
            }
            case 92: {
                String temp = Funcoes.formataHora((Time)valor, false);
                if (Funcoes.verificaHora(temp)) {
                    retorno = "'" + Funcoes.formataData("HH:mm:ss.SSS", (Time)valor) + "'";
                    break;
                }
                retorno = "null";
                break;
            }
            case 93: {
                if (valor instanceof Timestamp && valor != null) {
                    retorno = "'" + Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", (Timestamp)valor) + "'";
                    break;
                }
                retorno = "null";
                break;
            }
            default: {
                retorno = verificarTexto ? StringUtil.textoDBEscape(valor.toString()) : "'" + valor.toString() + "'";
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] pegaColunasPK(Statement st, String tabela) throws Exception {
        try (ResultSet rs = Conexao.executeQuery(st, "select c.oid from pg_catalog.pg_class c left join pg_catalog.pg_namespace n on n.oid = c.relnamespace where upper(c.relname) = upper('" + tabela + "')");){
            int oid = -1;
            String colunas = "";
            if (rs.next()) {
                oid = rs.getInt(1);
            }
            if (oid > -1 && (rs = Conexao.executeQuery(st, "select pg_catalog.pg_get_indexdef(i.indexrelid, 0, true) from pg_catalog.pg_class c, pg_catalog.pg_class c2, pg_catalog.pg_index i where c.oid = " + String.valueOf(oid) + " and c.oid = i.indrelid and i.indexrelid = c2.oid and i.indisprimary = true")).next()) {
                colunas = rs.getString(1);
            }
            if (!Funcoes.textoVazio(colunas)) {
                colunas = colunas.substring(colunas.toUpperCase().indexOf("BTREE") + 6);
                if ((colunas = colunas.trim()).startsWith("(")) {
                    colunas = colunas.substring(1);
                }
                if (colunas.endsWith(")")) {
                    colunas = colunas.substring(0, colunas.length() - 1);
                }
                String[] stringArray = colunas.split(",");
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
    }

    public static String bdText(String str) {
        return str == null || str.equals("null") ? "null" : StringUtil.textoDBEscape(str);
    }

    public static synchronized boolean existeExame(Statement st, String fil_codigo, String exa_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo from exames where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        ResultSet rs = Conexao.executeQuery(st, query.toString());
        return rs != null && rs.next();
    }

    public static synchronized void setExameSituacaoInterfaceamento(Statement st, String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, int nova_situacao) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicao set ier_situacao = ");
        query.append(nova_situacao);
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
    }

    public static void gravaLogSituacaoExameRequisicao(Statement st, String filial, String requisicao, String exame, String material, String situacao, boolean isInsertExameRequisicao) throws SQLException {
        DBUtil.gravaLogSituacaoExameRequisicao(st, filial, requisicao, exame, material, Variaveis.login, situacao, isInsertExameRequisicao);
    }

    public static void gravaLogSituacaoExameRequisicaoPerformance(Statement st, String filial, String requisicao, String exame, String material, String situacao, boolean isInsertExameRequisicao) throws SQLException {
        DBUtil.gravaLogSituacaoExameRequisicaoPerformance(st, filial, requisicao, exame, material, Variaveis.login, situacao, isInsertExameRequisicao, null, null);
    }

    public static void gravaLogSituacaoExameRequisicao(Statement st, String filial, String requisicao, String exame, String material, String situacao, boolean isInsertExameRequisicao, String motivoRecoleta, String justificativaRecoleta) throws SQLException {
        DBUtil.gravaLogSituacaoExameRequisicaoPerformance(st, filial, requisicao, exame, material, Variaveis.login, situacao, isInsertExameRequisicao, motivoRecoleta, justificativaRecoleta);
    }

    public static void gravaLogSituacaoExameRequisicao(Statement st, String filial, String requisicao, String exame, String material, String usuario, String situacao, boolean isInsertExameRequisicao) throws SQLException {
        DBUtil.gravaLogSituacaoExameRequisicaoPerformance(st, filial, requisicao, exame, material, situacao, isInsertExameRequisicao);
    }

    public static void gravaLogSituacaoExameRequisicaoPerformance(Statement st, String filial, String requisicao, String exame, String material, String usuario, String situacao, boolean isInsertExameRequisicao, String motivoRecoleta, String justificativaRecoleta) throws SQLException {
        if (new ExameRequisicaoService().examePossuiExameRequisicaoPerformance(st, filial, requisicao, exame, material)) {
            if (!isInsertExameRequisicao) {
                StringBuilder query = new StringBuilder();
                query.append("select trim(exr_situacao) as situacao from examerequisicao where fil_codigo = ").append(filial);
                query.append(" and req_codigo = ").append(requisicao);
                query.append(" and exa_codigo = '").append(exame).append("'");
                query.append(" and mco_codigo = ").append(material);
                query.append(" and trim(exr_situacao) = '").append(situacao.trim()).append("';");
                ResultSet rs = Conexao.executeQueryPerformance(st, query.toString());
                if (!rs.next()) {
                    StringBuilder bui = DBUtil.geraInsertExameRequisicaoSituacao(filial, requisicao, exame, material, usuario, situacao, motivoRecoleta, justificativaRecoleta);
                    Conexao.executePerformance(filial, st, bui.toString(), false);
                }
            } else {
                StringBuilder bui = DBUtil.geraInsertExameRequisicaoSituacao(filial, requisicao, exame, material, usuario, situacao, motivoRecoleta, justificativaRecoleta);
                Conexao.executePerformance(filial, st, bui.toString(), false);
            }
        }
    }

    public static void gravaLogSituacaoExameRequisicaoConexaoTemporaria(Statement st, String filial, String requisicao, String exame, String material, String situacao) throws SQLException {
        if (st == null) {
            st = ConexaoTemporaria.getStatement();
        }
        try {
            StringBuilder bui = DBUtil.geraInsertExameRequisicaoSituacao(filial, requisicao, exame, material, Variaveis.login, situacao, null, null);
            ConexaoTemporaria.execute(filial, st, bui);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaLogSituacaoExameRequisicaoConexaoTemporaria(String filial, String requisicao, String exame, String material, String situacao) throws SQLException {
        try (Statement st = ConexaoTemporaria.getStatement();){
            StringBuilder bui = DBUtil.geraInsertExameRequisicaoSituacao(filial, requisicao, exame, material, Variaveis.login, situacao, null, null);
            ConexaoTemporaria.execute(filial, st, bui);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaLogSituacaoExameRequisicaoConexaoIntegracaoServidor(String filial, String requisicao, String exame, String material, String situacao) throws SQLException {
        try (Statement st = ConexaoIntegracaoHospitalServidor.getStatement();){
            StringBuilder bui = DBUtil.geraInsertExameRequisicaoSituacao(filial, requisicao, exame, material, Variaveis.login, situacao, null, null);
            ConexaoIntegracaoHospitalServidor.executeUpdate(st, bui.toString());
        }
    }

    public static StringBuilder geraInsertExameRequisicaoSituacao(String filial, String requisicao, String exame, String material, String usuario, String situacao, String motivoRecoleta, String justificativaRecoleta) {
        StringBuilder bui = new StringBuilder();
        bui.append("insert into examerequisicaosituacoes(fil_codigo, req_codigo, exa_codigo, mco_codigo, usr_codigo, ers_situacao, ers_datahora,  ");
        if (DBUtil.existeMotivoRecoleta(motivoRecoleta)) {
            bui.append(" mrc_codigo, ");
        }
        bui.append(" ers_motivorecoleta) ");
        bui.append(" values ( ");
        bui.append(filial).append(", ");
        bui.append(requisicao).append(", ");
        bui.append(StringUtil.textoDBEscape(exame)).append(", ");
        bui.append(material).append(", ");
        bui.append(StringUtil.textoDBEscape(usuario)).append(", ");
        bui.append(StringUtil.textoDBEscape(situacao)).append(", ");
        bui.append("'").append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss.SSS", new java.util.Date())).append("'").append(", ");
        if (DBUtil.existeMotivoRecoleta(motivoRecoleta)) {
            bui.append(StringUtil.textoDBEscape(motivoRecoleta)).append(", ");
        }
        bui.append(StringUtil.textoDBEscape(justificativaRecoleta)).append(")");
        return bui;
    }

    public static Registro getSituacaoMotivoRecoleta(String filial, String requisicao, String exame, String material) {
        Registro registro = new Registro();
        StringBuilder bui = new StringBuilder();
        bui.append("select  m.mrc_descricao as motivoRecoleta,  s.ers_motivorecoleta as justificativaRecoleta ");
        bui.append(" from examerequisicaosituacoes s ");
        bui.append(" inner join motivorecoleta m on m.fil_codigo = s.fil_codigo and m.mrc_codigo  = s.mrc_codigo ");
        bui.append(" where s.fil_codigo = ");
        bui.append(filial);
        bui.append(" and s.req_codigo = ");
        bui.append(requisicao);
        bui.append(" and s.exa_codigo = '");
        bui.append(exame);
        bui.append("' and s.mco_codigo = ");
        bui.append(material);
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQueryPerformance(st, bui.toString());
            if (rs.next()) {
                registro.setValor("motivoRecoleta", rs.getString("motivoRecoleta"));
                registro.setValor("justificativaRecoleta", rs.getString("justificativaRecoleta"));
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return registro;
    }

    private static boolean existeMotivoRecoleta(String motivoRecoleta) {
        return !Funcoes.textoVazio(motivoRecoleta);
    }

    public static String getTabelaExcecao(String excecao) {
        if (Funcoes.textoVazio(excecao)) {
            return null;
        }
        int posInicial = excecao.indexOf(INICIO_DETALHE);
        if (posInicial > -1) {
            int posFinal = excecao.indexOf(SEPARADOR_DETALHE, posInicial);
            return excecao.substring(posInicial += INICIO_DETALHE.length(), posFinal == -1 ? excecao.length() : posFinal);
        }
        return null;
    }

    public static String getWhereExcecao(String excecao, String tabela) throws Exception {
        if (Funcoes.textoVazio(excecao)) {
            return null;
        }
        AbstractThreadBean bean = FabricaDao.getBean(tabela);
        if (bean == null) {
            throw new Exception("O bean da tabela '" + tabela + "' n\u00e3o foi localizado.");
        }
        int posInicial = excecao.indexOf(INICIO_DETALHE);
        int posFinal = excecao.indexOf(FIM_DETALHE);
        if (posInicial > -1 && posFinal > -1) {
            posInicial = excecao.indexOf(SEPARADOR_DETALHE, posInicial);
            String aux = excecao.substring(posInicial += SEPARADOR_DETALHE.length(), posFinal);
            StringTokenizer tokenizer = new StringTokenizer(aux, SEPARADOR_DETALHE);
            StringBuilder where = new StringBuilder();
            while (tokenizer.hasMoreTokens()) {
                if (!Funcoes.textoVazio(where.toString())) {
                    where.append(" and ");
                }
                String token = tokenizer.nextToken();
                String campo = token.substring(0, token.indexOf("="));
                String valor = token.substring(token.indexOf("=") + 1);
                Field[] fields = bean.getClass().getDeclaredFields();
                if (fields == null || fields.length == 0) {
                    return null;
                }
                boolean isString = false;
                for (Field f : fields) {
                    if (!f.isAnnotationPresent(DataBaseField.class) || !f.getAnnotation(DataBaseField.class).value().equalsIgnoreCase(campo)) continue;
                    f.setAccessible(true);
                    boolean bl = isString = f.getType() == String.class;
                    if (!f.isAnnotationPresent(DataBaseForeignKey.class)) break;
                    isString = isString || DBUtil.isCampoEstrangeiroString(f);
                    break;
                }
                where.append(campo).append("=").append(isString ? "'" : "").append(valor).append(isString ? "'" : "");
            }
            return where.toString();
        }
        return null;
    }

    private static boolean isCampoEstrangeiroString(Field campo) {
        Field[] fields = campo.getType().getDeclaredFields();
        if (fields == null || fields.length == 0) {
            return false;
        }
        for (Field f : fields) {
            f.setAccessible(true);
            if (!f.isAnnotationPresent(DataBasePrimaryKey.class) || f.isAnnotationPresent(DataBaseForeignKey.class)) continue;
            return f.getType() == String.class;
        }
        return false;
    }

    public static String getTabelaSelect(String select) {
        if (Funcoes.textoVazio(select)) {
            return null;
        }
        select.replaceAll("\n", " ");
        select.replaceAll("\r", " ");
        int indiceFrom = select.indexOf("from");
        if (indiceFrom > -1) {
            int posIni = select.indexOf(" ", indiceFrom);
            int posFim = select.indexOf(" ", posIni + 1);
            return select.substring(posIni, posFim).trim();
        }
        return null;
    }

    public static String getInsertDeSelect(Statement st, String select) throws SQLException {
        if (Funcoes.textoVazio(select)) {
            return null;
        }
        ResultSet rs = Conexao.executeQuery(st, select);
        if (rs.next()) {
            int i;
            ResultSetMetaData rsMetaData = rs.getMetaData();
            StringBuilder buf = new StringBuilder();
            buf.append("  insert into ").append(DBUtil.getTabelaSelect(select));
            buf.append(" ( ");
            for (i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                buf.append(rsMetaData.getColumnName(i));
                if (i >= rsMetaData.getColumnCount()) continue;
                buf.append(", ");
            }
            buf.append(" ) ");
            buf.append(" values (");
            for (i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                Object aux = rs.getObject(rsMetaData.getColumnName(i));
                if (aux == null) {
                    buf.append("null");
                } else if (aux instanceof String || aux instanceof Date || aux instanceof Timestamp || aux instanceof Time || aux instanceof PGInterval) {
                    buf.append(StringUtil.textoDBEscape(aux.toString()));
                } else {
                    buf.append(aux.toString());
                }
                if (i >= rsMetaData.getColumnCount()) continue;
                buf.append(", ");
            }
            buf.append(" ) ");
            return buf.toString();
        }
        return null;
    }

    public static String getInsertDeVariosSelect(Statement st, String select) throws SQLException {
        if (Funcoes.textoVazio(select)) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        ResultSet rs = Conexao.executeQuery(st, select);
        while (rs.next()) {
            int i;
            ResultSetMetaData rsMetaData = rs.getMetaData();
            buf.append("insert into ").append(DBUtil.getTabelaSelect(select));
            buf.append(" ( ");
            for (i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                buf.append(rsMetaData.getColumnName(i));
                if (i >= rsMetaData.getColumnCount()) continue;
                buf.append(", ");
            }
            buf.append(" ) ");
            buf.append(" values (");
            for (i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                Object aux = rs.getObject(rsMetaData.getColumnName(i));
                if (aux == null) {
                    buf.append("null");
                } else if (aux instanceof String || aux instanceof Date || aux instanceof Timestamp || aux instanceof Time || aux instanceof PGInterval) {
                    buf.append(StringUtil.textoDBEscape(aux.toString()));
                } else {
                    buf.append(aux.toString());
                }
                if (i >= rsMetaData.getColumnCount()) continue;
                buf.append(", ");
            }
            buf.append(" );\n ");
        }
        return buf.toString();
    }

    public static boolean campoExiste(Statement st, String tabela, String campo) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select column_name ");
            buf.append("   from information_schema.columns ");
            buf.append("  where table_name = '").append(tabela).append("' ");
            buf.append("    and upper(column_name) = upper('").append(campo).append("') ");
            ResultSet rs = st.executeQuery(buf.toString());
            return rs.next();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] carregaLargeObject(Long oid) throws Exception {
        LargeObjectManager lobj = ((PGConnection)Conexao.getConnection()).getLargeObjectAPI();
        LargeObject objeto = lobj.open(oid.longValue());
        InputStream inputStream = objeto.getInputStream();
        ArrayList<Byte> retornoAux = new ArrayList<Byte>();
        int aux = -1;
        while ((aux = inputStream.read()) > -1) {
            retornoAux.add((byte)aux);
        }
        byte[] retorno = new byte[retornoAux.size()];
        for (int i = 0; i < retornoAux.size(); ++i) {
            retorno[i] = (Byte)retornoAux.get(i);
        }
        objeto.close();
        inputStream.close();
        return retorno;
    }

    public static Long gravaLargeObject(byte[] dados, Connection conexao) throws Exception {
        if (dados == null) {
            throw new Exception("N\u00e3o foi poss\u00edvel salvar LargeObject - dados NULL.");
        }
        if (conexao == null) {
            throw new Exception("N\u00e3o foi poss\u00edvel salvar LargeObject - conexao NULL.");
        }
        LargeObjectManager lobj = ((PGConnection)conexao).getLargeObjectAPI();
        long oid = lobj.createLO(393216);
        LargeObject obj = lobj.open(oid, 131072);
        obj.write(dados);
        obj.close();
        return oid;
    }

    public static boolean temApenasBaseAlimentos(Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder("select count(fil_codigo) from filiais_postocoleta");
        ResultSet rs = st.executeQuery(buf.toString());
        int totalFiliais = rs.next() ? rs.getInt(1) : 0;
        buf.setLength(0);
        buf.append("select count(fil_codigo) from filiais_postocoleta ");
        buf.append("where fil_tipobase = '").append(ALTERACAO).append("' ");
        rs = st.executeQuery(buf.toString());
        int totalAlimentos = rs.next() ? rs.getInt(1) : 0;
        return totalFiliais == totalAlimentos;
    }

    public static ArrayList<String> getReqMultiGuias(String filCodigo, String reqCodigo, Statement st) throws SQLException {
        ArrayList<String> requisicoes = new ArrayList<String>();
        StringBuilder query = new StringBuilder();
        query.append("select req_codigo from requisicaorequisicao where fil_codigo = ");
        query.append(filCodigo);
        query.append(" and req_kodigo = ");
        query.append(reqCodigo);
        ResultSet rs = st.executeQuery(query.toString());
        if (rs != null && rs.next()) {
            reqCodigo = rs.getString("req_codigo");
        }
        requisicoes.add(reqCodigo);
        query.delete(0, query.length());
        query.append("select req_kodigo from requisicaorequisicao where fil_codigo = ");
        query.append(filCodigo);
        query.append(" and req_codigo = ");
        query.append(reqCodigo);
        rs = st.executeQuery(query.toString());
        while (rs != null && rs.next()) {
            requisicoes.add(rs.getString("req_kodigo"));
        }
        return requisicoes;
    }

    public static boolean requisicaoAgrupaMultiguiasLabExterno(Statement st, String filial, String requisicao) throws SQLException {
        if (Funcoes.textoVazio(filial)) {
            filial = Variaveis.filialPadrao;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT coalesce(lae.lae_agruparmultiguias, false) FROM examerequisicao er ");
        sql.append("LEFT JOIN examematcoletalabexterno emc ");
        sql.append("       ON er.fil_codigo = emc.fil_codigo ");
        sql.append("      AND er.exa_codigo = emc.exa_codigo ");
        sql.append("      AND er.mco_codigo = emc.mco_codigo ");
        sql.append("LEFT JOIN labexterno lae ");
        sql.append("       ON emc.fil_codigo = lae.fil_codigo ");
        sql.append("      AND emc.lae_codigo = lae.lae_codigo ");
        sql.append("WHERE er.fil_codigo =  ").append(filial);
        sql.append("      AND er.req_codigo = ").append(requisicao);
        sql.append("      AND lae.lae_agruparmultiguias = true");
        sql.append("      AND emc.ele_padrao ");
        ResultSet rs = st.executeQuery(sql.toString());
        return rs.next();
    }

    public static boolean requisicaoAgrupaMultiguiasLabExterno(Statement statement, String filial, Integer[] requisicoes) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT coalesce(lae.lae_agruparmultiguias, false) FROM examerequisicao er ");
        sql.append("LEFT JOIN examematcoletalabexterno emc ");
        sql.append("       ON er.fil_codigo = emc.fil_codigo ");
        sql.append("      AND er.exa_codigo = emc.exa_codigo ");
        sql.append("      AND er.mco_codigo = emc.mco_codigo ");
        sql.append("LEFT JOIN labexterno lae ");
        sql.append("       ON emc.fil_codigo = lae.fil_codigo ");
        sql.append("      AND emc.lae_codigo = lae.lae_codigo ");
        sql.append("WHERE er.fil_codigo =  ").append(filial);
        sql.append("      AND er.req_codigo in (");
        for (int i = 0; i < requisicoes.length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(requisicoes[i]);
        }
        sql.append(")");
        sql.append("      AND lae.lae_agruparmultiguias = true");
        sql.append("      AND emc.ele_padrao");
        ResultSet rs = statement.executeQuery(sql.toString());
        return rs.next();
    }

    public static boolean requisicaoAgrupaMultiguiasLabExterno(Statement statement, String filial, String requisicao, String codExame, String mcoCodigo, String codLabExterno) throws SQLException {
        ResultSet rs;
        StringBuilder sql = new StringBuilder();
        boolean isAgrupar = false;
        sql.append("SELECT coalesce(lae.lae_agruparmultiguias, false) as isAgrupar FROM examerequisicao er ");
        sql.append("LEFT JOIN examematcoletalabexterno emc ");
        sql.append("       ON er.fil_codigo = emc.fil_codigo ");
        sql.append("      AND er.exa_codigo = emc.exa_codigo ");
        sql.append("      AND er.mco_codigo = emc.mco_codigo ");
        sql.append("LEFT JOIN labexterno lae ");
        sql.append("       ON emc.fil_codigo = lae.fil_codigo ");
        sql.append("      AND emc.lae_codigo = lae.lae_codigo ");
        sql.append("WHERE er.fil_codigo =  ").append(filial);
        sql.append("      AND er.req_codigo in ( ").append(requisicao).append(")");
        sql.append("      AND er.exa_codigo in (").append(codExame).append(")");
        sql.append("      AND er.mco_codigo in (").append(mcoCodigo).append(")");
        if (!Funcoes.textoVazio(codLabExterno)) {
            sql.append("      AND lae.lae_codigo = ").append(codLabExterno);
        }
        if ((rs = statement.executeQuery(sql.toString())).next()) {
            isAgrupar = rs.getBoolean("isAgrupar");
        }
        return isAgrupar;
    }

    public static boolean requisicaoAgrupaMultiguiasLabExterno(Statement statement, String filial, String requisicao, String codExame, String mcoCodigo, Protocolo protocolo) throws SQLException {
        StringBuilder sql = new StringBuilder();
        boolean isAgrupar = false;
        sql.append("SELECT coalesce(lae.lae_agruparmultiguias, false) as isAgrupar FROM examerequisicao er ");
        sql.append("LEFT JOIN examematcoletalabexterno emc ");
        sql.append("       ON er.fil_codigo = emc.fil_codigo ");
        sql.append("      AND er.exa_codigo = emc.exa_codigo ");
        sql.append("      AND er.mco_codigo = emc.mco_codigo ");
        sql.append("LEFT JOIN labexterno lae ");
        sql.append("       ON emc.fil_codigo = lae.fil_codigo ");
        sql.append("      AND emc.lae_codigo = lae.lae_codigo ");
        sql.append("WHERE er.fil_codigo =  ").append(filial);
        sql.append("      AND er.req_codigo in ( ").append(requisicao).append(")");
        sql.append("      AND er.exa_codigo in (").append(codExame).append(")");
        sql.append("      AND er.mco_codigo in (").append(mcoCodigo).append(")");
        sql.append("      AND lae.lae_protocolo = '").append(protocolo.getCodigo()).append("'");
        ResultSet rs = statement.executeQuery(sql.toString());
        if (rs.next()) {
            isAgrupar = rs.getBoolean("isAgrupar");
        }
        return isAgrupar;
    }

    public static boolean requisicaoAgrupaMultiguiasLabExternoResultado(Statement statement, String filial, Integer[] requisicoes) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT coalesce(lae.lae_agruparmultiguias, false) FROM examerequisicao er ");
        sql.append("LEFT JOIN examematcoletalabexterno emc ");
        sql.append("       ON er.fil_codigo = emc.fil_codigo ");
        sql.append("      AND er.exa_codigo = emc.exa_codigo ");
        sql.append("      AND er.mco_codigo = emc.mco_codigo ");
        sql.append("LEFT JOIN labexterno lae ");
        sql.append("       ON emc.fil_codigo = lae.fil_codigo ");
        sql.append("      AND emc.lae_codigo = lae.lae_codigo ");
        sql.append("WHERE er.fil_codigo =  ").append(filial);
        sql.append("      AND er.req_codigo in (");
        for (int i = 0; i < requisicoes.length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(requisicoes[i]);
        }
        sql.append(")");
        sql.append(" AND lae.lae_agruparmultiguias = true");
        ResultSet rs = Conexao.executeQuery(statement, sql);
        return rs.next();
    }

    public static boolean requisicaoAgrupaMultiguiasLabExterno(Statement statement, Integer filial, Integer requisicao, List<String> exames, List<Integer> materiais, Integer labExterno) throws SQLException {
        try {
            return DBUtil.requisicaoAgrupaMultiguiasLabExterno(statement, String.valueOf(filial), String.valueOf(requisicao), ValorIn.criar(exames).toString(), ValorIn.criar(materiais).toString(), String.valueOf(labExterno));
        }
        catch (ValorInException e) {
            throw new SQLException(e);
        }
    }

    public static boolean requisicaoAgrupaMultiguiasLabExterno(Statement statement, Integer filial, Integer requisicao, List<String> exames, List<Integer> materiais, Protocolo protocolo) throws SQLException {
        try {
            return DBUtil.requisicaoAgrupaMultiguiasLabExterno(statement, String.valueOf(filial), String.valueOf(requisicao), ValorIn.criar(exames).toString(), ValorIn.criar(materiais).toString(), protocolo);
        }
        catch (ValorInException e) {
            throw new SQLException(e);
        }
    }

    public static boolean requisicaoAgrupaMultiguiasLabExterno(Statement st, Integer filial, Integer requisicao) throws SQLException {
        return DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, String.valueOf(filial), String.valueOf(requisicao));
    }

    public static boolean requisicaoAgrupaMultiguiasLabExterno(Statement st, Integer filial, Integer requisicao, Protocolo protocolo) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT coalesce(lae.lae_agruparmultiguias, false) as agrupar FROM examerequisicao er ");
        sql.append("LEFT JOIN examematcoletalabexterno emc ");
        sql.append("       ON er.fil_codigo = emc.fil_codigo ");
        sql.append("      AND er.exa_codigo = emc.exa_codigo ");
        sql.append("      AND er.mco_codigo = emc.mco_codigo ");
        sql.append("LEFT JOIN labexterno lae ");
        sql.append("       ON emc.fil_codigo = lae.fil_codigo ");
        sql.append("      AND emc.lae_codigo = lae.lae_codigo ");
        sql.append("LEFT JOIN requisicaorequisicao r ");
        sql.append(" on r.fil_codigo = er.fil_codigo ");
        sql.append(" and (r.req_kodigo = er.req_codigo or r.req_codigo = er.req_codigo) ");
        sql.append("WHERE er.fil_codigo =  ").append(filial);
        sql.append("       AND (r.req_kodigo = ").append(requisicao);
        sql.append("       \t\t\t\tOR   r.req_codigo = ").append(requisicao);
        sql.append("            ) ");
        sql.append("      AND lae.lae_agruparmultiguias = true");
        sql.append("\t\t\tAND lae.lae_protocolo = '").append(protocolo.getCodigo()).append("'");
        sql.append("      AND emc.ele_padrao");
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getBoolean("agrupar");
        }
        return false;
    }

    public static boolean requisicaoAgrupaMultiguiasLabExternoLote(Statement st, String filial, String requisicao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT coalesce(lae.lae_agruparmultiguias, false) as agrupar FROM loteexternorequisicao er ");
        sql.append("LEFT JOIN labexterno lae ");
        sql.append("       ON lae.fil_codigo = er.fil_codigo and ");
        sql.append("      lae.lae_codigo = er.lae_codigo ");
        sql.append("WHERE er.fil_codigo =  ").append(filial);
        sql.append("      AND er.req_codigo = ").append(requisicao);
        sql.append("      AND lae.lae_agruparmultiguias = true");
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getBoolean("agrupar");
        }
        return false;
    }

    public static void fecharResultSet(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static boolean isRequisicaoFaturada(String filial, String requisicao, Statement st) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select fat.fat_codigo as fatura ");
            sql.append(" from fatura fat");
            sql.append(" left join faturarequisicao freq on ");
            sql.append(" fat.fil_codigo = freq.fil_codigo and fat.fat_codigo = freq.fat_codigo ");
            sql.append(" where freq.req_codigo = ").append(requisicao).append(" and fat.fil_codigo = ").append(filial);
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                return !Funcoes.textoVazio(rs.getString("fatura"));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            return false;
        }
        return false;
    }

    public static StringBuilder selectImpressaoAnexoRecibo(String filial, String requisicao, boolean isAlimentos, boolean ordenarSetor, String ordemComprovante, boolean ocultarApenasFaturamento, Statement st) {
        StringBuilder buf = new StringBuilder();
        buf.append("select a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,");
        buf.append(" (select numeroNotaFiscal from (select");
        buf.append(" case when nota.nfi_numero is not null and nota.nfi_situacao = 'A' then nota.nfi_numero ");
        buf.append(" when nfat.nfi_numero is not null and  nfat.nfi_situacao = 'A' then nfat.nfi_numero ");
        buf.append(" else null ");
        buf.append(" end as numeroNotaFiscal ");
        buf.append(" from requisicao a ");
        buf.append(" left join faturarequisicao freq on ");
        buf.append(" a.fil_codigo = freq.fil_codigo ");
        buf.append(" and a.req_codigo = freq.req_codigo ");
        buf.append(" left join faturanotafiscal fatnota on ");
        buf.append(" freq.fil_codigo = fatnota.fil_codigo ");
        buf.append(" and freq.fat_codigo = fatnota.fat_codigo ");
        buf.append(" left join requisicaonotafiscal reqnf on ");
        buf.append(" a.fil_codigo = reqnf.fil_codigo ");
        buf.append(" and a.req_codigo = reqnf.req_codigo ");
        buf.append(" left join notafiscal nota on ");
        buf.append(" nota.fil_codigo = reqnf.fil_codigo ");
        buf.append(" and nota.nfi_codigo = reqnf.nfi_codigo left join notafiscal nfat on ");
        buf.append(" fatnota.fil_codigo = nfat.fil_codigo and fatnota.nfi_codigo = nfat.nfi_codigo where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" ) as numeroNotaFiscal where numeroNotaFiscal is not null and a.fil_codigo = ");
        buf.append(filial + ") as numeroNotaFiscal, ");
        buf.append("a.req_responsavel as responsavelPacienteRequisicao, a.req_cpfresponsavel as cpfResponsavelPacienteRequisicao, a.req_incapacitado as incapacitadoPacienteRequisicao,");
        buf.append("j.pac_responsavel as responsavelPaciente, j.pac_cpfresponsavel as cpfResponsavelPaciente, j.pac_incapacitado as incapacitadoPaciente,");
        buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_obs as obsRequisicao, a.req_totpago as totalPagoRequisicao, a.req_horaentregaprev as horaEntregaRequisicao, a.req_total as totalRequisicao,");
        buf.append("a.req_horafatura as horaFaturaRequisicao, a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, a.req_idade as idadeRequisicao, a.req_anomes as anoMesRequisicao,");
        buf.append("a.req_matricula as matriculaRequisicao, a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao, a.req_titular as titularRequisicao, a.req_peso as pesoRequisicao,");
        buf.append("a.req_altura as alturaRequisicao, a.req_desconto as descontoRequisicao, a.req_vlrdesconto as valorDescontoRequisicao,");
        buf.append("a.req_acrescimo as acrescimoRequisicao, a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_notacaixa as notaCaixaRequisicao, ");
        buf.append("a.req_vlrexames as valorExamesRequisicao, a.req_vlrmateriais as valorMateriaisRequisicao, a.req_guia as guiaRequisicao, a.req_guiaprincipal as guiaPrincipalRequisicao,");
        buf.append("a.sit_codigo as codigoSituacao, g.sit_descricao as descricaoSituacao, a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao,");
        buf.append("a.req_imprimirseparado as imprimirSeparadoRequisicao, '' as datasEntregaParcialRequisicao, a.req_prontuario as prontuarioRequisicao, ");
        buf.append("a.req_complementodestino as complementoDestinoRequisicao, '' as multiguiasRequisicao, a.req_cartaosus as cartaoSUSRequisicao, ");
        buf.append("b.exr_situacao as situacaoExame, b.exr_situacao as descricaoSituacaoExame, false as existeExamesSemMaterial, ");
        buf.append("b.exr_codautorizacao as autorizacaoExame, b.exr_motivoprazo as observacaoPrazoCarenciaExame, ");
        buf.append("b.exr_valorcusto as custoCBHPMExame, b.exr_valoruco as ucoCBHPMExame, b.exr_valorporte as valorPorteCBHPMExame, b.exr_porte as porteCHBPMExame, ");
        buf.append("a.usr_codigo as codigoUsuario, h.usr_nome as nomeUsuario, h.usr_assinatura as assinaturaUsuario,");
        buf.append("a.usr_codabertura as codigoUsuarioAbertura, ab.usr_nome as nomeUsuarioAbertura, ab.usr_assinatura as assinaturaUsuarioAbertura,");
        buf.append("k.cid_codigo as codigoCidadeConvenio, k.cid_nome as descricaoCidadeConvenio, k.cid_uf as estadoCidadeConvenio,");
        buf.append("l.cid_codigo as codigoCidadeMedico, l.cid_nome as descricaoCidadeMedico, l.cid_uf as estadoCidadeMedico,");
        buf.append("m.cid_codigo as codigoCidadeDestino, m.cid_nome as descricaoCidadeDestino, m.cid_uf as estadoCidadeDestino,");
        buf.append("n.cid_codigo as codigoCidadeColeta, n.cid_nome as descricaoCidadeColeta, n.cid_uf as estadoCidadeColeta,");
        buf.append("o.cid_codigo as codigoCidadePaciente, o.cid_nome as descricaoCidadePaciente, o.cid_uf as estadoCidadePaciente,");
        buf.append("p.bai_codigo as codigoBairroConvenio, p.bai_descricao as descricaoBairroConvenio,");
        buf.append("q.bai_codigo as codigoBairroMedico, q.bai_descricao as descricaoBairroMedico,");
        buf.append("r.bai_codigo as codigoBairroDestino, r.bai_descricao as descricaoBairroDestino,");
        buf.append("s.bai_codigo as codigoBairroColeta, s.bai_descricao as descricaoBairroColeta,");
        buf.append("t.bai_codigo as codigoBairroPaciente, t.bai_descricao as descricaoBairroPaciente,");
        buf.append("a.des_codigo as codigoDestino, e.des_descricao as descricaoDestino, e.des_endereco as enderecoDestino, e.des_complemento as complementoDestino,e.des_cep as cepDestino, e.des_fone as foneDestino, e.des_enviarweb as enviarParaWebDestino, ");
        buf.append("a.col_codigo as codigoColeta, f.col_descricao as descricaoColeta, f.col_endereco as enderecoColeta, f.col_complemento as complementoColeta, f.col_cep as cepColeta, f.col_fone as foneColeta,");
        buf.append("a.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial,");
        buf.append("cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial,");
        buf.append("baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial,");
        buf.append("filial.fil_integrar as integracaoEntreFiliais, '' as tipoIntegracaoEntreFiliais, ");
        buf.append("j.pac_senhaweb as senhaWebPaciente, b.exr_vlrexame as valorExameConvenio, j.pac_codigoapoiado as codigoApoiadoPaciente, ");
        buf.append("d.med_cbo as codigoCBOMedico, d.med_cbo as descricaoCBOMedico, d.med_conselho as conselhoMedico, operadora.mec_codigooperadora as codigoOperadoraMedico, d.med_crm as crmMedico, d.med_uf as estadoCrmMedico, d.med_nome as nomeMedico, d.med_abrev as tratamentoMedico, d.med_endereco as enderecoMedico, d.med_numeroendereco as numeroEnderecoMedico, d.med_tipologradouroendereco as tipoLogradouroMedico, d.med_complemento as complementoMedico, d.med_cep as cepMedico, d.med_fone as foneMedico, d.med_celular as celularMedico, d.med_fax as faxMedico, d.med_email as emailMedico, d.med_site as siteMedico,");
        buf.append("c.con_codigo as codigoConvenio, c.con_fantasia as fantasiaConvenio, c.con_razao as razaoSocialConvenio, c.con_endereco as enderecoConvenio, c.con_numeroendereco as numeroEnderecoConvenio, c.con_tipologradouroendereco as tipoLogradouroConvenio,  c.con_complemento as complementoConvenio, c.con_cep as cepConvenio, c.con_fone as foneConvenio, c.con_email1 as email1Convenio, c.con_email2 as email2Convenio, c.con_site as siteConvenio,");
        buf.append("conrepasse.con_codigo as codigoConvenioRepasse, conrepasse.con_fantasia as fantasiaConvenioRepasse, conrepasse.con_razao as razaoSocialConvenioRepasse, conrepasse.con_endereco as enderecoConvenioRepasse, conrepasse.con_numeroendereco as numeroEnderecoConvenioRepasse, conrepasse.con_tipologradouroendereco as tipoLogradouroConvenioRepasse, conrepasse.con_complemento as complementoConvenioRepasse, conrepasse.con_cep as cepConvenioRepasse, conrepasse.con_fone as foneConvenioRepasse, conrepasse.con_email1 as email1ConvenioRepasse, conrepasse.con_email2 as email2ConvenioRepasse, conrepasse.con_site as siteConvenioRepasse,(c.con_cobrexame is not null and c.con_cobrexame = true and c.con_percpgto is not null and c.con_percpgto > 0) as cobraExameBalcaoConvenio,");
        buf.append("j.pac_codigo as codigoPaciente, j.pac_nome as nomePaciente, j.pac_sexo as sexoPaciente, j.pac_datanasc as dataNascimentoPaciente, j.pac_grpsangue as grupoSanguineoPaciente, j.pac_fatorrh as fatorRHPaciente, j.pac_fatordu as fatorDUPaciente, j.pac_cor as corPaciente,");
        buf.append("j.pac_profissao as profissaoPaciente, j.pac_rg as rgPaciente, j.pac_cpf as cpfPaciente, j.pac_estcivil as estadoCivilPaciente, j.pac_dum as dumPaciente, j.pac_fone as fonePaciente, j.pac_celular as celularPaciente, j.pac_fax as faxPaciente, j.pac_fonecomercial as foneComercialPaciente,");
        buf.append("j.pac_endereco as enderecoPaciente, j.pac_numeroendereco as numeroEnderecoPaciente, j.pac_tipologradouroendereco as tipoLogradouroEnderecoPaciente, j.pac_tipologradouroendereco as tipoLogradouroPaciente ,j.pac_complemento as complementoPaciente, j.pac_cep as cepPaciente, j.pac_email as emailPaciente, j.pac_fonecontato as foneContatoPaciente, j.pac_nomecontato as contatoPaciente,");
        buf.append("j.pac_nomepagador as nomePagadorPaciente, j.pac_cpfpagador as cpfPagadorPaciente, ");
        buf.append("b.exa_codigo as codigoExame, w.exa_descricao as descricaoExame, b.exr_vlrchexame as ambExame, b.exr_vlrchexame as chExame, b.exr_vlrexame as valorExame,b.exr_vlrmaterial as valorMateriaisExame, b.exr_vlrch as valorCH,");
        buf.append("w.exa_soa as soaExame, w.exa_coa as coaExame, w.exa_inmetro as certificadoInmetroExame, ");
        buf.append("v.mco_descricao as descricaoMaterial, v.mco_codigo as codigoMaterial, v.mco_abreviatura as abreviaturaMaterial, b.exr_datamaterial as dataColetaExame, b.exr_datamaterial as horaColetaExame, ");
        buf.append("coalesce(b.exr_urgente, false) as urgenteExame, b.exr_matexterno as materialExternoExame, ");
        buf.append("b.usr_codmaterial as usuarioColetaExame, prazo.prz_descricao as descricaoPrazo, prazo.prz_codigo as codigoPrazo, metodo.met_codigo as codigoMetodo, CASE WHEN exr_intervaloJejum is null then TO_CHAR(exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(exr_intervaloJejum,'HH24:MI:SS') end  as tempoJejumExame, ");
        buf.append("metodo.met_descricao as descricaoMetodo, b.exr_descricaomaterial as materialInformadoExame, b.exr_dataentregaprev as dataEntregaExame, b.exr_dataentregaprev as horaEntregaExame, ");
        buf.append("j.pac_senhaweb as senhaWebPaciente, b.exr_vlrexame as valorExameConvenio, ");
        buf.append("b.exr_codautorizacao, ");
        buf.append("exmsetor.set_codigo as codigoSetorExame, setores.set_descricao as descricaoSetorExame, setores.set_sigla as abreviaturaSetorExame, ");
        buf.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, a.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla, ");
        buf.append("tpe.tpe_codigo as codigoTabelaPreco, tpe.tpe_descricao as descricaoTabelaPreco, tpe.tpe_moeda as moedaTabelaPreco, ");
        buf.append("a.req_descricaoproduto as descricaoProdutoRequisicao, ");
        buf.append("a.req_datafabricacao as dataFabricacaoProdutoRequisicao, ");
        buf.append("a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao, ");
        buf.append("a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao, ");
        buf.append("a.req_numeroloteproduto as numeroLoteProdutoRequisicao, ");
        buf.append("a.req_datavalidade as dataValidadeProdutoRequisicao, ");
        buf.append("a.req_marcaproduto as marcaProdutoRequisicao, ");
        buf.append("a.req_datacoletaproduto as dataColetaProdutoRequisicao, ");
        buf.append("a.req_horacoletaproduto as horaColetaProdutoRequisicao, ");
        buf.append("a.req_lacreproduto as lacreProdutoRequisicao, ");
        buf.append("a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao, ");
        buf.append("a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao, ");
        buf.append("a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao, ");
        buf.append("a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao, ");
        buf.append("a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao, ");
        buf.append("a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao, ");
        buf.append("a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao, ");
        buf.append("a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao, ");
        buf.append("a.req_partidaproduto as partidaProdutoRequisicao, ");
        buf.append("a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao, ");
        buf.append("a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao, ");
        buf.append("a.req_anoprpproduto as anoPRPProdutoRequisicao, a.req_cicloprpproduto as cicloPRPProdutoRequisicao, ");
        buf.append("a.req_amostraprpproduto as amostraPRPProdutoRequisicao, a.req_amostrasupprpproduto as amostraSupervisaoPRPProdutoRequisicao, ");
        buf.append("a.req_horainicioturnoprpproduto as horaInicioTurnoPRPProdutoRequisicao, a.req_linhaprpproduto as linhaPRPProdutoRequisicao, ");
        buf.append("a.req_volumeabateprpproduto as volumeAbatePRPProdutoRequisicao, a.req_turnoprpproduto as turnoPRPProdutoRequisicao, ");
        buf.append("a.req_areaproduto as areaProdutoRequisicao, ");
        buf.append("a.unm_codigo as codigoUnidadeProdutoRequisicao, ");
        buf.append("unidademedida.unm_descricao as descricaoUnidadeProdutoRequisicao, ");
        buf.append("a.emb_codigo as codigoEmbalagemProdutoRequisicao, ");
        buf.append("emb.emb_descricao as descricaoEmbalagemProdutoRequisicao, ");
        buf.append("paccontatos.pco_nome as nomeResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_cargo as cargoResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_email as emailResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_fone as foneResponsavelRequisicao_, ");
        buf.append("ent.ent_fantasia as nomeResponsavelRequisicao, ");
        buf.append("case when nota.nfi_numero is not null then nota.nfi_numero when nfat.nfi_numero is not null then nfat.nfi_numero else null end as numeroNotaFiscal,");
        buf.append("ent.ent_cargo as cargoResponsavelRequisicao, ");
        buf.append("ent.ent_email as emailResponsavelRequisicao, ");
        buf.append("ent.ent_fone as foneResponsavelRequisicao, ");
        buf.append("ent.ent_razaosocial as razaoSocialResponsavelRequisicao, ");
        buf.append("ent.ent_tipologradouroendereco as tipoLogradouroResponsavelRequisicao, ");
        buf.append("ent.ent_endereco as enderecoResponsavelRequisicao, ");
        buf.append("ent.ent_numeroendereco as numeroEnderecoResponsavelRequisicao, ");
        buf.append("ent.ent_complemento as complementoResponsavelRequisicao, ");
        buf.append("ent.ent_cep as cepResponsavelRequisicao, ");
        buf.append("ent.ent_cpfcnpj as cpfCnpjResponsavelRequisicao, ");
        buf.append("cidentidade.cid_nome as descricaoCidadeResponsavelRequisicao, ");
        buf.append("cidentidade.cid_uf as estadoCidadeResponsavelRequisicao, ");
        buf.append("baientidade.bai_descricao as descricaoBairroResponsavelRequisicao, ");
        buf.append("entempresapaciente.ent_codigo as codigoEmpresaPaciente, entempresapaciente.ent_fantasia as fantasiaEmpresaPaciente, ");
        buf.append("entempresapaciente.ent_razaosocial as razaoSocialEmpresaPaciente, entempresapaciente.ent_fone as foneEmpresaPaciente, ");
        buf.append("a.req_datarecebimentoproduto as dataRecebimentoProdutoRequisicao, ");
        buf.append("a.req_horarecebimentoproduto as horaRecebimentoProdutoRequisicao, ");
        buf.append("a.req_localcoletaproduto as localColetaProdutoRequisicao, ");
        buf.append("a.req_nrsolicitacaoproduto as numeroSolicitacaoProdutoRequisicao, ");
        buf.append("a.req_fornecedorproduto as fornecedorProdutoRequisicao, ");
        if (isAlimentos) {
            buf.append("pal.pal_codigo as codigoProdutoAlimento, ");
            buf.append("pal.pal_descricao as descricaoProdutoAlimento, ");
            buf.append("cpl.cpl_codigo as codigoCategoriaProdutoAlimento, ");
            buf.append("cpl.cpl_descricao as descricaoCategoriaProdutoAlimento, ");
        } else {
            buf.append("'' as codigoProdutoAlimento, ");
            buf.append("'' as descricaoProdutoAlimento, ");
            buf.append("'' as codigoCategoriaProdutoAlimento, ");
            buf.append("'' as descricaoCategoriaProdutoAlimento, ");
        }
        buf.append("j.bai_codigocobranca as codigoBairroCobrancaPaciente, ");
        buf.append("baicobranca.bai_descricao as descricaoBairroCobrancaPaciente, ");
        buf.append("j.cid_codigocobranca as codigoCidadeCobrancaPaciente, ");
        buf.append("cidcobranca.cid_nome as descricaoCidadeCobrancaPaciente, ");
        buf.append("cidcobranca.cid_uf as estadoCidadeCobrancaPaciente, ");
        buf.append("j.pac_razaosocial as razaoSocialPaciente, ");
        buf.append("j.pac_cnpj as cnpjPaciente, ");
        buf.append("j.pac_ie as inscricaoEstadualPaciente, ");
        buf.append("j.pac_proprietario as proprietarioPaciente, ");
        buf.append("j.pac_sif as sifPaciente, ");
        buf.append("j.pac_tipologradouroendcobranca as tipoLogradouroCobrancaPaciente, ");
        buf.append("j.pac_enderecocobranca as enderecoCobrancaPaciente, ");
        buf.append("j.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente, ");
        buf.append("j.pac_complementocobranca as complementoCobrancaPaciente, ");
        buf.append("j.pac_cepcobranca as cepCobrancaPaciente, ");
        buf.append("j.pac_fonecobranca as foneCobrancaPaciente, ");
        buf.append("j.pac_responsavelcobranca as responsavelCobrancaPaciente, ");
        buf.append("j.pac_pelagem as pelagemPaciente, ");
        buf.append("j.pac_cartaosus as cartaoSUSPaciente, ");
        buf.append("j.pac_fumante as fumantePaciente, ");
        buf.append("j.pac_diabetico as diabeticoPaciente, ");
        buf.append("j.pac_nomesocial as nomeSocialPaciente, ");
        buf.append("j.pac_whatsapp as whatsAppPaciente, ");
        buf.append("j.pac_mae as nomeMae, ");
        buf.append("especie.epc_codigo as codigoEspecie, especie.epc_descricao as descricaoEspecie, especie.epc_cientifico as cientificoEspecie, ");
        buf.append("raca.rac_codigo as codigoRaca, raca.rac_descricao as descricaoRaca, raca.rac_cientifico as cientificoRaca, ");
        buf.append("us.uns_codigo as codigoUnidadeSaude, us.uns_descricao as descricaoUnidadeSaude, us.uns_endereco as enderecoUnidadeSaude, us.uns_complemento as complementoUnidadeSaude, us.uns_cep as cepUnidadeSaude, us.uns_fone as foneUnidadeSaude,");
        buf.append("cidadeus.cid_codigo as codigoCidadeUnidadeSaude, cidadeus.cid_nome as descricaoCidadeUnidadeSaude, cidadeus.cid_uf as estadoCidadeUnidadeSaude,");
        buf.append("bairrous.bai_codigo as codigoBairroUnidadeSaude, bairrous.bai_descricao as descricaoBairroUnidadeSaude, ");
        buf.append("pai.pai_codigo as codigoPais, pai.pai_nome as nomePais, a.req_datacertificadoalimentos as dataCertificado, ");
        buf.append("a.req_numerocertificadoalimentos as numeroCertificado, a.req_tcaalimentos as termoColetaAmostra, ");
        buf.append("a.req_totaltaxa as totalTaxaRequisicao, ");
        buf.append("'' as quantidadeExameSemMaterial, a.req_procedencia as procedenciaRequisicao ");
        buf.append(", age(a.req_data, j.pac_datanasc) as idadeRequisicaoPaciente ");
        buf.append(", a.req_periodogestacional as periodoGestacionalRequisicao, j.pac_passaporte as passaportePaciente ");
        buf.append(", a.req_perguntas as perguntasRequisicao ");
        buf.append(", a.req_nomeplano as nomeDoPlano, j.pac_mae as nomeMae ");
        buf.append(" from requisicao a ");
        buf.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        if (ocultarApenasFaturamento) {
            buf.append(" and b.exr_situacao <> 'A' ");
        }
        buf.append("left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
        buf.append("left join convenios conrepasse on a.fil_codigo = conrepasse.fil_codigo and a.con_codrepasse = conrepasse.con_codigo ");
        buf.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf ");
        buf.append("left join medicoconveniotiss operadora on a.fil_codigo = operadora.fil_codigo and a.med_conselho = operadora.med_conselho and a.med_crm = operadora.med_crm and a.med_uf = operadora.med_uf and a.con_codigo = operadora.con_codigo ");
        buf.append("left join destino e on a.fil_codigo = e.fil_codigo and upper(a.des_codigo) = upper(e.des_codigo) ");
        buf.append("left join coletas f on a.fil_codigo = f.fil_codigo and upper(a.col_codigo) = upper(f.col_codigo) ");
        buf.append("left join situacao g on a.fil_codigo = g.fil_codigo and a.sit_codigo = g.sit_codigo ");
        buf.append("left join usuario h on upper(a.usr_codigo) = upper(h.usr_codigo) ");
        buf.append("left join usuario ab on upper(a.usr_codabertura) = upper(ab.usr_codigo) ");
        buf.append("left join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
        buf.append("left join cidades k on c.fil_codigo = k.fil_codigo and c.cid_codigo = k.cid_codigo ");
        buf.append("left join cidades l on d.fil_codigo = l.fil_codigo and d.cid_codigo = l.cid_codigo ");
        buf.append("left join cidades m on e.fil_codigo = m.fil_codigo and e.cid_codigo = m.cid_codigo ");
        buf.append("left join cidades n on f.fil_codigo = n.fil_codigo and f.cid_codigo = n.cid_codigo ");
        buf.append("left join cidades o on j.fil_codigo = o.fil_codigo and j.cid_codigo = o.cid_codigo ");
        buf.append("left join bairro p on c.fil_codigo = p.fil_codigo and c.bai_codigo = p.bai_codigo ");
        buf.append("left join bairro q on d.fil_codigo = q.fil_codigo and d.bai_codigo = q.bai_codigo ");
        buf.append("left join bairro r on e.fil_codigo = r.fil_codigo and e.bai_codigo = r.bai_codigo ");
        buf.append("left join bairro s on f.fil_codigo = s.fil_codigo and f.bai_codigo = s.bai_codigo ");
        buf.append("left join bairro t on j.fil_codigo = t.fil_codigo and j.bai_codigo = t.bai_codigo ");
        buf.append("left join examematcoleta u on b.fil_codigo = u.fil_codigo and upper(b.exa_codigo) = upper(u.exa_codigo) and b.mco_codigo = u.mco_codigo ");
        buf.append("left join materialcoleta v on u.fil_codigo = v.fil_codigo and u.mco_codigo = v.mco_codigo ");
        buf.append("left join exames w on b.fil_codigo = w.fil_codigo and upper(b.exa_codigo) = upper(w.exa_codigo) ");
        buf.append("left join prazoentrega prazo on u.fil_codigo = prazo.fil_codigo and u.prz_codigo = prazo.prz_codigo ");
        buf.append("left join metodologia metodo on u.fil_codigo = metodo.fil_codigo and u.met_codigo = metodo.met_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append("left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
        buf.append("left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
        buf.append("left join examematcoleta emc on b.fil_codigo = emc.fil_codigo and b.exa_codigo = emc.exa_codigo and b.mco_codigo = emc.mco_codigo ");
        buf.append("left join examesetor exmsetor on w.fil_codigo = exmsetor.fil_codigo and upper(w.exa_codigo) = upper(exmsetor.exa_codigo) and exmsetor.ese_default = true ");
        buf.append("left join setores setores on exmsetor.fil_codigo = setores.fil_codigo and exmsetor.set_codigo = setores.set_codigo ");
        buf.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
        buf.append("left join tabelaprecoexames tpe on c.fil_codigo = tpe.fil_codigo and c.tpe_codigo = tpe.tpe_codigo ");
        buf.append("left join unidademedida on a.fil_codigo = unidademedida.fil_codigo and a.unm_codigo = unidademedida.unm_codigo ");
        buf.append("left join pacientescontatos paccontatos on a.fil_codigo = paccontatos.fil_codigo and a.pac_codigo = paccontatos.pac_codigo and a.pco_codigo = paccontatos.pco_codigo ");
        buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
        buf.append("left join entidade entempresapaciente on j.fil_codigo = entempresapaciente.fil_codigo and j.ent_codempresa = entempresapaciente.ent_codigo ");
        buf.append("left join cidades cidcobranca on j.fil_codigo = cidcobranca.fil_codigo and j.cid_codigocobranca = cidcobranca.cid_codigo ");
        buf.append("left join bairro baicobranca on j.fil_codigo = baicobranca.fil_codigo and j.bai_codigocobranca = baicobranca.bai_codigo ");
        buf.append("left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
        buf.append("left join unidadesaude us on a.fil_codigo = us.fil_codigo and a.uns_codigo = us.uns_codigo ");
        buf.append("left join cidades cidadeus on us.fil_codigo = cidadeus.fil_codigo and us.cid_codigo = cidadeus.cid_codigo ");
        buf.append("left join bairro bairrous on us.fil_codigo = bairrous.fil_codigo and us.bai_codigo = bairrous.bai_codigo ");
        buf.append("left join especie on j.fil_codigo = especie.fil_codigo and j.epc_codigo = especie.epc_codigo ");
        buf.append("left join raca on especie.fil_codigo = raca.fil_codigo and especie.epc_codigo = raca.epc_codigo and j.rac_codigo = raca.rac_codigo ");
        buf.append("left join cidades cidentidade on ent.fil_codigo = cidentidade.fil_codigo and ent.cid_codigo = cidentidade.cid_codigo ");
        buf.append("left join bairro baientidade on ent.fil_codigo = baientidade.fil_codigo and ent.bai_codigo = baientidade.bai_codigo ");
        buf.append("left join pais pai on a.pai_codigo = pai.pai_codigo and a.fil_codigo = pai.fil_codigo ");
        buf.append("left join faturarequisicao freq on a.fil_codigo = freq.fil_codigo and a.req_codigo = freq.req_codigo and a.con_codigo = freq.con_codigo ");
        buf.append("left join fatura fat on a.fil_codigo = fat.fil_codigo and freq.fat_codigo = fat.fat_codigo and a.con_codigo = fat.con_codigo ");
        if (DBUtil.isRequisicaoFaturada(filial, requisicao, st)) {
            buf.append("inner join faturaexamerequisicao fexr on a.fil_codigo = fexr.fil_codigo and a.req_codigo = fexr.req_codigo and b.exa_codigo = fexr.exa_codigo and b.mco_codigo = fexr.mco_codigo and fat.fat_codigo = fexr.fat_codigo ");
        }
        buf.append("left join faturanotafiscal fatnota on freq.fil_codigo = fatnota.fil_codigo and freq.fat_codigo = fatnota.fat_codigo ");
        buf.append("left join requisicaonotafiscal reqnf on a.fil_codigo = reqnf.fil_codigo and a.req_codigo = reqnf.req_codigo ");
        buf.append("left join notafiscal nota on nota.fil_codigo = reqnf.fil_codigo and nota.nfi_codigo = reqnf.nfi_codigo ");
        buf.append("left join notafiscal nfat on fatnota.fil_codigo = nfat.fil_codigo and fatnota.nfi_codigo = nfat.nfi_codigo ");
        if (isAlimentos) {
            buf.append("left join categoriaprodutoalimentos cpl on a.fil_codigo = cpl.fil_codigo and a.cpl_codigo = cpl.cpl_codigo ");
            buf.append("left join produtoalimentos pal on a.fil_codigo = pal.fil_codigo and pal.pal_codigo = a.pal_codigo and cpl.cpl_codigo = pal.cpl_codigo ");
        }
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and (a.req_excluida = false or (a.req_excluida = true and a.req_origemagendamento = true)) and b.exr_excluido = false ");
        if (ordenarSetor) {
            buf.append(" and exmsetor.ese_default = true ");
        }
        buf.append(" order by");
        if (ordemComprovante.equals(ALTERACAO)) {
            buf.append(" \ta.req_codigo, a.req_data,a.req_dtfatura,a.req_urgente,a.req_dataentregaprev ");
        } else {
            if (ordenarSetor) {
                buf.append(" exmsetor.set_codigo, ");
            }
            buf.append(" a.req_codigo ");
            if (ordemComprovante.equals("C")) {
                buf.append(", b.exa_codigo");
            } else if (ordemComprovante.equals("P")) {
                buf.append(", u.emc_pagina, u.emc_ordem, b.exa_codigo, b.mco_codigo ");
            }
        }
        return buf;
    }
}

