/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.ComponenteCor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CorComboBox
extends JComboBox
implements ListCellRenderer {
    private Color[] cores = new Color[]{Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue, new Color(0, 0, 0)};
    private String[] nomes = new String[]{"Branca", "Cinza claro", "Cinza", "Cinza escuro", "Preta", "Vermelha", "Rosa", "Laranja", "Amarela", "Verde", "Magenta", "Ciano", "Azul", "Personalizada"};

    public CorComboBox() {
        for (int i = 0; i < this.cores.length; ++i) {
            this.addItem(new Integer(i));
        }
        this.setRenderer(this);
    }

    public CorComboBox(boolean removerPersonalizada) {
        for (int i = 0; i < this.cores.length; ++i) {
            if (removerPersonalizada && i + 1 != this.cores.length) {
                this.addItem(new Integer(i));
                continue;
            }
            if (removerPersonalizada) continue;
            this.addItem(new Integer(i));
        }
        this.setRenderer(this);
    }

    public void setCores(Color[] cores) {
        this.cores = cores;
    }

    public Color[] getCores() {
        return this.cores;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        ComponenteCor tmp = new ComponenteCor(list.getBackground(), "");
        if (value != null && this.cores.length > 0) {
            int indice = (Integer)value;
            tmp = new ComponenteCor(this.cores[indice], this.nomes[indice]);
            tmp.setPreferredSize(new Dimension(10, 15));
            if (isSelected) {
                tmp.setBackground(list.getSelectionBackground());
                tmp.setForeground(list.getSelectionForeground());
            } else {
                tmp.setBackground(list.getBackground());
                tmp.setForeground(list.getForeground());
            }
        }
        return tmp;
    }

    public void setCorPersonalizada(Color cor) {
        this.cores[this.cores.length - 1] = cor;
    }

    public Color getCorSelecionada() {
        int i = this.getSelectedIndex();
        return i > -1 ? this.cores[i] : null;
    }

    public void setCorSelecionada(Color cor) {
        boolean ok = false;
        for (int i = 0; i < this.cores.length - 1; ++i) {
            if (!this.cores[i].equals(cor)) continue;
            this.setSelectedIndex(i);
            ok = true;
        }
        if (!ok) {
            this.cores[this.cores.length - 1] = cor;
            this.setSelectedIndex(this.cores.length - 1);
        }
    }

    public String getNomeCorSelecionada() {
        int i = this.getSelectedIndex();
        return i > -1 ? this.nomes[i] : "";
    }

    public int getIndiceCorPersonalizada() {
        return this.cores.length - 1;
    }
}

