/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.Laboratorio;
import jalis.service.cadastro.ConvenioService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.TDialog;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;

public class ConvenioUtil {
    private static final RoundingMode ROUND = RoundingMode.HALF_UP;
    private static final int CASAS = 2;
    private static int EXAME_CODIGO = 1;
    private static int EXAME_MATERIAL = 3;

    public static boolean verificaPoliticaCota(String filial, DadosConvenios convenio, Component owner, Integer codigoRequisicao, java.util.Date data) {
        block24: {
            if (convenio.getTipoPolitica().equalsIgnoreCase("C")) {
                ResultSet rs;
                Integer valorCota = convenio.getValorCota();
                if (valorCota == null || valorCota <= 0) {
                    Funcoes.mensagem(owner, "O valor da cota do conv\u00eanio n\u00e3o foi definido.", 2);
                    return false;
                }
                boolean isConsiderarAgendamentoCota = false;
                StringBuilder buf = new StringBuilder();
                buf.append(" select con_usaragendamentopolitica ");
                buf.append("   from convenios ");
                buf.append("  where con_codigo = ").append(convenio.getCodigo());
                buf.append("    and fil_codigo = ").append(filial);
                try {
                    rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                    if (rs.next()) {
                        isConsiderarAgendamentoCota = rs.getBoolean("con_usaragendamentopolitica");
                    }
                }
                catch (SQLException sqle) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar as informa\u00e7\u00f5es do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                }
                if (convenio.getZerarPolitica().equalsIgnoreCase("M")) {
                    buf.setLength(0);
                    buf.append(" select COUNT(1) as qtde ");
                    buf.append("   from requisicao r");
                    if (isConsiderarAgendamentoCota) {
                        buf.append(" left join agendamento a on r.fil_codigo = a.fil_codigo and r.req_codigo = a.req_codigo and a.agd_datahoracancelamento IS NULL ");
                    }
                    buf.append("  where r.con_codigo = ").append(convenio.getCodigo());
                    buf.append("    and r.fil_codigo = ").append(filial);
                    buf.append("    and date_trunc('month', req_dtfatura) = cast('").append(Funcoes.formataData("yyyy-MM", data)).append("-01' as timestamp) ");
                    if (isConsiderarAgendamentoCota) {
                        buf.append("    \tAND (NOT r.req_excluida or (a.agd_codigo is not null and a.agd_datahoracancelamento IS NULL) )");
                    } else {
                        buf.append("    and not r.req_excluida");
                    }
                    if (codigoRequisicao != null) {
                        buf.append(" and r.req_codigo <> ").append(codigoRequisicao);
                    }
                    try {
                        rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                        if (rs.next()) {
                            int qtde = rs.getInt("qtde");
                            if (++qtde > valorCota) {
                                Funcoes.mensagem(owner, "A cota de \"" + valorCota + "\" requisi\u00e7\u00f5es do conv\u00eanio foi esgotada.", 2);
                                return !convenio.getBloqueioPolitica().equalsIgnoreCase("P");
                            }
                            return true;
                        }
                        break block24;
                    }
                    catch (SQLException sqle) {
                        ErrorLogger.mostraMensagem(owner, "N\u00e3o foi poss\u00edvel buscar o valor da cota do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                        return false;
                    }
                }
                buf.setLength(0);
                buf.append(" select MAX(fat_datahora) as data ");
                buf.append("   from fatura ");
                buf.append("  where con_codigo = ").append(convenio.getCodigo());
                buf.append("    and fil_codigo = ").append(filial);
                buf.append("    and fat_datacancelamento IS NULL ");
                try {
                    rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                    if (rs.next()) {
                        Date dataFatura = rs.getDate("data");
                        buf.setLength(0);
                        buf.append(" select COUNT(1) as qtde ");
                        buf.append("   from requisicao a ");
                        buf.append("   left join faturarequisicao b on a.fil_codigo = b.fil_kodigo and a.req_codigo = b.req_codigo ");
                        buf.append("   left join fatura c on b.fil_codigo = c.fil_codigo and b.fat_codigo = c.fat_codigo ");
                        if (isConsiderarAgendamentoCota) {
                            buf.append(" left join agendamento agend on a.fil_codigo = agend.fil_codigo and a.req_codigo = agend.req_codigo and agend.agd_datahoracancelamento IS NULL");
                        }
                        buf.append("  where a.con_codigo = ").append(convenio.getCodigo());
                        buf.append("    and a.fil_codigo = ").append(filial);
                        buf.append("    and not a.req_excluida ");
                        buf.append("    and c.fat_datacancelamento is null ");
                        buf.append("    and b.req_codigo is null ");
                        if (codigoRequisicao != null) {
                            buf.append(" and a.req_codigo <> ").append(codigoRequisicao);
                        }
                        if (dataFatura != null) {
                            buf.append("    and a.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", dataFatura)).append("' ");
                        }
                        if (isConsiderarAgendamentoCota) {
                            buf.append("    \tAND (NOT a.req_excluida or (agend.agd_codigo is not null and agend.agd_datahoracancelamento IS NULL) )");
                        } else {
                            buf.append("    and not a.req_excluida");
                        }
                        rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                        if (rs.next()) {
                            int qtde = rs.getInt("qtde");
                            if (++qtde > valorCota) {
                                Funcoes.mensagem(owner, "A cota de \"" + valorCota + "\" requisi\u00e7\u00f5es do conv\u00eanio foi esgotada.", 2);
                                return !convenio.getBloqueioPolitica().equalsIgnoreCase("P");
                            }
                            return true;
                        }
                    }
                }
                catch (SQLException sqle) {
                    ErrorLogger.mostraMensagem(owner, "N\u00e3o foi poss\u00edvel buscar o valor da cota do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean verificaPoliticaCotaUnidadeSaude(String filial, DadosConvenios convenio, Component owner, String unidadeSaude, int quantidadeExames, String codigoRequisicao, java.util.Date data) {
        block36: {
            if (convenio.getTipoPolitica().equalsIgnoreCase("U")) {
                ResultSet rs;
                boolean isConsiderarAgendamentoCota = false;
                StringBuilder buf = new StringBuilder();
                buf.append(" select con_usaragendamentopolitica ");
                buf.append("   from convenios ");
                buf.append("  where con_codigo = ").append(convenio.getCodigo());
                buf.append("    and fil_codigo = ").append(filial);
                try {
                    rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                    if (rs.next()) {
                        isConsiderarAgendamentoCota = rs.getBoolean("con_usaragendamentopolitica");
                    }
                }
                catch (SQLException sqle) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar as informa\u00e7\u00f5es do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                }
                if (convenio.getZerarPolitica().equalsIgnoreCase("M")) {
                    buf.setLength(0);
                    buf.append(" select COUNT(er.req_codigo) as qtde ");
                    buf.append("   from requisicao r");
                    buf.append(" inner join examerequisicao er on r.fil_codigo = er.fil_codigo and r.req_codigo = er.req_codigo ");
                    if (isConsiderarAgendamentoCota) {
                        buf.append(" left join agendamento a on r.fil_codigo = a.fil_codigo and r.req_codigo = a.req_codigo and a.agd_datahoracancelamento IS NULL ");
                    }
                    buf.append("  where r.con_codigo = ").append(convenio.getCodigo());
                    buf.append("    and r.fil_codigo = ").append(filial);
                    buf.append("    and r.uns_codigo = '").append(unidadeSaude).append("'");
                    buf.append("    and not exr_excluido ");
                    buf.append("    and date_trunc('month', req_dtfatura) = cast('").append(Funcoes.formataData("yyyy-MM", data)).append("-01' as timestamp) ");
                    if (isConsiderarAgendamentoCota) {
                        buf.append("    \tAND (NOT r.req_excluida or (a.agd_codigo is not null and a.agd_datahoracancelamento IS NULL) )");
                    } else {
                        buf.append("    and not r.req_excluida");
                    }
                    if (codigoRequisicao != null) {
                        buf.append(" and r.req_codigo <> ").append(codigoRequisicao);
                    }
                    try {
                        rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                        if (!rs.next()) break block36;
                        int qtde = rs.getInt("qtde");
                        if (!Funcoes.textoVazio(unidadeSaude) && convenio.getTipoPolitica().equalsIgnoreCase("U")) {
                            StringBuilder bufs = new StringBuilder();
                            bufs.append("select cus_qtdeexame as qtde from conveniounidadesaude where fil_codigo = ");
                            bufs.append(filial);
                            bufs.append(" and con_codigo = ").append(convenio.getCodigo());
                            bufs.append(" and uns_codigo = '").append(unidadeSaude).append("'");
                            try {
                                rs = Conexao.executeQuery(Conexao.getStatement(), bufs.toString());
                                if (rs.next()) {
                                    int qtdeCota = rs.getInt("qtde");
                                    if (quantidadeExames + qtde > qtdeCota) {
                                        String mensagem = "A cota m\u00e1xima de \"" + qtdeCota + "\" da unidade de sa\u00fade foi esgotada.";
                                        if (convenio.getBloqueioPolitica().equalsIgnoreCase("P")) {
                                            mensagem = mensagem + "\n N\u00e3o \u00e9 poss\u00edvel salvar a requisi\u00e7\u00e3o pois o n\u00famero de exames excede o valor permitido.";
                                            Funcoes.mensagem(owner, mensagem, 2);
                                        } else if (convenio.getBloqueioPolitica().equalsIgnoreCase("A")) {
                                            Funcoes.mensagem(owner, mensagem, 2);
                                        }
                                    }
                                    if (convenio.getBloqueioPolitica().equalsIgnoreCase("P")) {
                                        return quantidadeExames + qtde <= qtdeCota;
                                    }
                                }
                            }
                            catch (SQLException e) {
                                ErrorLogger.mostraMensagem(owner, "N\u00e3o foi poss\u00edvel buscar o valor da cota da unidade de sa\u00fade.\n" + e.getMessage(), e.getStackTrace());
                                return false;
                            }
                        }
                        return true;
                    }
                    catch (SQLException sqle) {
                        ErrorLogger.mostraMensagem(owner, "N\u00e3o foi poss\u00edvel buscar o valor da cota do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                        return false;
                    }
                }
                buf.setLength(0);
                buf.append(" select MAX(fat_datahora) as data ");
                buf.append("   from fatura ");
                buf.append("  where con_codigo = ").append(convenio.getCodigo());
                buf.append("    and fil_codigo = ").append(filial);
                buf.append("    and fat_datacancelamento IS NULL ");
                try {
                    rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                    if (!rs.next()) break block36;
                    Date dataFatura = rs.getDate("data");
                    buf.setLength(0);
                    buf.append(" select COUNT(er.req_codigo) as qtde ");
                    buf.append("   from requisicao a ");
                    buf.append(" inner join examerequisicao er on a.fil_codigo = er.fil_codigo and a.req_codigo = er.req_codigo ");
                    buf.append("   left join faturarequisicao b on a.fil_codigo = b.fil_kodigo and a.req_codigo = b.req_codigo ");
                    buf.append("   left join fatura c on b.fil_codigo = c.fil_codigo and b.fat_codigo = c.fat_codigo ");
                    if (isConsiderarAgendamentoCota) {
                        buf.append(" left join agendamento agend on a.fil_codigo = agend.fil_codigo and a.req_codigo = agend.req_codigo and agend.agd_datahoracancelamento IS NULL");
                    }
                    buf.append("  where a.con_codigo = ").append(convenio.getCodigo());
                    buf.append("    and a.fil_codigo = ").append(filial);
                    buf.append("    and not a.req_excluida ");
                    buf.append("    and not exr_excluido ");
                    buf.append("    and c.fat_datacancelamento is null ");
                    buf.append("    and b.req_codigo is null ");
                    buf.append("    and r.uns_codigo = '").append(unidadeSaude).append("'");
                    if (codigoRequisicao != null) {
                        buf.append(" and a.req_codigo <> ").append(codigoRequisicao);
                    }
                    if (dataFatura != null) {
                        buf.append("    and a.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", dataFatura)).append("' ");
                    }
                    if (isConsiderarAgendamentoCota) {
                        buf.append("    \tAND (NOT a.req_excluida or (agend.agd_codigo is not null and agend.agd_datahoracancelamento IS NULL) )");
                    } else {
                        buf.append("    and not a.req_excluida");
                    }
                    rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                    if (!rs.next()) break block36;
                    int qtde = rs.getInt("qtde");
                    if (!Funcoes.textoVazio(unidadeSaude) && convenio.getTipoPolitica().equalsIgnoreCase("U")) {
                        StringBuilder bufs = new StringBuilder();
                        bufs.append("select cus_qtdeexame as qtde from conveniounidadesaude where fil_codigo = ");
                        bufs.append(filial);
                        bufs.append(" and con_codigo = ").append(convenio.getCodigo());
                        bufs.append(" and uns_codigo = '").append(unidadeSaude).append("'");
                        try {
                            rs = Conexao.executeQuery(Conexao.getStatement(), bufs.toString());
                            if (rs.next()) {
                                int qtdeCota = rs.getInt("qtde");
                                if (quantidadeExames + qtde > qtdeCota) {
                                    String mensagem = "A cota m\u00e1xima de \"" + qtdeCota + "\" da unidade de sa\u00fade foi esgotada.";
                                    if (convenio.getBloqueioPolitica().equalsIgnoreCase("P")) {
                                        mensagem = mensagem + "\n N\u00e3o \u00e9 poss\u00edvel salvar a requisi\u00e7\u00e3o pois o n\u00famero de exames excede o valor permitido.";
                                        Funcoes.mensagem(owner, mensagem, 2);
                                    } else if (convenio.getBloqueioPolitica().equalsIgnoreCase("A")) {
                                        Funcoes.mensagem(owner, mensagem, 2);
                                    }
                                }
                                if (convenio.getBloqueioPolitica().equalsIgnoreCase("P")) {
                                    return quantidadeExames + qtde <= qtdeCota;
                                }
                            }
                        }
                        catch (SQLException e) {
                            ErrorLogger.mostraMensagem(owner, "N\u00e3o foi poss\u00edvel buscar o valor da cota da unidade de sa\u00fade.\n" + e.getMessage(), e.getStackTrace());
                            return false;
                        }
                    }
                    return true;
                }
                catch (SQLException sqle) {
                    ErrorLogger.mostraMensagem(owner, "N\u00e3o foi poss\u00edvel buscar o valor da cota do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                    return false;
                }
            }
        }
        return true;
    }

    public static Integer getUtilizadoPoliticaCota(String filial, String codigoConvenio, String zerarPolitica) {
        ResultSet rs;
        if (codigoConvenio == null || zerarPolitica == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o \u00e9 poss\u00edvel buscar a cota utilizada do conv\u00eanio.", 2);
            return 0;
        }
        boolean isConsiderarAgendamentoCota = false;
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_usaragendamentopolitica ");
        buf.append("   from convenios ");
        buf.append("  where con_codigo = ").append(codigoConvenio);
        buf.append("    and fil_codigo = ").append(filial);
        try {
            rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                isConsiderarAgendamentoCota = rs.getBoolean("con_usaragendamentopolitica");
            }
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar as informa\u00e7\u00f5es do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
        }
        if (zerarPolitica.equalsIgnoreCase("M")) {
            buf.setLength(0);
            buf.append(" select COUNT(1) as qtde ");
            buf.append("   from requisicao r");
            if (isConsiderarAgendamentoCota) {
                buf.append(" left join agendamento a on r.fil_codigo = a.fil_codigo and r.req_codigo = a.req_codigo and a.agd_datahoracancelamento IS NULL ");
            }
            buf.append("  where r.con_codigo = ").append(codigoConvenio);
            buf.append("    and r.fil_codigo = ").append(filial);
            buf.append("    and date_trunc('month', req_dtfatura) = cast('").append(Funcoes.formataData("yyyy-MM", new java.util.Date())).append("-01' as timestamp) ");
            if (isConsiderarAgendamentoCota) {
                buf.append("    AND (NOT r.req_excluida or (a.agd_codigo is not null and a.agd_datahoracancelamento IS NULL) )");
            } else {
                buf.append("    and not r.req_excluida ");
            }
            try {
                rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs.next()) {
                    return rs.getInt("qtde");
                }
                return 0;
            }
            catch (SQLException sqle) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a cota utilizada do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                return 0;
            }
        }
        buf.setLength(0);
        buf.append(" select MAX(fat_datahora) as data ");
        buf.append("   from fatura ");
        buf.append("  where con_codigo = ").append(codigoConvenio);
        buf.append("    and fil_codigo = ").append(filial);
        buf.append("    and fat_datacancelamento IS NULL ");
        try {
            rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                Date dataFatura = rs.getDate("data");
                buf.setLength(0);
                buf.append(" select COUNT(1) as qtde ");
                buf.append("   from requisicao a ");
                buf.append("   left join faturarequisicao b on a.fil_codigo = b.fil_kodigo and a.req_codigo = b.req_codigo ");
                buf.append("   left join fatura c on b.fil_codigo = c.fil_codigo and b.fat_codigo = c.fat_codigo ");
                if (isConsiderarAgendamentoCota) {
                    buf.append(" left join agendamento agend on a.fil_codigo = agend.fil_codigo and a.req_codigo = agend.req_codigo and agend.agd_datahoracancelamento IS NULL ");
                }
                buf.append("  where a.con_codigo = ").append(codigoConvenio);
                buf.append("    and a.fil_codigo = ").append(filial);
                buf.append("    and c.fat_datacancelamento is null ");
                buf.append("    and b.req_codigo is null ");
                if (dataFatura != null) {
                    buf.append("    and a.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", dataFatura)).append("' ");
                }
                if (isConsiderarAgendamentoCota) {
                    buf.append("    AND (NOT a.req_excluida or (agend.agd_codigo is not null and agend.agd_datahoracancelamento IS NULL) )");
                } else {
                    buf.append("    and not a.req_excluida ");
                }
                rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs.next()) {
                    return rs.getInt("qtde");
                }
                return 0;
            }
            return 0;
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a cota utilizada do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
            return 0;
        }
    }

    public static Integer getUtilizadoPoliticaCotaUnidadeSaude(String filial, String codigoConvenio, String zerarPolitica) {
        ResultSet rs;
        if (codigoConvenio == null || zerarPolitica == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o \u00e9 poss\u00edvel buscar a cota utilizada do conv\u00eanio.", 2);
            return 0;
        }
        boolean isConsiderarAgendamentoCota = false;
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_usaragendamentopolitica ");
        buf.append("   from convenios ");
        buf.append("  where con_codigo = ").append(codigoConvenio);
        buf.append("    and fil_codigo = ").append(filial);
        try {
            rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                isConsiderarAgendamentoCota = rs.getBoolean("con_usaragendamentopolitica");
            }
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar as informa\u00e7\u00f5es do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
        }
        if (zerarPolitica.equalsIgnoreCase("M")) {
            buf.setLength(0);
            buf.append(" select COUNT(1) as qtde ");
            buf.append("   from requisicao r");
            buf.append(" inner join conveniounidadesaude cus on r.fil_codigo = cus.fil_codigo and r.con_codigo = cus.con_codigo and r.uns_codigo = cus.uns_codigo");
            if (isConsiderarAgendamentoCota) {
                buf.append(" left join agendamento a on r.fil_codigo = a.fil_codigo and r.req_codigo = a.req_codigo and a.agd_datahoracancelamento IS NULL ");
            }
            buf.append("  where r.con_codigo = ").append(codigoConvenio);
            buf.append("    and r.fil_codigo = ").append(filial);
            buf.append("    and date_trunc('month', req_dtfatura) = cast('").append(Funcoes.formataData("yyyy-MM", new java.util.Date())).append("-01' as timestamp) ");
            if (isConsiderarAgendamentoCota) {
                buf.append("    AND (NOT r.req_excluida or (a.agd_codigo is not null and a.agd_datahoracancelamento IS NULL) )");
            } else {
                buf.append("    and not r.req_excluida ");
            }
            try {
                rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs.next()) {
                    return rs.getInt("qtde");
                }
                return 0;
            }
            catch (SQLException sqle) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a cota utilizada do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                return 0;
            }
        }
        buf.setLength(0);
        buf.append(" select MAX(fat_datahora) as data ");
        buf.append("   from fatura ");
        buf.append("  where con_codigo = ").append(codigoConvenio);
        buf.append("    and fil_codigo = ").append(filial);
        buf.append("    and fat_datacancelamento IS NULL ");
        try {
            rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                Date dataFatura = rs.getDate("data");
                buf.setLength(0);
                buf.append(" select COUNT(1) as qtde ");
                buf.append("   from requisicao a ");
                buf.append(" inner join conveniounidadesaude cus on a.fil_codigo = cus.fil_codigo and a.con_codigo = cus.con_codigo and a.uns_codigo = cus.uns_codigo");
                buf.append("   left join faturarequisicao b on a.fil_codigo = b.fil_kodigo and a.req_codigo = b.req_codigo ");
                buf.append("   left join fatura c on b.fil_codigo = c.fil_codigo and b.fat_codigo = c.fat_codigo ");
                if (isConsiderarAgendamentoCota) {
                    buf.append(" left join agendamento agend on a.fil_codigo = agend.fil_codigo and a.req_codigo = agend.req_codigo and agend.agd_datahoracancelamento IS NULL ");
                }
                buf.append("  where a.con_codigo = ").append(codigoConvenio);
                buf.append("    and a.fil_codigo = ").append(filial);
                buf.append("    and c.fat_datacancelamento is null ");
                buf.append("    and b.req_codigo is null ");
                if (dataFatura != null) {
                    buf.append("    and a.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", dataFatura)).append("' ");
                }
                if (isConsiderarAgendamentoCota) {
                    buf.append("    AND (NOT a.req_excluida or (agend.agd_codigo is not null and agend.agd_datahoracancelamento IS NULL) )");
                } else {
                    buf.append("    and not a.req_excluida ");
                }
                rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs.next()) {
                    return rs.getInt("qtde");
                }
                return 0;
            }
            return 0;
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a cota utilizada do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
            return 0;
        }
    }

    public static boolean verificaPoliticaCotaMaximaExame(int filial, DadosConvenios convenio, Component owner, Integer codigoRequisicao, java.util.Date data, ModeloGridTable modeloExame) throws Exception {
        block14: {
            if (convenio.getTipoPolitica().equalsIgnoreCase("M")) {
                boolean isConsiderarAgendamentoCota = false;
                try {
                    isConsiderarAgendamentoCota = new ConvenioService().isConsiderarAgendamentoCota(filial, convenio.getCodigo());
                }
                catch (SQLException sqle) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar as informa\u00e7\u00f5es do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                }
                if (convenio.getZerarPolitica().equalsIgnoreCase("M")) {
                    try {
                        ModeloGridTable modeloExameEsgotado = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Material", "Descri\u00e7\u00e3o"});
                        for (int i = 0; i < modeloExame.getRowCount(); ++i) {
                            String exame = (String)modeloExame.getValueAt(i, EXAME_CODIGO);
                            int material = ((DadosMaterial)modeloExame.getValueAt(i, EXAME_MATERIAL)).getCodigo();
                            int qtdeCotaExame = new ConvenioService().quantidadeRequisicaoPorPeriodoMes(filial, convenio.getCodigo(), exame, material, isConsiderarAgendamentoCota, data, codigoRequisicao);
                            int valorCota = new ConvenioService().retornaConvenioCotaExameQuantidade(filial, convenio.getCodigo(), StringUtil.textoDBEscape(convenio.getTipoPolitica()), exame, material);
                            if (valorCota <= 0 || qtdeCotaExame < valorCota) continue;
                            if (convenio.getBloqueioPolitica().equalsIgnoreCase("P")) {
                                if (convenio.getTipoPolitica().equalsIgnoreCase("M")) {
                                    Object[] item = new Object[]{modeloExame.getLineValue(i)[1], modeloExame.getLineValue(i)[2], ((DadosMaterial)modeloExame.getLineValue(i)[3]).getCodigo(), ((DadosMaterial)modeloExame.getLineValue(i)[3]).getDescricao()};
                                    modeloExameEsgotado.addLine(item);
                                    continue;
                                }
                                Funcoes.mensagem(owner, "A cota m\u00e1xima de " + valorCota + " requisi\u00e7\u00f5es do conv\u00eanio foi esgotada. \n N\u00e3o \u00e9 poss\u00edvel salvar a requisi\u00e7\u00e3o pois o n\u00famero de exames excede o valor permitido. ", 2);
                                return false;
                            }
                            Funcoes.mensagem(owner, "A cota m\u00e1xima de " + valorCota + " requisi\u00e7\u00f5es do conv\u00eanio foi esgotada. ", 2);
                            return true;
                        }
                        if (modeloExameEsgotado.getRowCount() > 0) {
                            ConvenioUtil.getMensagemCotaEsgotada(modeloExameEsgotado, owner);
                            return false;
                        }
                        break block14;
                    }
                    catch (SQLException sqle) {
                        ErrorLogger.mostraMensagem(owner, "N\u00e3o foi poss\u00edvel buscar o valor da cota do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                        return false;
                    }
                }
                try {
                    for (int i = 0; i < modeloExame.getRowCount(); ++i) {
                        String exame = (String)modeloExame.getValueAt(i, EXAME_CODIGO);
                        int material = ((DadosMaterial)modeloExame.getValueAt(i, EXAME_MATERIAL)).getCodigo();
                        java.util.Date dataFatura = new ConvenioService().retornaDataHoraUltimoFaturamento(filial, convenio.getCodigo(), exame, material);
                        if (dataFatura == null) continue;
                        int quantidade = new ConvenioService().quantidadeRequisicaoPorDataFaturamento(filial, convenio.getCodigo(), exame, material, isConsiderarAgendamentoCota, dataFatura);
                        int valorCota = new ConvenioService().retornaConvenioCotaExameQuantidade(filial, convenio.getCodigo(), StringUtil.textoDBEscape(convenio.getTipoPolitica()), exame, material);
                        if (quantidade <= 0 || valorCota <= 0 || quantidade <= valorCota) continue;
                        if (convenio.getBloqueioPolitica().equalsIgnoreCase("P")) {
                            Funcoes.mensagem(owner, "A cota m\u00e1xima de " + valorCota + " requisi\u00e7\u00f5es do conv\u00eanio foi esgotada. \n N\u00e3o \u00e9 poss\u00edvel salvar a requisi\u00e7\u00e3o pois o n\u00famero de exames excede o valor permitido. ", 2);
                            return false;
                        }
                        Funcoes.mensagem(owner, "A cota m\u00e1xima de " + valorCota + " requisi\u00e7\u00f5es do conv\u00eanio foi esgotada. ", 2);
                        return true;
                    }
                }
                catch (SQLException sqle) {
                    ErrorLogger.mostraMensagem(owner, "N\u00e3o foi poss\u00edvel buscar o valor da cota do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                    return false;
                }
            }
        }
        return true;
    }

    private static void getMensagemCotaEsgotada(ModeloGridTable modeloExameEsgotado, Component owner) {
        JPanel painel = new JPanel(new GridBagLayout());
        JLabel label_icon = new JLabel();
        label_icon.setIcon(TDialog.ICON_WARNING);
        label_icon.setBorder(new EmptyBorder(5, 15, 0, 15));
        final JDialog telaAlertaEsgotada = new JDialog(Laboratorio.getInstancia(), "Alerta", true);
        JButton buttonOK = new JButton();
        buttonOK.setText("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                telaAlertaEsgotada.dispose();
            }
        });
        telaAlertaEsgotada.setPreferredSize(new Dimension(600, 320));
        telaAlertaEsgotada.setSize(new Dimension(600, 320));
        telaAlertaEsgotada.setLocationRelativeTo(owner);
        JLabel jLabelExamesEsgotados = new JLabel("Exames esgotados:");
        modeloExameEsgotado.setColumnName(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Material", "Descri\u00e7\u00e3o"});
        JTable tableExamesEsgotados = ComponenteFactory.novoJTable((TableModel)modeloExameEsgotado, 70, 0, 60, 150);
        JScrollPane scrollExames = new JScrollPane(tableExamesEsgotados);
        scrollExames.setMinimumSize(new Dimension(20, 100));
        scrollExames.setPreferredSize(new Dimension(20, 100));
        JLabel label_msg = new JLabel();
        String msg = "A cota m\u00e1xima de " + modeloExameEsgotado.getRowCount() + " exames do conv\u00eanio foi esgotada. \n N\u00e3o \u00e9 poss\u00edvel salvar a requisi\u00e7\u00e3o pois o n\u00famero de exames excede o valor permitido. ";
        msg = "<html>" + msg.replaceAll("\n", "<br>") + "</html>";
        label_msg.setText(msg);
        label_msg.getFontMetrics(label_msg.getFont()).getLineMetrics(msg, label_msg.getGraphics());
        JPanel panel_left = new JPanel(new BorderLayout());
        JPanel panel_right = new JPanel(new BorderLayout());
        JPanel panel_msg = new JPanel(new BorderLayout());
        panel_left.add((Component)label_icon, "Center");
        panel_right.add((Component)panel_msg, "Center");
        panel_msg.add((Component)label_msg, "Center");
        JPanel panelConteudo = new JPanel(new BorderLayout());
        panelConteudo.add((Component)panel_left, "West");
        panelConteudo.add((Component)panel_right, "Center");
        JPanel panelButton = new JPanel(new BorderLayout());
        panelButton.setPreferredSize(new Dimension(100, 10));
        panelButton.setLayout(new FlowLayout(2, 3, 3));
        panelButton.add((Component)buttonOK, "Last");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        painel.add((Component)panelConteudo, c);
        ++c.gridy;
        painel.add((Component)jLabelExamesEsgotados, c);
        ++c.gridy;
        painel.add((Component)scrollExames, c);
        ++c.gridy;
        painel.add((Component)panelButton, c);
        telaAlertaEsgotada.add(painel);
        telaAlertaEsgotada.setVisible(true);
    }

    public static boolean verificaPoliticaCredito(String filial, DadosConvenios convenio, BigDecimal valor, boolean somenteExame, Component owner, Integer codigoRequisicao) {
        if (convenio.getTipoPolitica().equalsIgnoreCase("T")) {
            ResultSet rs;
            Double valorCredito = convenio.getValorCredito();
            if (valorCredito == null || valorCredito <= 0.0) {
                Funcoes.mensagem(owner, "O valor de cr\u00e9dito do conv\u00eanio n\u00e3o foi definido.", 2);
                return false;
            }
            if (valor == null) {
                ErrorLogger.mostraMensagem(owner, "O valor da requisi\u00e7\u00e3o n\u00e3o foi informado.", null, "ConvenioUtil.verificaPoliticaCredito");
                return false;
            }
            boolean isConsiderarAgendamentoCota = false;
            StringBuilder buf = new StringBuilder();
            buf.append(" select con_usaragendamentopolitica ");
            buf.append("   from convenios ");
            buf.append("  where con_codigo = ").append(convenio.getCodigo());
            buf.append("    and fil_codigo = ").append(filial);
            try {
                ResultSet rs2 = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs2.next()) {
                    isConsiderarAgendamentoCota = rs2.getBoolean("con_usaragendamentopolitica");
                }
            }
            catch (SQLException sqle) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar as informa\u00e7\u00f5es do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
            }
            Date dataFatura = null;
            if (convenio.getZerarPolitica().equalsIgnoreCase("F")) {
                buf.setLength(0);
                buf.append(" select MAX(fat_datahora) as data ");
                buf.append("   from fatura ");
                buf.append("  where con_codigo = ").append(convenio.getCodigo());
                buf.append("    and fil_codigo = ").append(filial);
                buf.append("    and fat_datacancelamento IS NULL ");
                try {
                    rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                    if (rs.next()) {
                        dataFatura = rs.getDate("data");
                    }
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(owner, "N\u00e3o foi poss\u00edvel buscar a data da \u00faltima fatura do convenio.\n" + e.getMessage(), e.getStackTrace());
                    return false;
                }
            }
            buf.setLength(0);
            buf.append(" select SUM(calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exr.exa_codigo, exr.mco_codigo, false, true, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo").append(")) as valor ");
            buf.append("   from requisicao req ");
            buf.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
            buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
            if (isConsiderarAgendamentoCota) {
                buf.append(" left join agendamento a on req.fil_codigo = a.fil_codigo and req.req_codigo = a.req_codigo and a.agd_datahoracancelamento IS NULL");
            }
            buf.append("  where req.con_codigo = ").append(convenio.getCodigo());
            buf.append("    and req.fil_codigo = ").append(filial);
            if (isConsiderarAgendamentoCota) {
                buf.append("    AND (NOT req.req_excluida or (a.agd_codigo is not null and a.agd_datahoracancelamento IS NULL) )");
            } else {
                buf.append("    and not req.req_excluida ");
            }
            buf.append("    and not exr.exr_excluido ");
            if (convenio.getZerarPolitica().equalsIgnoreCase("F")) {
                buf.append("    and exr.exr_datafatura is null ");
            }
            if (convenio.getZerarPolitica().equalsIgnoreCase("M")) {
                buf.append("    and date_trunc('month', req.req_data) = cast('").append(Funcoes.formataData("yyyy-MM", new java.util.Date())).append("-01' as timestamp) ");
            } else if (dataFatura != null) {
                buf.append("    and req.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", dataFatura)).append("' ");
            }
            if (codigoRequisicao != null) {
                buf.append(" and req.req_codigo <> ").append(codigoRequisicao);
            }
            try {
                rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                BigDecimal aux = BigDecimal.ZERO;
                if (rs.next()) {
                    aux = rs.getBigDecimal("valor") == null ? BigDecimal.ZERO : rs.getBigDecimal("valor");
                }
                Double valorRequisicoes = Double.parseDouble(aux.add(valor).setScale(2, ROUND).toString());
                Double valorDisponivel = convenio.getValorCredito() - Double.parseDouble(aux.setScale(2, ROUND).toString());
                if (valorDisponivel < valor.doubleValue()) {
                    Funcoes.mensagem(owner, "O cr\u00e9dito de \"R$ " + Funcoes.formataDecimal(convenio.getValorCredito()) + "\" do conv\u00eanio foi ultrapassado.\n" + (valorDisponivel >= 0.0 ? "Cr\u00e9dito dispon\u00edvel: \"R$ " : "Valor ultrapassado: \"R$ ") + Funcoes.formataDecimal(valorDisponivel >= 0.0 ? valorDisponivel : valorDisponivel * -1.0) + "\".\nValor " + (somenteExame ? "do Exame: " : "da requisi\u00e7\u00e3o: ") + "\"R$ " + Funcoes.formataDecimal(Double.parseDouble(valor.toString())) + "\".", 2);
                    return !convenio.getBloqueioPolitica().equalsIgnoreCase("P");
                }
                return true;
            }
            catch (SQLException sqle) {
                ErrorLogger.mostraMensagem(owner, "N\u00e3o foi poss\u00edvel buscar o valor de cr\u00e9dito do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                return false;
            }
        }
        ErrorLogger.mostraMensagem(owner, "Pol\u00edtica incorreta.", null, "ConvenioUtil.verificaPoliticaCota");
        return false;
    }

    public static Double getUtilizadoPoliticaCredito(String filial, String codigoConvenio, String zerarPolitica) {
        ResultSet rs;
        if (codigoConvenio == null || zerarPolitica == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o \u00e9 poss\u00edvel buscar o cr\u00e9dito utilizado do conv\u00eanio.", 2);
            return 0.0;
        }
        Date dataFatura = null;
        if (zerarPolitica.equalsIgnoreCase("F")) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select MAX(fat_datahora) as data ");
            buf.append("   from fatura ");
            buf.append("  where con_codigo = ").append(codigoConvenio);
            buf.append("    and fil_codigo = ").append(filial);
            buf.append("    and fat_datacancelamento IS NULL ");
            try {
                ResultSet rs2 = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs2.next()) {
                    dataFatura = rs2.getDate("data");
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a data da \u00faltima fatura do convenio.\n" + e.getMessage(), e.getStackTrace());
                return 0.0;
            }
        }
        boolean isConsiderarAgendamentoCota = false;
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_usaragendamentopolitica ");
        buf.append("   from convenios ");
        buf.append("  where con_codigo = ").append(codigoConvenio);
        buf.append("    and fil_codigo = ").append(filial);
        try {
            rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                isConsiderarAgendamentoCota = rs.getBoolean("con_usaragendamentopolitica");
            }
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar as informa\u00e7\u00f5es do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
        }
        buf.setLength(0);
        buf.append(" select SUM(calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exr.exa_codigo, exr.mco_codigo, false, true, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo").append(")) as valor ");
        buf.append("   from requisicao req ");
        buf.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        if (isConsiderarAgendamentoCota) {
            buf.append(" left join agendamento a on req.fil_codigo = a.fil_codigo and req.req_codigo = a.req_codigo and a.agd_datahoracancelamento IS NULL ");
        }
        buf.append("  where req.con_codigo = ").append(codigoConvenio);
        buf.append("    and req.fil_codigo = ").append(filial);
        buf.append("    and not exr.exr_excluido");
        if (zerarPolitica.equalsIgnoreCase("F")) {
            buf.append("    and exr.exr_datafatura is null ");
        }
        if (zerarPolitica.equalsIgnoreCase("M")) {
            buf.append("    and date_trunc('month', req.req_data) = cast('").append(Funcoes.formataData("yyyy-MM", new java.util.Date())).append("-01' as timestamp) ");
        } else if (dataFatura != null) {
            buf.append("    and req.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", dataFatura)).append("' ");
        }
        if (isConsiderarAgendamentoCota) {
            buf.append("    AND (NOT req.req_excluida or (a.agd_codigo is not null and a.agd_datahoracancelamento IS NULL) )");
        } else {
            buf.append("    and not req.req_excluida ");
        }
        try {
            rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            BigDecimal aux = BigDecimal.ZERO;
            if (rs.next()) {
                return rs.getDouble("valor");
            }
            return 0.0;
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar o valor de cr\u00e9dito dispon\u00edvel do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isImprimirResumoFatura(String filial, String convenio) {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select con_imprimirresumo from convenios where ");
        buf.append("fil_codigo = ").append(filial);
        buf.append("and con_codigo = ").append(convenio);
        boolean retorno = false;
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            retorno = rs.next() && rs.getBoolean(1);
        }
        catch (Exception e) {
            try {
                retorno = false;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static boolean convenioCobraNoBalcao(String filial, String convenio) throws Exception {
        Statement st = Conexao.getStatement();
        boolean retorno = false;
        try {
            StringBuilder buf = new StringBuilder("select (con_cobrexame or (con_percpgtomaterial != null and con_percpgtomaterial > 0)) as cobra from convenios ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append(" and con_codigo = ").append(convenio);
            ResultSet rs = Conexao.executeQuery(st, buf);
            retorno = rs.next() && rs.getBoolean(1);
        }
        catch (Exception e) {
            try {
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static ArrayList<DadosConvenios> getConveniosRepasse(Statement st, Statement st2, String filial, String codigo) throws Exception {
        ArrayList<DadosConvenios> retorno = new ArrayList<DadosConvenios>();
        StringBuilder buf = new StringBuilder("select con_codrepasse from conveniosrepasse ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append(" and con_codigo = ").append(codigo);
        buf.append(" order by con_codrepasse ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            DadosConvenios d = ConvenioUtil.getDadosConvenios(filial, rs.getInt("con_codrepasse"), st2);
            if (d == null) continue;
            retorno.add(d);
        }
        return retorno;
    }

    public static String getTipoCalculoConvenioRepasse(Statement st, String filial, String codigoConvenioPrincipal, String codigoConvenioRepasse) throws Exception {
        StringBuilder buf = new StringBuilder("select cre_tipocalculo from conveniosrepasse ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append(" and con_codigo = ").append(codigoConvenioPrincipal);
        buf.append(" and con_codrepasse = ").append(codigoConvenioRepasse);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            return rs.getString(1);
        }
        return "P";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DadosConvenios getDadosConvenios(String filial, int codigo) throws SQLException {
        DadosConvenios dadosConvenios;
        Statement st = Conexao.getStatement();
        try {
            dadosConvenios = ConvenioUtil.getDadosConvenios(filial, codigo, st);
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return dadosConvenios;
    }

    public static DadosConvenios getDadosConvenios(String filial, int codigo, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder("select a.con_codigo, a.con_fantasia, a.con_maskcart, a.col_codigo, a.des_codigo, a.con_razao, a.con_nrexames, a.lay_codigo, ");
        buf.append("b.des_descricao, c.col_descricao, a.tpe_codigo, d.tpe_tipocbhpm, a.con_valorch, a.con_tpcalcch, a.con_cobrexame, a.con_cobrmaterial,");
        buf.append("a.con_percpgto, a.con_bonus, a.con_acrescimo, a.con_informarmat, a.con_titdep, a.con_norma, a.con_maskcart, a.con_adicionalminimorequisicao, ");
        buf.append("a.con_validadeguia, a.con_codigoguia, a.con_diasvalidade, a.con_proibido, a.con_percpgtomaterial, a.con_minimorequisicao, ");
        buf.append("a.con_qtdecolunas, a.con_imprimircomprovante, a.con_imprimircapa, a.con_imprimiranexo, a.con_imprimiranexocobranca, a.con_imprimirrecibo, a.con_imprimirprotocolo, ");
        buf.append(" a.con_imprimirguia, a.con_imprimiretqcoleta, a.con_imprimiretqtriagem, a.con_imprimirtermo, ");
        buf.append("a.con_mudardatafatura, a.con_descontoporte, a.con_descontouco, a.con_acrescimoporte, a.con_acrescimouco, a.con_examesporguia, ");
        buf.append("a.con_cnpjcpf, a.con_exigevalidadecarteira, a.con_exigenomeplano, a.con_exigeunidadesaude, a.con_reajuste, a.con_precosdiferenciados, a.con_tpcalcfatu ");
        buf.append(" , COALESCE(a.con_tipopolitica, '").append("N").append("') as con_tipopolitica, a.con_bloqueiopolitica, a.con_valorcota, a.con_valorcredito, a.con_zerarpolitica ");
        buf.append(" ,a.con_perguntarpercbalcao, COALESCE(a.con_descexame, false) as con_descexame, COALESCE(a.con_gerarguiarequisicao, false) as con_gerarguiarequisicao ");
        buf.append(" ,a.con_ignorardestinoestacao, a.con_ignorarcoletaestacao, a.con_contato, a.con_fone, a.con_integracaohospital,a.con_endereco, a.con_numeroendereco, a.con_tipologradouroendereco, a.con_apoiado, con_faturaeletronica, a.con_observ, a.con_email1, cid.cid_nome, cid.cid_uf ");
        buf.append(" ,bai.bai_codigo as codigoBairro, bai.bai_descricao as descricaoBairro, baicob.bai_codigo as codigoBairroCobranca, baicob.bai_descricao as descricaoBairroCobranca ");
        buf.append(" ,cidcob.cid_codigo as codigoCidadeCobranca, cidcob.cid_nome as descricaoCidadeCobranca, cidcob.cid_uf as ufCidadeCobranca ");
        buf.append(" ,a.con_tipopessoa, a.con_inscrest, a.con_inscmunic, a.cid_codigo, a.con_complemento, a.con_cep, a.con_fax, a.con_site ");
        buf.append(" ,a.con_tipologradouroendcobranca, a.con_endcobranca, a.con_numeroendcobranca, a.con_cepcobranca, COALESCE(a.con_exigircartaosus, false) as con_exigircartaosus ");
        buf.append(" ,a.con_configelegibilidade, a.con_configsolicitadotiss, a.con_pesquisarelegibilidade, a.con_solicitartiss, a.con_configstatustiss, a.con_statustiss, a.con_senhaweb, a.con_usaragendamentopolitica ");
        buf.append(" ,a.con_exigirvalorminimo, a.con_percvalorminimo, a.con_mascaratoken, a.con_exigirtoken, a.con_exigirtoken, a.con_mascaratoken");
        buf.append(", a.con_utilizarcasasdecimais, a.con_tipoarredondamentopreco, a.con_casasprecoexame");
        buf.append(" from convenios a ");
        buf.append(" left join destino b on a.fil_codigo = b.fil_codigo and a.des_codigo = b.des_codigo ");
        buf.append(" left join coletas c on a.fil_codigo = c.fil_codigo and a.col_codigo = c.col_codigo ");
        buf.append(" left join tabelaprecoexames d on a.fil_codigo = d.fil_codigo and a.tpe_codigo = d.tpe_codigo ");
        buf.append(" left join cidades cid on a.fil_codigo = cid.fil_codigo and a.cid_codigo = cid.cid_codigo ");
        buf.append(" left join cidades cidcob on a.fil_codigo = cidcob.fil_codigo and a.cid_codigo = cidcob.cid_codigo ");
        buf.append(" left join bairro bai on a.fil_codigo = bai.fil_codigo and a.bai_codigo = bai.bai_codigo ");
        buf.append(" left join bairro baicob on a.fil_codigo = baicob.fil_codigo and a.bai_codigo = baicob.bai_codigo ");
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append("   and a.con_codigo = ").append(String.valueOf(codigo));
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs != null && rs.next()) {
            int codConvenio = rs.getInt("con_codigo");
            String razao = rs.getString("con_razao");
            String fantasia = rs.getString("con_fantasia");
            String cnpj = rs.getString("con_cnpjcpf");
            int tabela = rs.getInt("tpe_codigo");
            BigDecimal ch = rs.getBigDecimal("con_valorch");
            String tipoCalculo = rs.getString("con_tpcalcch");
            boolean cobrarExame = rs.getString("con_cobrexame") != null ? rs.getBoolean("con_cobrexame") : false;
            boolean cobrarMaterial = rs.getString("con_cobrmaterial") != null ? rs.getBoolean("con_cobrmaterial") : false;
            double percentualBalcao = rs.getString("con_percpgto") != null ? rs.getDouble("con_percpgto") : 0.0;
            double percentualBalcaoMaterial = rs.getString("con_percpgtomaterial") != null ? rs.getDouble("con_percpgtomaterial") : 0.0;
            double bonus = rs.getString("con_bonus") != null ? rs.getDouble("con_bonus") : 0.0;
            double acrescimo = rs.getString("con_acrescimo") != null ? rs.getDouble("con_acrescimo") : 0.0;
            double acrescimoPorte = rs.getString("con_acrescimoporte") != null ? rs.getDouble("con_acrescimoporte") : 0.0;
            double acrescimoUCO = rs.getString("con_acrescimouco") != null ? rs.getDouble("con_acrescimouco") : 0.0;
            double descontoUCO = rs.getString("con_descontouco") != null ? rs.getDouble("con_descontouco") : 0.0;
            double descontoPorte = rs.getString("con_descontoporte") != null ? rs.getDouble("con_descontoporte") : 0.0;
            double maxDesconto = -1.0;
            double valorMinimoRequisicao = !DBUtil.campoNull(rs.getString("con_minimorequisicao")) ? rs.getDouble("con_minimorequisicao") : 0.0;
            double valorAdicionalMinimoRequisicao = !DBUtil.campoNull(rs.getString("con_adicionalminimorequisicao")) ? rs.getDouble("con_adicionalminimorequisicao") : 0.0;
            String codColeta = rs.getString("col_codigo");
            String descColeta = rs.getString("col_descricao");
            String codDestino = rs.getString("des_codigo");
            String descDestino = rs.getString("des_descricao");
            String titdep = rs.getString("con_titdep");
            String norma = rs.getString("con_norma");
            boolean informarMat = rs.getBoolean("con_informarmat");
            String matricula = rs.getString("con_maskcart");
            int qtdeExames = rs.getInt("con_nrexames");
            int codigoLayout = DBUtil.campoNull(rs.getString("lay_codigo")) ? -1 : rs.getInt("lay_codigo");
            boolean validadeGuia = rs.getBoolean("con_validadeguia");
            boolean codigoGuia = rs.getBoolean("con_codigoguia");
            int dias = rs.getInt("con_diasvalidade");
            boolean proibido = rs.getBoolean("con_proibido");
            int qtdeColunasGuia = rs.getInt("con_qtdecolunas");
            boolean tipoCBHPM = rs.getBoolean("tpe_tipocbhpm");
            boolean imprimirComprovante = rs.getBoolean("con_imprimircomprovante");
            boolean imprimirAnexo = rs.getBoolean("con_imprimiranexo");
            boolean imprimirAnexoCobranca = rs.getBoolean("con_imprimiranexocobranca");
            boolean imprimirRecibo = rs.getBoolean("con_imprimirrecibo");
            boolean imprimirProtocolo = rs.getBoolean("con_imprimirprotocolo");
            boolean imprimirCapa = rs.getBoolean("con_imprimircapa");
            boolean imprimirGuia = rs.getBoolean("con_imprimirguia");
            boolean imprimirEtiquetaColeta = rs.getBoolean("con_imprimiretqcoleta");
            boolean imprimirEtiquetaTriagem = rs.getBoolean("con_imprimiretqtriagem");
            boolean imprimirTermoConsentimento = rs.getBoolean("con_imprimirtermo");
            boolean mudarFatura = rs.getBoolean("con_mudardatafatura");
            String tipoCalculoFatura = rs.getString("con_tpcalcfatu");
            boolean obrigaValidadeCarteira = rs.getBoolean("con_exigevalidadecarteira");
            boolean obrigaNomePlano = rs.getBoolean("con_exigenomeplano");
            boolean obrigaUnidadeSaude = rs.getBoolean("con_exigeunidadesaude");
            boolean precosDiferenciados = rs.getBoolean("con_precosdiferenciados");
            String indiceReajuste = rs.getString("con_reajuste");
            int examesPorGuia = rs.getInt("con_examesporguia");
            String tipoPolitica = rs.getString("con_tipopolitica");
            String bloqueioPolitica = rs.getString("con_bloqueiopolitica");
            String zerarPolitica = rs.getString("con_zerarpolitica");
            Integer valorCota = rs.getInt("con_valorcota");
            Double valorCredito = rs.getDouble("con_valorcredito");
            boolean perguntarPercentualBalcao = rs.getBoolean("con_perguntarpercbalcao");
            boolean descontoPorUsuario = rs.getBoolean("con_descexame");
            boolean gerarGuiaRequisicao = rs.getBoolean("con_gerarguiarequisicao");
            boolean ignorarColetaEstacao = rs.getBoolean("con_ignorarcoletaestacao");
            boolean ignorarDestinoEstacao = rs.getBoolean("con_ignorardestinoestacao");
            boolean isApoio = rs.getBoolean("con_apoiado");
            String observacao = rs.getString("con_observ");
            String hospital = rs.getString("con_integracaohospital");
            String eletronico = rs.getString("con_faturaeletronica");
            String endereco = rs.getString("con_endereco");
            String numeroEndereco = rs.getString("con_numeroendereco");
            String tipoLogradouroEndereco = rs.getString("con_tipologradouroendereco");
            String contato = rs.getString("con_contato");
            String telefone = rs.getString("con_fone");
            String email = rs.getString("con_email1");
            String cidade = rs.getString("cid_nome");
            String uf = rs.getString("cid_uf");
            String tipoPessoaConvenio = rs.getString("con_tipopessoa");
            String ieConvenio = rs.getString("con_inscrest");
            String inscricaoMunicipalConvenio = rs.getString("con_inscmunic");
            Integer codigoCidadeConvenio = rs.getInt("cid_codigo");
            String complementoEnderecoConvenio = rs.getString("con_complemento");
            String codigoBairroConvenio = rs.getString("codigoBairro");
            String descricaoBairroConvenio = rs.getString("descricaoBairro");
            String cepConvenio = rs.getString("con_cep");
            String faxConvenio = rs.getString("con_fax");
            String siteConvenio = rs.getString("con_site");
            Integer codigoCidadeCobrancaConvenio = rs.getInt("codigoCidadeCobranca");
            String descricaoCidadeCobrancaConvenio = rs.getString("descricaoCidadeCobranca");
            String ufCidadeCobrancaConvenio = rs.getString("ufCidadeCobranca");
            String tipoLogradouroEnderecoCobrancaConvenio = rs.getString("con_tipologradouroendcobranca");
            String enderecoCobrancaConvenio = rs.getString("con_endcobranca");
            String numeroEnderecoCobrancaConvenio = rs.getString("con_numeroendcobranca");
            String complementoEnderecoCobrancaConvenio = rs.getString("con_numeroendcobranca");
            String codigoBairroEnderecoCobrancaConvenio = rs.getString("codigoBairroCobranca");
            String descricaoBairroEnderecoCobrancaConvenio = rs.getString("descricaoBairroCobranca");
            String cepCobrancaConvenio = rs.getString("con_cepcobranca");
            boolean exigirCartaoSus = rs.getBoolean("con_exigircartaosus");
            String xmlConfigSolicitacaoProcedimento = rs.getString("con_configsolicitadotiss");
            String xmlConfigElegibilidade = rs.getString("con_configelegibilidade");
            boolean pesquisarElegibilidade = rs.getBoolean("con_pesquisarelegibilidade");
            boolean solicitarTiss = rs.getBoolean("con_solicitartiss");
            boolean solicitarAutorizacao = rs.getBoolean("con_statustiss");
            String xmlConfigAutorizacaoProcedimento = rs.getString("con_configstatustiss");
            String senhaWebConvenio = rs.getString("con_senhaweb");
            boolean usarAgendamentoPolitica = rs.getBoolean("con_usaragendamentopolitica");
            boolean exigirPagamentoMinimoRequisicao = rs.getBoolean("con_exigirvalorminimo");
            double percentualPagamentoMinimoRequisicao = rs.getDouble("con_percvalorminimo");
            boolean convenioUtilizarCasasDecimais = rs.getBoolean("con_utilizarcasasdecimais");
            int convenioTipoArredondamentoPreco = rs.getInt("con_tipoarredondamentopreco");
            int convenioCasasPrecoExame = rs.getInt("con_casasprecoexame");
            boolean pedirToken = rs.getBoolean("con_exigirtoken");
            String mascaraToken = rs.getString("con_mascaratoken");
            if (descontoPorUsuario) {
                buf.delete(0, buf.length());
                buf.append("select max(c.cde_desconto) as maximo from usuario a ");
                buf.append("left join tipousuario b on a.tpu_codigo=b.tpu_codigo ");
                buf.append("left join conveniodesconto c on b.tpu_codigo = c.tpu_codigo ");
                buf.append("where upper(a.usr_codigo)=upper('");
                buf.append(Variaveis.login);
                buf.append("') and c.fil_codigo=");
                buf.append(filial);
                buf.append(" and c.con_codigo=");
                buf.append(String.valueOf(codigo));
                ResultSet rsMax = st.executeQuery(buf.toString());
                if (rsMax != null && rsMax.next() && !DBUtil.campoNull(rsMax.getString("maximo"))) {
                    maxDesconto = rsMax.getDouble("maximo");
                }
                rsMax.close();
                rs.close();
            }
            DadosConvenios c = new DadosConvenios(codConvenio, fantasia, razao, cnpj, tabela, ch, tipoCalculo, cobrarExame, percentualBalcao, bonus, acrescimo, maxDesconto, codColeta, codDestino, descColeta, descDestino, matricula, informarMat, titdep, norma, qtdeExames, cobrarMaterial, codigoLayout, validadeGuia, codigoGuia, dias, proibido, percentualBalcaoMaterial, valorMinimoRequisicao, valorAdicionalMinimoRequisicao, qtdeColunasGuia, tipoCBHPM, mudarFatura, descontoPorte, descontoUCO, acrescimoPorte, acrescimoUCO, obrigaValidadeCarteira, obrigaNomePlano, obrigaUnidadeSaude, precosDiferenciados, indiceReajuste, examesPorGuia, tipoCalculoFatura, tipoPolitica, bloqueioPolitica, zerarPolitica, valorCota, valorCredito, perguntarPercentualBalcao, descontoPorUsuario, gerarGuiaRequisicao, ignorarColetaEstacao, ignorarDestinoEstacao, contato, telefone, email, cidade, uf, endereco, numeroEndereco, tipoLogradouroEndereco, isApoio, observacao, eletronico, hospital, tipoPessoaConvenio, ieConvenio, inscricaoMunicipalConvenio, codigoCidadeConvenio, complementoEnderecoConvenio, codigoBairroConvenio, descricaoBairroConvenio, cepConvenio, faxConvenio, siteConvenio, codigoCidadeCobrancaConvenio, descricaoCidadeCobrancaConvenio, ufCidadeCobrancaConvenio, tipoLogradouroEnderecoCobrancaConvenio, enderecoCobrancaConvenio, numeroEnderecoCobrancaConvenio, complementoEnderecoCobrancaConvenio, codigoBairroEnderecoCobrancaConvenio, descricaoBairroEnderecoCobrancaConvenio, cepCobrancaConvenio, exigirCartaoSus, xmlConfigSolicitacaoProcedimento, xmlConfigElegibilidade, pesquisarElegibilidade, solicitarTiss, xmlConfigAutorizacaoProcedimento, solicitarAutorizacao, senhaWebConvenio, usarAgendamentoPolitica, convenioUtilizarCasasDecimais, convenioTipoArredondamentoPreco, convenioCasasPrecoExame, pedirToken, mascaraToken);
            c.setImprimirAnexo(imprimirAnexo);
            c.setImprimirComprovante(imprimirComprovante);
            c.setImprimirCapa(imprimirCapa);
            c.setImprimirRecibo(imprimirRecibo);
            c.setImprimirProtocolo(imprimirProtocolo);
            c.setImprimirAnexoCobranca(imprimirAnexoCobranca);
            c.setImprimirGuia(imprimirGuia);
            c.setImprimirEtiquetaColeta(imprimirEtiquetaColeta);
            c.setImprimirEtiquetaTriagem(imprimirEtiquetaTriagem);
            c.setImprimirTermoConsentimento(imprimirTermoConsentimento);
            c.setExigirPagamentoMinimoRequisicao(exigirPagamentoMinimoRequisicao);
            c.setPercentualPagamentoMinimoRequisicao(percentualPagamentoMinimoRequisicao);
            return c;
        }
        return null;
    }

    public static String getModeloFaturaNovaSemMaterialClinicas() {
        StringBuilder buf = new StringBuilder("<relatorio>");
        buf.append("  <alturaPagina>29.7</alturaPagina>");
        buf.append("  <larguraPagina>21.0</larguraPagina>");
        buf.append("  <margens><esquerda>1.5</esquerda><direita>1.5</direita><superior>0.70555556</superior><inferior>0.84666663</inferior></margens>");
        buf.append("  <linhasGuias></linhasGuias>");
        buf.append("  <bandas>");
        buf.append("    <banda>");
        buf.append("      <tipoBanda>0</tipoBanda>");
        buf.append("      <nome>Banda1</nome>");
        buf.append("      <altura>66</altura>");
        buf.append("      <campoChave></campoChave>");
        buf.append("      <nomeBandaFilha></nomeBandaFilha>");
        buf.append("      <nomeBandaRodapeGrupo></nomeBandaRodapeGrupo>");
        buf.append("      <itens>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem>");
        buf.append("          <nome>Rotulo1</nome>");
        buf.append("          <retangulo><x>1</x><y>1</y><largura>140</largura><altura>9</altura></retangulo>");
        buf.append("          <fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte>");
        buf.append("          <bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas>");
        buf.append("          <corDaFonte>-16777216</corDaFonte>");
        buf.append("          <alinhamentoHorizontal>2</alinhamentoHorizontal>");
        buf.append("          <texto>Faturamento de exames</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem>");
        buf.append("          <nome>CampoBanco1</nome>");
        buf.append("          <retangulo><x>1</x><y>9</y><largura>353</largura><altura>8</altura></retangulo>");
        buf.append("          <fonte><nome>Arial</nome><estilo>1</estilo><tamanho>10</tamanho></fonte>");
        buf.append("          <bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas>");
        buf.append("          <corDaFonte>-16777216</corDaFonte>");
        buf.append("          <alinhamentoHorizontal>2</alinhamentoHorizontal>");
        buf.append("          <nomeCampo>razaoSocialFilial</nomeCampo>");
        buf.append("          <mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco2</nome><retangulo><x>1</x><y>29</y><largura>353</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>enderecoFilial</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao1</nome><retangulo><x>2</x><y>39</y><largura>352</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><expressao>descricaoBairroFilial + \"   \" + descricaoCidadeFilial + \"-\" + estadoCidadeFilial</expressao>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco4</nome><retangulo><x>1</x><y>19</y><largura>353</largura><altura>8</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>10</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>cnpjFilial</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo2</nome><retangulo><x>375</x><y>1</y><largura>49</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Fatura:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco5</nome><retangulo><x>447</x><y>1</y><largura>60</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>codigoFatura</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo3</nome><retangulo><x>375</x><y>11</y><largura>38</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>In\u00edcio:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo4</nome><retangulo><x>375</x><y>20</y><largura>37</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Fim:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo5</nome><retangulo><x>375</x><y>40</y><largura>67</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Vencimento:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo6</nome><retangulo><x>375</x><y>30</y><largura>59</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Emiss\u00e3o:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco6</nome><retangulo><x>447</x><y>40</y><largura>60</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>dataVencimentoFatura</nomeCampo><mascara>dd/MM/aaaa</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco7</nome><retangulo><x>447</x><y>11</y><largura>60</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>dataInicioFatura</nomeCampo><mascara>dd/MM/aaaa</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco8</nome><retangulo><x>447</x><y>20</y><largura>60</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>dataFinalFatura</nomeCampo><mascara>dd/MM/aaaa</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco9</nome><retangulo><x>447</x><y>30</y><largura>60</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>dataEmissaoFatura</nomeCampo><mascara>dd/MM/aaaa</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo7</nome><retangulo><x>1</x><y>49</y><largura>56</largura><altura>13</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>10</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Conv\u00eanio:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco10</nome><retangulo><x>62</x><y>49</y><largura>443</largura><altura>13</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>10</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>razaoSocialConvenio</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Forma</tipoItem><nome>Forma1</nome><retangulo><x>1</x><y>60</y><largura>507</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>12</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>0</alinhamentoHorizontal><tipo>2</tipo><corLinha>-16777216</corLinha><corPreenchimento>-1</corPreenchimento><alinhamentoVertical>0</alinhamentoVertical><espessura>1</espessura>");
        buf.append("        </itemBanda>");
        buf.append("      </itens>");
        buf.append("    </banda>");
        buf.append("    <banda>");
        buf.append("      <tipoBanda>1</tipoBanda>");
        buf.append("      <nome>Banda2</nome>");
        buf.append("      <altura>9</altura>");
        buf.append("      <campoChave>codigoRequisicao</campoChave>");
        buf.append("      <nomeBandaFilha>Banda5</nomeBandaFilha>");
        buf.append("      <nomeBandaRodapeGrupo>Banda4</nomeBandaRodapeGrupo>");
        buf.append("      <itens>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco11</nome><retangulo><x>1</x><y>1</y><largura>62</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>codigoRequisicao</nomeCampo><mascara>00000000</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco12</nome><retangulo><x>69</x><y>1</y><largura>36</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>dataRequisicao</nomeCampo><mascara>dd/MM</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco13</nome><retangulo><x>112</x><y>1</y><largura>168</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>nomePaciente</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco14</nome><retangulo><x>287</x><y>1</y><largura>85</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>matriculaRequisicao</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco15</nome><retangulo><x>380</x><y>1</y><largura>125</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>nomeMedico</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("      </itens>");
        buf.append("    </banda>");
        buf.append("    <banda>");
        buf.append("      <tipoBanda>2</tipoBanda>");
        buf.append("      <nome>Banda5</nome>");
        buf.append("      <altura>7</altura>");
        buf.append("      <campoChave></campoChave>");
        buf.append("      <nomeBandaFilha></nomeBandaFilha>");
        buf.append("      <nomeBandaRodapeGrupo></nomeBandaRodapeGrupo>");
        buf.append("      <itens>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco18</nome><retangulo><x>8</x><y>1</y><largura>39</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>codigoExame</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco19</nome><retangulo><x>52</x><y>1</y><largura>28</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>abreviaturaMaterial</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco20</nome><retangulo><x>88</x><y>1</y><largura>193</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>descricaoExame</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco21</nome><retangulo><x>288</x><y>1</y><largura>83</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>ambExame</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco22</nome><retangulo><x>395</x><y>1</y><largura>53</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>chExame</nomeCampo><mascara>#.##0,00</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco23</nome><retangulo><x>454</x><y>1</y><largura>54</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>valorExame</nomeCampo><mascara>R$ #.##0,00</mascara>");
        buf.append("        </itemBanda>");
        buf.append("      </itens>");
        buf.append("    </banda>");
        buf.append("    <banda>");
        buf.append("      <tipoBanda>3</tipoBanda>");
        buf.append("      <nome>Banda4</nome>");
        buf.append("      <altura>10</altura>");
        buf.append("      <campoChave></campoChave>");
        buf.append("      <nomeBandaFilha></nomeBandaFilha>");
        buf.append("      <nomeBandaRodapeGrupo></nomeBandaRodapeGrupo>");
        buf.append("      <itens>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco16</nome><retangulo><x>395</x><y>1</y><largura>53</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>valorExamesCHRequisicao</nomeCampo><mascara>#.##0,00</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco17</nome><retangulo><x>454</x><y>1</y><largura>54</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>valorExamesRequisicao</nomeCampo><mascara>R$ #.##0,00</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo8</nome><retangulo><x>338</x><y>1</y><largura>49</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Subtotal:</texto>");
        buf.append("        </itemBanda>");
        buf.append("      </itens>");
        buf.append("    </banda>");
        buf.append("    <banda>");
        buf.append("      <tipoBanda>4</tipoBanda>");
        buf.append("      <nome>Banda6</nome>");
        buf.append("      <altura>152</altura>");
        buf.append("      <campoChave></campoChave>");
        buf.append("      <nomeBandaFilha></nomeBandaFilha>");
        buf.append("      <nomeBandaRodapeGrupo></nomeBandaRodapeGrupo>");
        buf.append("      <itens>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo9</nome><retangulo><x>205</x><y>8</y><largura>158</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Quantidade de requisi\u00e7\u00f5es:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo10</nome><retangulo><x>205</x><y>18</y><largura>158</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Quantidade de exames:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco24</nome><retangulo><x>422</x><y>8</y><largura>85</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>quantidadeRequisicoesFatura</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco25</nome><retangulo><x>422</x><y>18</y><largura>85</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>quantidadeExamesFatura</nomeCampo><mascara></mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo11</nome><retangulo><x>205</x><y>28</y><largura>158</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Total dos exames:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo12</nome><retangulo><x>205</x><y>38</y><largura>158</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Total dos exames (CH):</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo13</nome><retangulo><x>205</x><y>48</y><largura>158</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Subtotal:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo14</nome><retangulo><x>205</x><y>68</y><largura>158</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Adicional:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo15</nome><retangulo><x>205</x><y>78</y><largura>158</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Despesas de cobran\u00e7a:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo16</nome><retangulo><x>205</x><y>87</y><largura>158</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Total geral:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco26</nome><retangulo><x>422</x><y>28</y><largura>85</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>totalExamesFatura</nomeCampo><mascara>R$ #.##0,00</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco27</nome><retangulo><x>422</x><y>38</y><largura>85</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>totalCHFatura</nomeCampo><mascara>#.##0,00</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco29</nome><retangulo><x>422</x><y>68</y><largura>85</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>valorAdicionalFatura</nomeCampo><mascara>R$ #.##0,00</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco30</nome><retangulo><x>422</x><y>78</y><largura>85</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>valorDespesaCobrancaFatura</nomeCampo><mascara>R$ #.##0,00</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo17</nome><retangulo><x>205</x><y>58</y><largura>158</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Desconto:</texto>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco28</nome><retangulo><x>422</x><y>58</y><largura>85</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>percentualDescontoFatura</nomeCampo><mascara>#.##0,00 %</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>SubTotal</nome><retangulo><x>422</x><y>48</y><largura>85</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>totalExamesFatura</nomeCampo><mascara>R$ #.##0,00</mascara>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>TotalGeral</nome><retangulo><x>422</x><y>88</y><largura>85</largura><altura>9</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><expressao>numero((totalExamesFatura - (totalExamesFatura * percentualDescontoFatura / 100)) + valorAdicionalFatura + valorDespesaCobrancaFatura; \"R$ #.##0,00\")</expressao>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Texto</tipoItem><nome>Texto1</nome><retangulo><x>205</x><y>101</y><largura>302</largura><altura>50</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><quebrarPalavras>false</quebrarPalavras><nomeCampo>mensagemFatura</nomeCampo>");
        buf.append("        </itemBanda>");
        buf.append("      </itens>");
        buf.append("    </banda>");
        buf.append("    <banda>");
        buf.append("      <tipoBanda>5</tipoBanda>");
        buf.append("      <nome>Banda3</nome>");
        buf.append("      <altura>9</altura>");
        buf.append("      <campoChave></campoChave>");
        buf.append("      <nomeBandaFilha></nomeBandaFilha>");
        buf.append("      <nomeBandaRodapeGrupo></nomeBandaRodapeGrupo>");
        buf.append("      <itens>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Forma</tipoItem><nome>Forma2</nome><retangulo><x>1</x><y>1</y><largura>507</largura><altura>2</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>12</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>0</alinhamentoHorizontal><tipo>2</tipo><corLinha>-16777216</corLinha><corPreenchimento>-1</corPreenchimento><alinhamentoVertical>0</alinhamentoVertical><espessura>1</espessura>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao2</nome><retangulo><x>373</x><y>3</y><largura>136</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><expressao>\"P\u00e1gina: \" + zero(paginaCorrente; 3) + \"/\" + zero(quantidadePaginas; 3)</expressao>");
        buf.append("        </itemBanda>");
        buf.append("        <itemBanda>");
        buf.append("          <tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao3</nome><retangulo><x>1</x><y>3</y><largura>136</largura><altura>6</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><expressao>data(dataHoraCorrente; \"dd/MM/aaaa hh:mm\")</expressao>");
        buf.append("        </itemBanda>");
        buf.append("      </itens>");
        buf.append("    </banda>");
        buf.append("  </bandas>");
        buf.append("</relatorio>");
        return buf.toString();
    }

    public static String getModeloFaturaNovaSemMaterialAlimentos() {
        StringBuilder buf = new StringBuilder();
        buf.append("<relatorio><alturaPagina>29.7</alturaPagina><larguraPagina>21.0</larguraPagina><margens><esquerda>1.5</esquerda><direita>1.5</direita>");
        buf.append("<superior>0.70555556</superior><inferior>0.84666663</inferior></margens><linhasGuias></linhasGuias><bandas><banda><tipoBanda>0</tipoBanda>");
        buf.append("<nome>Banda1</nome><altura>66.0</altura><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo>");
        buf.append("</nomeBandaRodapeGrupo><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo1</nome><retangulo><x>1</x>");
        buf.append("<y>1</y><largura>140.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas>");
        buf.append("<esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte>");
        buf.append("<alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Faturamento de exames</texto></itemBanda>");
        buf.append("<itemBanda>");
        buf.append("<tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco1</nome><retangulo><x>1</x><y>9</y><largura>353.0</largura><altura>8.0</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>10</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>razaoSocialFilial</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco2</nome><retangulo><x>1</x><y>29</y><largura>353.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>enderecoFilial</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao1</nome><retangulo><x>2</x><y>39</y><largura>352.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>descricaoBairroFilial + \"   \" + descricaoCidadeFilial + \"-\" + estadoCidadeFilial</expressao><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco4</nome><retangulo><x>1</x><y>19</y><largura>353.0</largura><altura>8.0</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>10</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>cnpjFilial</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo2</nome><retangulo><x>375</x><y>1</y><largura>49.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Fatura:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco5</nome><retangulo><x>447</x><y>1</y><largura>60.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>codigoFatura</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo3</nome><retangulo><x>375</x><y>11</y><largura>38.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>In\u00edcio:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo4</nome><retangulo><x>375</x><y>20</y><largura>37.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Fim:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo5</nome><retangulo><x>375</x><y>40</y><largura>67.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Vencimento:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo6</nome><retangulo><x>375</x><y>30</y><largura>59.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Emiss\u00e3o:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco6</nome><retangulo><x>447</x><y>40</y><largura>60.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>dataVencimentoFatura</nomeCampo><mascara>dd/MM/aaaa</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco7</nome><retangulo><x>447</x><y>11</y><largura>60.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>dataInicioFatura</nomeCampo><mascara>dd/MM/aaaa</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco8</nome><retangulo><x>447</x><y>20</y><largura>60.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>dataFinalFatura</nomeCampo><mascara>dd/MM/aaaa</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco9</nome><retangulo><x>447</x><y>30</y><largura>60.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>dataEmissaoFatura</nomeCampo><mascara>dd/MM/aaaa</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo7</nome><retangulo><x>1</x><y>49</y><largura>56.0</largura><altura>13.0</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>10</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Conv\u00eanio:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco10</nome><retangulo><x>62</x><y>49</y><largura>443.0</largura><altura>13.0</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>10</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>razaoSocialConvenio</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Forma</tipoItem><nome>Forma1</nome><retangulo><x>1</x><y>60</y><largura>507.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>12</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>0</alinhamentoHorizontal><tipo>2</tipo><corLinha>-16777216</corLinha><corPreenchimento>-1</corPreenchimento><alinhamentoVertical>0</alinhamentoVertical><espessura>1</espessura></itemBanda></itens></banda><banda><tipoBanda>1</tipoBanda><nome>BandaModalidade</nome><altura>10.0</altura><campoChave>descricaoDestino</campoChave><nomeBandaFilha>BandaRequisicao</nomeBandaFilha><nomeBandaRodapeGrupo>BandaFimModalidade</nomeBandaRodapeGrupo><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo18</nome><retangulo><x>1</x><y>0</y><largura>46.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Modalidade:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco3</nome><retangulo><x>49</x><y>0</y><largura>288.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>descricaoDestino</nomeCampo><mascara></mascara></itemBanda></itens></banda><banda><tipoBanda>1</tipoBanda><nome>BandaRequisicao</nome><altura>9.0</altura><campoChave>codigoRequisicao</campoChave><nomeBandaFilha>Banda5</nomeBandaFilha><nomeBandaRodapeGrupo>BandaFimRequisicao</nomeBandaRodapeGrupo><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco11</nome><retangulo><x>13</x><y>1</y><largura>62.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>codigoRequisicao</nomeCampo><mascara>00000000</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco12</nome><retangulo><x>80</x><y>1</y><largura>36.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>dataRequisicao</nomeCampo><mascara>dd/MM</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco13</nome><retangulo><x>120</x><y>1</y><largura>163.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>nomePaciente</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco15</nome><retangulo><x>288</x><y>1</y><largura>215.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>descricaoProdutoRequisicao</nomeCampo><mascara></mascara></itemBanda></itens></banda><banda><tipoBanda>2</tipoBanda><nome>Banda5</nome><altura>7.0</altura><colunas>0</colunas><entreColunas>0</entreColunas><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco18</nome><retangulo><x>138</x><y>1</y><largura>39.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>codigoExame</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco20</nome><retangulo><x>188</x><y>1</y><largura>256.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>descricaoExame</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco23</nome><retangulo><x>454</x><y>1</y><largura>54.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>valorExame</nomeCampo><mascara>R$ #.##0,00</mascara></itemBanda></itens></banda><banda><tipoBanda>3</tipoBanda><nome>BandaFimRequisicao</nome><altura>10.0</altura><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco17</nome><retangulo><x>454</x><y>1</y><largura>54.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>valorExamesRequisicao</nomeCampo><mascara>R$ #.##0,00</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo8</nome><retangulo><x>338</x><y>1</y><largura>49.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Subtotal:</texto></itemBanda></itens></banda><banda><tipoBanda>3</tipoBanda><nome>BandaFimModalidade</nome><altura>11.0</altura><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo12</nome><retangulo><x>338</x><y>1</y><largura>77.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Subtotal modalidade:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao4</nome><retangulo><x>454</x><y>1</y><largura>54.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>somatorio(valorExame)</expressao><mascara>R$ #.##0,00</mascara></itemBanda></itens></banda><banda><tipoBanda>4</tipoBanda><nome>Banda6</nome><altura>151.0</altura><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo9</nome><retangulo><x>205</x><y>18</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Quantidade de requisi\u00e7\u00f5es:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo10</nome><retangulo><x>205</x><y>28</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Quantidade de exames:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco24</nome><retangulo><x>422</x><y>18</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>quantidadeRequisicoesFatura</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco25</nome><retangulo><x>422</x><y>28</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>quantidadeExamesFatura</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo11</nome><retangulo><x>205</x><y>38</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Total dos exames:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo13</nome><retangulo><x>205</x><y>48</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Subtotal:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo14</nome><retangulo><x>205</x><y>68</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Adicional:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo15</nome><retangulo><x>205</x><y>78</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Despesas de cobran\u00e7a:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo16</nome><retangulo><x>205</x><y>87</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Total geral:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco26</nome><retangulo><x>422</x><y>38</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>totalExamesFatura</nomeCampo><mascara>R$ #.##0,00</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco29</nome><retangulo><x>422</x><y>68</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>valorAdicionalFatura</nomeCampo><mascara>R$ #.##0,00</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco30</nome><retangulo><x>422</x><y>78</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>valorDespesaCobrancaFatura</nomeCampo><mascara>R$ #.##0,00</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo17</nome><retangulo><x>205</x><y>58</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Desconto:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco28</nome><retangulo><x>422</x><y>58</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>percentualDescontoFatura</nomeCampo><mascara>#.##0,00 %</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>SubTotal</nome><retangulo><x>422</x><y>48</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>totalExamesFatura</nomeCampo><mascara>R$ #.##0,00</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>TotalGeral</nome><retangulo><x>422</x><y>88</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>numero((totalExamesFatura - (totalExamesFatura * percentualDescontoFatura / 100)) + valorAdicionalFatura + valorDespesaCobrancaFatura; \"R$ #.##0,00\")</expressao><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Texto</tipoItem><nome>Texto1</nome><retangulo><x>205</x><y>101</y><largura>302.0</largura><altura>50.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><quebrarPalavras>false</quebrarPalavras><nomeCampo>mensagemFatura</nomeCampo></itemBanda></itens></banda><banda><tipoBanda>5</tipoBanda><nome>Banda3</nome><altura>9.0</altura><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><itens><itemBanda><tipoItem>jalis.relatorio.gerador.item.Forma</tipoItem><nome>Forma2</nome><retangulo><x>1</x><y>1</y><largura>507.0</largura><altura>2.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>12</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>0</alinhamentoHorizontal><tipo>2</tipo><corLinha>-16777216</corLinha><corPreenchimento>-1</corPreenchimento><alinhamentoVertical>0</alinhamentoVertical><espessura>1</espessura></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao2</nome><retangulo><x>373</x><y>3</y><largura>136.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>\"P\u00e1gina: \" + zero(paginaCorrente; 3) + \"/\" + zero(quantidadePaginas; 3)</expressao><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao3</nome><retangulo><x>1</x><y>3</y><largura>136.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>data(dataHoraCorrente; \"dd/MM/aaaa hh:mm\")</expressao><mascara></mascara></itemBanda></itens></banda></bandas></relatorio>");
        return buf.toString();
    }

    public static String getModeloResumoFaturaNova() {
        StringBuilder buf = new StringBuilder();
        buf.append("<relatorio><alturaPagina>29.7</alturaPagina><larguraPagina>21.0</larguraPagina><margens><esquerda>1.5</esquerda><direita>1.5</direita><superior>0.70555556</superior><inferior>0.84666663</inferior></margens><linhasGuias></linhasGuias><bandas><banda><tipoBanda>0</tipoBanda><nome>Banda1</nome><altura>77.0</altura><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><itens>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo1</nome><retangulo><x>1</x><y>1</y><largura>140.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Resumo de fatura</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco1</nome><retangulo><x>1</x><y>9</y><largura>353.0</largura><altura>8.0</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>9</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>razaoSocialFilial</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco2</nome><retangulo><x>1</x><y>29</y><largura>353.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>enderecoFilial</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao1</nome><retangulo><x>2</x><y>39</y><largura>352.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>descricaoBairroFilial + \"   \" + descricaoCidadeFilial + \"-\" + estadoCidadeFilial</expressao><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco4</nome><retangulo><x>1</x><y>19</y><largura>353.0</largura><altura>8.0</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>10</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>cnpjFilial</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo2</nome><retangulo><x>375</x><y>1</y><largura>49.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Fatura:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco5</nome><retangulo><x>447</x><y>1</y><largura>60.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>codigoFatura</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo3</nome><retangulo><x>375</x><y>11</y><largura>38.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>In\u00edcio:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo4</nome><retangulo><x>375</x><y>20</y><largura>37.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Fim:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo5</nome><retangulo><x>375</x><y>40</y><largura>67.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Vencimento:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo6</nome><retangulo><x>375</x><y>30</y><largura>59.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Emiss\u00e3o:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco6</nome><retangulo><x>447</x><y>40</y><largura>60.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>dataVencimentoFatura</nomeCampo><mascara>dd/MM/aaaa</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco7</nome><retangulo><x>447</x><y>11</y><largura>60.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>dataInicioFatura</nomeCampo><mascara>dd/MM/aaaa</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco8</nome><retangulo><x>447</x><y>20</y><largura>60.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>dataFinalFatura</nomeCampo><mascara>dd/MM/aaaa</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco9</nome><retangulo><x>447</x><y>30</y><largura>60.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>dataEmissaoFatura</nomeCampo><mascara>dd/MM/aaaa</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo7</nome><retangulo><x>1</x><y>49</y><largura>53.0</largura><altura>13.0</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>9</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Conv\u00eanio:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco10</nome><retangulo><x>55</x><y>49</y><largura>452.0</largura><altura>13.0</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>9</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>razaoSocialConvenio</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Forma</tipoItem><nome>Forma1</nome><retangulo><x>1</x><y>70</y><largura>507.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>12</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>0</alinhamentoHorizontal><tipo>2</tipo><corLinha>-16777216</corLinha><corPreenchimento>-1</corPreenchimento><alinhamentoVertical>0</alinhamentoVertical><espessura>1</espessura></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo8</nome><retangulo><x>7</x><y>64</y><largura>59.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Exame</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo12</nome><retangulo><x>279</x><y>64</y><largura>59.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><texto>Qtde Exames</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo18</nome><retangulo><x>339</x><y>64</y><largura>59.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><texto>Total CH</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo19</nome><retangulo><x>430</x><y>64</y><largura>59.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><texto>Total</texto></itemBanda></itens></banda><banda><tipoBanda>2</tipoBanda><nome>Banda5</nome><altura>7.0</altura><colunas>0</colunas><entreColunas>0</entreColunas><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><itens>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco18</nome><retangulo><x>5</x><y>1</y><largura>206.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><nomeCampo>descricaoExame</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco23</nome><retangulo><x>284</x><y>1</y><largura>54.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>quantidadeExame</nomeCampo><mascara>#.##0,00</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco3</nome><retangulo><x>344</x><y>1</y><largura>54.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>valorTotalExamesCHRequisicao</nomeCampo><mascara>#.##0,00</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao4</nome><retangulo><x>409</x><y>1</y><largura>80.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>valorTotalExamesRequisicao + valorTotalMateriaisRequisicao</expressao><mascara>#.##0,00</mascara></itemBanda></itens></banda><banda><tipoBanda>4</tipoBanda><nome>Banda6</nome><altura>151.0</altura><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><itens>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo9</nome><retangulo><x>205</x><y>18</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Quantidade de requisi\u00e7\u00f5es:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo10</nome><retangulo><x>205</x><y>28</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Quantidade de exames:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco24</nome><retangulo><x>422</x><y>18</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>quantidadeRequisicoesFatura</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco25</nome><retangulo><x>422</x><y>28</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>quantidadeExamesFatura</nomeCampo><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo11</nome><retangulo><x>205</x><y>38</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Total dos exames:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo13</nome><retangulo><x>205</x><y>48</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Subtotal:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo14</nome><retangulo><x>205</x><y>68</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Adicional:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo15</nome><retangulo><x>205</x><y>78</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Despesas de cobran\u00e7a:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo16</nome><retangulo><x>205</x><y>87</y><largura>158.0</largura><altura>10.0</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Total geral:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco26</nome><retangulo><x>422</x><y>38</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>totalExamesFatura</nomeCampo><mascara>R$ #.##0,00</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco29</nome><retangulo><x>422</x><y>68</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>valorAdicionalFatura</nomeCampo><mascara>R$ #.##0,00</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco30</nome><retangulo><x>422</x><y>78</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>valorDespesaCobrancaFatura</nomeCampo><mascara>R$ #.##0,00</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Rotulo</tipoItem><nome>Rotulo17</nome><retangulo><x>205</x><y>58</y><largura>158.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><texto>Desconto:</texto></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>CampoBanco28</nome><retangulo><x>422</x><y>58</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>percentualDescontoFatura</nomeCampo><mascara>#.##0,00 %</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.CampoBanco</tipoItem><nome>SubTotal</nome><retangulo><x>422</x><y>48</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><nomeCampo>totalExamesFatura</nomeCampo><mascara>R$ #.##0,00</mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>TotalGeral</nome><retangulo><x>422</x><y>88</y><largura>85.0</largura><altura>9.0</altura></retangulo><fonte><nome>Arial</nome><estilo>1</estilo><tamanho>8</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>numero((totalExamesFatura - (totalExamesFatura * percentualDescontoFatura / 100)) + valorAdicionalFatura + valorDespesaCobrancaFatura; \"R$ #.##0,00\")</expressao><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Texto</tipoItem><nome>Texto1</nome><retangulo><x>205</x><y>101</y><largura>302.0</largura><altura>50.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><quebrarPalavras>false</quebrarPalavras><nomeCampo>mensagemFatura</nomeCampo></itemBanda></itens></banda><banda><tipoBanda>5</tipoBanda><nome>Banda3</nome><altura>9.0</altura><campoChave></campoChave><nomeBandaFilha></nomeBandaFilha><nomeBandaRodapeGrupo></nomeBandaRodapeGrupo><itens>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Forma</tipoItem><nome>Forma2</nome><retangulo><x>1</x><y>1</y><largura>507.0</largura><altura>2.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>12</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>0</alinhamentoHorizontal><tipo>2</tipo><corLinha>-16777216</corLinha><corPreenchimento>-1</corPreenchimento><alinhamentoVertical>0</alinhamentoVertical><espessura>1</espessura></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao2</nome><retangulo><x>373</x><y>3</y><largura>136.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>4</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>\"P\u00e1gina: \" + zero(paginaCorrente; 3) + \"/\" + zero(quantidadePaginas; 3)</expressao><mascara></mascara></itemBanda>");
        buf.append("<itemBanda><tipoItem>jalis.relatorio.gerador.item.Expressao</tipoItem><nome>Expressao3</nome><retangulo><x>1</x><y>3</y><largura>136.0</largura><altura>6.0</altura></retangulo><fonte><nome>Arial</nome><estilo>0</estilo><tamanho>7</tamanho></fonte><bordas><esquerda>false</esquerda><direita>false</direita><superior>false</superior><inferior>false</inferior></bordas><corDaFonte>-16777216</corDaFonte><alinhamentoHorizontal>2</alinhamentoHorizontal><quebrarLinhas>false</quebrarLinhas><quebrarPalavras>false</quebrarPalavras><expressao>data(dataHoraCorrente; \"dd/MM/aaaa hh:mm\")</expressao><mascara></mascara></itemBanda></itens></banda></bandas></relatorio>");
        return buf.toString();
    }

    public static int getCodigoLayout(String filial, String convenio, Statement st) throws SQLException {
        int codigoLayout = -1;
        StringBuilder sql = new StringBuilder();
        sql.append("select lay_codigo from convenios where fil_codigo = ").append(filial);
        sql.append(" and con_codigo = ").append(convenio);
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            codigoLayout = DBUtil.campoNull(rs.getString("lay_codigo")) ? -1 : rs.getInt("lay_codigo");
        }
        rs.close();
        return codigoLayout;
    }
}

