/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.TTextFieldCPF;
import jalis.util.TTextFieldTelefone;
import jalis.util.logger.ErrorLogger;
import java.text.ParseException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class ComponenteUtils {
    public static void mascaraTelefone(String mascara, TTextField ... txt) {
        if (!Funcoes.textoVazio(mascara)) {
            for (TTextField t : txt) {
                try {
                    t.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter(mascara)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void novaMascaraTelefone(String mascara, TTextFieldTelefone ... txt) {
        if (!Funcoes.textoVazio(mascara)) {
            for (TTextFieldTelefone t : txt) {
                try {
                    t.setValidarConteudo(true);
                    DefaultFormatterFactory defaultFormatterFactory = ComponenteUtils.criaFormatacao(mascara);
                    t.setFormatterFactory(defaultFormatterFactory);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void novaMascaraCPF(String mask, TTextFieldCPF[] texts) {
        if (!Funcoes.textoVazio(mask)) {
            for (TTextFieldCPF t : texts) {
                try {
                    t.setValidarConteudo(true);
                    DefaultFormatterFactory defaultFormatterFactory = ComponenteUtils.criaFormatacao(mask);
                    t.setFormatterFactory(defaultFormatterFactory);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static DefaultFormatterFactory criaFormatacao(String mascara) throws ParseException {
        MaskFormatter maskFormatter = new MaskFormatter(mascara);
        maskFormatter.setValidCharacters("0123456789 ");
        DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(maskFormatter);
        return defaultFormatterFactory;
    }

    public static void maskCBO(String mask, TTextField[] texts) {
        if (!Funcoes.textoVazio(mask)) {
            for (TTextField t : texts) {
                try {
                    t.setValidarConteudo(true);
                    DefaultFormatterFactory defaultFormatterFactory = ComponenteUtils.criaFormatacao(mask);
                    t.setFormatterFactory(defaultFormatterFactory);
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel realizar a formata\u00e7\u00e3o do campo CBO." + ex.getMessage(), ex.getStackTrace(), "Configurando BPA");
                }
            }
        }
    }

    public static void maskCodigoAMB(String mask, TTextField[] texts) {
        if (!Funcoes.textoVazio(mask)) {
            for (TTextField t : texts) {
                try {
                    t.setValidarConteudo(true);
                    DefaultFormatterFactory defaultFormatterFactory = ComponenteUtils.criaFormatacao(mask);
                    t.setFormatterFactory(defaultFormatterFactory);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void maskCodigoCBHPM(String mask, TTextField[] texts) {
        if (!Funcoes.textoVazio(mask)) {
            for (TTextField t : texts) {
                try {
                    t.setValidarConteudo(true);
                    DefaultFormatterFactory defaultFormatterFactory = ComponenteUtils.criaFormatacao(mask);
                    t.setFormatterFactory(defaultFormatterFactory);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

