/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.Funcoes;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class Comparador
implements Comparator<Object[]> {
    int col;
    int sentido;
    Integer colAux = null;
    final String regex = "[0-9]+";
    boolean removerTagsHTML = false;

    public Comparador(int col, int sentido) {
        this.col = col;
        this.sentido = sentido;
    }

    public Comparador(int col, int colAux, int sentido) {
        this.col = col;
        this.colAux = colAux;
        this.sentido = sentido;
    }

    public Comparador(int col, int sentido, boolean removerTagsHTML) {
        this.col = col;
        this.sentido = sentido;
        this.removerTagsHTML = removerTagsHTML;
    }

    @Override
    public int compare(Object[] a, Object[] b) {
        String sB;
        String sA = a[this.col] == null ? "" : a[this.col].toString();
        String string = sB = b[this.col] == null ? "" : b[this.col].toString();
        if (sA.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && sB.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            try {
                if (this.colAux == null) {
                    return (Double.parseDouble(Funcoes.limpaDecimal(sA)) < Double.parseDouble(Funcoes.limpaDecimal(sB)) ? -1 : (Double.parseDouble(Funcoes.limpaDecimal(sA)) == Double.parseDouble(Funcoes.limpaDecimal(sB)) ? 0 : 1)) * this.sentido;
                }
                Object[] auxA = new Object[]{a[this.colAux]};
                Object[] auxB = new Object[]{b[this.colAux]};
                return (Double.parseDouble(Funcoes.limpaDecimal(sA)) < Double.parseDouble(Funcoes.limpaDecimal(sB)) ? -1 : (Double.parseDouble(Funcoes.limpaDecimal(sA)) == Double.parseDouble(Funcoes.limpaDecimal(sB)) ? this.compare(auxA, auxB) : 1)) * this.sentido;
            }
            catch (Exception e) {
                return sA.compareToIgnoreCase(sB) * this.sentido;
            }
        }
        if (sA.matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])(/(\\d{2}|\\d{4}))?") && sB.matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])(/(\\d{2}|\\d{4}))?")) {
            if (this.colAux == null) {
                return Funcoes.comparaData(sA, sB) * this.sentido;
            }
            Object[] auxA = new Object[]{a[this.colAux]};
            Object[] auxB = new Object[]{b[this.colAux]};
            int retorno = Funcoes.comparaData(sA, sB);
            return (retorno == 0 ? this.compare(auxA, auxB) : retorno) * this.sentido;
        }
        if (sA.matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])/\\d{4} ([01]\\d|2[0-3]):[0-5]\\d") && sB.matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])/\\d{4} ([01]\\d|2[0-3]):[0-5]\\d")) {
            if (this.colAux == null) {
                return Funcoes.comparaDataHora(sA, sB, "dd/MM/yyyy HH:mm") * this.sentido;
            }
            Object[] auxA = new Object[]{a[this.colAux]};
            Object[] auxB = new Object[]{b[this.colAux]};
            int retorno = Funcoes.comparaDataHora(sA, sB, "dd/MM/yyyy HH:mm");
            return (retorno == 0 ? this.compare(auxA, auxB) : retorno) * this.sentido;
        }
        if (sA.matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])/\\d{4} ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d") && sB.matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])/\\d{4} ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d")) {
            if (this.colAux == null) {
                return Funcoes.comparaDataHora(sA, sB, "dd/MM/yyyy HH:mm:ss") * this.sentido;
            }
            Object[] auxA = new Object[]{a[this.colAux]};
            Object[] auxB = new Object[]{b[this.colAux]};
            int retorno = Funcoes.comparaDataHora(sA, sB, "dd/MM/yyyy HH:mm:ss");
            return (retorno == 0 ? this.compare(auxA, auxB) : retorno) * this.sentido;
        }
        if (sA.matches("[0-9]+") && sB.matches("[0-9]+")) {
            long iA = Long.parseLong(sA);
            long iB = Long.parseLong(sB);
            if (this.colAux == null) {
                return (iA < iB ? -1 : (iA == iB ? 0 : 1)) * this.sentido;
            }
            Object[] auxA = new Object[]{a[this.colAux]};
            Object[] auxB = new Object[]{b[this.colAux]};
            int retorno = iA < iB ? -1 : (iA == iB ? 0 : 1);
            return (retorno == 0 ? this.compare(auxA, auxB) : retorno) * this.sentido;
        }
        Collator col = Collator.getInstance(Locale.getDefault());
        if (this.removerTagsHTML) {
            if (this.colAux == null) {
                return col.compare(sA.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", ""), sB.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "")) * this.sentido;
            }
            Object[] auxA = new Object[]{a[this.colAux]};
            Object[] auxB = new Object[]{b[this.colAux]};
            int retorno = col.compare(sA.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", ""), sB.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", ""));
            return (retorno == 0 ? this.compare(auxA, auxB) : retorno) * this.sentido;
        }
        if (this.colAux == null) {
            return col.compare(sA, sB) * this.sentido;
        }
        Object[] auxA = new Object[]{a[this.colAux]};
        Object[] auxB = new Object[]{b[this.colAux]};
        int retorno = col.compare(sA, sB);
        return (retorno == 0 ? this.compare(auxA, auxB) : retorno) * this.sentido;
    }
}

