/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.DialogoFiltro;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class CheckItemFiltroArray
extends JComponent
implements ActionListener {
    public static final String COMANDO_ABRIR_JANELA = "abrirJanela";
    public static final String COMANDO_JANELA_FECHADA = "janelaFechada";
    public static final String COMANDO_OUTROS = "outros";
    private JCheckBox checkBox;
    private JButton button;
    private String tituloFiltro;
    private String[] campos = new String[2];
    private String[] colunas = new String[2];
    private String[] arrayDados;
    private int[] colunasSelecao;
    private int[] tamanhoColunas = new int[2];
    private int colunaHint;
    private int qtdeRegistros;
    private Map<Integer, String[]> selecionados = new HashMap<Integer, String[]>();
    private Object[] selecionadosNovoFiltro = null;
    private Object[] consultaFixa = null;
    private ArrayList<ActionListener> listeners = new ArrayList();

    public CheckItemFiltroArray(String titulo, String tituloBotao, String filtrando) {
        int[] nArray;
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.checkBox = ComponenteFactory.novoJCheckBox(titulo, this);
        this.add((Component)this.checkBox, "West");
        if (titulo != null) {
            this.checkBox.setName(titulo);
        }
        this.button = ComponenteFactory.novoJButton(tituloBotao, '\u0000', this, null, null, false);
        this.add((Component)this.button, "East");
        if (titulo != null) {
            this.button.setName(titulo);
        }
        this.button.setMaximumSize(new Dimension(60, 20));
        this.button.setPreferredSize(new Dimension(60, 20));
        this.tituloFiltro = filtrando;
        if (this.colunasSelecao == null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = this.colunasSelecao;
        }
        this.colunasSelecao = nArray;
        this.setMinimumSize(new Dimension(20, 20));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CheckItemFiltroArray.this.checkBox.isEnabled() && CheckItemFiltroArray.this.checkBox.isFocusable()) {
                    CheckItemFiltroArray.this.checkBox.grabFocus();
                }
            }
        });
    }

    public void setDados(String[] arrayDados, String[] campos) {
        this.arrayDados = arrayDados;
        this.campos[0] = campos[0];
        this.colunas[0] = campos[0];
        this.colunas[1] = "";
        this.tamanhoColunas[0] = 0;
        this.tamanhoColunas[1] = 20;
        this.consultaFixa = arrayDados;
    }

    public void setSelecionados(String[] sel) {
        this.setSelecionados(sel, 0);
    }

    public void setSelecionados(String[] sel, int coluna) {
        if (sel != null && sel.length > 0) {
            this.selecionados.put(new Integer(coluna), sel);
        }
    }

    public String[] getSelecionados() {
        return this.getSelecionados(0);
    }

    public String[] getSelecionados(int coluna) {
        return this.selecionados.get(new Integer(coluna)) != null && this.selecionados.get(new Integer(coluna)).length > 0 ? this.selecionados.get(new Integer(coluna)) : null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkBox.setEnabled(enabled);
        this.button.setEnabled(this.checkBox.isSelected() && enabled);
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public boolean vazio() {
        return !this.isSelected() || this.selecionados.get(0) == null || this.selecionados.get(0).length == 0;
    }

    public void setSelected(boolean selected) {
        this.checkBox.setSelected(selected);
        this.button.setEnabled(selected);
    }

    public void clear() {
        this.checkBox.setSelected(false);
        this.button.setEnabled(false);
        this.setToolTipText(null);
        this.selecionados.clear();
    }

    public void setColunaHint(int coluna) {
        this.colunaHint = coluna;
    }

    public int getQtdeRegistros() {
        return this.qtdeRegistros;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.checkBox) {
            this.button.setEnabled(this.checkBox.isSelected());
            if (!this.checkBox.isSelected()) {
                this.selecionados.clear();
                this.setToolTipText(null);
            }
            this.fireActionPerformed(COMANDO_OUTROS);
        } else if (o == this.button) {
            this.fireActionPerformed(COMANDO_ABRIR_JANELA);
            DialogoFiltro df = DialogoFiltro.novaInstancia(this.getTopLevelAncestor(), this.tituloFiltro);
            if (df != null) {
                if (this.consultaFixa != null) {
                    df.setDados(this.selecionados, this.consultaFixa, this.campos, this.colunas, this.tamanhoColunas);
                }
                df.setVisible(true);
                if (df.ok()) {
                    this.qtdeRegistros = df.getQtdeRegistros();
                    this.atualizarSelecionados(df);
                }
                this.fireActionPerformed(COMANDO_JANELA_FECHADA);
            }
        }
    }

    private void atualizarSelecionados(DialogoFiltro df) {
        this.selecionados.clear();
        for (int col : this.colunasSelecao) {
            this.selecionados.put(new Integer(col), df.getSelecionados(col));
        }
        String[] tmp = df.getSelecionados(this.colunaHint);
        if (tmp.length == 0) {
            this.setToolTipText(null);
        } else {
            StringBuilder bui = new StringBuilder("<html><b>Filtro selecionado: </b><br>");
            for (int i = 0; i < 10 && i < tmp.length; ++i) {
                bui.append("<li>");
                bui.append(tmp[i]);
                bui.append("<br>");
                if (i != 9) continue;
                bui.append("<li>...<br>");
            }
            bui.append("</html>");
            this.setToolTipText(bui.toString());
        }
    }

    public void setConsultaFixa(Object[] valores) {
        if (valores != null) {
            this.consultaFixa = valores;
        }
    }

    public Object[] getConsultaFixa() {
        return this.consultaFixa;
    }

    public void removerConsultaFixa() {
        if (this.consultaFixa != null) {
            this.consultaFixa = null;
        }
    }

    public void setTitulo(String titulo) {
        this.checkBox.setText(titulo);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    private void fireActionPerformed(String comando) {
        for (ActionListener aux : this.listeners) {
            aux.actionPerformed(new ActionEvent(this, 0, comando));
        }
    }
}

