/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.util.DialogoFiltro;
import jalis.util.NovoDialogoFiltro;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class CheckItemFiltro
extends JComponent
implements ActionListener {
    private JCheckBox checkBox;
    private JButton button;
    private String tabela;
    private String tituloFiltro;
    private String filtro;
    private String[] campos;
    private String[] colunas;
    private int[] colunasSelecao;
    private int[] tamanhoColunas;
    private int colunaHint;
    private int qtdeRegistros;
    private int colunaOrdenacao;
    private boolean considerarComoSelect;
    private boolean pesquisaAvancada;
    private boolean executarAoAbrir = false;
    private Map<Integer, String[]> selecionados = new HashMap<Integer, String[]>();
    private Map<Integer, String[]> naoSelecionados = new HashMap<Integer, String[]>();
    private Object[] selecionadosNovoFiltro = null;
    private ArrayList<Object[]> consultaFixa = null;
    private String sql;

    public CheckItemFiltro(String tituloCheck, String tituloBotao, String tituloFiltro, String filtro) {
        this(tituloCheck, tituloBotao, tituloFiltro, filtro, null, 0, false);
    }

    public CheckItemFiltro(String tituloCheck, String tituloBotao, String tituloFiltro, String filtro, boolean pesquisaAvancada) {
        this(tituloCheck, tituloBotao, tituloFiltro, filtro, null, 0, pesquisaAvancada);
    }

    public CheckItemFiltro(String tituloCheck, String tituloBotao, String tituloFiltro, String filtro, int colunaOrdenacao, boolean pesquisaAvancada) {
        this(tituloCheck, tituloBotao, tituloFiltro, filtro, null, colunaOrdenacao, pesquisaAvancada);
    }

    public CheckItemFiltro(String tituloCheck, String tituloBotao, String tituloFiltro, String filtro, int[] colunasSelecao, boolean pesquisaAvancada) {
        this(tituloCheck, tituloBotao, tituloFiltro, filtro, colunasSelecao, 0, pesquisaAvancada);
    }

    public CheckItemFiltro(String tituloCheck, String tituloBotao, String tituloFiltro, String filtro, int[] colunasSelecao, int colunaOrdenacao, boolean pesquisaAvancada) {
        int[] nArray;
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.checkBox = ComponenteFactory.novoJCheckBox(tituloCheck, this);
        this.add((Component)this.checkBox, "West");
        if (this.checkBox != null && tituloCheck != null) {
            this.checkBox.setName(tituloCheck);
        }
        this.button = ComponenteFactory.novoJButton(tituloBotao, '\u0000', this, null, null, false);
        this.add((Component)this.button, "East");
        if (this.button != null) {
            this.button.setName(tituloCheck);
        }
        if (this.button != null) {
            this.button.setMaximumSize(new Dimension(60, 20));
            this.button.setPreferredSize(new Dimension(60, 20));
        }
        this.tituloFiltro = tituloFiltro;
        this.filtro = filtro;
        if (colunasSelecao == null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = colunasSelecao;
        }
        this.colunasSelecao = nArray;
        this.colunaOrdenacao = colunaOrdenacao;
        this.pesquisaAvancada = pesquisaAvancada;
        this.setMinimumSize(new Dimension(20, 20));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CheckItemFiltro.this.checkBox.isEnabled() && CheckItemFiltro.this.checkBox.isFocusable()) {
                    CheckItemFiltro.this.checkBox.grabFocus();
                }
            }
        });
    }

    public void setDados(String tabela, String[] campos, String[] colunas, int[] tamanhoColunas) {
        this.setDados(tabela, campos, colunas, tamanhoColunas, false);
    }

    public void setDados(String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, boolean considerarComoSelect) {
        this.setDados(tabela, campos, colunas, tamanhoColunas, 0, considerarComoSelect, false, true);
    }

    public void setDados(String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, int colunaOrdenacao, boolean pesquisaAvancada) {
        this.setDados(tabela, campos, colunas, tamanhoColunas, colunaOrdenacao, false, pesquisaAvancada, true);
    }

    public void setDados(String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, int colunaOrdenacao, boolean considerarComoSelect, boolean pesquisaAvancada, boolean executarAoAbrir) {
        this.tabela = tabela;
        this.campos = campos;
        this.colunas = colunas;
        this.tamanhoColunas = tamanhoColunas;
        this.colunaOrdenacao = colunaOrdenacao;
        this.considerarComoSelect = considerarComoSelect;
        this.pesquisaAvancada = pesquisaAvancada;
        this.executarAoAbrir = executarAoAbrir;
    }

    public void setSelecionados(String[] sel) {
        this.setSelecionados(sel, 0);
    }

    public void setSelecionados(String[] sel, int coluna) {
        if (sel != null && sel.length > 0) {
            this.selecionados.put(new Integer(coluna), sel);
        }
    }

    public String[] getSelecionados() {
        return this.getSelecionados(0);
    }

    public String[] getNaoSelecionados() {
        return this.getNaoSelecionados(0);
    }

    public String[] getSelecionados(int coluna) {
        return this.selecionados.get(new Integer(coluna)) != null && this.selecionados.get(new Integer(coluna)).length > 0 ? this.selecionados.get(new Integer(coluna)) : null;
    }

    public String[] getNaoSelecionados(int coluna) {
        return this.naoSelecionados.get(new Integer(coluna)) != null && this.naoSelecionados.get(new Integer(coluna)).length > 0 ? this.naoSelecionados.get(new Integer(coluna)) : null;
    }

    public int getQuantidadeRegistros(String tabelaBanco) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) as result  from ").append(tabelaBanco);
        buf.append(" where fil_codigo  = ").append(Variaveis.filialPadrao);
        try {
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getInt(1);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "CheckitemFiltro:245");
        }
        return 0;
    }

    public String[] getSelecionadosAvancado(int coluna) {
        if (this.selecionadosNovoFiltro == null || this.selecionadosNovoFiltro.length == 0 || this.selecionadosNovoFiltro.length == this.getQuantidadeRegistros(this.tabela)) {
            return null;
        }
        String[] retorno = new String[this.selecionadosNovoFiltro.length];
        for (int i = 0; i < this.selecionadosNovoFiltro.length; ++i) {
            Object[] auxArray = (Object[])this.selecionadosNovoFiltro[i];
            if (auxArray == null) continue;
            retorno[i] = auxArray[coluna].toString();
        }
        return retorno;
    }

    public Object[] getSelecionadosAvancado() {
        if (this.selecionadosNovoFiltro == null || this.selecionadosNovoFiltro.length == 0 || !this.checkBox.isSelected()) {
            return null;
        }
        Object[] retorno = new Object[this.selecionadosNovoFiltro.length];
        for (int i = 0; i < this.selecionadosNovoFiltro.length; ++i) {
            retorno[i] = (Object[])this.selecionadosNovoFiltro[i];
        }
        return retorno;
    }

    public void setSelecionadosAvancado(Object[] valores) {
        if (valores != null) {
            this.selecionadosNovoFiltro = new Object[valores.length];
            for (int i = 0; i < valores.length; ++i) {
                Object[] valor;
                this.selecionadosNovoFiltro[i] = valor = (Object[])valores[i];
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkBox.setEnabled(enabled);
        this.button.setEnabled(this.checkBox.isSelected() && enabled);
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public boolean vazio() {
        return !this.isSelected() || this.selecionados.get(0) == null || this.selecionados.get(0).length == 0;
    }

    public void setSelected(boolean selected) {
        this.checkBox.setSelected(selected);
        this.button.setEnabled(selected);
    }

    public void clear() {
        this.checkBox.setSelected(false);
        this.button.setEnabled(false);
        this.setToolTipText(null);
        this.selecionados.clear();
    }

    public void setColunaHint(int coluna) {
        this.colunaHint = coluna;
    }

    public int getQtdeRegistros() {
        return this.qtdeRegistros;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.checkBox) {
            this.button.setEnabled(this.checkBox.isSelected());
            if (!this.checkBox.isSelected()) {
                this.selecionados.clear();
                this.setToolTipText(null);
            }
        } else if (o == this.button) {
            if (!this.pesquisaAvancada) {
                DialogoFiltro df = DialogoFiltro.novaInstancia(this.getTopLevelAncestor(), this.tituloFiltro);
                if (df != null) {
                    if (this.consultaFixa != null) {
                        df.setDados(this.selecionados, this.campos, this.colunas, this.tamanhoColunas, this.consultaFixa, this.colunaOrdenacao);
                    } else {
                        df.setDados(this.selecionados, this.tabela, this.campos, this.colunas, this.tamanhoColunas, this.filtro, this.considerarComoSelect, this.colunaOrdenacao, true);
                    }
                    df.setVisible(true);
                    if (df.ok()) {
                        this.qtdeRegistros = df.getQtdeRegistros();
                        this.atualizarSelecionados(df);
                    }
                }
            } else {
                NovoDialogoFiltro df = NovoDialogoFiltro.novaInstancia(this.getTopLevelAncestor(), this.tituloFiltro);
                if (this.considerarComoSelect && df != null) {
                    df.setDados(this.selecionadosNovoFiltro, this.sql, this.campos, this.colunas, this.tamanhoColunas, this.filtro, this.considerarComoSelect, this.colunaOrdenacao, this.executarAoAbrir);
                    df.setVisible(true);
                    if (df.ok()) {
                        this.qtdeRegistros = df.getQtdeRegistros();
                        this.atualizarSelecionados(df);
                    }
                } else if (df != null) {
                    df.setDados(this.selecionadosNovoFiltro, this.tabela, this.campos, this.colunas, this.tamanhoColunas, this.filtro, this.considerarComoSelect, this.colunaOrdenacao, this.executarAoAbrir);
                    df.setVisible(true);
                    if (df.ok()) {
                        this.qtdeRegistros = df.getQtdeRegistros();
                        this.atualizarSelecionados(df);
                    }
                }
            }
        }
    }

    private void atualizarSelecionados(DialogoFiltro df) {
        this.selecionados.clear();
        for (int col : this.colunasSelecao) {
            this.selecionados.put(new Integer(col), df.getSelecionados(col));
        }
        this.naoSelecionados.clear();
        for (int col : this.colunasSelecao) {
            this.naoSelecionados.put(new Integer(col), df.getNaoSelecionados(col));
        }
        String[] tmp = df.getSelecionados(this.colunaHint);
        if (tmp.length == 0) {
            this.setToolTipText(null);
        } else {
            StringBuilder bui = new StringBuilder("<html><b>Filtro selecionado: </b><br>");
            for (int i = 0; i < 10 && i < tmp.length; ++i) {
                bui.append("<li>");
                bui.append(tmp[i]);
                bui.append("<br>");
                if (i != 9) continue;
                bui.append("<li>...<br>");
            }
            bui.append("</html>");
            this.setToolTipText(bui.toString());
        }
    }

    private void atualizarSelecionados(NovoDialogoFiltro df) {
        this.selecionadosNovoFiltro = df.getSelecionados();
        if (this.selecionadosNovoFiltro.length == 0) {
            this.setToolTipText(null);
        } else {
            StringBuilder bui = new StringBuilder("<html><b>Filtro selecionado: </b><br>");
            for (int i = 0; i < 10 && i < this.selecionadosNovoFiltro.length; ++i) {
                bui.append("<li>");
                Object[] aux = (Object[])this.selecionadosNovoFiltro[i];
                for (int j = 0; j < aux.length; ++j) {
                    if (j > 0) {
                        bui.append(", ");
                    }
                    if (aux[j] == null) continue;
                    bui.append(aux[j].toString());
                }
                bui.append("<br>");
                if (i != 9) continue;
                bui.append("<li>...<br>");
            }
            bui.append("</html>");
            this.setToolTipText(bui.toString());
        }
    }

    public void setConsultaFixa(ArrayList<Object[]> valores) {
        if (valores != null) {
            this.consultaFixa = valores;
        }
    }

    public ArrayList<Object[]> getConsultaFixa() {
        return this.consultaFixa;
    }

    public void removerConsultaFixa() {
        if (this.consultaFixa != null) {
            this.consultaFixa = null;
        }
    }

    public void setFiltro(String filtro) {
        this.filtro = filtro;
    }

    public void setTitulo(String titulo) {
        this.checkBox.setText(titulo);
    }

    public void setTamanhoPreferidoCheck(Dimension dimension) {
        this.checkBox.setPreferredSize(dimension);
    }

    public void setTamanhoMinimoCheck(Dimension dimension) {
        this.checkBox.setMinimumSize(dimension);
    }

    public boolean isPesquisaAvancada() {
        return this.pesquisaAvancada;
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public JButton getButton() {
        return this.button;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

