/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.BairroVO;
import jalis.model.vo.cadastro.auxiliares.CidadeVO;
import jalis.service.cadastro.auxiliares.BairroService;
import jalis.service.cadastro.auxiliares.CidadeService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SolicitaCep;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TDialog;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class CEP {
    private static Component parent;
    private static boolean buscando;
    private static JComboBox comboTipoLogradouro;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean buscarCEP(JComboBox comboTipoLogradouro2, TTextField txtCEP, TTextField txtEndereco, TTextField txtCodCidade, TTextField txtDescCidade, TTextField txtCodBairro, TTextField txtDescBairro, Component frame) {
        if (buscando) {
            return false;
        }
        buscando = true;
        parent = frame;
        comboTipoLogradouro = comboTipoLogradouro2;
        try {
            if (!CEP.cepValido(txtCEP)) {
                buscando = false;
                return false;
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(parent, e.getMessage(), 1);
            buscando = false;
            txtCEP.requestFocus();
            return false;
        }
        String caminho = "http://viacep.com.br/ws/" + txtCEP.getText() + "/xml/";
        SplashMensagem splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
        splash.mostrar("Buscando CEP, por favor aguarde.");
        try {
            String xml = new String(CEP.buscaDadosDaURL(caminho));
            splash.apagar();
            if (!Funcoes.textoVazio(xml.toString())) {
                String tmp = xml.toString();
                if (!Funcoes.textoVazio(StringUtil.getValor(tmp, "erro"))) {
                    Funcoes.mensagem(parent, "N\u00e3o foi poss\u00edvel realizar a busca do CEP, ou o CEP informado n\u00e3o existe, tente novamente.", 2);
                    txtCEP.requestFocus();
                    boolean bl = false;
                    return bl;
                }
                CEP.defineValorDosCampos(txtEndereco, comboTipoLogradouro, txtCodCidade, txtDescCidade, txtCodBairro, txtDescBairro, tmp);
            }
            boolean tmp = true;
            return tmp;
        }
        catch (Exception e) {
            String mensagem = "Verifique sua conex\u00e3o com a internet.";
            if (!e.getMessage().contains("timed out")) {
                mensagem = "";
            }
            Funcoes.mensagem(parent, "N\u00e3o foi poss\u00edvel realizar a busca do CEP." + mensagem + "\nMotivo: " + e.getMessage(), 1);
            txtCEP.requestFocus();
            boolean bl = false;
            return bl;
        }
        finally {
            buscando = false;
            splash.apagar();
        }
    }

    private static boolean substituirEndereco(TTextField txtEndereco, TTextField txtCodBairro, String endereco, String bairro, String cidade, String ibge, String uf) throws ThreadDaoException {
        boolean camposPreenchidos;
        CidadeService cidadeService = new CidadeService();
        BairroService bairroService = new BairroService();
        CidadeVO cidadeVO = null;
        BairroVO bairroVO = null;
        if (!Funcoes.textoVazio(bairro)) {
            bairroVO = bairroService.getBairroNome(Variaveis.filialPadrao, bairro);
        }
        if (!Funcoes.textoVazio(ibge)) {
            cidadeVO = cidadeService.getCidadeIbge(Variaveis.filialPadrao, ibge);
        }
        if (CEP.isNull(cidadeVO) && !Funcoes.textoVazio(cidade)) {
            cidadeVO = cidadeService.getCidadeNome(Variaveis.filialPadrao, cidade, uf);
        }
        boolean buscaNaoVazio = !CEP.isNull(cidadeVO) || !CEP.isNull(bairroVO) || !Funcoes.textoVazio(endereco);
        boolean bl = camposPreenchidos = !Funcoes.textoVazio(txtEndereco.getText()) || !Funcoes.textoVazio(txtCodBairro.getText());
        if (camposPreenchidos && buscaNaoVazio) {
            return new TDialog().showPerguntaSimNao(Laboratorio.getInstancia(), "Aten\u00e7\u00e3o", "O endere\u00e7o/bairro j\u00e1 est\u00e1 preenchido. Deseja substituir o endere\u00e7o?", 1) == 0;
        }
        if (!camposPreenchidos && buscaNaoVazio) {
            return buscaNaoVazio;
        }
        return false;
    }

    private static boolean isNull(Object o) {
        return o == null;
    }

    private static void defineValorDosCampos(TTextField txtEndereco, JComboBox comboTipoLogradouro, TTextField txtCodCidade, TTextField txtDescCidade, TTextField txtCodBairro, TTextField txtDescBairro, String tmp) throws ThreadDaoException {
        String endereco = StringUtil.getValor(tmp, "logradouro");
        String cidade = StringUtil.getValor(tmp, "localidade").replace("'", " ");
        String ibge = StringUtil.getValor(tmp, "ibge");
        String uf = StringUtil.getValor(tmp, "uf");
        String bairro = StringUtil.getValor(tmp, "bairro");
        if (!CEP.substituirEndereco(txtEndereco, txtCodBairro, endereco, bairro, cidade, ibge, uf)) {
            return;
        }
        if (!Funcoes.textoVazio(endereco)) {
            CEP.defineEndereco(txtEndereco, comboTipoLogradouro, endereco);
        } else {
            txtEndereco.clear();
        }
        if (!Funcoes.textoVazio(ibge)) {
            CEP.defineCidade(txtCodCidade, txtDescCidade, cidade, ibge, uf);
        }
        CEP.defineBairro(txtCodBairro, txtDescBairro, bairro);
        ScreenUtil.requisitarFoco(txtEndereco);
    }

    private static void defineBairro(TTextField txtCodBairro, TTextField txtDescBairro, String bairro) throws ThreadDaoException {
        BairroVO bairroVO = null;
        if (!Funcoes.textoVazio(bairro)) {
            BairroService cid = new BairroService();
            bairroVO = cid.getBairroNome(Variaveis.filialPadrao, bairro);
        }
        if (!CEP.isNull(bairroVO)) {
            txtCodBairro.setText(bairroVO.getCodigo());
            txtDescBairro.setText(bairroVO.getDescricaoCadastro());
        } else {
            txtCodBairro.clear();
            txtDescBairro.clear();
        }
    }

    private static void defineCidade(TTextField txtCodCidade, TTextField txtDescCidade, String cidade, String ibge, String uf) throws ThreadDaoException {
        CidadeService cid = new CidadeService();
        CidadeVO cidadeVO = cid.getCidadeIbge(Variaveis.filialPadrao, ibge);
        if (cidadeVO == null) {
            cidadeVO = cid.getCidadeNome(Variaveis.filialPadrao, cidade, uf);
        }
        if (cidadeVO != null) {
            txtCodCidade.setText(cidadeVO.getCodigo().toString());
            txtDescCidade.setText(cidadeVO.getDescricaoCadastro());
        } else {
            txtCodCidade.clear();
            txtDescCidade.clear();
        }
    }

    private static void defineEndereco(TTextField txtEndereco, JComboBox comboTipoLogradouro, String endereco) {
        String[] s = endereco.split(" ");
        boolean encontrou = false;
        if (comboTipoLogradouro != null) {
            String item;
            int i;
            for (i = 0; i < comboTipoLogradouro.getItemCount(); ++i) {
                item = comboTipoLogradouro.getItemAt(i).toString();
                if (item == null || !item.equalsIgnoreCase(s[0])) continue;
                comboTipoLogradouro.setSelectedIndex(i);
                encontrou = true;
                break;
            }
            if (!encontrou) {
                for (i = 0; i < comboTipoLogradouro.getItemCount(); ++i) {
                    item = comboTipoLogradouro.getItemAt(i).toString();
                    if (item == null || !item.equalsIgnoreCase(Tipos.tipoLogradouroDescricao("OU"))) continue;
                    comboTipoLogradouro.setSelectedIndex(i);
                    break;
                }
            }
        }
        String temp = "";
        for (int i = 1; i < s.length; ++i) {
            temp = temp + " " + s[i];
        }
        txtEndereco.setText(temp.trim());
    }

    private static void cepComTraco(JTextField field) throws Exception {
        String cep = field.getText().replace("-", "");
        CEP.validaTamanho(field);
        field.setText(cep.substring(0, 5) + "-" + cep.substring(5));
    }

    private static StringBuilder buscaDadosDaURL(String caminho) throws MalformedURLException, IOException, UnsupportedEncodingException {
        URL url = new URL(caminho);
        HttpURLConnection lista = (HttpURLConnection)url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(lista.getInputStream(), "UTF-8"));
        StringBuilder b = new StringBuilder();
        int valor = in.read();
        while (valor != -1) {
            b.append((char)valor);
            valor = in.read();
        }
        in.close();
        return b;
    }

    private static boolean cepVazio(JTextField field) throws Exception {
        if (Funcoes.textoVazio(field)) {
            field.setText(CEP.solicitaCep());
            if (Funcoes.textoVazio(field)) {
                return true;
            }
        }
        return false;
    }

    private static String solicitaCep() {
        return new SolicitaCep(parent).getResponse();
    }

    private static void validaTamanho(JTextField field) throws Exception {
        String cep = field.getText();
        if (Funcoes.textoVazio(cep) || cep.replace("-", "").length() != 8) {
            throw new Exception("CEP inv\u00e1lido!");
        }
    }

    public static boolean tamanhoDoCepCorreto(JTextField field) {
        String cep = field.getText();
        return !Funcoes.textoVazio(cep) && cep.replace("-", "").length() == 8;
    }

    public static boolean cepValido(JTextField field) {
        try {
            if (!CEP.cepVazio(field)) {
                CEP.validaTamanho(field);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Funcoes.mensagem(parent, e.getMessage(), 1);
            return false;
        }
    }

    public static boolean CepExiste(JTextField txtCEP, Component frame) {
        parent = frame;
        String caminho = "http://viacep.com.br/ws/" + txtCEP.getText() + "/xml/";
        try {
            if (CEP.tamanhoDoCepCorreto(txtCEP)) {
                String tmp;
                String xml = new String(CEP.buscaDadosDaURL(caminho));
                if (!Funcoes.textoVazio(xml.toString()) && !Funcoes.textoVazio(StringUtil.getValor(tmp = xml.toString(), "erro"))) {
                    txtCEP.requestFocus();
                    return false;
                }
                return true;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(parent, e.getMessage(), e.getStackTrace());
        }
        return false;
    }

    static {
        buscando = false;
        comboTipoLogradouro = new JComboBox<String>(Tipos.arrayTiposLogradouro);
    }
}

