/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import jalis.util.Funcoes;

public class ByteArray {
    private byte[] buffer;
    private int size;

    public ByteArray(byte[] array) {
        this.size = array.length;
        this.buffer = new byte[this.size];
        System.arraycopy(array, 0, this.buffer, 0, this.size);
    }

    public ByteArray(int initialCapacity) {
        this.buffer = new byte[initialCapacity];
        this.size = 0;
    }

    public ByteArray() {
        this(10);
    }

    public void add(byte b) {
        this.ensureCapacity(this.size + 1);
        this.buffer[this.size++] = b;
    }

    public void add(byte[] array) {
        Funcoes.validarNaoNull(array, "array");
        this.ensureCapacity(this.size + array.length);
        System.arraycopy(array, 0, this.buffer, this.size, array.length);
        this.size += array.length;
    }

    public void add(ByteArray ba) {
        Funcoes.validarNaoNull(ba, "ba");
        this.ensureCapacity(this.size + ba.size());
        System.arraycopy(ba.buffer, 0, this.buffer, this.size, ba.size);
        this.size += ba.size;
    }

    public void add(int index, byte b) {
        this.validateIndex(index);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.size - index);
        this.buffer[index] = b;
        ++this.size;
    }

    public void add(int index, byte[] array) {
        this.validateIndex(index);
        Funcoes.validarNaoNull(array, "array");
        this.ensureCapacity(this.size + array.length);
        System.arraycopy(this.buffer, index, this.buffer, index + array.length, this.size - index);
        System.arraycopy(array, 0, this.buffer, index, array.length);
        this.size += array.length;
    }

    public void add(int index, ByteArray ba) {
        this.validateIndex(index);
        Funcoes.validarNaoNull(ba, "ba");
        this.ensureCapacity(this.size + ba.size());
        System.arraycopy(this.buffer, index, this.buffer, index + ba.size, this.size - index);
        System.arraycopy(ba.buffer, 0, this.buffer, index, ba.size);
        this.size += ba.size;
    }

    public void set(int index, byte b) {
        this.validateIndex(index);
        this.buffer[index] = b;
    }

    public byte get(int index) {
        this.validateIndex(index);
        return this.buffer[index];
    }

    public void delete(int start, int end) {
        if (start < 0 || end > this.size || start > end) {
            throw new IndexOutOfBoundsException("Start: " + start + ", End: " + end + ", Size: " + this.size);
        }
        System.arraycopy(this.buffer, end, this.buffer, start, this.size - end);
        this.size -= end - start;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            byte[] oldBuffer = this.buffer;
            int newCapacity = this.buffer.length * 3 / 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.buffer = new byte[newCapacity];
            System.arraycopy(oldBuffer, 0, this.buffer, 0, this.size);
        }
    }

    public void setSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("O novo tamanho deve ser maior ou igual a zero: " + size);
        }
        this.ensureCapacity(size);
        this.size = size;
    }

    public void trimToSize() {
        if (this.size < this.buffer.length) {
            byte[] oldBuffer = this.buffer;
            this.buffer = new byte[this.size];
            System.arraycopy(oldBuffer, 0, this.buffer, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public byte[] toArray() {
        byte[] result = new byte[this.size];
        System.arraycopy(this.buffer, 0, result, 0, this.size);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ByteArray) {
            ByteArray tmp = (ByteArray)o;
            if (this.size == tmp.size) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.buffer[i] == tmp.buffer[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (byte b : this.buffer) {
            hash += b;
        }
        return hash;
    }

    private void validateIndex(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }
}

