/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import com.nitgen.SDK.BSP.NBioBSPJNI;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.SplashMensagem;
import java.util.ArrayList;

public class Biometria {
    public static NBioBSPJNI.DEVICE_INFO_EX[] getDispositivos() {
        try {
            NBioBSPJNI bsp = new NBioBSPJNI();
            NBioBSPJNI.DEVICE_ENUM_INFO deviceEnumInfo = new NBioBSPJNI.DEVICE_ENUM_INFO(bsp);
            bsp.EnumerateDevice(deviceEnumInfo);
            ArrayList<NBioBSPJNI.DEVICE_INFO_EX> dispositivos = new ArrayList<NBioBSPJNI.DEVICE_INFO_EX>();
            for (int i = 0; i < deviceEnumInfo.DeviceCount; ++i) {
                NBioBSPJNI.DEVICE_INFO_EX info = deviceEnumInfo.DeviceInfo[i];
                dispositivos.add(info);
            }
            if (dispositivos.isEmpty()) {
                return null;
            }
            return dispositivos.toArray(new NBioBSPJNI.DEVICE_INFO_EX[dispositivos.size()]);
        }
        catch (UnsatisfiedLinkError us) {}
        catch (NoClassDefFoundError no) {}
        catch (Exception ex) {}
        finally {
            return null;
        }
    }

    public static short getDispositivo(String name) {
        short retorno = -1;
        if (name.equals("Sem biometria") || Biometria.getDispositivos() == null) {
            return retorno;
        }
        for (NBioBSPJNI.DEVICE_INFO_EX disp : Biometria.getDispositivos()) {
            if (!disp.Name.equalsIgnoreCase(name)) continue;
            retorno = disp.DeviceID;
        }
        return retorno;
    }

    public static String capturar(short idDispositivo, boolean mostrarSplash) {
        NBioBSPJNI bsp = new NBioBSPJNI();
        NBioBSPJNI.DEVICE_INFO_EX info = new NBioBSPJNI.DEVICE_INFO_EX(bsp);
        info.NameID = idDispositivo;
        SplashMensagem mensagem = new SplashMensagem();
        mensagem.mostrar("Aguardando impress\u00e3o digital...");
        bsp.OpenDevice(info.NameID, info.Instance);
        NBioBSPJNI.FIR_HANDLE hSavedFIR = new NBioBSPJNI.FIR_HANDLE(bsp);
        NBioBSPJNI.INPUT_FIR inputFIR = new NBioBSPJNI.INPUT_FIR(bsp);
        NBioBSPJNI.WINDOW_OPTION winOption = new NBioBSPJNI.WINDOW_OPTION(bsp);
        winOption.WindowStyle = 1;
        bsp.Capture(2, hSavedFIR, -1, null, winOption);
        if (!bsp.IsErrorOccured()) {
            inputFIR.SetFIRHandle(hSavedFIR);
            NBioBSPJNI.FIR_TEXTENCODE textSavedFIR = new NBioBSPJNI.FIR_TEXTENCODE(bsp);
            inputFIR.SetTextFIR(textSavedFIR);
            bsp.GetTextFIRFromHandle(hSavedFIR, textSavedFIR);
            bsp.CloseDevice(info.NameID);
            mensagem.apagar();
            return textSavedFIR.TextFIR;
        }
        bsp.CloseDevice(info.NameID);
        mensagem.apagar();
        Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel obter a impress\u00e3o digital\nC\u00f3digo apresentado: \"" + bsp.GetErrorCode() + "\".", 1);
        return null;
    }

    public static boolean verificar(short idDispositivo, String impressaoOriginal, boolean mostrarSplash) throws Exception {
        String capturada = Biometria.capturar(idDispositivo, mostrarSplash);
        if (capturada == null) {
            throw new Exception("Impress\u00e3o digital n\u00e3o informada.");
        }
        NBioBSPJNI bsp = new NBioBSPJNI();
        NBioBSPJNI.FIR_TEXTENCODE textoFIROrigem = new NBioBSPJNI.FIR_TEXTENCODE(bsp);
        NBioBSPJNI.FIR_TEXTENCODE textoFIRVerificar = new NBioBSPJNI.FIR_TEXTENCODE(bsp);
        NBioBSPJNI.FIR_PAYLOAD payload = new NBioBSPJNI.FIR_PAYLOAD(bsp);
        textoFIROrigem.TextFIR = impressaoOriginal;
        textoFIRVerificar.TextFIR = capturada;
        NBioBSPJNI.INPUT_FIR inputOrigem = new NBioBSPJNI.INPUT_FIR(bsp);
        NBioBSPJNI.INPUT_FIR inputVerificar = new NBioBSPJNI.INPUT_FIR(bsp);
        inputOrigem.SetTextFIR(textoFIROrigem);
        inputVerificar.SetTextFIR(textoFIRVerificar);
        Boolean retorno = new Boolean(false);
        bsp.VerifyMatch(inputOrigem, inputVerificar, retorno, payload);
        return retorno;
    }

    public static boolean comparar(String impressaoOriginal, String impressaoParaComparar) {
        NBioBSPJNI bsp = new NBioBSPJNI();
        NBioBSPJNI.FIR_TEXTENCODE textoFIROrigem = new NBioBSPJNI.FIR_TEXTENCODE(bsp);
        NBioBSPJNI.FIR_TEXTENCODE textoFIRVerificar = new NBioBSPJNI.FIR_TEXTENCODE(bsp);
        NBioBSPJNI.FIR_PAYLOAD payload = new NBioBSPJNI.FIR_PAYLOAD(bsp);
        textoFIROrigem.TextFIR = impressaoOriginal;
        textoFIRVerificar.TextFIR = impressaoParaComparar;
        NBioBSPJNI.INPUT_FIR inputOrigem = new NBioBSPJNI.INPUT_FIR(bsp);
        NBioBSPJNI.INPUT_FIR inputVerificar = new NBioBSPJNI.INPUT_FIR(bsp);
        inputOrigem.SetTextFIR(textoFIROrigem);
        inputVerificar.SetTextFIR(textoFIRVerificar);
        Boolean retorno = new Boolean(false);
        bsp.VerifyMatch(inputOrigem, inputVerificar, retorno, payload);
        return retorno;
    }
}

