/*
 * Decompiled with CFR 0.152.
 */
package jalis.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

public class ArraysUtil {
    public static <T> T[] inserir(T[] a, T[] b, int pos) {
        if (pos < 0 || pos > a.length) {
            throw new ArrayIndexOutOfBoundsException("A posi\u00e7\u00e3o " + pos + " est\u00e1 fora dos limites do array.");
        }
        Object[] res = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + b.length);
        System.arraycopy(a, 0, res, 0, pos);
        System.arraycopy(b, 0, res, pos, b.length);
        System.arraycopy(a, pos, res, pos + b.length, a.length - pos);
        return res;
    }

    public static <T> T[] concatenar(T[] a, T[] b) {
        Object[] res = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + b.length);
        System.arraycopy(a, 0, res, 0, a.length);
        System.arraycopy(b, 0, res, a.length, b.length);
        return res;
    }

    public static int[] concatenar(int[] a, int[] b) {
        int[] auxA = (int[])a.clone();
        int[] auxB = (int[])b.clone();
        int[] novo = new int[auxA.length + auxB.length];
        int j = 0;
        int i = 0;
        while (i < auxA.length) {
            novo[j] = auxA[i];
            ++i;
            ++j;
        }
        i = 0;
        while (i < auxB.length) {
            novo[j] = auxB[i];
            ++i;
            ++j;
        }
        return novo;
    }

    public static byte[] concatenarVariosArraysByte(byte[] ... a) throws Exception {
        if (a.length <= 0 || a[0] == null) {
            throw new Exception("Convers\u00e3o incorreto no tipo do array");
        }
        int tamanhoNovo = 0;
        for (byte[] t : a) {
            tamanhoNovo += t.length;
        }
        byte[] res = new byte[tamanhoNovo];
        int i = 0;
        for (byte[] t : a) {
            for (int j = 0; j < t.length; ++j) {
                res[i++] = t[j];
            }
        }
        return res;
    }

    public static <T> T[] concatenarVarios(T[] ... a) throws Exception {
        if (a.length <= 0 || a[0] == null) {
            throw new Exception("Convers\u00e3o incorreta no tipo do array");
        }
        int tamanhoNovo = 0;
        for (T[] t : a) {
            tamanhoNovo += t.length;
        }
        Object[] res = (Object[])Array.newInstance(a[0].getClass().getComponentType(), tamanhoNovo);
        tamanhoNovo = 0;
        for (T[] t : a) {
            System.arraycopy(t, 0, res, tamanhoNovo, t.length);
            tamanhoNovo = t.length;
        }
        return res;
    }

    public static <T> T[] unir(T[] a, T[] b) {
        int pos = a.length;
        int tam = a.length;
        for (int i = 0; i < b.length; ++i) {
            if (ArraysUtil.contem(a, b[i])) continue;
            ++tam;
        }
        Object[] res = (Object[])Array.newInstance(a.getClass().getComponentType(), tam);
        System.arraycopy(a, 0, res, 0, a.length);
        for (int i = 0; i < b.length; ++i) {
            if (ArraysUtil.contem(a, b[i])) continue;
            res[pos++] = b[i];
        }
        return res;
    }

    public static <T> T[] subArray(T[] a, int posIni, int posFim) {
        if (a != null && posIni <= posFim && posIni >= 0 && posFim < a.length) {
            Object[] sub = (Object[])Array.newInstance(a.getClass().getComponentType(), posFim - posIni + 1);
            System.arraycopy(a, posIni, sub, 0, posFim - posIni + 1);
            return sub;
        }
        return null;
    }

    public static byte[] subArrayByte(byte[] a, int posIni, int qtde) {
        if (a != null && posIni >= 0 && qtde > 0 && posIni + qtde - 1 < a.length) {
            byte[] sub = new byte[qtde];
            int j = 0;
            int i = posIni;
            while (i < posIni + qtde) {
                sub[j] = a[i];
                ++i;
                ++j;
            }
            return sub;
        }
        return null;
    }

    public static <T> T[] remover(T[] a, int pos) {
        if (a != null && pos >= 0 && pos < a.length) {
            Object[] tmp = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length - 1);
            System.arraycopy(a, 0, tmp, 0, pos);
            System.arraycopy(a, pos + 1, tmp, pos, a.length - pos - 1);
            return tmp;
        }
        return null;
    }

    public static <T> T[] remover(T[] a, int posIni, int posFin) {
        if (a != null && posIni >= 0 && posIni <= posFin && posFin < a.length) {
            Object[] tmp = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length - posFin + posIni - 1);
            System.arraycopy(a, 0, tmp, 0, posIni);
            System.arraycopy(a, posFin + 1, tmp, posIni, a.length - posFin - 1);
            return tmp;
        }
        return null;
    }

    public static <T> T[] remover(T[] a, int[] pos) {
        if (a != null && pos != null && pos.length > 0 && pos.length <= a.length) {
            if (a.length == 1) {
                return pos[0] == 0 ? (Object[])Array.newInstance(a.getClass().getComponentType(), 0) : null;
            }
            Arrays.sort(pos);
            Object[] tmp = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length - pos.length);
            int cont = 0;
            int ult = pos.length - 1;
            for (int i = 0; i < pos.length; ++i) {
                if (pos[i] < 0 || pos[i] >= a.length || i > 0 && pos[i - 1] == pos[i]) {
                    return null;
                }
                if (i == 0) {
                    System.arraycopy(a, 0, tmp, 0, pos[i]);
                    continue;
                }
                System.arraycopy(a, pos[i - 1] + 1, tmp, pos[i - 1] - cont++, pos[i] - pos[i - 1] - 1);
            }
            System.arraycopy(a, pos[ult] + 1, tmp, pos[ult] - cont, a.length - pos[ult] - 1);
            return tmp;
        }
        return null;
    }

    public static boolean contem(Object[] a, Object o) {
        return ArraysUtil.indice(a, o) > -1;
    }

    public static boolean contem(String[] a, String o) {
        return ArraysUtil.indice((Object[])a, o) > -1;
    }

    public static boolean contem(String[] a, String o, boolean ignoreCase) {
        return ArraysUtil.indice(a, o, ignoreCase) > -1;
    }

    public static int indice(Object[] a, Object o) {
        return ArraysUtil.indice(a, o, 0);
    }

    public static int indice(Object[] a, Object o, int de) {
        if (a != null) {
            for (int i = de; i < a.length; ++i) {
                if (a[i] != o) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indice(Object[] a, String s) {
        return ArraysUtil.indice(a, s, 0);
    }

    public static int indice(Object[] a, String s, int de) {
        if (a != null) {
            for (int i = de; i < a.length; ++i) {
                if (!(a[i] instanceof String) || !a[i].toString().equalsIgnoreCase(s)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indice(String[] a, String o, int de, boolean ignoreCase) {
        if (a != null) {
            for (int i = de; i < a.length; ++i) {
                if (!(ignoreCase ? a[i].equalsIgnoreCase(o) : a[i].equals(o))) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indice(String[] a, String o, boolean ignoreCase) {
        return ArraysUtil.indice(a, o, 0, ignoreCase);
    }

    public static void trocar(Object[] a, int i, int j) {
        if (i >= 0 && j >= 0 && i < a.length && j < a.length) {
            Object o = a[i];
            a[i] = a[j];
            a[j] = o;
        }
    }

    public static int[] getArrayIndexado(int tamanho) {
        if (tamanho >= 0) {
            int[] array = new int[tamanho];
            for (int i = 0; i < array.length; ++i) {
                array[i] = i;
            }
            return array;
        }
        return null;
    }

    public static int[][] getIntervalos(int[] indices) {
        if (indices != null && indices.length > 0 && ArraysUtil.todosPositivos(indices)) {
            int[] tmp = (int[])indices.clone();
            Arrays.sort(tmp);
            ArrayList<int[]> array = new ArrayList<int[]>();
            int primeiro = -1;
            int ultimo = -1;
            for (int i = 0; i < tmp.length; ++i) {
                if (primeiro == -1 || ultimo < tmp[i] - 1) {
                    if (primeiro != -1) {
                        array.add(new int[]{primeiro, ultimo});
                    }
                    primeiro = ultimo = tmp[i];
                } else {
                    ultimo = tmp[i];
                }
                if (i != tmp.length - 1) continue;
                array.add(new int[]{primeiro, ultimo});
            }
            return (int[][])array.toArray((T[])new int[array.size()][]);
        }
        return null;
    }

    private static boolean todosPositivos(int[] array) {
        for (int i : array) {
            if (i >= 0) continue;
            return false;
        }
        return true;
    }

    public static int[] toPrimitive(Integer[] integerArray) {
        int[] result = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            result[i] = integerArray[i];
        }
        return result;
    }
}

