/*
 * Decompiled with CFR 0.152.
 */
package jalis.testes.alvaro;

import jalis.testes.alvaro.AmostraAlvaro;
import jalis.testes.alvaro.ExameAlvaro;
import jalis.testes.alvaro.LinhaResultadoAlvaro;
import jalis.testes.alvaro.PacienteAlvaro;
import jalis.testes.alvaro.RequisicaoAlvaro;
import jalis.util.xml.XMLUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class ParseResultadoAlvaro {
    private ArrayList<PacienteAlvaro> pacientes = new ArrayList();
    private ArrayList<RequisicaoAlvaro> requisicoes = new ArrayList();
    private ArrayList<ExameAlvaro> exames = new ArrayList();

    private void printElement(List<Element> elements) {
        for (Element e : elements) {
            if (e.getNodeName().equalsIgnoreCase("exame")) {
                this.parseExame(e);
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("pacientes")) {
                this.parsePacientes(XMLUtil.getElementosFilhos(e));
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("solicitacao")) {
                this.parseSolicitacao(e);
                continue;
            }
            if (!e.hasChildNodes()) continue;
            this.printElement(XMLUtil.getElementosFilhos(e));
        }
    }

    public static void main(String[] args) {
        new ParseResultadoAlvaro();
    }

    private void parseExame(Element element) {
        ExameAlvaro exame = new ExameAlvaro();
        exame.codigo = element.getAttribute("codigo");
        exame.descricao = element.getAttribute("descricao");
        exame.dataAlteracao = element.getAttribute("dataalteracao");
        this.exames.add(exame);
    }

    private void parsePacientes(List<Element> elements) {
        for (Element e : elements) {
            PacienteAlvaro paciente = new PacienteAlvaro();
            paciente.codigoAlvaro = e.getAttribute("codigo");
            paciente.codigoJalis = e.getAttribute("codigo_lis");
            paciente.codigoAOL = e.getAttribute("codigo_aol");
            paciente.dataNascimento = e.getAttribute("datanasc");
            paciente.nome = e.getAttribute("nome");
            paciente.sexo = e.getAttribute("sexo");
            this.pacientes.add(paciente);
        }
    }

    private void parseSolicitacao(Element element) {
        RequisicaoAlvaro requisicao = new RequisicaoAlvaro();
        requisicao.codigoAlvaro = element.getAttribute("codigo");
        requisicao.codigoJalis = element.getAttribute("codigo_lis");
        requisicao.codigoAOL = element.getAttribute("codigo_aol");
        requisicao.paciente = this.locatePaciente(element.getAttribute("paciente"));
        List<Element> list = XMLUtil.getElementosFilhos(element);
        for (Element e : list) {
            if (e.getNodeName().equalsIgnoreCase("amostras")) {
                requisicao.amostras = this.parseAmostras(XMLUtil.getElementosFilhos(e));
                continue;
            }
            if (!e.getNodeName().equalsIgnoreCase("exame")) continue;
            requisicao.exames = this.parseExames(XMLUtil.getElementosFilhos(e), requisicao);
        }
        this.requisicoes.add(requisicao);
    }

    private ArrayList<ExameAlvaro> parseExames(List<Element> elements, RequisicaoAlvaro requisicao) {
        ArrayList<ExameAlvaro> exames = new ArrayList<ExameAlvaro>();
        for (Element e : elements) {
            ExameAlvaro exame = this.locateExame(e.getAttribute("codigo"));
            if (exame == null) continue;
            exame.dataResultado = e.getAttribute("dataresultado");
            exame.metodo = e.getAttribute("metodo");
            exame.normal = e.getAttribute("normal");
            List<Element> list = XMLUtil.getElementosFilhos(e);
            for (Element l : list) {
                LinhaResultadoAlvaro linha = new LinhaResultadoAlvaro();
                linha.amostra = this.locateAmostra(l.getAttribute("amostra"), requisicao);
                linha.linhaResultado = l.getAttribute("linharesultado");
                linha.resultado = l.getAttribute("resultado");
                exame.linhasResultado.add(linha);
            }
        }
        return exames;
    }

    private ArrayList<AmostraAlvaro> parseAmostras(List<Element> elements) {
        ArrayList<AmostraAlvaro> amostras = new ArrayList<AmostraAlvaro>();
        for (Element e : elements) {
            AmostraAlvaro a = new AmostraAlvaro();
            a.codigo = e.getAttribute("codigo");
            a.descricao = e.getAttribute("descricao");
            a.material = e.getAttribute("material");
            amostras.add(a);
        }
        return amostras;
    }

    private PacienteAlvaro locatePaciente(String paciente) {
        for (PacienteAlvaro p : this.pacientes) {
            if (!p.codigoAOL.equalsIgnoreCase(paciente)) continue;
            return p;
        }
        return null;
    }

    private ExameAlvaro locateExame(String exame) {
        for (ExameAlvaro e : this.exames) {
            if (!e.codigo.equalsIgnoreCase(exame)) continue;
            return (ExameAlvaro)e.clone();
        }
        return null;
    }

    private AmostraAlvaro locateAmostra(String amostra, RequisicaoAlvaro requisicao) {
        for (AmostraAlvaro a : requisicao.amostras) {
            if (!a.codigo.equalsIgnoreCase(amostra)) continue;
            return a;
        }
        return null;
    }
}

