/*
 * Decompiled with CFR 0.152.
 */
package jalis.testes.alvaro;

import jalis.testes.alvaro.Exame;
import jalis.util.xml.XMLUtil;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ParseExamesAlvaro {
    Hashtable<String, String> material = new Hashtable();
    Hashtable<String, Exame> exames = new Hashtable();

    private void parseMateriais(List<Element> elements) {
        for (Element e : elements) {
            this.material.put(e.getAttribute("codigo"), e.getAttribute("descricao"));
        }
    }

    private void parseExames(List<Element> elements) {
        for (Element e : elements) {
            String codigo = e.getAttribute("codigo");
            String descricao = e.getAttribute("descricao");
            String materialCodigo = e.getAttribute("materialpadrao");
            Exame exa = new Exame();
            exa.codigo = codigo;
            exa.descricao = descricao;
            exa.material = materialCodigo;
            exa.materialDescricao = this.material.get(materialCodigo);
            if (e.hasChildNodes()) {
                List<Element> childs = XMLUtil.getElementosFilhos(e);
                for (Element c : childs) {
                    if (c.getNodeName().equalsIgnoreCase("linhasreferencia")) {
                        this.parseLinhas(c, exa);
                        continue;
                    }
                    if (!c.getNodeName().equalsIgnoreCase("valorreferencia")) continue;
                    this.parseValoresReferencia(c, exa);
                }
            }
            this.exames.put(codigo, exa);
        }
    }

    private void parseLinhas(Element linhas, Exame exa) {
        List<Element> l = XMLUtil.getElementosFilhos(linhas);
        for (Element e : l) {
            exa.linhasResultado.put(e.getAttribute("codigo"), e.getAttribute("descricao"));
        }
    }

    private void parseValoresReferencia(Element c, Exame e) {
        StringBuffer sb = new StringBuffer();
        NodeList nl = c.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            sb.append(nl.item(i).getNodeValue());
        }
        e.valorReferencia = sb.toString();
    }

    public static void main(String[] args) {
        new ParseExamesAlvaro();
    }
}

