/*
 * Decompiled with CFR 0.152.
 */
package jalis.testes;

import jalis.integracaohospitais.conexao.ConexaoIntegracaoHospitalServidor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;

public class TesteTransacao
extends Frame {
    ConexaoIntegracaoHospitalServidor conexao = null;
    JButton botaoConectar = new JButton("Conectar");
    JButton botaoDesconectar = new JButton("Desconectar");
    JButton botaoExecutar = new JButton("Executar");
    JButton botaoPesquisar = new JButton("Pesquisar");
    JButton botaoCommit = new JButton("Commit");
    JButton botaoRollback = new JButton("Rollback");
    JButton botaoStatement = new JButton("Novo Statement");
    ArrayList<Statement> listaStatements = new ArrayList();

    public static void main(String[] args) {
        TesteTransacao janela = new TesteTransacao();
        janela.setVisible(true);
    }

    public TesteTransacao() {
        this.conexao = new ConexaoIntegracaoHospitalServidor();
        this.setSize(500, 100);
        this.setLayout(new FlowLayout());
        this.add(this.botaoConectar);
        this.add(this.botaoDesconectar);
        this.add(this.botaoExecutar);
        this.add(this.botaoPesquisar);
        this.add(this.botaoCommit);
        this.add(this.botaoRollback);
        this.add(this.botaoStatement);
        this.botaoConectar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesteTransacao.this.conectar();
            }
        });
        this.botaoDesconectar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesteTransacao.this.desconectar();
            }
        });
        this.botaoExecutar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesteTransacao.this.executar();
            }
        });
        this.botaoPesquisar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesteTransacao.this.pesquisar();
            }
        });
        this.botaoCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TesteTransacao testeTransacao = TesteTransacao.this;
                    testeTransacao.conexao.arquivaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.botaoRollback.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TesteTransacao testeTransacao = TesteTransacao.this;
                    testeTransacao.conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.botaoStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesteTransacao testeTransacao = TesteTransacao.this;
                TesteTransacao.this.listaStatements.add(testeTransacao.conexao.getStatement());
            }
        });
    }

    private void conectar() {
        ConexaoIntegracaoHospitalServidor.configuraConexaoIntegracaoHospitalServidor("jdbc:postgresql://127.0.0.1/jalis", "thread", "teste123");
    }

    private void desconectar() {
        TesteTransacao testeTransacao = this;
        testeTransacao.conexao.shutdown();
    }

    private void executar() {
        TesteTransacao testeTransacao = this;
        Statement st = testeTransacao.conexao.getStatement();
        try {
            ConexaoIntegracaoHospitalServidor.executeUpdate(st, "update raca set rac_descricao = 'a'");
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                throw throwable;
            }
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
        }
        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
    }

    private void pesquisar() {
        TesteTransacao testeTransacao = this;
        Statement st = testeTransacao.conexao.getStatement();
        try {
            ConexaoIntegracaoHospitalServidor.executeQuery(st, "select rac_descricao from raca");
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                throw throwable;
            }
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
        }
        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
    }
}

