/*
 * Decompiled with CFR 0.152.
 */
package jalis.testes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;

public class TesteSocket
extends JFrame {
    ServerSocket server = null;
    ArrayList<Socket> sockets = new ArrayList();
    JTextPane pane = new JTextPane();
    JButton buttonACK = new JButton("ACK");
    JButton buttonENQ = new JButton("ENQ");
    JButton buttonNULL = new JButton("NULL");
    JButton buttonSTX = new JButton("STX");
    JButton buttonETX = new JButton("ETX");
    JButton buttonEOT = new JButton("EOT");
    JButton buttonBlocoQuery = new JButton("Query");
    JButton buttonResultado = new JButton("Resultado");
    JButton buttonLimpar = new JButton("Limpar");
    private Socket socket;

    public static void main(String[] args) {
        TesteSocket t = new TesteSocket();
    }

    public TesteSocket() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.pane, "Center");
        this.setSize(new Dimension(200, 200));
        this.setDefaultCloseOperation(3);
        JPanel panelBotoes = new JPanel(new FlowLayout());
        panelBotoes.add(this.buttonACK);
        panelBotoes.add(this.buttonENQ);
        panelBotoes.add(this.buttonNULL);
        panelBotoes.add(this.buttonSTX);
        panelBotoes.add(this.buttonETX);
        panelBotoes.add(this.buttonEOT);
        panelBotoes.add(this.buttonBlocoQuery);
        panelBotoes.add(this.buttonResultado);
        panelBotoes.add(this.buttonLimpar);
        this.add((Component)panelBotoes, "South");
        this.buttonACK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PrintWriter printer = new PrintWriter(TesteSocket.this.socket.getOutputStream(), true);
                    TesteSocket.this.escrever(printer, '\u0006');
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.buttonENQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PrintWriter printer = new PrintWriter(TesteSocket.this.socket.getOutputStream(), true);
                    TesteSocket.this.escrever(printer, '\u0005');
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.buttonNULL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PrintWriter printer = new PrintWriter(TesteSocket.this.socket.getOutputStream(), true);
                    TesteSocket.this.escrever(printer, '\u0000');
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.buttonSTX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PrintWriter printer = new PrintWriter(TesteSocket.this.socket.getOutputStream(), true);
                    TesteSocket.this.escrever(printer, '\u0002');
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.buttonETX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PrintWriter printer = new PrintWriter(TesteSocket.this.socket.getOutputStream(), true);
                    TesteSocket.this.escrever(printer, '\u0003');
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.buttonEOT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PrintWriter printer = new PrintWriter(TesteSocket.this.socket.getOutputStream(), true);
                    TesteSocket.this.escrever(printer, '\u0004');
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.buttonBlocoQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PrintWriter printer = new PrintWriter(TesteSocket.this.socket.getOutputStream(), true);
                    String ms = "\u00021H|\\^&|||UIW_LIS|||||LIS_ID||P||20230207111610\rQ|1|^010007813204|^010007813204|ALL||||||||O\rL|1|N\r\u0003EE\r\n";
                    TesteSocket.this.escrever(printer, ms);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.buttonResultado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PrintWriter printer = new PrintWriter(TesteSocket.this.socket.getOutputStream(), true);
                    String ms = "\u00021H|\\^&|||UIW_LIS|||||LIS_ID||P||20230215094827\rP|1||||PACIENTE[SP]TESTE[SP]FRIGO|||F\rO|1|010006680719^045822^A7||^^^HCY^^^1|R|20230313095740|||||||||Serum^^^1||||||||||F\rR|1|^^^HCY^^^1^RLU^22897#0|43540|||||F\\R||Labmar^System||20230313100908|SP00649^IH00739\rR|2|^^^HCY^^^1^COFF^22897#0|1.00|pg/mL||||F\\R||Labmar^System||20230313100908|SP00649^IH00739\rR|3|^^^HCY^^^1^DOSE^22897#0|49.0|pg/mL||||F\\R||Labmar^System||20230313100908|SP00649^IH00739\rL|1|N\r\u0003A1\r\n";
                    TesteSocket.this.escrever(printer, ms);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.buttonLimpar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesteSocket.this.pane.setText("");
            }
        });
        this.setVisible(true);
        this.setSize(new Dimension(800, 500));
        try {
            this.escreverPane("iniciando servidor");
            this.socket = new Socket("localhost", 5001);
            InputStream input = this.socket.getInputStream();
            Recebimento r = new Recebimento(new BufferedInputStream(input));
            r.start();
            while (true) {
                Socket s = this.server.accept();
                this.escreverPane("Conectando com " + s.getRemoteSocketAddress().toString());
                this.socket = s;
                input = s.getInputStream();
                r = new Recebimento(new BufferedInputStream(input));
                r.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void escreverPane(String mensagem) throws BadLocationException {
        String tmp = "";
        for (char c : mensagem.toCharArray()) {
            tmp = c > '\u001f' ? tmp + "" + c : tmp + this.converterChar(c);
        }
        StyledDocument d = this.pane.getStyledDocument();
        d.insertString(d.getLength(), tmp + "\n", null);
    }

    private String converterChar(char c) {
        String tmp = "";
        switch (c) {
            case '\u0002': {
                tmp = "[STX]";
                break;
            }
            case '\u0001': {
                tmp = "[SOH]";
                break;
            }
            case '\u0005': {
                tmp = "[ENQ]";
                break;
            }
            case '\u0006': {
                tmp = "[ACK]";
                break;
            }
            case '\u0003': {
                tmp = "[ETX]";
                break;
            }
            case '\u0004': {
                tmp = "[EOT]";
                break;
            }
            case '\u0000': {
                tmp = "[NULL]";
                break;
            }
            case '\r': {
                tmp = "[CR]";
                break;
            }
            case '\n': {
                tmp = "[LF]";
                break;
            }
            case '\u0017': {
                tmp = "[LINE]";
                break;
            }
            default: {
                tmp = "(" + c + ")";
            }
        }
        return tmp;
    }

    private void escrever(PrintWriter printer, char mensagem) throws BadLocationException {
        this.escreverPane("L:" + this.converterChar(mensagem));
        printer.write(mensagem);
        printer.flush();
    }

    private void escrever(PrintWriter printer, String mensagem) throws BadLocationException {
        this.escreverPane("L:" + mensagem);
        printer.write(mensagem);
        printer.flush();
    }

    class Recebimento
    extends Thread {
        BufferedInputStream stream;

        public Recebimento(BufferedInputStream stream) {
            super("Thread-recebimento");
            this.stream = stream;
            System.out.println("Agurdando mensagem do cliente");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        byte[] readBuffer = new byte[this.stream.available()];
                        String tempString = "";
                        int numBytes = this.stream.read(readBuffer);
                        if ((tempString = tempString + new String(readBuffer, 0, numBytes)).length() > 0) {
                            TesteSocket.this.escreverPane("A:" + tempString);
                        }
                        this.esperar();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private void esperar() {
            try {
                Recebimento.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

