/*
 * Decompiled with CFR 0.152.
 */
package jalis.testes;

import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.io.File;
import java.io.FileReader;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;

public class TesteExamesPardini {
    public static void main(String[] args) {
        String path = "/home/cleisson/volpi";
        boolean processarArquivos = false;
        boolean escreverDescompactados = true;
        try {
            File diretorio = new File(path);
            File[] arquivosAux = diretorio.listFiles();
            ArrayList<File> arquivos = new ArrayList<File>();
            for (File aux : arquivosAux) {
                arquivos.add(aux);
            }
            Collections.sort(arquivos);
            Variaveis.caminhoBanco = "jdbc:postgresql://127.0.0.1/jalis";
            Statement st = ConexaoTemporaria.getStatement();
            DadosIntegracaoFilial d = IntegracaoUtil.buscaDadosFilial(st, "1");
            for (File file : arquivos) {
                if (file.isDirectory()) continue;
                FileReader reader = new FileReader(file);
                StringBuilder buf = new StringBuilder();
                int aux = -1;
                while ((aux = reader.read()) != -1) {
                    buf.append((char)aux);
                }
                Registro registro = IntegracaoUtil.arquivoRecebidoParaRegistro(buf.toString(), null);
                if (registro == null) {
                    System.out.println("Registro NULL -> " + file.getName());
                    continue;
                }
                if (processarArquivos && registro.getValor("data") instanceof Registro[]) {
                    IntegracaoUtil.processaVersao100((Registro[])registro.getValor("data"), st, d, registro.getString("arquivo"), null, null);
                }
                if (escreverDescompactados) {
                    StringBuilder texto = new StringBuilder();
                    for (Registro reg : (Registro[])registro.getValor("data")) {
                        System.out.println(file.getName() + " - " + reg.getString("codigo"));
                        texto.append(reg.getString("operacao")).append("\n");
                    }
                    File novoArquivo = new File(path + "/descompactado/" + file.getName());
                    novoArquivo.createNewFile();
                    StringUtil.escreverArquivoTexto(path + "/descompactado/" + file.getName(), texto.toString());
                }
                ConexaoTemporaria.anulaSQL();
            }
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

