/*
 * Decompiled with CFR 0.152.
 */
package jalis.testes;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.testes.CodigoPreco;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

public class TabelaXLS
extends JPanel
implements ActionListener {
    private CheckItemFiltro itemTabela;
    private JCheckBox itemExameProibido;
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JTextArea textImportacao = new JTextArea();
    private JScrollPane scrollImportacao = new JScrollPane(this.textImportacao);
    private JProgressBar progressImportacao = new JProgressBar();
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private Statement st = Conexao.getStatement();
    private Hashtable<Integer, CodigoPreco[]> lista = null;

    public TabelaXLS() {
        this.montaTela();
    }

    private void exportar() {
        try {
            if (this.lista == null) {
                this.textImportacao.setText("N\u00e3o existe dados a serem exportados...");
                return;
            }
            String arquivo = null;
            JFileChooser f = ComponenteFactory.novoJFileChooser();
            FileFilter flt = ComponenteFactory.novoFileFilter("(*.csv)", "csv");
            f.setFileFilter(flt);
            if (f.showSaveDialog(this) == 0 && !(arquivo = f.getSelectedFile().getAbsolutePath()).toUpperCase().endsWith(".csv")) {
                arquivo = arquivo + ".csv";
            }
            if (arquivo == null) {
                return;
            }
            String[] outro = new String[900];
            boolean passei = false;
            for (Integer tabela : this.lista.keySet()) {
                this.textImportacao.append("Exportando exames da tabela - " + tabela);
                CodigoPreco[] codigos = this.lista.get(tabela);
                int i = 0;
                while (i < codigos.length) {
                    CodigoPreco x = codigos[i];
                    String eita = "";
                    if (!passei) {
                        eita = eita + x.codigoExame + ";";
                        eita = eita + x.abreviatura + ";";
                        eita = eita + x.nomeExame + ";";
                        eita = eita + x.codigoMaterial + ";";
                    }
                    eita = eita + x.codigo + ";";
                    eita = eita + String.valueOf(x.preco).replace(".", ",") + ";";
                    int n = i++;
                    outro[n] = outro[n] + eita;
                }
                passei = true;
            }
            String grande = "";
            for (String e : outro) {
                grande = grande + e + "\n";
            }
            StringUtil.escreverArquivoTexto(arquivo, grande);
            Funcoes.mensagem(this, "Exporta\u00e7\u00e3o realizada com sucesso!", 5);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TabelaXLS: 97");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonConsultar) {
            this.filtrar();
        }
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exporta\u00e7\u00e3o de tabelas de pre\u00e7o para texto", "Exporta\u00e7ao de tabelas de pre\u00e7o para arquivos de texto", "export_result_text.jpg");
        JPanel panelAux = new JPanel();
        panelAux.setLayout(new BorderLayout());
        this.add((Component)panelAux, "Center");
        JPanel panel = new JPanel();
        panelAux.add((Component)panel, "West");
        panel.setBorder(BorderFactory.createTitledBorder("Filtro"));
        panel.setLayout(new GridBagLayout());
        panel.setPreferredSize(new Dimension(200, 200));
        GridBagConstraints cons = new GridBagConstraints();
        Dimension dim = new Dimension(190, 25);
        cons.insets = new Insets(2, 2, 2, 2);
        cons.fill = 2;
        cons.gridy = 0;
        this.itemTabela = new CheckItemFiltro("Tabela", "Filtrar", "Filtrando tabelas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemTabela.setDados("tabelaprecoexames", new String[]{"tpe_codigo", "tpe_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemTabela.setColunaHint(1);
        this.itemTabela.setPreferredSize(dim);
        this.itemTabela.setMinimumSize(dim);
        panel.add((Component)this.itemTabela, cons);
        ++cons.gridy;
        this.itemExameProibido = ComponenteFactory.novoJCheckBox("Apenas exames proibidos", this);
        this.itemExameProibido.setPreferredSize(dim);
        this.itemExameProibido.setMinimumSize(dim);
        panel.add((Component)this.itemExameProibido, cons);
        ++cons.gridy;
        cons.fill = 0;
        cons.anchor = 13;
        panel.add((Component)this.buttonConsultar, cons);
        ++cons.gridy;
        cons.gridwidth = 2;
        cons.fill = 1;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        panel.add((Component)new JPanel(), cons);
        panelAux.add((Component)this.scrollImportacao, "Center");
        panelAux = new JPanel(new FlowLayout(2, 3, 3));
        this.add((Component)panelAux, "South");
        panelAux.add(this.buttonNovo);
        panelAux.add(this.buttonExportar);
        panelAux.add(this.buttonFechar);
    }

    private void filtrar() {
        try {
            this.textImportacao.setText("Consultando Tabelas...");
            ResultSet rs = this.st.executeQuery("select tpe_codigo from tabelaprecoexames where fil_codigo =1 order by tpe_codigo");
            ArrayList<Integer> tabelas = new ArrayList<Integer>();
            while (rs.next()) {
                tabelas.add(rs.getInt("tpe_codigo"));
            }
            this.lista = new Hashtable();
            ArrayList<CodigoPreco> temp = new ArrayList<CodigoPreco>();
            Iterator iterator = tabelas.iterator();
            while (iterator.hasNext()) {
                int tabela = (Integer)iterator.next();
                this.textImportacao.append("Consultando Exames daTabela - " + tabela + "...");
                rs = this.st.executeQuery("select a.exa_codigo,c.mco_abreviatura, b.exa_descricao, a.mco_codigo, a.dtp_codamb, a.dtp_valor from detalhetabelapreco a left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo where a.fil_codigo = 1 and a.tpe_codigo = " + String.valueOf(tabela) + " and b.exa_proibido = " + (this.itemExameProibido.isSelected() ? "true" : " false ") + "order by a.exa_codigo, c.mco_abreviatura");
                while (rs.next()) {
                    temp.add(new CodigoPreco(rs.getString("exa_codigo"), rs.getString("mco_codigo"), rs.getString("exa_descricao"), rs.getString("mco_abreviatura"), rs.getString("dtp_codamb"), rs.getDouble("dtp_valor")));
                }
                this.lista.put(tabela, temp.toArray(new CodigoPreco[temp.size()]));
                temp.clear();
            }
            this.textImportacao.append("Consulta conclu\u00edda");
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TabelaXLS: 186");
        }
    }

    public static void main(String[] args) {
        JDialog teste = new JDialog();
        teste.setLayout(new BorderLayout());
        teste.add((Component)new TabelaXLS(), "Center");
        teste.setSize(new Dimension(800, 600));
        teste.setVisible(true);
    }
}

