/*
 * Decompiled with CFR 0.152.
 */
package jalis.testes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProcessaLayout
extends JFrame {
    JPanel panelTopo = new JPanel(new FlowLayout());
    JPanel panelExame = new JPanel(new BorderLayout());
    JPanel panelLayout = new JPanel(null);
    JPanel panelSelecionado = new JPanel(new BorderLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton buttonAbrir = new JButton("Abrir arquivo");
    JButton buttonFechar = new JButton("Fechar");
    JTextArea textCampoSelecionado = new JTextArea();
    JComboBox comboCamposDisponiveis = new JComboBox();

    public static void main(String[] args) {
        new ProcessaLayout().setVisible(true);
    }

    public ProcessaLayout() {
        super("ProcessaLayout");
        this.setSize(new Dimension(550, 500));
        this.setLayout(new BorderLayout());
        this.panelBotoes.add(this.buttonFechar);
        this.panelTopo.add(this.buttonAbrir);
        this.panelSelecionado.add((Component)new JScrollPane(this.textCampoSelecionado), "Center");
        JPanel panelTemp = new JPanel(new FlowLayout(0));
        panelTemp.add(new JLabel("Campos dispon\u00edveis:"));
        panelTemp.add(this.comboCamposDisponiveis);
        this.panelSelecionado.add((Component)new JScrollPane(this.textCampoSelecionado), "Center");
        this.panelSelecionado.add((Component)panelTemp, "South");
        this.panelSelecionado.setPreferredSize(new Dimension(100, 100));
        this.add((Component)this.buttonAbrir, "North");
        this.add((Component)this.panelExame, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.setDefaultCloseOperation(3);
        this.panelExame.add((Component)this.panelLayout, "Center");
        this.panelExame.add((Component)this.panelSelecionado, "South");
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcessaLayout.this.setVisible(false);
                ProcessaLayout.this.dispose();
            }
        });
        this.buttonAbrir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcessaLayout.this.textCampoSelecionado.setText("");
                ProcessaLayout.this.comboCamposDisponiveis.removeAllItems();
                File arquivo = new File("/home/junior/Desktop/exames_jalis.xml");
                if (arquivo.exists()) {
                    Document doc = ProcessaLayout.this.analisarXML(arquivo);
                    Element raiz = doc.getDocumentElement();
                    ArrayList<Element> filhos = new ArrayList<Element>();
                    if (raiz != null) {
                        NodeList list = raiz.getChildNodes();
                        for (int i = 0; i < list.getLength(); ++i) {
                            if (list.item(i).getNodeType() != 1) continue;
                            filhos.add((Element)list.item(i));
                        }
                    }
                    for (Element elemento : filhos) {
                        String nome = elemento.getNodeName();
                        if (nome.equals("codigo")) {
                            ProcessaLayout.this.textCampoSelecionado.append("C\u00f3digo: " + elemento.getTextContent());
                            continue;
                        }
                        if (nome.equals("descricao")) {
                            ProcessaLayout.this.textCampoSelecionado.append("\nExame: " + elemento.getTextContent());
                            continue;
                        }
                        if (!nome.equals("materiais")) continue;
                        ProcessaLayout.this.parseMaterial(elemento);
                    }
                }
            }
        });
    }

    private void parseMaterial(Element elemento) {
        NodeList material = elemento.getElementsByTagName("material");
        for (int i = 0; i < material.getLength(); ++i) {
            NodeList list = material.item(i).getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                Element el = (Element)list.item(j);
                if (!el.getNodeName().equals("metodologias")) continue;
                NodeList componentes = ((Element)el.getElementsByTagName("layout").item(0)).getElementsByTagName("componente");
                for (int k = 0; k < componentes.getLength(); ++k) {
                    JComponent comp;
                    Element ele = (Element)componentes.item(k);
                    String nome = ele.getElementsByTagName("nome").item(0).getTextContent();
                    String tipo = ele.getElementsByTagName("tipo").item(0).getTextContent();
                    String texto = ele.getElementsByTagName("texto").item(0).getTextContent();
                    String nomeFonte = ele.getElementsByTagName("nomeFonte").item(0).getTextContent();
                    int altura = ele.getElementsByTagName("altura").item(0).getTextContent().matches("\\d+") ? Integer.parseInt(ele.getElementsByTagName("altura").item(0).getTextContent()) : 0;
                    int largura = ele.getElementsByTagName("largura").item(0).getTextContent().matches("\\d+") ? Integer.parseInt(ele.getElementsByTagName("largura").item(0).getTextContent()) : 0;
                    int esquerda = ele.getElementsByTagName("esquerda").item(0).getTextContent().matches("\\d+") ? Integer.parseInt(ele.getElementsByTagName("esquerda").item(0).getTextContent()) : 0;
                    int topo = ele.getElementsByTagName("topo").item(0).getTextContent().matches("\\d+") ? Integer.parseInt(ele.getElementsByTagName("topo").item(0).getTextContent()) : 0;
                    int tamanhoFonte = ele.getElementsByTagName("tamanhoFonte").item(0).getTextContent().matches("\\d+") ? Integer.parseInt(ele.getElementsByTagName("tamanhoFonte").item(0).getTextContent()) : 0;
                    int tipoFonte = ele.getElementsByTagName("tipoFonte").item(0).getTextContent().matches("\\d+") ? Integer.parseInt(ele.getElementsByTagName("tipoFonte").item(0).getTextContent()) : 0;
                    Font fonte = new Font(nomeFonte, tipoFonte, tamanhoFonte);
                    JComponent jComponent = comp = tipo.equals("TEXTO") ? new JLabel(texto) : new JTextField(texto);
                    if (tipo.equals("CAMPO")) {
                        this.comboCamposDisponiveis.addItem(nome);
                    }
                    ((Component)comp).setFont(fonte);
                    comp.setName(nome);
                    comp.setFocusable(false);
                    comp.setBounds(esquerda, topo, largura, altura);
                    comp.setCursor(Cursor.getPredefinedCursor(12));
                    comp.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            ProcessaLayout.this.textCampoSelecionado.append("\nItem selecionado: " + ((Component)e.getSource()).getName());
                        }
                    });
                    this.panelLayout.add(comp);
                }
            }
        }
        this.panelLayout.revalidate();
        this.panelLayout.repaint();
    }

    public Document analisarXML(File arquivo) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(arquivo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

