/*
 * Decompiled with CFR 0.152.
 */
package jalis.testes;

import jalis.laboratorio.configurador.pagina.DimensoesAssinaturaDigitalDTO;
import jalis.laboratorio.resultados.assinaturadigital.AssinaturaDigitalPDF;
import jalis.laboratorio.resultados.assinaturadigital.DadosAssinaturaDigitalDTO;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class PdfAssinado {
    private static final String SENHA_CERTIFICADO = "1234";

    public static void main(String[] args) {
        try {
            byte[] pdfEmBytes = PdfAssinado.getPdfEmBytes(PdfAssinado.getPath("/PDF/pdf-sem-ass.pdf"));
            byte[] certificadoEmBytes = PdfAssinado.getCertificadoEmBytes(PdfAssinado.getPath("/certificado.pfx"));
            DadosAssinaturaDigitalDTO dto = PdfAssinado.getDadosAssinaturaDigitalDTO(pdfEmBytes, certificadoEmBytes, SENHA_CERTIFICADO, 50, 29);
            AssinaturaDigitalPDF ca = new AssinaturaDigitalPDF(dto);
            byte[] assinado = ca.assinarPDF();
            String nome = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH_mm_ss_SSS"));
            String pathSalvo = "/home/cesar/PDF/comp/" + nome + ".pdf";
            Files.write(Paths.get(pathSalvo, new String[0]), assinado, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static DadosAssinaturaDigitalDTO getDadosAssinaturaDigitalDTO(byte[] pdf, byte[] certificado, String senha, int alturaAss, int margemEsq) throws Exception {
        byte[] pdfEmBytes = pdf;
        byte[] certificadoEmBytes = certificado;
        byte[] imagem = PdfAssinado.getImagemEmBytes(PdfAssinado.getPath("/Imagens/Wallpapers/03.png"));
        int posicaoHorizontalAssinatura = 4;
        boolean posicaoVerticalAssinatura = true;
        int margemEsquerda = margemEsq;
        int margemDireita = 12;
        int margemInferior = 28;
        boolean margemAssinatura = false;
        int alturaAssinatura = alturaAss;
        int alturaRodape = 101;
        boolean posicaoVertitcalAbsolutaAssinatura = false;
        boolean tipoAssinaturaRodape = true;
        Font fonteAssDigital = new Font("Arial", 0, 10);
        DimensoesAssinaturaDigitalDTO dimensoesAssDigital = new DimensoesAssinaturaDigitalDTO.Builder().alturaImagem(0).larguraImagem(0).larguraAssinatura(200).fonte(fonteAssDigital).build();
        return new DadosAssinaturaDigitalDTO.Builder().pdfOriginal(new ByteArrayInputStream(pdfEmBytes)).certificado(certificadoEmBytes).senhaCertificado(senha).razao("RAZAO").local("LOCAL").posicaoHorizontalAssinatura(4).posicaoVerticalAssinatura(1).margemEsquerda(margemEsquerda).margemDireita(12).margemInferior(28).margemAssinatura(0.0f).alturaAssinatura(alturaAssinatura).alturaRodape(101).posicaoVerticalAbsolutaAssinatura(0).data(new Date()).tipoAssinaturaRodape(1).dimensoesAssinaturaDigital(dimensoesAssDigital).build();
    }

    private static byte[] getPdfEmBytes(String pathArquivoPdf) throws IOException {
        return Files.readAllBytes(Paths.get(pathArquivoPdf, new String[0]));
    }

    private static byte[] getCertificadoEmBytes(String pathCertificado) throws IOException {
        return Files.readAllBytes(Paths.get(pathCertificado, new String[0]));
    }

    private static byte[] getImagemEmBytes(String pathImagem) throws IOException {
        return Files.readAllBytes(Paths.get(pathImagem, new String[0]));
    }

    private static String getPath(String pathArquivo) {
        return System.getProperty("user.home") + pathArquivo;
    }
}

