/*
 * Decompiled with CFR 0.152.
 */
package jalis.testes;

import jalis.testes.PDFDict;
import jalis.testes.PDFObject;
import jalis.testes.Page;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;

class PDF {
    protected PrintWriter out;
    protected ArrayList pages;
    protected ArrayList xrefs;
    PDFObject rootObj = new RootObject(this);
    InfoObject infoObj = new InfoObject(this);
    OutlinesObject outlinesObj = new OutlinesObject(this);
    PagesObject pagesObj = new PagesObject(this);
    FontDict fontDict = new FontDict(this);
    protected int currObj = 1;
    protected boolean startedWriting = false;
    protected static final String PDF_MAGIC = "%PDF-1.0";
    long offset = 0L;
    DecimalFormat nf10 = new DecimalFormat("0000000000");
    DecimalFormat nf5 = new DecimalFormat("00000");
    long xrefStart;

    public PDF(PrintWriter o) {
        this.out = o;
        this.pages = new ArrayList();
        this.xrefs = new ArrayList();
    }

    public void add(Page p) {
        this.pages.add(p);
    }

    public void insertPage(int where, Page p) {
        this.pages.add(where, p);
    }

    protected void print(String s) {
        this.out.print(s);
        this.offset += (long)s.length();
    }

    protected void println(String s) {
        this.print(s);
        this.print("\n");
    }

    protected void print(Object o) {
        this.print(o.toString());
    }

    protected void println(Object o) {
        this.println(o.toString());
    }

    protected void print(int i) {
        String s = Integer.toString(i);
        this.print(s);
    }

    protected void println(int i) {
        String s = Integer.toString(i);
        this.print(s);
    }

    protected void println() {
        this.print("\n");
    }

    protected void addXref() {
        this.xrefs.add(new Long(this.offset));
    }

    public void writePDF() {
        if (this.startedWriting) {
            throw new IllegalStateException("writePDF() can only be called once.");
        }
        this.startedWriting = true;
        this.writePDFHeader();
        this.writePDFbody();
        this.writeXrefs();
        this.writePDFTrailer();
        this.out.flush();
        this.out.close();
    }

    protected void writePDFHeader() {
        this.println(PDF_MAGIC);
        this.rootObj.print();
        this.infoObj.print();
        this.outlinesObj.print();
        this.pagesObj.print();
    }

    protected void writePDFbody() {
        for (int i = 0; i < this.pages.size(); ++i) {
            ((Page)this.pages.get(i)).print();
        }
        this.addXref();
        this.print(this.currObj++);
        this.println(" 0 obj");
        this.println("[/PDF /Text]");
        this.println("endobj");
        this.fontDict.print();
    }

    protected void printXref(long n, int where, char inUse) {
        this.println(this.nf10.format(n) + " " + this.nf5.format(where) + " " + inUse);
    }

    protected void writeXrefs() {
        this.xrefStart = this.offset;
        this.println("xref");
        this.print(0);
        this.print(" ");
        this.print(this.xrefs.size() + 1);
        this.println();
        this.printXref(0L, 65535, 'f');
        for (int i = 0; i < this.xrefs.size(); ++i) {
            Long lo = (Long)this.xrefs.get(i);
            long l = lo;
            this.printXref(l, 0, 'n');
        }
    }

    protected void writePDFTrailer() {
        this.println("trailer");
        this.println("<<");
        this.println("/Size " + (this.xrefs.size() + 1));
        this.println("/Root 1 0 R");
        this.println("/Info 2 0 R");
        this.println(">>");
        this.println("% startxref");
        this.println("% " + this.xrefStart);
        this.println("%%EOF");
    }

    public void setAuthor(String au) {
        this.infoObj.dict.put("Author", "(" + au + ")");
    }

    class FontDict
    extends PDFDict {
        protected FontDict(PDF m) {
            super(m);
            this.dict.put("Type", "/Font");
            this.dict.put("Subtype", "/Type1");
            this.dict.put("Name", "/F1");
            this.dict.put("BaseFont", "/Helvetica");
            this.dict.put("Encoding", "/MacRomanEncoding");
        }
    }

    class PagesObject
    extends PDFDict {
        protected PagesObject(PDF m) {
            super(m);
            this.dict.put("Type", "/Pages");
            this.dict.put("Count", "1");
            this.dict.put("Kids", "[5 0 R]");
        }
    }

    class OutlinesObject
    extends PDFDict {
        protected OutlinesObject(PDF m) {
            super(m);
            this.dict.put("Type", "/Outlines");
            this.dict.put("Count", "0");
        }
    }

    class InfoObject
    extends PDFDict {
        protected InfoObject(PDF m) {
            super(m);
            this.dict.put("Title", "(Sample PDF by SPDF)");
            this.dict.put("Creator", "(Darwin Open Systems SPDF Software)");
            this.dict.put("Created", "(D:20000516010203)");
        }
    }

    class RootObject
    extends PDFDict {
        protected RootObject(PDF m) {
            super(m);
            this.dict.put("Type", "/Catalog");
            this.dict.put("Outlines", "3 0 R");
            this.dict.put("Pages", "4 0 R");
        }
    }
}

