/*
 * Decompiled with CFR 0.152.
 */
package jalis.testes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class HTMLDocumentEditor
extends JFrame
implements ActionListener {
    private HTMLDocument document;
    private JTextPane textPane = new JTextPane();
    private boolean debug = false;
    private File currentFile;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();
    private Action cutAction = new DefaultEditorKit.CutAction();
    private Action copyAction = new DefaultEditorKit.CopyAction();
    private Action pasteAction = new DefaultEditorKit.PasteAction();
    private Action boldAction = new StyledEditorKit.BoldAction();
    private Action underlineAction = new StyledEditorKit.UnderlineAction();
    private Action italicAction = new StyledEditorKit.ItalicAction();
    private Action insertBreakAction = new DefaultEditorKit.InsertBreakAction();
    private HTMLEditorKit.InsertHTMLTextAction unorderedListAction = new HTMLEditorKit.InsertHTMLTextAction("Bullets", "<ul><li> </li></ul>", HTML.Tag.P, HTML.Tag.UL);
    private HTMLEditorKit.InsertHTMLTextAction bulletAction = new HTMLEditorKit.InsertHTMLTextAction("Bullets", "<li> </li>", HTML.Tag.UL, HTML.Tag.LI);

    public HTMLDocumentEditor() {
        super("HTMLDocumentEditor");
        HTMLEditorKit editorKit = new HTMLEditorKit();
        this.document = (HTMLDocument)editorKit.createDefaultDocument();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.err.println("Error loading L&F: " + exc);
        }
        this.init();
    }

    public static void main(String[] args) {
        HTMLDocumentEditor editor = new HTMLDocumentEditor();
    }

    public void init() {
        this.addWindowListener(new FrameListener());
        JMenuBar menuBar = new JMenuBar();
        this.getContentPane().add((Component)menuBar, "North");
        JMenu fileMenu = new JMenu("File");
        JMenu editMenu = new JMenu("Edit");
        JMenu colorMenu = new JMenu("Color");
        JMenu fontMenu = new JMenu("Font");
        JMenu styleMenu = new JMenu("Style");
        JMenu alignMenu = new JMenu("Align");
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(colorMenu);
        menuBar.add(fontMenu);
        menuBar.add(styleMenu);
        menuBar.add(alignMenu);
        menuBar.add(helpMenu);
        JMenuItem newItem = new JMenuItem("New", new ImageIcon("whatsnew-bang.gif"));
        JMenuItem openItem = new JMenuItem("Open", new ImageIcon("open.gif"));
        JMenuItem saveItem = new JMenuItem("Save", new ImageIcon("save.gif"));
        JMenuItem saveAsItem = new JMenuItem("Save As");
        JMenuItem exitItem = new JMenuItem("Exit", new ImageIcon("exit.gif"));
        newItem.addActionListener(this);
        openItem.addActionListener(this);
        saveItem.addActionListener(this);
        saveAsItem.addActionListener(this);
        exitItem.addActionListener(this);
        fileMenu.add(newItem);
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.add(saveAsItem);
        fileMenu.add(exitItem);
        JMenuItem undoItem = new JMenuItem(this.undoAction);
        JMenuItem redoItem = new JMenuItem(this.redoAction);
        JMenuItem cutItem = new JMenuItem(this.cutAction);
        JMenuItem copyItem = new JMenuItem(this.copyAction);
        JMenuItem pasteItem = new JMenuItem(this.pasteAction);
        JMenuItem clearItem = new JMenuItem("Clear");
        JMenuItem selectAllItem = new JMenuItem("Select All");
        JMenuItem insertBreaKItem = new JMenuItem(this.insertBreakAction);
        JMenuItem unorderedListItem = new JMenuItem(this.unorderedListAction);
        JMenuItem bulletItem = new JMenuItem(this.bulletAction);
        cutItem.setText("Cut");
        copyItem.setText("Copy");
        pasteItem.setText("Paste");
        insertBreaKItem.setText("Break");
        cutItem.setIcon(new ImageIcon("cut.gif"));
        copyItem.setIcon(new ImageIcon("copy.gif"));
        pasteItem.setIcon(new ImageIcon("paste.gif"));
        insertBreaKItem.setIcon(new ImageIcon("break.gif"));
        unorderedListItem.setIcon(new ImageIcon("bullets.gif"));
        clearItem.addActionListener(this);
        selectAllItem.addActionListener(this);
        editMenu.add(undoItem);
        editMenu.add(redoItem);
        editMenu.add(cutItem);
        editMenu.add(copyItem);
        editMenu.add(pasteItem);
        editMenu.add(clearItem);
        editMenu.add(selectAllItem);
        editMenu.add(insertBreaKItem);
        editMenu.add(unorderedListItem);
        editMenu.add(bulletItem);
        JMenuItem redTextItem = new JMenuItem(new StyledEditorKit.ForegroundAction("Red", Color.red));
        JMenuItem orangeTextItem = new JMenuItem(new StyledEditorKit.ForegroundAction("Orange", Color.orange));
        JMenuItem yellowTextItem = new JMenuItem(new StyledEditorKit.ForegroundAction("Yellow", Color.yellow));
        JMenuItem greenTextItem = new JMenuItem(new StyledEditorKit.ForegroundAction("Green", Color.green));
        JMenuItem blueTextItem = new JMenuItem(new StyledEditorKit.ForegroundAction("Blue", Color.blue));
        JMenuItem cyanTextItem = new JMenuItem(new StyledEditorKit.ForegroundAction("Cyan", Color.cyan));
        JMenuItem magentaTextItem = new JMenuItem(new StyledEditorKit.ForegroundAction("Magenta", Color.magenta));
        JMenuItem blackTextItem = new JMenuItem(new StyledEditorKit.ForegroundAction("Black", Color.black));
        redTextItem.setIcon(new ImageIcon("red.gif"));
        orangeTextItem.setIcon(new ImageIcon("orange.gif"));
        yellowTextItem.setIcon(new ImageIcon("yellow.gif"));
        greenTextItem.setIcon(new ImageIcon("green.gif"));
        blueTextItem.setIcon(new ImageIcon("blue.gif"));
        cyanTextItem.setIcon(new ImageIcon("cyan.gif"));
        magentaTextItem.setIcon(new ImageIcon("magenta.gif"));
        blackTextItem.setIcon(new ImageIcon("black.gif"));
        colorMenu.add(redTextItem);
        colorMenu.add(orangeTextItem);
        colorMenu.add(yellowTextItem);
        colorMenu.add(greenTextItem);
        colorMenu.add(blueTextItem);
        colorMenu.add(cyanTextItem);
        colorMenu.add(magentaTextItem);
        colorMenu.add(blackTextItem);
        JMenu fontTypeMenu = new JMenu("Font Type");
        fontMenu.add(fontTypeMenu);
        String[] fontTypes = new String[]{"SansSerif", "Serif", "Monospaced", "Dialog", "DialogInput"};
        for (int i = 0; i < fontTypes.length; ++i) {
            if (this.debug) {
                System.out.println(fontTypes[i]);
            }
            JMenuItem nextTypeItem = new JMenuItem(fontTypes[i]);
            nextTypeItem.setAction(new StyledEditorKit.FontFamilyAction(fontTypes[i], fontTypes[i]));
            fontTypeMenu.add(nextTypeItem);
        }
        JMenu fontSizeMenu = new JMenu("Font Size");
        fontMenu.add(fontSizeMenu);
        int[] fontSizes = new int[]{6, 8, 10, 12, 14, 16, 20, 24, 32, 36, 48, 72};
        for (int i = 0; i < fontSizes.length; ++i) {
            if (this.debug) {
                System.out.println(fontSizes[i]);
            }
            JMenuItem nextSizeItem = new JMenuItem(String.valueOf(fontSizes[i]));
            nextSizeItem.setAction(new StyledEditorKit.FontSizeAction(String.valueOf(fontSizes[i]), fontSizes[i]));
            fontSizeMenu.add(nextSizeItem);
        }
        JMenuItem boldMenuItem = new JMenuItem(this.boldAction);
        JMenuItem underlineMenuItem = new JMenuItem(this.underlineAction);
        JMenuItem italicMenuItem = new JMenuItem(this.italicAction);
        boldMenuItem.setText("Bold");
        underlineMenuItem.setText("Underline");
        italicMenuItem.setText("Italic");
        boldMenuItem.setIcon(new ImageIcon("bold.gif"));
        underlineMenuItem.setIcon(new ImageIcon("underline.gif"));
        italicMenuItem.setIcon(new ImageIcon("italic.gif"));
        styleMenu.add(boldMenuItem);
        styleMenu.add(underlineMenuItem);
        styleMenu.add(italicMenuItem);
        JMenuItem subscriptMenuItem = new JMenuItem(new SubscriptAction());
        JMenuItem superscriptMenuItem = new JMenuItem(new SuperscriptAction());
        JMenuItem strikeThroughMenuItem = new JMenuItem(new StrikeThroughAction());
        subscriptMenuItem.setText("Subscript");
        superscriptMenuItem.setText("Superscript");
        strikeThroughMenuItem.setText("StrikeThrough");
        subscriptMenuItem.setIcon(new ImageIcon("subscript.gif"));
        superscriptMenuItem.setIcon(new ImageIcon("superscript.gif"));
        strikeThroughMenuItem.setIcon(new ImageIcon("strikethough.gif"));
        styleMenu.add(subscriptMenuItem);
        styleMenu.add(superscriptMenuItem);
        styleMenu.add(strikeThroughMenuItem);
        JMenuItem leftAlignMenuItem = new JMenuItem(new StyledEditorKit.AlignmentAction("Left Align", 0));
        JMenuItem centerMenuItem = new JMenuItem(new StyledEditorKit.AlignmentAction("Center", 1));
        JMenuItem rightAlignMenuItem = new JMenuItem(new StyledEditorKit.AlignmentAction("Right Align", 2));
        leftAlignMenuItem.setText("Left Align");
        centerMenuItem.setText("Center");
        rightAlignMenuItem.setText("Right Align");
        leftAlignMenuItem.setIcon(new ImageIcon("left.gif"));
        centerMenuItem.setIcon(new ImageIcon("center.gif"));
        rightAlignMenuItem.setIcon(new ImageIcon("right.gif"));
        alignMenu.add(leftAlignMenuItem);
        alignMenu.add(centerMenuItem);
        alignMenu.add(rightAlignMenuItem);
        JMenuItem helpItem = new JMenuItem("Help");
        helpItem.addActionListener(this);
        helpMenu.add(helpItem);
        JMenuItem shortcutsItem = new JMenuItem("Keyboard Shortcuts");
        shortcutsItem.addActionListener(this);
        helpMenu.add(shortcutsItem);
        JMenuItem aboutItem = new JMenuItem("About QuantumHyperSpace");
        aboutItem.addActionListener(this);
        helpMenu.add(aboutItem);
        JPanel editorControlPanel = new JPanel();
        editorControlPanel.setLayout(new FlowLayout());
        JButton cutButton = new JButton(this.cutAction);
        JButton copyButton = new JButton(this.copyAction);
        JButton pasteButton = new JButton(this.pasteAction);
        JButton boldButton = new JButton(this.boldAction);
        JButton underlineButton = new JButton(this.underlineAction);
        JButton italicButton = new JButton(this.italicAction);
        cutButton.setText("Cut");
        copyButton.setText("Copy");
        pasteButton.setText("Paste");
        boldButton.setText("Bold");
        underlineButton.setText("Underline");
        italicButton.setText("Italic");
        cutButton.setIcon(new ImageIcon("cut.gif"));
        copyButton.setIcon(new ImageIcon("copy.gif"));
        pasteButton.setIcon(new ImageIcon("paste.gif"));
        boldButton.setIcon(new ImageIcon("bold.gif"));
        underlineButton.setIcon(new ImageIcon("underline.gif"));
        italicButton.setIcon(new ImageIcon("italic.gif"));
        editorControlPanel.add(cutButton);
        editorControlPanel.add(copyButton);
        editorControlPanel.add(pasteButton);
        editorControlPanel.add(boldButton);
        editorControlPanel.add(underlineButton);
        editorControlPanel.add(italicButton);
        JButton subscriptButton = new JButton(new SubscriptAction());
        JButton superscriptButton = new JButton(new SuperscriptAction());
        JButton strikeThroughButton = new JButton(new StrikeThroughAction());
        subscriptButton.setIcon(new ImageIcon("subscript.gif"));
        superscriptButton.setIcon(new ImageIcon("superscript.gif"));
        strikeThroughButton.setIcon(new ImageIcon("strikethough.gif"));
        JPanel specialPanel = new JPanel();
        specialPanel.setLayout(new FlowLayout());
        specialPanel.add(subscriptButton);
        specialPanel.add(superscriptButton);
        specialPanel.add(strikeThroughButton);
        JButton leftAlignButton = new JButton(new StyledEditorKit.AlignmentAction("Left Align", 0));
        JButton centerButton = new JButton(new StyledEditorKit.AlignmentAction("Center", 1));
        JButton rightAlignButton = new JButton(new StyledEditorKit.AlignmentAction("Right Align", 2));
        JButton colorButton = new JButton(new StyledEditorKit.AlignmentAction("Right Align", 2));
        leftAlignButton.setIcon(new ImageIcon("left.gif"));
        centerButton.setIcon(new ImageIcon("center.gif"));
        rightAlignButton.setIcon(new ImageIcon("right.gif"));
        colorButton.setIcon(new ImageIcon("color.gif"));
        leftAlignButton.setText("Left Align");
        centerButton.setText("Center");
        rightAlignButton.setText("Right Align");
        JPanel alignPanel = new JPanel();
        alignPanel.setLayout(new FlowLayout());
        alignPanel.add(leftAlignButton);
        alignPanel.add(centerButton);
        alignPanel.add(rightAlignButton);
        this.document.addUndoableEditListener(this.undoHandler);
        this.resetUndoManager();
        this.textPane = new JTextPane(this.document);
        this.textPane.setContentType("text/html");
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension scrollPaneSize = new Dimension(5 * screenSize.width / 8, 5 * screenSize.height / 8);
        scrollPane.setPreferredSize(scrollPaneSize);
        JPanel toolPanel = new JPanel();
        toolPanel.setLayout(new BorderLayout());
        toolPanel.add((Component)editorControlPanel, "North");
        toolPanel.add((Component)specialPanel, "Center");
        toolPanel.add((Component)alignPanel, "South");
        this.getContentPane().add((Component)menuBar, "North");
        this.getContentPane().add((Component)scrollPane, "South");
        this.pack();
        this.setLocationRelativeTo(null);
        this.startNewDocument();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (this.debug) {
            int modifier = ae.getModifiers();
            long when = ae.getWhen();
            String parameter = ae.paramString();
            System.out.println("actionCommand: " + actionCommand);
            System.out.println("modifier: " + modifier);
            System.out.println("when: " + when);
            System.out.println("parameter: " + parameter);
        }
        if (actionCommand.compareTo("New") == 0) {
            this.startNewDocument();
        } else if (actionCommand.compareTo("Open") == 0) {
            this.openDocument();
        } else if (actionCommand.compareTo("Save") == 0) {
            this.saveDocument();
        } else if (actionCommand.compareTo("Save As") == 0) {
            this.saveDocumentAs();
        } else if (actionCommand.compareTo("Exit") == 0) {
            this.exit();
        } else if (actionCommand.compareTo("Clear") == 0) {
            this.clear();
        } else if (actionCommand.compareTo("Select All") == 0) {
            this.selectAll();
        } else if (actionCommand.compareTo("Help") == 0) {
            this.help();
        } else if (actionCommand.compareTo("Keyboard Shortcuts") == 0) {
            this.showShortcuts();
        } else if (actionCommand.compareTo("About QuantumHyperSpace") == 0) {
            this.aboutQuantumHyperSpace();
        }
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    public void startNewDocument() {
        Document oldDoc = this.textPane.getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        HTMLEditorKit editorKit = new HTMLEditorKit();
        this.document = (HTMLDocument)editorKit.createDefaultDocument();
        this.textPane.setDocument(this.document);
        this.currentFile = null;
        this.setTitle("HTMLDocumentEditor");
        this.textPane.getDocument().addUndoableEditListener(this.undoHandler);
        this.resetUndoManager();
    }

    public void openDocument() {
        try {
            File current = new File(".");
            JFileChooser chooser = new JFileChooser(current);
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(new HTMLFileFilter());
            int approval = chooser.showSaveDialog(this);
            if (approval == 0) {
                this.currentFile = chooser.getSelectedFile();
                this.setTitle(this.currentFile.getName());
                FileReader fr = new FileReader(this.currentFile);
                Document oldDoc = this.textPane.getDocument();
                if (oldDoc != null) {
                    oldDoc.removeUndoableEditListener(this.undoHandler);
                }
                HTMLEditorKit editorKit = new HTMLEditorKit();
                this.document = (HTMLDocument)editorKit.createDefaultDocument();
                editorKit.read(fr, (Document)this.document, 0);
                this.document.addUndoableEditListener(this.undoHandler);
                this.textPane.setDocument(this.document);
                this.resetUndoManager();
            }
        }
        catch (BadLocationException ble) {
            System.err.println("BadLocationException: " + ble.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("FileNotFoundException: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage());
        }
    }

    public void saveDocument() {
        if (this.currentFile != null) {
            try {
                FileWriter fw = new FileWriter(this.currentFile);
                fw.write(this.textPane.getText());
                fw.close();
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("FileNotFoundException: " + fnfe.getMessage());
            }
            catch (IOException ioe) {
                System.err.println("IOException: " + ioe.getMessage());
            }
        } else {
            this.saveDocumentAs();
        }
    }

    public void saveDocumentAs() {
        try {
            File current = new File(".");
            JFileChooser chooser = new JFileChooser(current);
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(new HTMLFileFilter());
            int approval = chooser.showSaveDialog(this);
            if (approval == 0) {
                File newFile = chooser.getSelectedFile();
                if (newFile.exists()) {
                    String message = newFile.getAbsolutePath() + " already exists. \nDo you want to replace it?";
                    if (JOptionPane.showConfirmDialog(this, message) == 0) {
                        this.currentFile = newFile;
                        this.setTitle(this.currentFile.getName());
                        FileWriter fw = new FileWriter(this.currentFile);
                        fw.write(this.textPane.getText());
                        fw.close();
                        if (this.debug) {
                            System.out.println("Saved " + this.currentFile.getAbsolutePath());
                        }
                    }
                } else {
                    this.currentFile = new File(newFile.getAbsolutePath());
                    this.setTitle(this.currentFile.getName());
                    FileWriter fw = new FileWriter(this.currentFile);
                    fw.write(this.textPane.getText());
                    fw.close();
                    if (this.debug) {
                        System.out.println("Saved " + this.currentFile.getAbsolutePath());
                    }
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("FileNotFoundException: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage());
        }
    }

    public void exit() {
        String exitMessage = "Are you sure you want to exit?";
        if (JOptionPane.showConfirmDialog(this, exitMessage) == 0) {
            System.exit(0);
        }
    }

    public void clear() {
        this.startNewDocument();
    }

    public void selectAll() {
        this.textPane.selectAll();
    }

    public void help() {
        JOptionPane.showMessageDialog(this, "DocumentEditor.java\nAuthor: Charles Bell\nVersion: May 25, 2002\nhttp://www.quantumhyperspace.com\nQuantumHyperSpace Programming Services");
    }

    public void showShortcuts() {
        String shortcuts = "Navigate in    |  Tab\nNavigate out   |  Ctrl+Tab\nNavigate out backwards    |  Shift+Ctrl+Tab\nMove up/down a line    |  Up/Down Arrown\nMove left/right a component or char    |  Left/Right Arrow\nMove up/down one vertical block    |  PgUp/PgDn\nMove to start/end of line    |  Home/End\nMove to previous/next word    |  Ctrl+Left/Right Arrow\nMove to start/end of data    |  Ctrl+Home/End\nMove left/right one block    |  Ctrl+PgUp/PgDn\nSelect All    |  Ctrl+A\nExtend selection up one line    |  Shift+Up Arrow\nExtend selection down one line    |  Shift+Down Arrow\nExtend selection to beginning of line    |  Shift+Home\nExtend selection to end of line    |  Shift+End\nExtend selection to beginning of data    |  Ctrl+Shift+Home\nExtend selection to end of data    |  Ctrl+Shift+End\nExtend selection left    |  Shift+Right Arrow\nExtend selection right    |  Shift+Right Arrow\nExtend selection up one vertical block    |  Shift+PgUp\nExtend selection down one vertical block    |  Shift+PgDn\nExtend selection left one block    |  Ctrl+Shift+PgUp\nExtend selection right one block    |  Ctrl+Shift+PgDn\nExtend selection left one word    |  Ctrl+Shift+Left Arrow\nExtend selection right one word    |  Ctrl+Shift+Right Arrow\n";
        JOptionPane.showMessageDialog(this, shortcuts);
    }

    public void aboutQuantumHyperSpace() {
        JOptionPane.showMessageDialog(this, "QuantumHyperSpace Programming Services\nhttp://www.quantumhyperspace.com\nemail: support@quantumhyperspace.com\n                     or \nemail: charles@quantumhyperspace.com\n", "QuantumHyperSpace", 1, new ImageIcon("quantumhyperspace.gif"));
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                HTMLDocumentEditor.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                System.err.println("Unable to redo: " + ex);
                ex.printStackTrace();
            }
            this.update();
            HTMLDocumentEditor.this.undoAction.update();
        }

        protected void update() {
            if (HTMLDocumentEditor.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", HTMLDocumentEditor.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                HTMLDocumentEditor.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + ex);
                ex.printStackTrace();
            }
            this.update();
            HTMLDocumentEditor.this.redoAction.update();
        }

        protected void update() {
            if (HTMLDocumentEditor.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", HTMLDocumentEditor.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            HTMLDocumentEditor.this.undo.addEdit(e.getEdit());
            HTMLDocumentEditor.this.undoAction.update();
            HTMLDocumentEditor.this.redoAction.update();
        }
    }

    class HTMLFileFilter
    extends FileFilter {
        HTMLFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().indexOf(".htm") > 0;
        }

        @Override
        public String getDescription() {
            return "html";
        }
    }

    class StrikeThroughAction
    extends StyledEditorKit.StyledTextAction {
        public StrikeThroughAction() {
            super(StyleConstants.StrikeThrough.toString());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean strikeThrough = !StyleConstants.isStrikeThrough(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setStrikeThrough(sas, strikeThrough);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    class SuperscriptAction
    extends StyledEditorKit.StyledTextAction {
        public SuperscriptAction() {
            super(StyleConstants.Superscript.toString());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean superscript = !StyleConstants.isSuperscript(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setSuperscript(sas, superscript);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    class SubscriptAction
    extends StyledEditorKit.StyledTextAction {
        public SubscriptAction() {
            super(StyleConstants.Subscript.toString());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean subscript = !StyleConstants.isSubscript(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setSubscript(sas, subscript);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    class FrameListener
    extends WindowAdapter {
        FrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent we) {
            HTMLDocumentEditor.this.exit();
        }
    }
}

