/*
 * Decompiled with CFR 0.152.
 */
package jalis.testes;

import jalis.testes.Conectar;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ExportarAlimentos
extends JFrame {
    private Connection conn = null;

    public static void main(String[] args) {
        ExportarAlimentos e = new ExportarAlimentos();
        e.setVisible(true);
    }

    public ExportarAlimentos() {
        super("Exportar dados");
        this.montaTela();
        this.conn = Conectar.conectar();
    }

    public void montaTela() {
        this.setSize(new Dimension(400, 200));
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ExportarAlimentos.this.finalizar();
            }
        });
        JButton buttonFechar = new JButton("Fechar");
        buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarAlimentos.this.finalizar();
            }
        });
        JButton buttonCliente = new JButton("Clientes");
        buttonCliente.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(3));
                Statement st = null;
                try {
                    st = ExportarAlimentos.this.conn.createStatement(1004, 1007);
                    ResultSet rs = st.executeQuery("select a.pac_codigo, a.pac_nome, a.pac_razaosocial, a.pac_cnpj, a.pac_ie, a.pac_endereco, a.pac_nomecontato, a.pac_fonecontato, a.pac_complemento, a.pac_cep, a.pac_fone, a.pac_email, a.pac_fax, a.pac_tipopessoa, b.cid_nome, b.cid_codigoibge, c.bai_descricao from paciente a left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo = b.cid_codigo left join bairro c on a.fil_codigo = c.fil_codigo and a.bai_codigo = c.bai_codigo where a.fil_codigo = 2 order by a.pac_codigo limit 10");
                    StringBuilder buf = new StringBuilder();
                    buf.append("codigo").append(";");
                    buf.append("razaosocial").append(";");
                    buf.append("fantasia").append(";");
                    buf.append("cnpj").append(";");
                    buf.append("IE").append(";");
                    buf.append("endereco").append(";");
                    buf.append("complemento").append(";");
                    buf.append("cep").append(";");
                    buf.append("cidade").append(";");
                    buf.append("ibge").append(";");
                    buf.append("fone").append(";");
                    buf.append("fax").append(";");
                    buf.append("contato").append(";");
                    buf.append("pessoa").append(";");
                    buf.append("email").append(";");
                    buf.append("\n");
                    while (rs.next()) {
                        buf.append(rs.getString("pac_codigo")).append(";");
                        buf.append(rs.getString("pac_razaosocial")).append(";");
                        buf.append(rs.getString("pac_nome")).append(";");
                        buf.append(rs.getString("pac_cnpj")).append(";");
                        buf.append(rs.getString("pac_ie")).append(";");
                        buf.append(rs.getString("pac_endereco")).append(";");
                        buf.append(rs.getString("pac_complemento")).append(";");
                        buf.append(rs.getString("pac_cep")).append(";");
                        buf.append(rs.getString("cid_nome")).append(";");
                        buf.append(rs.getString("cid_codigoibge")).append(";");
                        buf.append(rs.getString("pac_fone")).append(";");
                        buf.append(rs.getString("pac_fax")).append(";");
                        buf.append(rs.getString("pac_nomecontato")).append(";");
                        buf.append(rs.getString("pac_tipopessoa")).append(";");
                        buf.append(rs.getString("pac_email")).append(";");
                        buf.append("\n");
                    }
                    ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(0));
                    JFileChooser fileChooser = new JFileChooser();
                    if (fileChooser.showSaveDialog(ExportarAlimentos.this) == 0) {
                        File file = fileChooser.getSelectedFile();
                        ExportarAlimentos.escreverArquivoTexto(file.getAbsolutePath(), buf.toString());
                        JOptionPane.showMessageDialog(null, "Arquivo gerado", "Arquivo", -1);
                    }
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, "Erro ao conectar ao banco de dados, mensagem retornada: " + e2.getMessage(), "Erro", 0);
                }
                finally {
                    ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
        JButton buttonConvenio = new JButton("Conv\u00eanios");
        buttonConvenio.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(3));
                Statement st = null;
                try {
                    st = ExportarAlimentos.this.conn.createStatement(1004, 1007);
                    ResultSet rs = st.executeQuery("select a.con_codigo, a.con_fantasia, a.con_razao, a.con_cnpjcpf, a.con_cnpjintegralimposto, a.con_inscrest, a.con_endereco, a.con_contato, a.con_complemento, a.con_cep, a.con_fone, a.con_email1, a.con_fax, a.con_tipopessoa, b.cid_nome, b.cid_codigoibge, c.bai_descricao from convenios a left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo = b.cid_codigo left join bairro c on a.fil_codigo = c.fil_codigo and a.bai_codigo = c.bai_codigo where a.fil_codigo = 2 order by a.con_codigo limit 10");
                    StringBuilder buf = new StringBuilder();
                    buf.append("codigo").append(";");
                    buf.append("razaosocial").append(";");
                    buf.append("fantasia").append(";");
                    buf.append("cnpj").append(";");
                    buf.append("IE").append(";");
                    buf.append("endereco").append(";");
                    buf.append("complemento").append(";");
                    buf.append("cep").append(";");
                    buf.append("cidade").append(";");
                    buf.append("ibge").append(";");
                    buf.append("fone").append(";");
                    buf.append("fax").append(";");
                    buf.append("contato").append(";");
                    buf.append("pessoa").append(";");
                    buf.append("email").append(";");
                    buf.append("integrarcnpjimposto").append(";");
                    buf.append("\n");
                    while (rs.next()) {
                        buf.append(rs.getString("con_codigo")).append(";");
                        buf.append(rs.getString("con_razao")).append(";");
                        buf.append(rs.getString("con_fantasia")).append(";");
                        buf.append(rs.getString("con_cnpjcpf")).append(";");
                        buf.append(rs.getString("con_inscrest")).append(";");
                        buf.append(rs.getString("con_endereco")).append(";");
                        buf.append(rs.getString("con_complemento")).append(";");
                        buf.append(rs.getString("con_cep")).append(";");
                        buf.append(rs.getString("cid_nome")).append(";");
                        buf.append(rs.getString("cid_codigoibge")).append(";");
                        buf.append(rs.getString("con_fone")).append(";");
                        buf.append(rs.getString("con_fax")).append(";");
                        buf.append(rs.getString("con_contato")).append(";");
                        buf.append(rs.getString("con_tipopessoa")).append(";");
                        buf.append(rs.getString("con_email1")).append(";");
                        buf.append(rs.getString("con_cnpjintegralimposto")).append(";");
                        buf.append("\n");
                    }
                    ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(0));
                    JFileChooser fileChooser = new JFileChooser();
                    if (fileChooser.showSaveDialog(ExportarAlimentos.this) == 0) {
                        File file = fileChooser.getSelectedFile();
                        ExportarAlimentos.escreverArquivoTexto(file.getAbsolutePath(), buf.toString());
                        JOptionPane.showMessageDialog(null, "Arquivo gerado", "Arquivo", -1);
                    }
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, "Erro ao conectar ao banco de dados, mensagem retornada: " + e2.getMessage(), "Erro", 0);
                }
                finally {
                    ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
        JButton buttonFornecedor = new JButton("Fornecedores");
        buttonFornecedor.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(3));
                Statement st = null;
                try {
                    st = ExportarAlimentos.this.conn.createStatement(1004, 1007);
                    ResultSet rs = st.executeQuery("select a.ent_codigo, a.ent_fantasia, a.ent_razaosocial, a.ent_cpfcnpj, a.ent_rgie, a.ent_endereco, a.ent_nomecontato, a.ent_complemento, a.ent_cep, a.ent_fone, a.ent_email, a.ent_fax, a.ent_tipopessoa, b.cid_nome, b.cid_codigoibge, c.bai_descricao from entidade a left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo = b.cid_codigo left join bairro c on a.fil_codigo = c.fil_codigo and a.bai_codigo = c.bai_codigo where a.fil_codigo = 2 and a.ent_tipo = 'F' order by a.ent_codigo limit 10");
                    StringBuilder buf = new StringBuilder();
                    buf.append("codigo").append(";");
                    buf.append("razaosocial").append(";");
                    buf.append("fantasia").append(";");
                    buf.append("cnpj").append(";");
                    buf.append("IE").append(";");
                    buf.append("endereco").append(";");
                    buf.append("complemento").append(";");
                    buf.append("cep").append(";");
                    buf.append("cidade").append(";");
                    buf.append("ibge").append(";");
                    buf.append("fone").append(";");
                    buf.append("fax").append(";");
                    buf.append("contato").append(";");
                    buf.append("pessoa").append(";");
                    buf.append("email").append(";");
                    buf.append("\n");
                    while (rs.next()) {
                        buf.append(rs.getString("ent_codigo")).append(";");
                        buf.append(rs.getString("ent_razaosocial")).append(";");
                        buf.append(rs.getString("ent_fantasia")).append(";");
                        buf.append(rs.getString("ent_cpfcnpj")).append(";");
                        buf.append(rs.getString("ent_rgie")).append(";");
                        buf.append(rs.getString("ent_endereco")).append(";");
                        buf.append(rs.getString("ent_complemento")).append(";");
                        buf.append(rs.getString("ent_cep")).append(";");
                        buf.append(rs.getString("cid_nome")).append(";");
                        buf.append(rs.getString("cid_codigoibge")).append(";");
                        buf.append(rs.getString("ent_fone")).append(";");
                        buf.append(rs.getString("ent_fax")).append(";");
                        buf.append(rs.getString("ent_nomecontato")).append(";");
                        buf.append(rs.getString("ent_tipopessoa")).append(";");
                        buf.append(rs.getString("ent_email")).append(";");
                        buf.append("\n");
                    }
                    ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(0));
                    JFileChooser fileChooser = new JFileChooser();
                    if (fileChooser.showSaveDialog(ExportarAlimentos.this) == 0) {
                        File file = fileChooser.getSelectedFile();
                        ExportarAlimentos.escreverArquivoTexto(file.getAbsolutePath(), buf.toString());
                        JOptionPane.showMessageDialog(null, "Arquivo gerado", "Arquivo", -1);
                    }
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, "Erro ao conectar ao banco de dados, mensagem retornada: " + e2.getMessage(), "Erro", 0);
                }
                finally {
                    ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
        JButton buttonMaterial = new JButton("Materiais");
        buttonMaterial.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(3));
                Statement st = null;
                try {
                    st = ExportarAlimentos.this.conn.createStatement(1004, 1007);
                    ResultSet rs = st.executeQuery("select a.mat_codigo, a.mat_descricao, coalesce(a.mat_modelo, '') as mat_modelo, coalesce(a.mat_imobilizado, false) as mat_imobilizado, coalesce(a.mat_marca, '') as mat_marca, a.unm_codigo from material a where a.mat_inativo is null or a.mat_inativo = false order by mat_codigo limit 10");
                    StringBuilder buf = new StringBuilder();
                    buf.append("codigo").append(";");
                    buf.append("descricao").append(";");
                    buf.append("marca").append(";");
                    buf.append("modelo").append(";");
                    buf.append("imobilizado").append(";");
                    buf.append("unidade").append(";");
                    buf.append("\n");
                    while (rs.next()) {
                        buf.append(rs.getString("mat_codigo")).append(";");
                        buf.append(rs.getString("mat_descricao")).append(";");
                        buf.append(rs.getString("mat_marca")).append(";");
                        buf.append(rs.getString("mat_modelo")).append(";");
                        buf.append(rs.getString("mat_imobilizado")).append(";");
                        buf.append(rs.getString("unm_codigo")).append(";");
                        buf.append("\n");
                    }
                    ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(0));
                    JFileChooser fileChooser = new JFileChooser();
                    if (fileChooser.showSaveDialog(ExportarAlimentos.this) == 0) {
                        File file = fileChooser.getSelectedFile();
                        ExportarAlimentos.escreverArquivoTexto(file.getAbsolutePath(), buf.toString());
                        JOptionPane.showMessageDialog(null, "Arquivo gerado", "Arquivo", -1);
                    }
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, "Erro ao conectar ao banco de dados, mensagem retornada: " + e2.getMessage(), "Erro", 0);
                }
                finally {
                    ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
        JButton buttonSaldoMaterial = new JButton("Saldo de Materiais");
        buttonSaldoMaterial.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(3));
                Statement st = null;
                try {
                    st = ExportarAlimentos.this.conn.createStatement(1004, 1007);
                    ResultSet rs = st.executeQuery("select a.mat_codigo, a.mat_descricao, b.sde_data, coalesce(b.sde_saldo, 0) as sde_saldo from saldoestoque b left join material a on b.fil_codigo = a.fil_codigo and b.mat_codigo = a.mat_codigo where a.mat_inativo is null or a.mat_inativo = false order by a.mat_codigo, b.sde_data limit 10");
                    StringBuilder buf = new StringBuilder();
                    buf.append("material").append(";");
                    buf.append("data").append(";");
                    buf.append("saldo").append(";");
                    buf.append("\n");
                    while (rs.next()) {
                        buf.append(rs.getString("mat_codigo")).append(";");
                        buf.append(ExportarAlimentos.formataData("dd/MM/yyyy", rs.getDate("sde_data"))).append(";");
                        buf.append(ExportarAlimentos.formataDecimal("0.0000", rs.getDouble("sde_saldo"))).append(";");
                        buf.append("\n");
                    }
                    ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(0));
                    JFileChooser fileChooser = new JFileChooser();
                    if (fileChooser.showSaveDialog(ExportarAlimentos.this) == 0) {
                        File file = fileChooser.getSelectedFile();
                        ExportarAlimentos.escreverArquivoTexto(file.getAbsolutePath(), buf.toString());
                        JOptionPane.showMessageDialog(null, "Arquivo gerado", "Arquivo", -1);
                    }
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, "Erro ao conectar ao banco de dados, mensagem retornada: " + e2.getMessage(), "Erro", 0);
                }
                finally {
                    ExportarAlimentos.this.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
        this.getContentPane().setLayout(new FlowLayout(2));
        this.getContentPane().add(buttonCliente);
        this.getContentPane().add(buttonConvenio);
        this.getContentPane().add(buttonFornecedor);
        this.getContentPane().add(buttonMaterial);
        this.getContentPane().add(buttonSaldoMaterial);
        this.getContentPane().add(buttonFechar);
    }

    private void finalizar() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    public static boolean escreverArquivoTexto(String nomeArquivo, String texto) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(nomeArquivo, false));
            out.write(texto);
            out.close();
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Erro ao gravar o arquivo: " + e.getMessage(), "Erro", 0);
            return false;
        }
    }

    private static String formataData(String modelo, Date data) {
        if (data == null) {
            return "";
        }
        SimpleDateFormat meuFormato = new SimpleDateFormat(modelo);
        return meuFormato.format(data);
    }

    public static String formataDecimal(String modelo, double valor) {
        DecimalFormat meuFormato = new DecimalFormat(modelo);
        return meuFormato.format(valor);
    }
}

