/*
 * Decompiled with CFR 0.152.
 */
package jalis.testes;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ConexaoWeb;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.thread.CamposWeb;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ExportaTudoWeb {
    private static ConexaoWeb conexaoWeb;

    private static void mostraMensagem(String s) {
        System.out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        conexaoWeb = new ConexaoWeb();
        String ip = "192.168.1.2";
        if (args.length > 0) {
            ip = args[0];
        }
        System.out.println("Conectando no servidor no ip: " + ip);
        Variaveis.caminhoBanco = "jdbc:postgresql://" + ip + "/jalis";
        Variaveis.filialPadrao = "1";
        Statement stTemporario = ConexaoTemporaria.getStatement();
        Statement stUpdate = ConexaoTemporaria.getStatement();
        Statement stWeb = conexaoWeb.getStatement();
        int registros = 0;
        boolean parar = false;
        while (!parar) {
            String operacao = "";
            String codigo = "";
            try {
                System.out.println("Buscando...");
                ResultSet rs = stTemporario.executeQuery(ExportaTudoWeb.getSelect());
                System.out.print("query ok...\n");
                registros = DBUtil.qtdeRegistros(rs);
                int contador = 1;
                if (registros == 0) {
                    System.out.println("N\u00e3o h\u00e1 dados para enviar, aguardando");
                    for (int ix = 0; ix < 1000; ix += 10) {
                        System.out.print(".");
                    }
                    System.out.println("\n");
                    continue;
                }
                ExportaTudoWeb.mostraMensagem("Conectando na base web");
                if (!conexaoWeb.getConnected()) {
                    ExportaTudoWeb.mostraMensagem("erro ao conectar");
                    return;
                }
                try {
                    while (rs.next() && !parar) {
                        codigo = rs.getString("ewe_codigo");
                        operacao = ExportaTudoWeb.criaComando(stWeb, rs.getString("ewe_operacao"), rs.getString("ewe_tipooperacao"));
                        if (!Funcoes.textoVazio(operacao)) {
                            conexaoWeb.executeUpdate(stWeb, operacao);
                        }
                        ExportaTudoWeb.marcaExportado(stUpdate, rs.getString("fil_codigo"), rs.getString("ewe_codigo"));
                        System.out.print("\rEnviando: " + String.valueOf(contador++) + " de " + String.valueOf(registros) + "            ");
                    }
                    ExportaTudoWeb.mostraMensagem("\nArquivando dados");
                    conexaoWeb.arquivaSQL();
                    ConexaoTemporaria.arquivaSQL();
                    ExportaTudoWeb.mostraMensagem("\nDados arquivados na web");
                }
                catch (SQLException ex) {
                    try {
                        conexaoWeb.anulaSQL();
                        ConexaoTemporaria.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ex.printStackTrace();
                    System.out.println(codigo + ">>>>>>>>>>>>>" + operacao);
                    parar = true;
                }
                finally {
                    ExportaTudoWeb.mostraMensagem("Finalizando conex\u00e3o com web");
                }
                System.out.println("Limpando");
                System.gc();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            conexaoWeb.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        conexaoWeb.shutdown();
    }

    private static String getSelect() {
        StringBuilder tmp = new StringBuilder("select fil_codigo, ewe_codigo, ewe_datahora, ewe_operacao, ewe_tipooperacao ");
        tmp.append("from exportaweb where ");
        tmp.append(" ewe_exportado = false or ewe_exportado is null order by ");
        tmp.append("ewe_datahora");
        tmp.append(" limit 50 ");
        return tmp.toString();
    }

    private static String criaComando(Statement st, String op, String tipo) throws SQLException {
        String tmp = StringUtil.getValor(op, "configuracao");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaConfiguracao(op);
        }
        tmp = StringUtil.getValor(op, "convenios");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaConvenio(st, op, tipo);
        }
        tmp = StringUtil.getValor(op, "medicos");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaMedico(st, op, tipo);
        }
        tmp = StringUtil.getValor(op, "exames");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaExame(st, op, tipo);
        }
        tmp = StringUtil.getValor(op, "requisicao");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaRequisicao(st, op, tipo);
        }
        tmp = StringUtil.getValor(op, "requisicaoexame");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaRequisicaoExame(st, op, tipo);
        }
        tmp = StringUtil.getValor(op, "requisicaoexameimagem");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaRequisicaoExameImagem(st, op, tipo);
        }
        tmp = StringUtil.getValor(op, "paciente");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaPaciente(st, op, tipo);
        }
        tmp = StringUtil.getValor(op, "entidade");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaEntidade(st, op, tipo);
        }
        tmp = StringUtil.getValor(op, "pacienteentidade");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaPacienteEntidade(st, op, tipo);
        }
        tmp = StringUtil.getValor(op, "mensagensconvenio");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaMensagem(st, op, tipo);
        }
        tmp = StringUtil.getValor(op, "destinos");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaDestino(st, op, tipo);
        }
        tmp = StringUtil.getValor(op, "medicosexames");
        if (!Funcoes.textoVazio(tmp)) {
            return ExportaTudoWeb.montaMedicoExame(st, op, tipo);
        }
        return "";
    }

    private static String montaConfiguracao(String c) {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        return ExportaTudoWeb.montaUpdate("configuracao", a);
    }

    private static String montaConvenio(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals("I")) {
            buf.append(ExportaTudoWeb.montaSelect("convenios", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaTudoWeb.montaInsert("convenios", a));
            }
            rs.close();
        } else if (tipo.equals("A")) {
            buf.append(ExportaTudoWeb.montaUpdate("convenios", a));
        } else {
            buf.append(ExportaTudoWeb.montaDelete("convenios", a));
        }
        return buf.toString();
    }

    private static String montaPaciente(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals("I")) {
            buf.append(ExportaTudoWeb.montaSelect("paciente", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaTudoWeb.montaInsert("paciente", a));
            }
            rs.close();
        } else if (tipo.equals("A")) {
            buf.append(ExportaTudoWeb.montaUpdate("paciente", a));
        } else {
            buf.append(ExportaTudoWeb.montaDelete("paciente", a));
        }
        return buf.toString();
    }

    private static String montaEntidade(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals("I")) {
            buf.append(ExportaTudoWeb.montaSelect("entidade", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaTudoWeb.montaInsert("entidade", a));
            }
            rs.close();
        } else if (tipo.equals("A")) {
            buf.append(ExportaTudoWeb.montaUpdate("entidade", a));
        } else {
            buf.append(ExportaTudoWeb.montaDelete("entidade", a));
        }
        return buf.toString();
    }

    private static String montaPacienteEntidade(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals("I")) {
            buf.append(ExportaTudoWeb.montaSelect("pacienteentidade", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaTudoWeb.montaInsert("pacienteentidade", a));
            }
            rs.close();
        } else if (tipo.equals("A")) {
            buf.append(ExportaTudoWeb.montaUpdate("pacienteentidade", a));
        } else {
            buf.append(ExportaTudoWeb.montaDelete("pacienteentidade", a));
        }
        return buf.toString();
    }

    private static String montaMensagem(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals("I")) {
            buf.append(ExportaTudoWeb.montaSelect("mensagensconvenio", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaTudoWeb.montaInsert("mensagensconvenio", a));
            }
            rs.close();
        } else if (tipo.equals("D")) {
            buf.append(ExportaTudoWeb.montaDelete("mensagensconvenio", a));
        } else {
            return "";
        }
        return buf.toString();
    }

    private static String montaDestino(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals("I")) {
            buf.append(ExportaTudoWeb.montaSelect("destinos", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaTudoWeb.montaInsert("destinos", a));
            }
            rs.close();
        } else if (tipo.equals("A")) {
            buf.append(ExportaTudoWeb.montaUpdate("destinos", a));
        } else {
            buf.append(ExportaTudoWeb.montaDelete("destinos", a));
        }
        return buf.toString();
    }

    private static String montaMedico(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals("I")) {
            buf.append(ExportaTudoWeb.montaSelect("medicos", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaTudoWeb.montaInsert("medicos", a));
            }
            rs.close();
        } else if (tipo.equals("A")) {
            buf.append(ExportaTudoWeb.montaUpdate("medicos", a));
        } else {
            buf.append(ExportaTudoWeb.montaDelete("medicos", a));
        }
        return buf.toString();
    }

    private static String montaMedicoExame(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals("I")) {
            buf.append(ExportaTudoWeb.montaSelect("medicosexames", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaTudoWeb.montaInsert("medicosexames", a));
            }
            rs.close();
        } else if (tipo.equals("A")) {
            buf.append(ExportaTudoWeb.montaUpdate("medicosexames", a));
        } else {
            buf.append(ExportaTudoWeb.montaDelete("medicosexames", a));
        }
        return buf.toString();
    }

    private static String montaExame(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals("I")) {
            buf.append(ExportaTudoWeb.montaSelect("exames", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaTudoWeb.montaInsert("exames", a));
            }
            rs.close();
        } else if (tipo.equals("A")) {
            buf.append(ExportaTudoWeb.montaUpdate("exames", a));
        } else {
            buf.append(ExportaTudoWeb.montaDelete("exames", a));
        }
        return buf.toString();
    }

    private static String montaRequisicao(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals("I")) {
            buf.append(ExportaTudoWeb.montaSelect("requisicao", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaTudoWeb.montaInsert("requisicao", a));
            } else {
                buf.append(ExportaTudoWeb.montaUpdate("requisicao", a));
            }
            rs.close();
        } else if (tipo.equals("A")) {
            buf.append(ExportaTudoWeb.montaUpdate("requisicao", a));
        } else {
            buf.append(ExportaTudoWeb.montaDelete("requisicao", a));
        }
        return buf.toString();
    }

    private static String montaRequisicaoExame(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals("I")) {
            buf.append(ExportaTudoWeb.montaSelect("requisicaoexame", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaTudoWeb.montaInsert("requisicaoexame", a));
            } else {
                buf.append(ExportaTudoWeb.montaUpdate("requisicaoexame", a));
            }
            rs.close();
        } else if (tipo.equals("A")) {
            buf.append(ExportaTudoWeb.montaUpdate("requisicaoexame", a));
        } else {
            buf.append(ExportaTudoWeb.montaDelete("requisicaoexame", a));
        }
        return buf.toString();
    }

    private static String montaRequisicaoExameImagem(Statement st, String c, String tipo) throws SQLException {
        ArrayList a = ExportaTudoWeb.parseXml(c);
        StringBuilder buf = new StringBuilder();
        if (tipo.equals("I")) {
            buf.append(ExportaTudoWeb.montaSelect("requisicaoexameimagem", a));
            ResultSet rs = conexaoWeb.executeQuery(st, buf.toString());
            buf.delete(0, buf.length());
            if (!rs.next()) {
                buf.append(ExportaTudoWeb.montaInsert("requisicaoexameimagem", a));
            } else {
                buf.append(ExportaTudoWeb.montaUpdate("requisicaoexameimagem", a));
            }
            rs.close();
        } else if (tipo.equals("A")) {
            buf.append(ExportaTudoWeb.montaUpdate("requisicaoexameimagem", a));
        } else {
            buf.append(ExportaTudoWeb.montaDelete("requisicaoexameimagem", a));
        }
        return buf.toString();
    }

    private static String montaInsert(String tabela, ArrayList<String> a) {
        StringBuilder campos = new StringBuilder();
        StringBuilder valores = new StringBuilder("");
        if (!a.contains("codigoImagemExame") && tabela.equalsIgnoreCase("requisicaoexameimagem")) {
            return "";
        }
        for (int i = 0; i < a.size(); i += 2) {
            CamposWeb campo = (CamposWeb)ExportaWeb.CAMPOS.get(a.get(i));
            campos.append(campo.getNomeCampo());
            if (i < a.size() - 2) {
                campos.append(", ");
            }
            if (campo.getTipoCampo() == 2) {
                valores.append(a.get(i + 1).toString());
            } else if (campo.getTipoCampo() == 3) {
                if (a.get(i + 1) == null || Funcoes.textoVazio(a.get(i + 1).toString())) {
                    valores.append("null");
                } else {
                    valores.append(Funcoes.limpaDecimal(a.get(i + 1).toString()));
                }
            } else if (campo.getTipoCampo() == 1) {
                valores.append("'");
                if (campo.getNomeCampo().equalsIgnoreCase("usr_assinatura") && a.get(i + 1).toString().length() > 20) {
                    valores.append(StringUtil.textoDB(a.get(i + 1).toString().substring(0, 20)));
                } else {
                    valores.append(StringUtil.textoDB(a.get(i + 1).toString()));
                }
                valores.append("'");
            } else if (campo.getTipoCampo() == 4) {
                if (Funcoes.verificaData(a.get(i + 1).toString())) {
                    valores.append("'");
                    valores.append(Funcoes.formataData("MM/dd/yyyy", a.get(i + 1).toString()));
                    valores.append("'");
                } else {
                    valores.append("null");
                }
            } else if (campo.getTipoCampo() == 5) {
                if (Funcoes.verificaHora(a.get(i + 1).toString())) {
                    valores.append("'");
                    valores.append(a.get(i + 1).toString());
                    valores.append("'");
                } else {
                    valores.append("null");
                }
            } else if (campo.getTipoCampo() == 6) {
                if (!Funcoes.textoVazio(a.get(i + 1).toString()) && (a.get(i + 1).toString().equalsIgnoreCase("S") || a.get(i + 1).toString().equalsIgnoreCase("TRUE") || a.get(i + 1).toString().equalsIgnoreCase("SIM"))) {
                    valores.append("true");
                } else {
                    valores.append("false");
                }
            }
            if (i >= a.size() - 2) continue;
            valores.append(", ");
        }
        StringBuilder retorno = new StringBuilder("insert into ");
        retorno.append(tabela);
        retorno.append(" (");
        retorno.append((CharSequence)campos);
        retorno.append(") values (");
        retorno.append((CharSequence)valores);
        retorno.append(")");
        return retorno.toString();
    }

    private static String montaUpdate(String tabela, ArrayList a) {
        StringBuilder pk = new StringBuilder();
        StringBuilder valores = new StringBuilder("");
        for (int i = 0; i < a.size(); i += 2) {
            CamposWeb campo = (CamposWeb)ExportaWeb.CAMPOS.get(a.get(i));
            if (campo.getPK() && !campo.getForcarUpdate()) {
                if (pk.length() > 0) {
                    pk.append(" and ");
                }
                pk.append(ExportaTudoWeb.montaCampoUpdate(campo, a.get(i + 1).toString()));
                continue;
            }
            if (valores.length() > 0) {
                valores.append(", ");
            }
            if (campo.getNomeCampo().equalsIgnoreCase("usr_assinatura") && a.get(i + 1).toString().length() > 20) {
                valores.append(ExportaTudoWeb.montaCampoUpdate(campo, a.get(i + 1).toString().substring(0, 20)));
                continue;
            }
            valores.append(ExportaTudoWeb.montaCampoUpdate(campo, a.get(i + 1).toString()));
        }
        StringBuilder retorno = new StringBuilder("update ");
        retorno.append(tabela);
        retorno.append(" set ");
        retorno.append((CharSequence)valores);
        retorno.append(" where ");
        retorno.append((CharSequence)pk);
        return retorno.toString();
    }

    private static String montaDelete(String tabela, ArrayList a) {
        StringBuilder pk = new StringBuilder();
        for (int i = 0; i < a.size(); i += 2) {
            CamposWeb campo = (CamposWeb)ExportaWeb.CAMPOS.get(a.get(i));
            if (!campo.getPK()) continue;
            if (pk.length() > 0) {
                pk.append(" and ");
            }
            pk.append(ExportaTudoWeb.montaCampoUpdate(campo, a.get(i + 1).toString()));
        }
        StringBuilder retorno = new StringBuilder("delete from ");
        retorno.append(tabela);
        retorno.append(" where ");
        retorno.append((CharSequence)pk);
        return retorno.toString();
    }

    private static String montaSelect(String tabela, ArrayList a) {
        StringBuilder pk = new StringBuilder();
        for (int i = 0; i < a.size(); i += 2) {
            CamposWeb campo = (CamposWeb)ExportaWeb.CAMPOS.get(a.get(i));
            if (!campo.getPK()) continue;
            if (tabela.equals("requisicao") && campo.getNomeCampo().equals("pac_codigo")) {
                pk.append("");
                continue;
            }
            if (pk.length() > 0) {
                pk.append(" and ");
            }
            pk.append(ExportaTudoWeb.montaCampoUpdate(campo, a.get(i + 1).toString()));
        }
        StringBuilder retorno = new StringBuilder("select 1 from ");
        retorno.append(tabela);
        retorno.append(" where ");
        retorno.append((CharSequence)pk);
        return retorno.toString();
    }

    private static String montaCampoUpdate(CamposWeb campo, String valor) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(campo.getNomeCampo());
        if (!(valor.equalsIgnoreCase("is not null") || valor.equalsIgnoreCase("is null") || valor.trim().startsWith(">"))) {
            tmp.append(" = ");
        } else {
            tmp.append(" ");
        }
        if (campo.getTipoCampo() == 2) {
            tmp.append(Funcoes.textoVazio(valor) ? "null" : valor);
        } else if (campo.getTipoCampo() == 3) {
            tmp.append(Funcoes.textoVazio(valor) ? "null" : Funcoes.limpaDecimal(valor));
        } else if (campo.getTipoCampo() == 1) {
            tmp.append("'");
            tmp.append(valor);
            tmp.append("'");
        } else if (campo.getTipoCampo() == 4) {
            if (Funcoes.verificaData(valor)) {
                tmp.append("'");
                tmp.append(Funcoes.formataData("MM/dd/yyyy", valor));
                tmp.append("'");
            } else {
                tmp.append("null");
            }
        } else if (campo.getTipoCampo() == 5) {
            if (Funcoes.verificaHora(valor)) {
                tmp.append("'");
                tmp.append(valor);
                tmp.append("'");
            } else {
                tmp.append("null");
            }
        } else if (campo.getTipoCampo() == 6) {
            if (!Funcoes.textoVazio(valor) && (valor.equalsIgnoreCase("S") || valor.equalsIgnoreCase("TRUE") || valor.equalsIgnoreCase("SIM"))) {
                tmp.append("true");
            } else {
                tmp.append("false");
            }
        }
        return tmp.toString();
    }

    private static void marcaExportado(Statement st, String filial, String codigo) throws SQLException {
        StringBuilder buf = new StringBuilder("update exportaweb set ewe_exportado = true where fil_codigo = ");
        buf.append(filial);
        buf.append(" and ewe_codigo = ");
        buf.append(codigo);
        Conexao.executeUpdate(filial, st, buf.toString(), true);
    }

    private static ArrayList parseXml(String xml) {
        ArrayList a = new ArrayList();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder db = factory.newDocumentBuilder();
            StringBuilder buf = new StringBuilder();
            buf.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
            buf.append("<!--DTD-->");
            buf.append("<!DOCTYPE my_file [");
            buf.append("<!ELEMENT my_file (text)>");
            buf.append("<!ELEMENT text (#PCDATA)>");
            buf.append("<!--Entity declarations-->");
            buf.append("<!ENTITY exm \"&amp;exm\">");
            buf.append("<!ENTITY mat \"&amp;mat\">");
            buf.append("<!ENTITY img \"&amp;img\">");
            buf.append("<!ENTITY iexcl \"\u00a1\">");
            buf.append("<!ENTITY cent \"\u00a2\">");
            buf.append("<!ENTITY pound \"\u00a3\">");
            buf.append("<!ENTITY curren \"\u00a4\">");
            buf.append("<!ENTITY yen \"\u00a5\">");
            buf.append("<!ENTITY brvbar \"\u00a6\">");
            buf.append("<!ENTITY sect \"\u00a7\">");
            buf.append("<!ENTITY uml \"\u00a8\">");
            buf.append("<!ENTITY copy \"\u00a9\">");
            buf.append("<!ENTITY ordf \"\u00aa\">");
            buf.append("<!ENTITY laquo \"\u00ab\">");
            buf.append("<!ENTITY not \"\u00ac\">");
            buf.append("<!ENTITY shy \"\u00ad\">");
            buf.append("<!ENTITY reg \"\u00ae\">");
            buf.append("<!ENTITY macr \"\u00af\">");
            buf.append("<!ENTITY deg \"\u00b0\">");
            buf.append("<!ENTITY plusmn \"\u00b1\">");
            buf.append("<!ENTITY sup2 \"\u00b2\">");
            buf.append("<!ENTITY sup3 \"\u00b3\">");
            buf.append("<!ENTITY acute \"\u00b4\">");
            buf.append("<!ENTITY micro \"\u00b5\">");
            buf.append("<!ENTITY para \"\u00b6\">");
            buf.append("<!ENTITY middot \"\u00b7\">");
            buf.append("<!ENTITY cedil \"\u00b8\">");
            buf.append("<!ENTITY sup1 \"\u00b9\">");
            buf.append("<!ENTITY ordm \"\u00ba\">");
            buf.append("<!ENTITY raquo \"\u00bb\">");
            buf.append("<!ENTITY frac14 \"\u00bc\">");
            buf.append("<!ENTITY frac12 \"\u00bd\">");
            buf.append("<!ENTITY frac34 \"\u00be\">");
            buf.append("<!ENTITY iquest \"\u00bf\">");
            buf.append("<!ENTITY Agrave \"\u00c0\">");
            buf.append("<!ENTITY Aacute \"\u00c1\">");
            buf.append("<!ENTITY Acirc \"\u00c2\">");
            buf.append("<!ENTITY Atilde \"\u00c3\">");
            buf.append("<!ENTITY Auml \"\u00c4\">");
            buf.append("<!ENTITY Aring \"\u00c5\">");
            buf.append("<!ENTITY AElig \"\u00c6\">");
            buf.append("<!ENTITY Ccedil \"\u00c7\">");
            buf.append("<!ENTITY Egrave \"\u00c8\">");
            buf.append("<!ENTITY Eacute \"\u00c9\">");
            buf.append("<!ENTITY Ecirc \"\u00ca\">");
            buf.append("<!ENTITY Euml \"\u00cb\">");
            buf.append("<!ENTITY Igrave \"\u00cc\">");
            buf.append("<!ENTITY Iacute \"\u00cd\">");
            buf.append("<!ENTITY Icirc \"\u00ce\">");
            buf.append("<!ENTITY Iuml \"\u00cf\">");
            buf.append("<!ENTITY ETH \"\u00d0\">");
            buf.append("<!ENTITY Ntilde \"\u00d1\">");
            buf.append("<!ENTITY Ograve \"\u00d2\">");
            buf.append("<!ENTITY Oacute \"\u00d3\">");
            buf.append("<!ENTITY Ocirc \"\u00d4\">");
            buf.append("<!ENTITY Otilde \"\u00d5\">");
            buf.append("<!ENTITY Ouml \"\u00d6\">");
            buf.append("<!ENTITY times \"\u00d7\">");
            buf.append("<!ENTITY Oslash \"\u00d8\">");
            buf.append("<!ENTITY Ugrave \"\u00d9\">");
            buf.append("<!ENTITY Uacute \"\u00da\">");
            buf.append("<!ENTITY Ucirc \"\u00db\">");
            buf.append("<!ENTITY Uuml \"\u00dc\">");
            buf.append("<!ENTITY Yacute \"\u00dd\">");
            buf.append("<!ENTITY THORN \"\u00de\">");
            buf.append("<!ENTITY szlig \"\u00df\">");
            buf.append("<!ENTITY agrave \"\u00e0\">");
            buf.append("<!ENTITY aacute \"\u00e1\">");
            buf.append("<!ENTITY acirc \"\u00e2\">");
            buf.append("<!ENTITY atilde \"\u00e3\">");
            buf.append("<!ENTITY auml \"\u00e4\">");
            buf.append("<!ENTITY aring \"\u00e5\">");
            buf.append("<!ENTITY aelig \"\u00e6\">");
            buf.append("<!ENTITY ccedil \"\u00e7\">");
            buf.append("<!ENTITY egrave \"\u00e8\">");
            buf.append("<!ENTITY eacute \"\u00e9\">");
            buf.append("<!ENTITY ecirc \"\u00ea\">");
            buf.append("<!ENTITY euml \"\u00eb\">");
            buf.append("<!ENTITY igrave \"\u00ec\">");
            buf.append("<!ENTITY iacute \"\u00ed\">");
            buf.append("<!ENTITY icirc \"\u00ee\">");
            buf.append("<!ENTITY iuml \"\u00ef\">");
            buf.append("<!ENTITY eth \"\u00f0\">");
            buf.append("<!ENTITY ntilde \"\u00f1\">");
            buf.append("<!ENTITY ograve \"\u00f2\">");
            buf.append("<!ENTITY oacute \"\u00f3\">");
            buf.append("<!ENTITY ocirc \"\u00f4\">");
            buf.append("<!ENTITY otilde \"\u00f5\">");
            buf.append("<!ENTITY ouml \"\u00f6\">");
            buf.append("<!ENTITY divide \"\u00f7\">");
            buf.append("<!ENTITY oslash \"\u00f8\">");
            buf.append("<!ENTITY ugrave \"\u00f9\">");
            buf.append("<!ENTITY uacute \"\u00fa\">");
            buf.append("<!ENTITY ucirc \"\u00fb\">");
            buf.append("<!ENTITY uuml \"\u00fc\">");
            buf.append("<!ENTITY yacute \"\u00fd\">");
            buf.append("<!ENTITY thorn \"\u00fe\">");
            buf.append("<!ENTITY yuml \"\u00ff\">");
            buf.append("]>");
            buf.append(xml.replaceAll("&exm=", "&exm;=").replaceAll("&mat=", "&mat;=").replaceAll("&img=", "&img;="));
            Document doc = db.parse(new InputSource(new StringReader(buf.toString())));
            NodeList list = doc.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                ExportaTudoWeb.trataNodeChild(node, a);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportaWeb (1118)");
        }
        return a;
    }

    private static void trataNodeChild(Node node, ArrayList a) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node no = list.item(i);
            a.add(no.getNodeName());
            a.add(no.getTextContent());
        }
    }
}

