/*
 * Decompiled with CFR 0.152.
 */
package jalis.servidor;

import jalis.servidor.Mensagem;
import jalis.servidor.Servidor;
import jalis.servidor.SocketEstacaoListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Random;
import javax.swing.event.EventListenerList;

public class SocketEstacao {
    private static final boolean DEBUG = false;
    private String ip;
    private String estacao;
    private String usuario;
    private String versaoJalis;
    private String versaoJava;
    private String descricaoEstacao;
    private String codigo;
    private String oid;
    private String filial;
    private long tempo;
    private boolean conectado;
    private boolean lerEntrada;
    private Socket socket;
    private DataInputStream entrada;
    private DataOutputStream saida;
    private Long chave;
    private EventListenerList ouvintes = new EventListenerList();
    private boolean bloqueado = false;

    public SocketEstacao(String ipServidor, long tempoEspera) throws UnknownHostException, IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(Integer.parseInt("" + tempoEspera));
        socket.connect(new InetSocketAddress(ipServidor, Servidor.getPorta()));
        this.iniciar(socket, tempoEspera);
    }

    SocketEstacao(Socket socket, long tempoEspera) {
        this.iniciar(socket, tempoEspera);
    }

    public void addSocketEstacaoListener(SocketEstacaoListener ouvinte) {
        this.ouvintes.add(SocketEstacaoListener.class, ouvinte);
    }

    void removeSocketEstacaoListener(SocketEstacaoListener ouvinte) {
        this.ouvintes.remove(SocketEstacaoListener.class, ouvinte);
    }

    public void setLerEntrada(boolean ler) {
        this.lerEntrada = ler;
    }

    boolean conectado() {
        return this.conectado;
    }

    String enderecoIP() {
        return this.ip;
    }

    public String getUsuario() {
        return this.usuario;
    }

    String getChave() {
        return String.valueOf(this.chave);
    }

    public void setChave(String chave) {
        try {
            this.chave = Long.parseLong(chave);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDescricaoEstacao() {
        return this.descricaoEstacao;
    }

    public void setDescricaoEstacao(String descricaoEstacao) {
        this.descricaoEstacao = descricaoEstacao;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario == null ? "" : usuario;
    }

    boolean mesmoUsuario(String usuario) {
        return usuario == null ? false : this.usuario.equals(usuario);
    }

    public String getEstacao() {
        return this.estacao;
    }

    void setEstacao(String estacao) {
        this.estacao = estacao == null ? "" : estacao;
    }

    boolean estacaoDefinida() {
        return this.estacao.trim().length() > 0;
    }

    boolean usuarioDefinido() {
        return this.usuario.trim().length() > 0;
    }

    String getVersaoJalis() {
        return this.versaoJalis;
    }

    void setVersaoJalis(String versaoJalis) {
        this.versaoJalis = versaoJalis == null ? "" : versaoJalis;
    }

    String getVersaoJava() {
        return this.versaoJava;
    }

    void setVersaoJava(String versaoJava) {
        this.versaoJava = versaoJava == null ? "" : versaoJava;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    String getOID() {
        return this.oid;
    }

    void setOID(String oid) {
        this.oid = oid;
    }

    String getFilial() {
        return this.filial;
    }

    void setFilial(String filial) {
        this.filial = filial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fechar() {
        try {
            this.lerEntrada = false;
            this.conectado = false;
            this.entrada.close();
            DataOutputStream dataOutputStream = this.saida;
            synchronized (dataOutputStream) {
                this.saida.close();
            }
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void escreverMensagem(Mensagem msn) {
        if (this.conectado) {
            try {
                DataOutputStream dataOutputStream = this.saida;
                synchronized (dataOutputStream) {
                    this.saida.writeUTF(msn.toString());
                    this.saida.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Mensagem lerMensagem() {
        if (this.conectado) {
            try {
                String str = this.entrada.readUTF();
                while (!Mensagem.validarPadrao(str)) {
                    str = this.entrada.readUTF();
                }
                return Mensagem.parse(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Mensagem(null);
    }

    private void iniciar(Socket socket, long tempoEspera) {
        if (socket != null) {
            try {
                this.socket = socket;
                this.ip = socket.getRemoteSocketAddress().toString();
                this.estacao = "";
                this.usuario = "";
                this.descricaoEstacao = "";
                this.tempo = tempoEspera;
                this.entrada = new DataInputStream(socket.getInputStream());
                this.saida = new DataOutputStream(socket.getOutputStream());
                this.conectado = true;
                Random r = new Random();
                this.chave = r.nextLong();
                new Thread(){

                    @Override
                    public void run() {
                        boolean executar = true;
                        while (!Thread.interrupted() && executar) {
                            try {
                                String str;
                                if (SocketEstacao.this.lerEntrada && Mensagem.validarPadrao(str = SocketEstacao.this.entrada.readUTF())) {
                                    SocketEstacao.this.fireLeuMensagem(str);
                                }
                                Thread.sleep(50L);
                            }
                            catch (Exception e) {
                                if (!(e instanceof EOFException) && !(e instanceof SocketException)) {
                                    System.out.println(e.getMessage());
                                    e.printStackTrace();
                                    SocketEstacao.this.conectado = false;
                                    SocketEstacao.this.fireEstacaoDesconectou();
                                }
                                executar = false;
                            }
                        }
                    }
                }.start();
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (!Thread.interrupted() && SocketEstacao.this.conectado) {
                            try {
                                DataOutputStream dataOutputStream = SocketEstacao.this.saida;
                                synchronized (dataOutputStream) {
                                    SocketEstacao.this.saida.writeUTF("");
                                    SocketEstacao.this.saida.flush();
                                }
                                Thread.sleep(SocketEstacao.this.tempo);
                            }
                            catch (Exception e) {
                                if (!(e instanceof SocketException)) {
                                    System.out.println(e.getMessage());
                                    e.printStackTrace();
                                }
                                SocketEstacao.this.conectado = false;
                                SocketEstacao.this.fireEstacaoDesconectou();
                            }
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void fireLeuMensagem(String str) {
        for (SocketEstacaoListener ouvinte : (SocketEstacaoListener[])this.ouvintes.getListeners(SocketEstacaoListener.class)) {
            ouvinte.leuMensagem(this, Mensagem.parse(str));
        }
    }

    private void fireEstacaoDesconectou() {
        for (SocketEstacaoListener ouvinte : (SocketEstacaoListener[])this.ouvintes.getListeners(SocketEstacaoListener.class)) {
            ouvinte.estacaoDesconectou(this);
        }
    }

    public void avisarBloqueio() {
        this.bloqueado = true;
    }

    public void avisarLiberacao() {
        this.bloqueado = false;
    }

    public boolean getSituacaoBloqueio() {
        return !this.bloqueado;
    }
}

