/*
 * Decompiled with CFR 0.152.
 */
package jalis.servidor;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.pardini.Autenticador;
import jalis.laboratorio.util.parsers.pardini.ImportacaoHPardini;
import jalis.mensagens.NovaMensagem;
import jalis.model.bean.log.LogImportacaoLabExternoBean;
import jalis.service.cadastro.exame.LabExternoService;
import jalis.service.log.LogImportacaoLabExternoService;
import jalis.servidor.ConsultaLicencaAPI;
import jalis.servidor.Estacoes;
import jalis.servidor.Mensagem;
import jalis.servidor.SocketEstacao;
import jalis.servidor.SocketEstacaoListener;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.swing.Timer;
import org.json.JSONException;
import org.json.JSONObject;

public class Servidor
implements Runnable,
SocketEstacaoListener {
    private static Scanner sc = new Scanner(System.in);
    private static final int TEMPO_INTERVALO_IMPORTACAO_HP = 300000;
    private static final int TEMPO_IMPORTACAO_EXAME_HP = 600000;
    private static final int TEMPO_IMPORTACAO_EXAME_INICIAL_HP = 60000;
    private static final int PORTA_PADRAO = 4444;
    private static final String COLUNA_PID = "pid";
    private static final String COLUNA_PROCPID = "procpid";
    private static final String CAMINHO_LOG = "/var/log/";
    private static final String ARQUIVO_LOG = "ServidorJalis.log";
    private static final int TEMPO_CICLO = 5000;
    private static final StringBuilder builder = new StringBuilder();
    private static String numeroIP = "127.0.0.1";
    private static String status;
    private static boolean exibirMensagem;
    private static boolean exibirStatus;
    private static boolean informacoes;
    private static boolean atualizarServidor;
    private static boolean atualizarLicenca;
    private static boolean fecharEstacao;
    private static String codigoEstacao;
    private static boolean executar;
    private static boolean iniciarMonitoramento;
    private static int tempo_monitor;
    private static int limite_monitor;
    private static List<String> emails_monitor;
    private static int proximaPosicao;
    private static Timer timerMonitor;
    private static boolean importadorPardini;
    private static int horaImportar;
    private static int minutoImportar;
    private static String codigoFilialHP;
    private static String usuarioAvisar;
    private static Timer timerImportador;
    private static Timer intervalo;
    private static Timer timerEnvio;
    private static int diaUltimaExecucaoHP;
    private static int diaUltimaExecucaoVerficacaoLote;
    private static String codigoThread;
    private static String codigoJalis;
    private static boolean verificaMensagens;
    private static String usuarioVerificaVencimento;
    private static String horarioVerificaVencimento;
    private static String filiaisVerificaVencimento;
    private static BufferedWriter log;
    private static int tempoEspera;
    private static boolean modoDebug;
    private int limite;
    private static boolean horarioVerao;
    private static int porta;
    private static String nomeColunaTabelaProcessos;
    private static boolean validado;
    private ControleAgendamentos controleAgendamento = new ControleAgendamentos();
    private final Map<String, Set<String>> conversas = new HashMap<String, Set<String>>();
    private final Map<String, SocketEstacao> online = new HashMap<String, SocketEstacao>();
    private final Map<String, SocketEstacao> estacoes = new HashMap<String, SocketEstacao>();
    private Timer timer = new Timer(28800000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            validado = Servidor.this.validarUso();
            if (!validado) {
                Servidor.this.timer.stop();
            }
        }
    });

    public Servidor(int limiteConexoes) throws Exception {
        this.limite = limiteConexoes;
        this.verificaColunaTabelaProcessos();
        if (ParametrosGerais.carregaParametros()) {
            validado = this.validarUso();
            new Thread(this).start();
            if (validado) {
                this.timer.start();
            }
            if (Conexao.getConnected()) {
                Conexao.shutdown();
            }
        }
    }

    @Override
    public void run() {
        try {
            ServerSocket server = new ServerSocket(porta);
            Servidor.mensagem("Servidor Jalis rodando para ", this.limite, this.limite == 1 ? "estacao" : " estacoes", porta != 4444 ? " [ porta " + String.valueOf(porta) + "]" : "");
            this.removeTodosOIDs();
            while (!Thread.interrupted()) {
                try {
                    SocketEstacao estacao = new SocketEstacao(server.accept(), 5000L);
                    estacao.addSocketEstacaoListener(this);
                    estacao.setLerEntrada(true);
                }
                catch (Exception e) {
                    Servidor.debug("Erro ao iniciar comunicacao com estacao (" + e.getMessage() + ")");
                }
                Thread.sleep(50L);
            }
        }
        catch (Exception e) {
            Servidor.mensagem(e.getMessage());
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void estacaoDesconectou(SocketEstacao estacao) {
        SocketEstacao socketEstacao = estacao;
        synchronized (socketEstacao) {
            if (estacao.estacaoDefinida()) {
                Servidor.mensagem("Estacao \"", estacao.getEstacao(), "\" desconectou.");
            }
            Map<String, SocketEstacao> map = this.estacoes;
            synchronized (map) {
                this.estacoes.remove(estacao.getCodigo());
                Servidor.debug("Estacao " + estacao.getCodigo() + "(" + estacao.getEstacao() + ") removida");
                if (estacao.usuarioDefinido()) {
                    Map<String, SocketEstacao> map2 = this.online;
                    synchronized (map2) {
                        if (this.online.containsKey(estacao.getUsuario())) {
                            this.online.remove(estacao.getUsuario());
                        }
                    }
                }
            }
            this.controleAgendamento.liberarTudoEstacao(estacao.getEstacao());
            Mensagem msn = new Mensagem("conexao", "desconectar");
            estacao.escreverMensagem(msn);
            estacao.fechar();
            this.removeOIDTabelaUsuarioConectado(estacao.getOID());
        }
    }

    @Override
    public void leuMensagem(SocketEstacao estacao, Mensagem msn) {
        StringBuilder buf = new StringBuilder("Mensagem recebida:");
        Set<String> set = msn.getItens();
        for (String s : set) {
            buf.append("\n\t").append(s).append(":").append(msn.getString(s));
        }
        Servidor.debug(buf.toString());
        if (msn.mesmoID("conexao")) {
            this.tratarConexao(estacao, msn);
        } else if (msn.mesmoID("servidor")) {
            this.tratarServidor(estacao, msn);
        } else if (msn.mesmoID("usuario")) {
            this.tratarUsuario(estacao, msn);
        } else if (msn.mesmoID("chat")) {
            this.tratarChat(estacao, msn);
        } else if (msn.mesmoID("agendamento")) {
            this.tratarAgendamento(estacao, msn);
        } else if (msn.mesmoID("dataHoraServidor")) {
            this.tratarDataHoraServidor(estacao, msn);
        }
    }

    private static void mensagem(Object ... msn) {
        if (msn == null) {
            return;
        }
        try {
            builder.setLength(0);
            for (Object o : msn) {
                builder.append(String.valueOf(o));
            }
            if (exibirMensagem) {
                System.out.println(builder);
            }
            if (log != null) {
                Servidor.escreveLog(builder.append("\n").toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Servidor.escreveLog(e.getMessage() + "(153)");
        }
    }

    private static void escreveLog(String msn) {
        if (log != null) {
            try {
                log.write(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new java.util.Date()));
                log.write(":");
                log.write(msn);
                log.flush();
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
    }

    private static void debug(String msn) {
        if (modoDebug) {
            Servidor.mensagem("DEBUG:" + msn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tratarConexao(SocketEstacao estacao, Mensagem msn) {
        Mensagem m = new Mensagem("conexao");
        if (msn.mesmaAcao("desconectar")) {
            this.estacaoDesconectou(estacao);
        } else {
            if (msn.mesmaAcao("fechar")) {
                String codigoEstacao = msn.getList("codigoestacao").get(0);
                Servidor.debug("Fechando estacao " + codigoEstacao);
                Map<String, SocketEstacao> map = this.estacoes;
                synchronized (map) {
                    SocketEstacao se = this.estacoes.get(codigoEstacao);
                    if (se != null) {
                        se.escreverMensagem(msn);
                    } else {
                        m.setAcao("negado");
                    }
                    estacao.escreverMensagem(m);
                }
            }
            if (msn.mesmaAcao("validar") || msn.mesmaAcao("revalidar")) {
                SocketEstacao socketEstacao = estacao;
                synchronized (socketEstacao) {
                    String nomeEstacao = msn.getString("nomeestacao");
                    String chaveEstacao = msn.getString("chave");
                    String versaoJalis = msn.getString("versaojalis");
                    String versaoJava = msn.getString("versaojava");
                    String descricaoEstacao = msn.getString("descricaoestacao");
                    String codigoEstacao = msn.getString("codigoestacao");
                    String oid = msn.getString("oid");
                    Servidor.debug("Validando estacao " + codigoEstacao);
                    Map<String, SocketEstacao> map = this.estacoes;
                    synchronized (map) {
                        String chaveAtual;
                        if (this.estacoes.containsKey(codigoEstacao) && (chaveAtual = this.estacoes.get(codigoEstacao).getChave()) != null && !chaveAtual.isEmpty() && chaveAtual.equals(chaveEstacao)) {
                            this.estacoes.remove(codigoEstacao);
                            Servidor.debug("Removendo estacao " + codigoEstacao + " por chave duplicada");
                        }
                        if (nomeEstacao.trim().length() == 0) {
                            m.setAcao("negado");
                            Servidor.debug("Acesso negado para estacao (estacao sem identificacao)");
                        } else if (this.estacoes.size() >= this.limite) {
                            m.setAcao("excedido");
                            Servidor.mensagem("Nao validou estacao \"", nomeEstacao, "\" para o endereco \"", estacao.enderecoIP(), "\", pois o limite de conexoes foi excedido.");
                        } else if (this.estacoes.containsKey(nomeEstacao)) {
                            m.setAcao("duplicado");
                            Servidor.mensagem("Nao validou estacao \"", nomeEstacao, "\" para o endereco \"", estacao.enderecoIP(), "\", pois ja esta conectada.");
                        } else {
                            if (chaveEstacao == null || chaveEstacao.isEmpty()) {
                                chaveEstacao = estacao.getChave();
                            }
                            m.setAcao("validado");
                            m.setString("chave", chaveEstacao);
                            estacao.setEstacao(nomeEstacao);
                            estacao.setVersaoJalis(versaoJalis);
                            estacao.setVersaoJava(versaoJava);
                            estacao.setDescricaoEstacao(descricaoEstacao);
                            estacao.setChave(chaveEstacao);
                            estacao.setCodigo(codigoEstacao);
                            estacao.setOID(oid);
                            this.estacoes.put(codigoEstacao, estacao);
                            if (msn.mesmaAcao("validar")) {
                                Servidor.mensagem("Validou estacao \"", nomeEstacao, "\" para o endereco \"", estacao.enderecoIP(), "\", chave \"" + estacao.getChave() + "\" (" + chaveEstacao + ")");
                            } else {
                                List<String> list = msn.getList("usuario");
                                if (!list.isEmpty()) {
                                    estacao.setUsuario(list.get(0));
                                    if (list.contains("online")) {
                                        Map<String, SocketEstacao> map2 = this.online;
                                        synchronized (map2) {
                                            this.online.put(estacao.getUsuario(), estacao);
                                        }
                                        this.adicionaOIDConectado(estacao.getOID(), estacao.getUsuario(), estacao.getCodigo(), null);
                                    }
                                }
                                Servidor.mensagem("Revalidou estacao \"", nomeEstacao, "\" para o endereco \"", estacao.enderecoIP(), "\", chave \"" + estacao.getChave() + "\" (" + chaveEstacao + ")");
                            }
                        }
                    }
                    estacao.escreverMensagem(m);
                    estacao.avisarLiberacao();
                    estacao.escreverMensagem(new Mensagem("liberar"));
                    if (!validado) {
                        estacao.avisarBloqueio();
                        estacao.escreverMensagem(new Mensagem("bloquear"));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tratarServidor(SocketEstacao estacao, Mensagem msn) {
        Map<String, Set<String>> map;
        Mensagem m = new Mensagem("servidor");
        Variaveis.caminhoBanco = "jdbc:postgresql://" + numeroIP + "/jalis";
        if (msn.mesmaAcao("atualizar")) {
            Servidor.mensagem("Recarregando dados do banco.");
            if (!ParametrosGerais.carregaParametros()) {
                Servidor.mensagem("Erro ao carregar os parametros gerais do sistema.");
                Servidor.mensagem(Conexao.getUltimoErro());
            } else {
                Estacoes est = Estacoes.decodificar(ParametrosGerais.getEstacoes());
                if (est == null) {
                    Servidor.mensagem("Erro ao decodificar chave do numero de estacoes.");
                } else if (est.getCodigoCliente() != ParametrosGerais.getCodigoCliente()) {
                    Servidor.mensagem("O numero de cliente da chave e do banco de dados nao conferem.");
                } else if (!Servidor.validaCodigoClienteCriptografado()) {
                    Servidor.mensagem("O numero de cliente da chave e do banco de dados nao conferem.");
                } else {
                    this.limite = est.getQuantidadeEstacoes();
                    Servidor.mensagem("Servidor Jalis rodando para ", this.limite, this.limite == 1 ? "estacao" : " estacoes", " [", Funcoes.formataHora(new java.util.Date(), true), "]");
                    Servidor.mensagem("Revalidando estacoes conectadas");
                    Map<String, SocketEstacao> map2 = this.estacoes;
                    synchronized (map2) {
                        for (SocketEstacao se2 : this.estacoes.values()) {
                            if (se2.usuarioDefinido()) {
                                this.online.remove(se2.getUsuario());
                                this.removeOIDTabelaUsuarioConectado(estacao.getOID());
                            }
                            se2.fechar();
                        }
                        this.estacoes.clear();
                    }
                }
                if (Conexao.getConnected()) {
                    Conexao.shutdown();
                }
            }
        } else {
            if (msn.mesmaAcao("estacoes")) {
                m.setAcao("estacoes");
                map = this.estacoes;
                synchronized (map) {
                    Iterator<SocketEstacao> iterator = this.estacoes.values().iterator();
                    while (iterator.hasNext()) {
                        SocketEstacao se;
                        SocketEstacao se2 = se = iterator.next();
                        synchronized (se2) {
                            List<String> list = m.setList(se.getCodigo(), new ArrayList<String>());
                            list.add(se.getUsuario());
                            list.add(se.enderecoIP());
                            list.add(se.getVersaoJalis());
                            list.add(se.getVersaoJava());
                            list.add(se.getDescricaoEstacao());
                        }
                    }
                }
            }
            if (msn.mesmaAcao("usuarios")) {
                m.setAcao("usuarios");
                map = this.estacoes;
                synchronized (map) {
                    Iterator<SocketEstacao> iterator = this.estacoes.values().iterator();
                    while (iterator.hasNext()) {
                        SocketEstacao se;
                        SocketEstacao se2 = se = iterator.next();
                        synchronized (se2) {
                            if (se.usuarioDefinido()) {
                                if (!m.contemItem(se.getUsuario())) {
                                    m.setList(se.getUsuario(), new ArrayList<String>());
                                }
                                m.getList(se.getUsuario()).add(se.getEstacao());
                            }
                        }
                    }
                }
            }
            if (msn.mesmaAcao("online")) {
                m.setAcao("online");
                map = this.online;
                synchronized (map) {
                    Iterator<SocketEstacao> iterator = this.online.values().iterator();
                    while (iterator.hasNext()) {
                        SocketEstacao se;
                        SocketEstacao se2 = se = iterator.next();
                        synchronized (se2) {
                            if (se.usuarioDefinido()) {
                                List<String> list = m.setList(se.getUsuario(), new ArrayList<String>());
                                list.add(se.getEstacao());
                                list.add(se.enderecoIP());
                            }
                        }
                    }
                }
            }
            if (msn.mesmaAcao("chat")) {
                m.setAcao("chat");
                map = this.conversas;
                synchronized (map) {
                    for (String ident : this.conversas.keySet()) {
                        List<String> list = m.setList(ident, new ArrayList<String>());
                        for (String usu : this.conversas.get(ident)) {
                            list.add(usu);
                        }
                    }
                }
            }
        }
        map = estacao;
        synchronized (map) {
            estacao.escreverMensagem(m);
        }
    }

    private static boolean validaCodigoClienteCriptografado() {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatementTratandoShutdown();
        buf.append("select par_cliente = convert_from(decode(par_copiarcliente, 'base64'), 'latin1') as comparacao,");
        buf.append(" par_cliente as original,");
        buf.append(" convert_from(decode(par_copiarcliente, 'base64'), 'latin1') as convertido");
        buf.append(" from parametros");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getBoolean("comparacao");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tratarUsuario(SocketEstacao estacao, Mensagem msn) {
        if (msn.mesmaAcao("estacoes")) {
            SocketEstacao socketEstacao = estacao;
            synchronized (socketEstacao) {
                if (estacao.usuarioDefinido()) {
                    Mensagem m = new Mensagem("usuario", "estacoes");
                    List<String> list = m.setList("estacoes", new ArrayList<String>());
                    Map<String, SocketEstacao> map = this.estacoes;
                    synchronized (map) {
                        Iterator<SocketEstacao> iterator = this.estacoes.values().iterator();
                        while (iterator.hasNext()) {
                            SocketEstacao se;
                            SocketEstacao socketEstacao2 = se = iterator.next();
                            synchronized (socketEstacao2) {
                                if (se != estacao && se.mesmoUsuario(estacao.getUsuario())) {
                                    list.add(se.getEstacao());
                                }
                            }
                        }
                    }
                    estacao.escreverMensagem(m);
                }
            }
        }
        if (msn.mesmaAcao("login") || msn.mesmaAcao("logout")) {
            SocketEstacao socketEstacao = estacao;
            synchronized (socketEstacao) {
                String oidAux = estacao.getOID();
                estacao.setUsuario(msn.getString("usuario"));
                estacao.setFilial(msn.getString("filial"));
                Map<String, SocketEstacao> map = this.online;
                synchronized (map) {
                    if (msn.mesmaAcao("login")) {
                        SocketEstacao se = this.online.get(estacao.getUsuario());
                        if (se != null) {
                            SocketEstacao socketEstacao3 = se;
                            synchronized (socketEstacao3) {
                                se.escreverMensagem(new Mensagem("usuario", "offline"));
                            }
                        }
                        this.online.put(estacao.getUsuario(), estacao);
                        this.adicionaOIDConectado(estacao.getOID(), estacao.getUsuario(), estacao.getCodigo(), estacao.getFilial());
                    } else {
                        this.online.remove(estacao.getUsuario());
                        this.removeOIDTabelaUsuarioConectado(oidAux);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tratarAgendamento(SocketEstacao estacao, Mensagem msn) {
        if (msn.mesmaAcao("acaoquantidade")) {
            SocketEstacao socketEstacao = estacao;
            synchronized (socketEstacao) {
                if (estacao.usuarioDefinido()) {
                    Integer salaAtendimento = Integer.parseInt(msn.getString("sala"));
                    String dataHoraAgendamento = msn.getString("datahora");
                    java.util.Date dataAux = Funcoes.getData("dd/MM/yyyy HH:mm", dataHoraAgendamento);
                    msn = new Mensagem("agendamento", "acaoquantidade");
                    msn.setString("quantidade", String.valueOf(this.controleAgendamento.getQuantidadeAgendamentos(salaAtendimento, dataAux, estacao.getEstacao())));
                    estacao.escreverMensagem(msn);
                }
            }
        }
        if (msn.mesmaAcao("acaobloqueia")) {
            SocketEstacao socketEstacao = estacao;
            synchronized (socketEstacao) {
                if (estacao.usuarioDefinido()) {
                    Integer salaAtendimento = Integer.parseInt(msn.getString("sala"));
                    String dataHoraAgendamento = msn.getString("datahora");
                    java.util.Date dataAux = Funcoes.getData("dd/MM/yyyy HH:mm", dataHoraAgendamento);
                    this.controleAgendamento.bloqueiaAgendamento(salaAtendimento, dataAux, estacao.getEstacao());
                }
            }
        }
        if (msn.mesmaAcao("acaolibera")) {
            SocketEstacao socketEstacao = estacao;
            synchronized (socketEstacao) {
                if (estacao.usuarioDefinido()) {
                    Integer salaAtendimento = Integer.parseInt(msn.getString("sala"));
                    String dataHoraAgendamento = msn.getString("datahora");
                    java.util.Date dataAux = Funcoes.getData("dd/MM/yyyy HH:mm", dataHoraAgendamento);
                    this.controleAgendamento.liberaAgendamento(salaAtendimento, dataAux, estacao.getEstacao());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tratarDataHoraServidor(SocketEstacao estacao, Mensagem msn) {
        if (msn.mesmaAcao("getData")) {
            SocketEstacao socketEstacao = estacao;
            synchronized (socketEstacao) {
                msn = new Mensagem("dataHoraServidor", "getData");
                msn.setString("valor", Funcoes.formataData("dd/MM/yyyy", new java.util.Date()));
                estacao.escreverMensagem(msn);
            }
        }
        if (msn.mesmaAcao("getHora")) {
            SocketEstacao socketEstacao = estacao;
            synchronized (socketEstacao) {
                msn = new Mensagem("dataHoraServidor", "getHora");
                msn.setString("valor", Funcoes.formataData("HH:mm:ss", new java.util.Date()));
                estacao.escreverMensagem(msn);
            }
        }
        if (msn.mesmaAcao("getDataHora")) {
            SocketEstacao socketEstacao = estacao;
            synchronized (socketEstacao) {
                msn = new Mensagem("dataHoraServidor", "getDataHora");
                msn.setString("valor", Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new java.util.Date()));
                estacao.escreverMensagem(msn);
            }
        }
    }

    private void tratarChat(SocketEstacao estacao, Mensagem msn) {
    }

    private static void tratarArgumentos(String[] args) throws Exception {
        Object[] argumentos = args;
        if (args != null && args.length == 1 && args[0].split(" ").length > 1) {
            argumentos = args[0].split(" ");
        }
        ArrayList<String> param = new ArrayList<String>();
        for (int pos = 0; pos < argumentos.length; ++pos) {
            if (param.contains(argumentos[pos])) {
                System.out.println("O parametro " + argumentos[pos] + " deve ser especificado somente uma unica vez.");
                executar = false;
                return;
            }
            param.add(argumentos[pos]);
            if (argumentos[pos].equals("-v")) {
                exibirMensagem = true;
                continue;
            }
            if (argumentos[pos].equals("-h")) {
                System.out.println("Servidor de esta\u00e7\u00f5es do sistema Jalis.");
                System.out.println("Opcoes:");
                System.out.println("\t-h\n\t  Imprime ajuda para os comandos do servidor.\n");
                System.out.println("\t-v\n\t  Imprime as mensagens de evento do servidor.\n");
                System.out.println("\t-log\n\t  Grava as mensagens do servidor no arquivo \"/var/log/ServidorJalis.log\".\n");
                System.out.println("\t-debug\n\t  Ativa ou desativa a opcao de DEBUG das mensagens recebidas e enviadas");
                System.out.println("\t  pelo servidor e as estacoes.\n");
                System.out.println("\t-ip numero_ip\n\t  Especifica o numero de IP do banco de dados do Jalis");
                System.out.println("\t  em que o servidor sera conectado.\n");
                System.out.println("\t  Se essa opcao for omitida, o servidor ira utilizar o");
                System.out.println("\t  numero de IP 127.0.0.1 por default.\n");
                System.out.println("\t-porta numero\n\t  Especifica o numero da porta para conexoes de estacoes");
                System.out.println("\t  Se essa opcao for omitida, o servidor ira utilizar o");
                System.out.println("\t  numero 4444 por default.\n");
                System.out.println("\t-d tempo_segundos\n\t  Especifica o tempo em segundos que o servidor deve esperar");
                System.out.println("\t  antes de ser carregado.\n");
                System.out.println("\t  Esta opcao \u00e9 \u00fatil para dar tempo para o servidor de banco");
                System.out.println("\t  de dados seja inicializado.\n");
                System.out.println("\t-atualizar\n\t  Solicita ao servidor para que recarregue os dados do banco e");
                System.out.println("\t  revalide todas as conex\u00f5es.\n");
                System.out.println("\t-verao\n\t  Informa ao servidor que devera utilizar um TimeZone diferente para");
                System.out.println("\t  considerar o horario de verao.\n");
                System.out.println("\t-fechar [ codigo_estacao | todos ]");
                System.out.println("\t  Solicita ao servidor para que feche o sistema jalis da estacao.");
                System.out.println("\t  Deve-se especificar um dos seguintes valores para este parametro:\n");
                System.out.println("\t    codigo_estacao");
                System.out.println("\t      Informando o c\u00f3digo da esta\u00e7\u00e3o que ser\u00e1 fechada.\n");
                System.out.println("\t    todos");
                System.out.println("\t      Palavra chave que indica que todas as esta\u00e7\u00f5es ser\u00e3o fechadas.\n");
                System.out.println("\t-status [ estacoes | usuarios | online | chat ]");
                System.out.println("\t  Exibe o status do servidor rodando no IP especificado. Se o parametro de IP for");
                System.out.println("\t  omitido, o servidor ira utilizar o numero de IP 127.0.0.1 por default.\n");
                System.out.println("\t  Ao especificar este parametro, o servidor nao sera executado. Apenas sera exibido o status");
                System.out.println("\t  do servidor do numero de IP especificado, de acordo com a opcao definida para");
                System.out.println("\t  para o parametro.\n");
                System.out.println("\t  Deve-se especificar um dos seguintes valores para este parametro:\n");
                System.out.println("\t    estacoes");
                System.out.println("\t      Exibe lista das estacoes conectadas e os respectivos usuarios logados.\n");
                System.out.println("\t    usuarios");
                System.out.println("\t      Exibe lista dos usuarios e as estacoes em que estao logados.\n");
                System.out.println("\t    online");
                System.out.println("\t      Exibe lista dos usuarios que estao online no servidor de chat.\n");
                System.out.println("\t    chat");
                System.out.println("\t      Exibe lista de identificadores de conversas e seus respectivos usuarios.\n");
                System.out.println("\t-monitorar -tempo_monitor [valor] | -limite_monitor [valor] | -emails_monitor [valor, valor, valor]");
                System.out.println("\t  Ativa o monitoramento de logs para web, integra\u00e7\u00e3o off-line, e-mail, sms, hospitais");
                System.out.println("\t-atualizar_exame_pardini -hora_importar [valor] | -usuario_avisar [valor] | -filial [valor]");
                System.out.println("-atualizar_licenca");
                System.out.println("Solicita verifica\u00e7\u00e3o de licen\u00e7a do cliente no sistema Zero, validando se o mesmo tem licen\u00e7as para ser utilizadas e conceder acesso as estacoes. Dever\u00e1 ser informado os 2 comandos:");
                System.out.println("- C\u00f3digo Thread: [Informar o c\u00f3digo n\u00famerico] ");
                System.out.println("- C\u00f3digo Jalis: [Informar o c\u00f3digo n\u00famerico]");
                System.out.println("Com estes c\u00f3digos ser\u00e1 pesquisado no Zero a quantidade de licen\u00e7a dispon\u00edvel para o cliente e retornado se ainda h\u00e1 licen\u00e7a de esta\u00e7\u00e3o para uso ou n\u00e3o.");
                executar = false;
                return;
            }
            if (argumentos[pos].equals("-ip")) {
                if (pos == argumentos.length - 1) {
                    System.out.println("O numero de IP nao foi especificado apos o parametro -ip.");
                    executar = false;
                    return;
                }
                if (Funcoes.verificaIP(argumentos[++pos])) {
                    numeroIP = argumentos[pos];
                    continue;
                }
                System.out.println("O parametro " + argumentos[pos] + " nao e um numero de IP valido.");
                executar = false;
                return;
            }
            if (argumentos[pos].equals("-porta")) {
                if (pos == argumentos.length - 1) {
                    System.out.println("O numero da porta nao foi especificado apos o parametro -porta.");
                    executar = false;
                    return;
                }
                if (Funcoes.isNumeric(argumentos[++pos])) {
                    porta = Integer.parseInt(argumentos[pos]);
                    continue;
                }
                System.out.println("O parametro " + argumentos[pos] + " nao e um numero valido.");
                executar = false;
                return;
            }
            if (argumentos[pos].equals("-d")) {
                if (pos == argumentos.length - 1) {
                    System.out.println("O tempo em segundos nao foi especificado apos o parametro -d.");
                    executar = false;
                    return;
                }
                if (argumentos[++pos].matches("\\d+")) {
                    tempoEspera = Integer.parseInt(argumentos[pos]);
                    continue;
                }
                System.out.println("O parametro " + argumentos[pos] + " nao e um numero valido.");
                executar = false;
                return;
            }
            if (argumentos[pos].equals("-log")) {
                if (porta != 4444) {
                    log = new BufferedWriter(new FileWriter("/var/log/ServidorJalis" + String.valueOf(porta) + ".log"));
                    continue;
                }
                log = new BufferedWriter(new FileWriter("/var/log/ServidorJalis.log"));
                continue;
            }
            if (argumentos[pos].equals("-debug")) {
                boolean bl = modoDebug = !modoDebug;
                if (!modoDebug || log != null) continue;
                log = new BufferedWriter(new FileWriter("/var/log/ServidorJalis.log"));
                continue;
            }
            if (argumentos[pos].equals("-atualizar")) {
                atualizarServidor = true;
                executar = false;
                continue;
            }
            if (argumentos[pos].equals("-info")) {
                informacoes = true;
                executar = false;
                continue;
            }
            if (argumentos[pos].equals("-verao")) {
                horarioVerao = true;
                executar = true;
                continue;
            }
            if (argumentos[pos].equals("-fechar")) {
                if (pos == argumentos.length - 1) {
                    System.out.println("O c\u00f3digo da esta\u00e7\u00e3o ou a palavra chave [TODOS]valor n\u00e3o foi especificado apos o parametro -fechar.");
                    executar = false;
                    return;
                }
                fecharEstacao = true;
                codigoEstacao = argumentos[++pos];
                executar = false;
                continue;
            }
            if (argumentos[pos].equals("-status")) {
                executar = false;
                if (pos == argumentos.length - 1 || !argumentos[pos + 1].equals("estacoes") && !argumentos[pos + 1].equals("usuarios") && !argumentos[pos + 1].equals("online") && !((String)argumentos[pos + 1]).equals("chat")) {
                    if (pos == argumentos.length - 1) {
                        System.out.println("Nao foi especificada uma opcao valida para o parametro \"-status\".");
                    } else {
                        System.out.println("O valor " + argumentos[++pos] + " nao e uma opcao valida para o parametro \"-status\".");
                    }
                    System.out.println("Deve-se especificar uma das seguintes opcoes:");
                    System.out.println("\t -status estacoes");
                    System.out.println("\t -status usuarios");
                    System.out.println("\t -status online");
                    System.out.println("\t -status chat");
                    return;
                }
                exibirStatus = true;
                if (argumentos[++pos].equals("estacoes")) {
                    status = "estacoes";
                    continue;
                }
                if (argumentos[pos].equals("usuarios")) {
                    status = "usuarios";
                    continue;
                }
                if (argumentos[pos].equals("online")) {
                    status = "online";
                    continue;
                }
                status = "chat";
                continue;
            }
            if (argumentos[pos].equals("-monitorar")) {
                if (!Servidor.existeProximoArgumentoMonitor((String[])argumentos, pos)) {
                    executar = false;
                    Servidor.mostraMensagemErro();
                    return;
                }
                iniciarMonitoramento = true;
                continue;
            }
            if (argumentos[pos].equals("-tempo_monitor") || argumentos[pos].equals("-limite_monitor") || argumentos[pos].equals("-emails_monitor") || pos == proximaPosicao) {
                if (!iniciarMonitoramento) {
                    executar = false;
                    Servidor.mostraMensagemErro();
                    return;
                }
                if (argumentos[pos].equals("-tempo_monitor")) {
                    if (!Servidor.existeProximoArgumentoMonitor((String[])argumentos, pos)) {
                        executar = false;
                        iniciarMonitoramento = true;
                        Servidor.mostraMensagemErro();
                        return;
                    }
                    if (Funcoes.isNumeric(argumentos[pos + 1]) && Integer.parseInt((String)argumentos[pos + 1]) <= 0) {
                        iniciarMonitoramento = false;
                        executar = false;
                        System.out.println("O parametro " + (String)argumentos[pos] + " deve ser maior que 0 (zero).\n");
                        return;
                    }
                    if (Funcoes.isNumeric((String)argumentos[pos + 1])) {
                        tempo_monitor = Integer.parseInt((String)argumentos[pos + 1]);
                    } else {
                        iniciarMonitoramento = false;
                        executar = false;
                        System.out.println("O parametro " + (String)argumentos[pos] + " deve conter somente n\u00fameros.\n");
                        return;
                    }
                }
                if (argumentos[pos].equals("-limite_monitor")) {
                    if (!Servidor.existeProximoArgumentoMonitor((String[])argumentos, pos)) {
                        executar = false;
                        iniciarMonitoramento = true;
                        Servidor.mostraMensagemErro();
                        return;
                    }
                    if (Funcoes.isNumeric(argumentos[pos + 1]) && Integer.parseInt((String)argumentos[pos + 1]) <= 0) {
                        iniciarMonitoramento = false;
                        executar = false;
                        System.out.println("O parametro " + (String)argumentos[pos] + " deve ser maior que 0 (zero).\n");
                        return;
                    }
                    if (Funcoes.isNumeric((String)argumentos[pos + 1])) {
                        limite_monitor = Integer.parseInt((String)argumentos[pos + 1]);
                    } else {
                        iniciarMonitoramento = false;
                        executar = false;
                        System.out.println("O parametro " + (String)argumentos[pos] + " deve conter somente n\u00fameros.\n");
                        return;
                    }
                }
                if (!argumentos[pos].equals("-emails_monitor")) continue;
                if (!Servidor.existeProximoArgumentoMonitor((String[])argumentos, pos)) {
                    executar = false;
                    Servidor.mostraMensagemErro();
                    return;
                }
                if (Funcoes.textoVazio((String)argumentos[pos + 1])) {
                    iniciarMonitoramento = false;
                    executar = false;
                    System.out.println("O parametro " + (String)argumentos[pos] + " deve ser preenchido.\n");
                    return;
                }
                ArrayList<String> listaEmails = StringUtil.explode((String)argumentos[pos + 1], ",");
                if (listaEmails == null) continue;
                for (String email : listaEmails) {
                    if (Funcoes.textoVazio(email) || Funcoes.validaEmail(email)) continue;
                    executar = false;
                    iniciarMonitoramento = false;
                    System.out.println("O e-mail " + email + " n\u00e3o \u00e9 v\u00e1lido.\n");
                    return;
                }
                emails_monitor = listaEmails;
                continue;
            }
            if (argumentos[pos].equals("-validar_lote")) {
                Integer indiceHorarioValidaLote = ArraysUtil.indice(argumentos, "-validar_lote") + 1;
                Integer indiceUsuarioValidaLote = ArraysUtil.indice(argumentos, "-usuario_validar_lote") + 1;
                Integer indiceFilialValidarLote = ArraysUtil.indice(argumentos, "-filial_validar_lote") + 1;
                pos += 5;
                horarioVerificaVencimento = argumentos[indiceHorarioValidaLote];
                usuarioVerificaVencimento = argumentos[indiceUsuarioValidaLote];
                filiaisVerificaVencimento = argumentos[indiceFilialValidarLote];
                Servidor.tratarEnvioMensagens(filiaisVerificaVencimento);
                verificaMensagens = true;
                continue;
            }
            if (((String)argumentos[pos]).equals("-atualizar_exame_pardini")) {
                int posTime = ArraysUtil.indice(argumentos, "-hora_importar");
                int posUser = ArraysUtil.indice(argumentos, "-usuario_avisar");
                int posFilial = ArraysUtil.indice(argumentos, "-filial");
                if (posTime == -1 || posUser == -1 || posFilial == -1) {
                    executar = false;
                    Servidor.mostraMensagemErroAtualizador();
                    return;
                }
                if (argumentos.length < posTime + 2 || argumentos.length < posUser + 2 || argumentos.length < posFilial + 2) {
                    executar = false;
                    Servidor.mostraMensagemErroAtualizador();
                    return;
                }
                if (posTime == -1 || !Funcoes.verificaHora((String)argumentos[posTime + 1])) {
                    importadorPardini = false;
                    executar = false;
                    System.out.println("O parametro " + (String)argumentos[posTime] + " informado n\u00e3o \u00e9 valido.\n");
                    return;
                }
                if (Funcoes.textoVazio((String)argumentos[posUser + 1])) {
                    importadorPardini = false;
                    executar = false;
                    System.out.println("O parametro " + (String)argumentos[posUser] + " n\u00e3o est\u00e1 correto.\n");
                    return;
                }
                if (Funcoes.textoVazio((String)argumentos[posFilial + 1])) {
                    importadorPardini = false;
                    executar = false;
                    System.out.println("O parametro " + (String)argumentos[posFilial] + " n\u00e3o est\u00e1 correto.\n");
                    return;
                }
                if (!Servidor.existeUsuario((String)argumentos[posUser + 1])) {
                    importadorPardini = false;
                    executar = false;
                    System.out.println("O usu\u00e1rio " + (String)argumentos[posUser] + " inexistente no banco de dados.\n");
                    return;
                }
                importadorPardini = true;
                String[] horario = ((String)argumentos[posTime + 1]).split(":");
                horaImportar = Integer.parseInt(horario[0]);
                minutoImportar = Integer.parseInt(horario[1]);
                usuarioAvisar = argumentos[posUser + 1];
                codigoFilialHP = argumentos[posFilial + 1];
                pos = posFilial + 1;
                continue;
            }
            if (((String)argumentos[pos]).equals("-atualizar_licenca")) {
                System.out.println("Informe o C\u00f3digo Thread: ");
                codigoThread = sc.nextLine().trim();
                System.out.println("Informe o C\u00f3digo Jalis: ");
                codigoJalis = sc.nextLine().trim();
                if (!Funcoes.textoVazio(codigoThread) && !Funcoes.textoVazio(codigoJalis)) {
                    atualizarLicenca = true;
                    executar = false;
                    continue;
                }
                System.out.println("C\u00f3digo Thread e o C\u00f3digo Jalis devem ser informados!");
                atualizarLicenca = false;
                executar = false;
                continue;
            }
            System.out.println("O parametro " + (String)argumentos[pos] + " nao e uma opcao valida.\n");
            System.out.println("Utilize -h para mensagens de ajuda.");
            executar = false;
            return;
        }
        if (param.contains("-hora_importar") && !param.contains("-usuario_avisar")) {
            executar = false;
            Servidor.mostraMensagemErro();
        }
    }

    private static boolean trataRetornoConsultaAPI(String retorno) {
        if (!Funcoes.textoVazio(retorno)) {
            try {
                JSONObject obj = new JSONObject(retorno);
                int status = (Integer)obj.getJSONObject("resourse").get("status");
                if (status == 0) {
                    String msg = (String)obj.getJSONObject("resourse").get("mensagem");
                    System.out.println(msg);
                    return false;
                }
                if (obj.getJSONObject("resourse") != null) {
                    String codigoCliente = (String)obj.getJSONObject("resourse").get("mensagem1");
                    String qtdeEstacoes = (String)obj.getJSONObject("resourse").get("mensagem2");
                    Servidor.atualizaDados(codigoCliente, qtdeEstacoes);
                    return true;
                }
                System.out.println("Erro ao receber retorno da API.");
                return false;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void atualizaDados(String codigoCliente, String qtdeEstacoes) {
        StringBuilder buf = new StringBuilder();
        Variaveis.caminhoBanco = "jdbc:postgresql://" + numeroIP + "/jalis";
        Statement st = Conexao.getStatementTratandoShutdown();
        buf.append("update parametros");
        buf.append(" set par_cliente = '").append(codigoCliente).append("'");
        buf.append(", par_copiarcliente = encode('").append(codigoCliente).append("',").append("'base64') ");
        buf.append(", par_estacoes = '").append(qtdeEstacoes).append("'");
        try {
            Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                if (Conexao.getConnected()) {
                    Conexao.shutdown();
                }
                throw throwable;
            }
            Conexao.fecharStatement(st);
            if (Conexao.getConnected()) {
                Conexao.shutdown();
            }
        }
        Conexao.fecharStatement(st);
        if (Conexao.getConnected()) {
            Conexao.shutdown();
        }
    }

    private static boolean existeUsuario(String usuario) {
        return true;
    }

    private static boolean existeProximoArgumentoMonitor(String[] argumentos, int pos) {
        if (pos == argumentos.length - 1) {
            return false;
        }
        proximaPosicao = pos + 1;
        return true;
    }

    private static void mostraMensagemErroAtualizador() {
        System.out.println("Todos os par\u00e2metros s\u00e3o obrigat\u00f3rios");
        System.out.println("Ex: -atualizar_exame_pardini -hora_importar valor -usuario_avisar valor");
        System.out.println("-atualizar_exame_pardini -Ativa a importa\u00e7\u00e3o.");
        System.out.println("-hora_importar  -Hora em que ser\u00e1 feito a importa\u00e7\u00e3o.");
        System.out.println("-usuario_avisar -Usu\u00e1rio que ser\u00e1 avisado em caso de erro na importa\u00e7\u00e3o.");
        System.out.println("-filial -c\u00f3digo da filial padr\u00e3o do Jalis.");
    }

    private static void mostraMensagemErro() {
        System.out.println("Todos os par\u00e2metros s\u00e3o obrigat\u00f3rios");
        System.out.println("Ex: -monitorar -tempo_monitor valor -limite_monitor valor -emails_monitor valor,valor");
        System.out.println("-monitorar      -Ativa o monitoramento.");
        System.out.println("-tempo_monitor  -Tempo em minutos.");
        System.out.println("-limite_monitor -Limite de dados.");
        System.out.println("-emails_monitor -E-mails separados por v\u00edrgulas (sem espa\u00e7o).");
    }

    private static void tratarInformacoes() throws Exception {
        SocketEstacao socket = new SocketEstacao(numeroIP, 5000L);
        Mensagem m = new Mensagem("servidor", "informacoes");
        socket.escreverMensagem(m);
        m = socket.lerMensagem();
        if (m != null && m.mesmoID("servidor")) {
            if (ParametrosGerais.carregaParametros()) {
                Estacoes est = Estacoes.decodificar(ParametrosGerais.getEstacoes());
                System.out.println("Codigo cliente: " + est.getCodigoCliente());
                System.out.println("Versao sistema: " + ConstantesGerais.NRVERSAO);
                System.out.println("Quantidade de estacoes: " + est.getQuantidadeEstacoes());
                if (Conexao.getConnected()) {
                    Conexao.shutdown();
                }
            } else {
                System.out.println("Erro ao carregar os parametros gerais");
            }
        }
    }

    private static void tratarStatus() throws Exception {
        block8: {
            Mensagem m;
            block11: {
                block10: {
                    block9: {
                        SocketEstacao socket = new SocketEstacao(numeroIP, 5000L);
                        m = new Mensagem("servidor", status);
                        socket.escreverMensagem(m);
                        m = socket.lerMensagem();
                        if (m == null || !m.mesmoID("servidor")) break block8;
                        if (!m.mesmaAcao("estacoes")) break block9;
                        System.out.println("Estacoes conectadas ao servidor no IP " + numeroIP);
                        System.out.print(StringUtil.formatarColuna("CODIGO", 15, 'c'));
                        System.out.print(StringUtil.formatarColuna("USUARIO", 20, 'e'));
                        System.out.print(StringUtil.formatarColuna("ENDERECO", 25, 'c'));
                        System.out.print(StringUtil.formatarColuna("DESCRICAO", 25, 'e'));
                        System.out.print(StringUtil.formatarColuna("JALIS", 10, 'e'));
                        System.out.println(StringUtil.formatarColuna("JAVA", 10, 'e'));
                        for (String est : m.getItens()) {
                            List<String> list = m.getList(est);
                            if (list.size() != 5) continue;
                            System.out.print(StringUtil.formatarColuna(est, 15, 'c'));
                            System.out.print(StringUtil.formatarColuna(list.get(0), 20, 'e'));
                            System.out.print(StringUtil.formatarColuna(list.get(1), 25, 'c'));
                            System.out.print(StringUtil.formatarColuna(list.get(4), 25, 'e'));
                            System.out.print(StringUtil.formatarColuna(list.get(2), 10, 'e'));
                            System.out.println(StringUtil.formatarColuna(list.get(3), 10, 'e'));
                        }
                        int qtde = m.getItens().size();
                        System.out.println("Total de " + qtde + (qtde > 1 ? " estacoes" : " estacao"));
                        break block8;
                    }
                    if (!m.mesmaAcao("usuarios")) break block10;
                    System.out.println("Usuario logados no servidor no IP " + numeroIP);
                    System.out.print("\t" + StringUtil.formatarColuna("USUARIO", 20, 'e'));
                    System.out.println("ESTACOES");
                    for (String usu : m.getItens()) {
                        System.out.print("\t" + StringUtil.formatarColuna(usu, 20, 'e'));
                        ListIterator<String> itr = m.getList(usu).listIterator();
                        while (itr.hasNext()) {
                            if (itr.hasPrevious()) {
                                System.out.print(", ");
                            }
                            System.out.print(itr.next());
                        }
                        System.out.println();
                    }
                    break block8;
                }
                if (!m.mesmaAcao("online")) break block11;
                System.out.println("Usuarios online no servidor no IP " + numeroIP);
                System.out.print("\t" + StringUtil.formatarColuna("USUARIO", 20, 'e'));
                System.out.print(StringUtil.formatarColuna("ESTACAO", 15, 'c'));
                System.out.println(StringUtil.formatarColuna("ENDERECO", 25, 'c'));
                for (String usu : m.getItens()) {
                    List<String> list = m.getList(usu);
                    if (list.size() != 2) continue;
                    System.out.print("\t" + StringUtil.formatarColuna(usu, 20, 'e'));
                    System.out.print(StringUtil.formatarColuna(list.get(0), 15, 'c'));
                    System.out.println(StringUtil.formatarColuna(list.get(1), 25, 'c'));
                }
                break block8;
            }
            if (!m.mesmaAcao("chat")) break block8;
            System.out.println("Conversas de chat que estao sendo efetuadas no IP " + numeroIP);
            System.out.print("\t" + StringUtil.formatarColuna("IDENTIFICADOR", 13, 'c'));
            System.out.println("\tUSUARIOS");
            for (String id : m.getItens()) {
                System.out.print("\t" + StringUtil.formatarColuna(id, 13, 'c'));
                ListIterator<String> itr = m.getList(id).listIterator();
                while (itr.hasNext()) {
                    if (itr.hasPrevious()) {
                        System.out.print(", ");
                    }
                    System.out.print(itr.next());
                }
                System.out.println();
            }
        }
    }

    private static void tratarFecharEstacao() {
        try {
            ArrayList<String> estacoesParaFechar = new ArrayList<String>();
            SocketEstacao socket = new SocketEstacao(numeroIP, 5000L);
            if (codigoEstacao.equalsIgnoreCase("todos")) {
                Mensagem m = new Mensagem("servidor", "estacoes");
                socket.escreverMensagem(m);
                m = socket.lerMensagem();
                if (m != null && m.mesmoID("servidor") && m.mesmaAcao("estacoes")) {
                    for (String est : m.getItens()) {
                        List<String> list = m.getList(est);
                        if (list.size() <= 0) continue;
                        estacoesParaFechar.add(est);
                    }
                }
            } else {
                estacoesParaFechar.add(codigoEstacao);
            }
            for (String estacao : estacoesParaFechar) {
                System.out.println("Finalizando estacao " + estacao);
                Mensagem m = new Mensagem("conexao", "fechar");
                m.setString("codigoestacao", estacao);
                m.setString("origem", "administrador");
                socket.escreverMensagem(m);
                m = socket.lerMensagem();
                if (m == null || !m.mesmoID("conexao") || !m.mesmaAcao("negado")) continue;
                System.out.print(" - A estacao " + codigoEstacao + " nao esta conectada.\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Servidor.escreveLog(e.getMessage() + "(673)");
        }
    }

    private static void tratarMonitor() {
        if (timerMonitor == null) {
            timerMonitor = new Timer(60000 * tempo_monitor, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean isOk = Servidor.monitor();
                    if (!isOk) {
                        timerMonitor.stop();
                    }
                }
            });
            timerMonitor.start();
        }
    }

    private static void tratarEnvioMensagens(final String filial) {
        if (timerEnvio == null && !Funcoes.textoVazio(filial)) {
            timerEnvio = new Timer(60000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int hoje = Calendar.getInstance().get(5);
                    Calendar hora = Calendar.getInstance();
                    hora.set(Calendar.getInstance().get(1), Calendar.getInstance().get(2), Calendar.getInstance().get(5), Integer.valueOf(horarioVerificaVencimento), minutoImportar);
                    Integer horaVerificar = hora.get(11);
                    Calendar horaAtual = Calendar.getInstance();
                    horaAtual.setTime(new java.util.Date());
                    Integer horaAgora = horaAtual.get(11);
                    if (diaUltimaExecucaoVerficacaoLote != hoje && horaVerificar <= horaAgora) {
                        diaUltimaExecucaoVerficacaoLote = hoje;
                        boolean bl = Servidor.verificarLotes(filial);
                    }
                }
            });
            timerEnvio.start();
        }
    }

    private static void tratarImportadorPardini(final String filial) {
        if (timerImportador == null && !Funcoes.textoVazio(filial)) {
            timerImportador = new Timer(60000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int hoje = Calendar.getInstance().get(5);
                    Calendar hora = Calendar.getInstance();
                    hora.set(Calendar.getInstance().get(1), Calendar.getInstance().get(2), Calendar.getInstance().get(5), horaImportar, minutoImportar);
                    if (diaUltimaExecucaoHP != hoje && Calendar.getInstance().getTime().after(hora.getTime())) {
                        diaUltimaExecucaoHP = hoje;
                        boolean isOk = Servidor.atualizadorPardini(filial);
                        if (!isOk) {
                            intervalo = new Timer(300000, new ActionListener(){
                                int contaTentativas = 0;

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    boolean isOk = Servidor.atualizadorPardini(filial);
                                    if (isOk || this.contaTentativas == 3) {
                                        intervalo.stop();
                                        this.contaTentativas = 0;
                                    } else {
                                        ++this.contaTentativas;
                                    }
                                }
                            });
                            intervalo.start();
                        }
                    }
                }
            });
            timerImportador.start();
        }
    }

    protected static boolean verificarLotes(String filial) {
        Statement st = Conexao.getStatementTratandoShutdown();
        StringBuilder buf = new StringBuilder();
        buf.append("select distinct mll.fil_codigo, mll.mll_codigo, m.mat_codigo, m.mat_descricao, mll.mll_datalote, mll.mll_validadelote, m.mat_diasavisolote, m.mat_avisarvalidadelote, mu.usr_codigo, mll.mll_lote, mll.mll_quantidade, mll.mll_quantidadeconsumida ");
        buf.append(" from materiallote mll");
        buf.append(" inner join material m on (mll.fil_codigo = m.fil_codigo and mll.mat_codigo = m.mat_codigo) ");
        buf.append(" inner join materialusuario mu on (m.fil_codigo = mu.fil_codigo and m.mat_codigo = mu.mat_codigo)");
        buf.append(" where mll.fil_codigo = ").append(filial).append(" and m.mat_avisarvalidadelote");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                if (!rs.getBoolean("mat_avisarvalidadelote")) continue;
                Integer diasAviso = rs.getInt("mat_diasavisolote");
                Date dataLote = rs.getDate("mll_datalote");
                Calendar c2 = Calendar.getInstance();
                c2.setTime(rs.getDate("mll_validadelote"));
                java.util.Date dataVencimento = c2.getTime();
                Calendar c = Calendar.getInstance();
                c.setTime(new java.util.Date());
                c.add(5, diasAviso);
                java.util.Date dataAtualizado = c.getTime();
                double quantidade = Double.valueOf(rs.getString("mll_quantidade")) - Double.valueOf(rs.getString("mll_quantidadeconsumida"));
                if (dataAtualizado.compareTo(dataVencimento) < 0 || !(quantidade > 0.0)) continue;
                NovaMensagem novaMensagem = new NovaMensagem(Laboratorio.getInstancia());
                StringBuilder bu = new StringBuilder();
                bu.append("Verifique o lote ");
                bu.append(rs.getString("mll_lote"));
                bu.append(" do material ");
                bu.append(rs.getString("mat_descricao"));
                bu.append(" com data de validade ");
                bu.append(Funcoes.formataData("dd/MM/yyyy", rs.getDate("mll_validadelote")));
                NovaMensagem.enviarMensagem(false, Conexao.getStatementTratandoShutdown(), rs.getString("fil_codigo"), usuarioVerificaVencimento, rs.getString("usr_codigo"), "Validade de lote", StringUtil.textoDB(bu.toString()), false, "E");
                try {
                    Statement st2 = Conexao.getStatementTratandoShutdown();
                    Servidor.inserirLog(st2, rs.getString("fil_codigo"));
                    Servidor.inserirLogValidaLoteMaterial(st2, rs.getString("fil_codigo"), rs.getString("mll_codigo"), rs.getString("usr_codigo"));
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return true;
    }

    private static void inserirLogValidaLoteMaterial(Statement st, String codigoFilial, String loteMaterial, String codigoUsuario) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("insert into logvalidalotematerial(fil_codigo, mll_codigo, usr_codigo) values (");
        buf.append(codigoFilial).append(",");
        buf.append(loteMaterial).append(",");
        buf.append(StringUtil.textoDBEscape(codigoUsuario)).append(")");
        Conexao.executeUpdate(codigoFilial, st, buf.toString());
    }

    private static void inserirLog(Statement st, String codigoFilial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("insert into logvalidalote(lvl_datahora, fil_codigo) values (");
        buf.append("'").append(Funcoes.formataData("yyyy/MM/dd hh:mm:sss", new java.util.Date())).append("',");
        buf.append(codigoFilial).append(")");
        Conexao.executeUpdate(codigoFilial, st, buf.toString());
    }

    protected static boolean atualizadorPardini(String filialMatriz) {
        timerImportador.setDelay(600000);
        Statement st = Conexao.getStatementTratandoShutdown();
        class LabExterno {
            Integer codigo;
            String usuario;
            String senha;
            String configuracao;
            boolean isAtualizarAutomatico;

            public LabExterno(Integer codigo, String usuario, String senha, String configuracao, boolean isAtualizar) {
                this.codigo = codigo;
                this.usuario = usuario;
                this.senha = senha;
                this.configuracao = configuracao;
                this.isAtualizarAutomatico = isAtualizar;
            }
        }
        ArrayList<LabExterno> listaLaboratorios = new ArrayList<LabExterno>();
        StringBuilder buf = new StringBuilder();
        buf.append("select lae_codigo, lae_configuracao from labexterno where fil_codigo = ").append(filialMatriz).append(" and ");
        buf.append(" lae_protocolo = '").append(Protocolo.HPardini.toString()).append("' ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                String configuracao = rs.getString("lae_configuracao");
                String usuario = StringUtil.getValor(configuracao, "codigoProtocolo");
                String senha = StringUtil.getValor(configuracao, "senhaWeb");
                String atualizaAutomatico = StringUtil.getValor(configuracao, "atualizacaoAutomaticaListaExames");
                Boolean isAtualizacaAutomatico = !Funcoes.textoVazio(atualizaAutomatico) ? Boolean.parseBoolean(atualizaAutomatico) : false;
                if (Funcoes.textoVazio(configuracao) || Funcoes.textoVazio(usuario) || Funcoes.textoVazio(senha)) continue;
                LabExterno lab = new LabExterno(rs.getInt("lae_codigo"), usuario, senha, configuracao, isAtualizacaAutomatico);
                listaLaboratorios.add(lab);
            }
            rs.close();
        }
        catch (SQLException ex1) {
            Conexao.fecharStatement(st);
            Servidor.escreveLog(ex1.getMessage() + "\n" + ex1.getStackTrace());
            return false;
        }
        for (LabExterno lab : listaLaboratorios) {
            if (!lab.isAtualizarAutomatico) continue;
            ImportacaoHPardini importador = new ImportacaoHPardini(lab.codigo, lab.configuracao);
            File xml = Servidor.baixaArquivo(new Autenticador(lab.usuario, lab.senha));
            if (xml != null) {
                try {
                    String xmlTabela = Servidor.lerArquivoTexto(new FileInputStream(xml));
                    if (!importador.importaArquivo(xmlTabela, null, String.valueOf(filialMatriz))) continue;
                    new LabExternoService().atualizaDataUltimaImportacaoExamesAutomatico(String.valueOf(filialMatriz), lab.codigo);
                    LogImportacaoLabExternoBean importacaoLabExternoBean = new LogImportacaoLabExternoBean();
                    importacaoLabExternoBean.setFil_codigo(Integer.parseInt(filialMatriz));
                    importacaoLabExternoBean.setLae_codigo(lab.codigo);
                    java.util.Date dataHora = Funcoes.getDataSemErrorLogger("dd/MM/yyyy HH:mm:ss", Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new java.util.Date()));
                    importacaoLabExternoBean.setLil_datahora(dataHora);
                    importacaoLabExternoBean.setLil_log(importador.getRetornoExportacao().replaceAll("\\t", ""));
                    new LogImportacaoLabExternoService().insert(importacaoLabExternoBean, null, String.valueOf(filialMatriz), null);
                    Conexao.arquivaSQL();
                    continue;
                }
                catch (FileNotFoundException e) {
                    try {
                        NovaMensagem.enviarMensagem(st, usuarioAvisar, usuarioAvisar, "N\u00e3o foi possivel importar exames H. Pardini", e.getMessage(), false);
                        Conexao.arquivaSQL();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    return false;
                }
                catch (InterruptedException e) {
                    try {
                        NovaMensagem.enviarMensagem(st, usuarioAvisar, usuarioAvisar, "N\u00e3o foi possivel importar exames H. Pardini", e.getMessage(), false);
                        Conexao.arquivaSQL();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    return false;
                }
                catch (Exception e) {
                    Servidor.mensagem(e.getMessage());
                    try {
                        NovaMensagem.enviarMensagem(st, usuarioAvisar, usuarioAvisar, "N\u00e3o foi possivel importar exames H. Pardini", e.getMessage(), false);
                        Conexao.arquivaSQL();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    return false;
                }
            }
            try {
                Statement st2 = Conexao.getStatementTratandoShutdown();
                NovaMensagem.enviarMensagem(st2, usuarioAvisar, usuarioAvisar, "N\u00e3o foi possivel importar exames H. Pardini", "O download do arquivo n\u00e3o foi realizado.", false);
                Conexao.arquivaSQL();
                st2.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Conexao.fecharStatement(st);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String lerArquivoTexto(InputStream input) {
        try {
            StringBuilder str = new StringBuilder();
            byte[] buffer = new byte[1024];
            int size = input.read(buffer);
            while (size > -1) {
                str.append(new String(buffer, 0, size, "ISO-8859-1"));
                size = input.read(buffer);
            }
            String string = str.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            Statement st2 = Conexao.getStatementTratandoShutdown();
            try {
                NovaMensagem.enviarMensagem(st2, usuarioAvisar, usuarioAvisar, "N\u00e3o foi possivel importar exames H. Pardini", "Leitura do arquivo n\u00e3o realizada.", false);
                Conexao.arquivaSQL();
                st2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return "";
    }

    private static File baixaArquivo(Autenticador aut) {
        Authenticator.setDefault(aut);
        URL url = null;
        URLConnection con = null;
        try {
            url = new URL("http://www.hermespardini.com.br/cal/tabexalhpV3.xml");
            con = url.openConnection();
            con.connect();
            con.getInputStream().available();
        }
        catch (IOException e1) {
            Servidor.escreveLog("N\u00e3o foi poss\u00edvel fazer o download do arquivo." + e1.getMessage());
            return null;
        }
        FileOutputStream newFile = null;
        File arquivo = null;
        try {
            arquivo = File.createTempFile("tabelaPardini", ".xml");
            newFile = new FileOutputStream(arquivo);
            int c = 0;
            while ((c = con.getInputStream().read()) != -1) {
                newFile.write(c);
            }
            newFile.close();
        }
        catch (FileNotFoundException e) {
            Servidor.escreveLog("N\u00e3o foi poss\u00edvel localizar o arquivo para leitura." + e.getMessage());
            return null;
        }
        catch (IOException e) {
            Servidor.escreveLog("N\u00e3o foi poss\u00edvel gravar o arquivo." + e.getMessage());
            if (arquivo != null && arquivo.exists() && arquivo.length() == 0L) {
                arquivo.delete();
            }
            return null;
        }
        if (arquivo != null && arquivo.exists() && arquivo.length() > 0L) {
            return arquivo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean monitor() {
        Statement st = Conexao.getStatementTratandoShutdown();
        ArrayList<Integer> listaFiliais = new ArrayList<Integer>();
        StringBuilder buf = new StringBuilder();
        buf.append("select fil_codigo from filiais_postocoleta ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                listaFiliais.add(rs.getInt("fil_codigo"));
            }
            Collections.sort(listaFiliais);
            rs.close();
        }
        catch (SQLException ex1) {
            Conexao.fecharStatement(st);
            Servidor.escreveLog(ex1.getMessage() + "\n" + ex1.getStackTrace());
            return false;
        }
        try {
            int qtde = Servidor.getQuantidadeLogEmail(st);
            if (qtde >= limite_monitor) {
                Servidor.enviaEmailMonitor(st, "EMAIL", qtde, (Integer)listaFiliais.get(0));
            }
            if ((qtde = Servidor.getQuantidadeLogWeb(st)) >= limite_monitor) {
                Servidor.enviaEmailMonitor(st, "WEB", qtde, (Integer)listaFiliais.get(0));
            }
            if ((qtde = Servidor.getQuantidadeLogHospitais(st)) >= limite_monitor) {
                Servidor.enviaEmailMonitor(st, "HOSPITAL", qtde, (Integer)listaFiliais.get(0));
            }
            if ((qtde = Servidor.getQuantidadeLogSms(st)) >= limite_monitor) {
                Servidor.enviaEmailMonitor(st, "SMS", qtde, (Integer)listaFiliais.get(0));
            }
            for (Integer codigoFilial : listaFiliais) {
                qtde = Servidor.getQuantidadeLogIntegracaoOffline(st, codigoFilial);
                if (qtde < limite_monitor) continue;
                Servidor.enviaEmailMonitor(st, "INTEGRACAO OFFLINE", qtde, codigoFilial);
            }
        }
        catch (Exception e) {
            boolean bl;
            try {
                Conexao.fecharStatement(st);
                Servidor.escreveLog(e.getMessage() + "\n" + e.getStackTrace());
                bl = false;
            }
            catch (Throwable throwable) {
                if (Conexao.getConnected()) {
                    Conexao.fecharStatement(st);
                    Conexao.shutdown();
                }
                throw throwable;
            }
            if (Conexao.getConnected()) {
                Conexao.fecharStatement(st);
                Conexao.shutdown();
            }
            return bl;
        }
        if (Conexao.getConnected()) {
            Conexao.fecharStatement(st);
            Conexao.shutdown();
        }
        return true;
    }

    private static int getQuantidadeLogIntegracaoOffline(Statement st, Integer filial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select count(*) as qtde from logoffline ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("\t and not off_exportado");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("qtde");
        }
        return 0;
    }

    private static int getQuantidadeLogSms(Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select count(*) as qtde from logsms ");
        buf.append(" where sms_situacao in ('").append("E").append("', '").append("F").append("') ");
        buf.append("    or sms_dataenvio is null");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("qtde");
        }
        return 0;
    }

    private static int getQuantidadeLogWeb(Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select count(*) as qtde from exportaweb ");
        buf.append(" where not ewe_exportado ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("qtde");
        }
        return 0;
    }

    private static int getQuantidadeLogEmail(Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select count(*) as qtde from logemail ");
        buf.append(" where  ema_situacao in ('").append("E").append("', '").append("F").append("') ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("qtde");
        }
        return 0;
    }

    private static int getQuantidadeLogHospitais(Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select count(*) as qtde from exportaintegracaohospital ");
        buf.append(" where not eih_exportado ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("qtde");
        }
        return 0;
    }

    public static void enviaEmailMonitor(Statement st, String exportacao, int quantidadeLogs, Integer codigoFilial) throws SQLException {
        String razao = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select fil.fil_razaosocial, cid.cid_nome ");
        buf.append("from filiais_postocoleta fil ");
        buf.append("left join cidades cid on fil.fil_codigo = cid.fil_codigo ");
        buf.append("\t\t\tand fil.cid_codigo = cid.cid_codigo ");
        buf.append("where fil.fil_codigo = ").append(codigoFilial);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            razao = codigoFilial + " - " + rs.getString("fil_razaosocial") + (!Funcoes.textoVazio(rs.getString("cid_nome")) ? " - " + rs.getString("cid_nome") : "");
        }
        rs.close();
        buf.delete(0, buf.length());
        buf.append("Verifique a exporta\u00e7\u00e3o: " + exportacao);
        buf.append("\n").append(razao);
        buf.append("\nData: ");
        buf.append(Funcoes.formataData("dd/MM/yyyy HH:mm", new java.util.Date()));
        buf.append("\nQuantidade de logs n\u00e3o enviados ultrapassa o limite: ").append(limite_monitor);
        buf.append("\nQuantidade de logs para enviar: ").append(quantidadeLogs);
        for (String email : emails_monitor) {
            if (Funcoes.textoVazio(email)) continue;
            ErrorLogger.enviarEmail(email, buf.toString(), "VERIFIQUE A EXPORTACAO JALIS (" + exportacao + ")", false);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            Servidor.tratarArgumentos(args);
            Variaveis.caminhoBanco = "jdbc:postgresql://" + numeroIP + "/jalis";
            if (executar) {
                if (horarioVerao) {
                    Funcoes.configurarHorarioVerao(true);
                }
                int limite = 0;
                Thread.sleep(tempoEspera * 1000);
                if (!ParametrosGerais.carregaParametros()) {
                    Servidor.mensagem("Nao foi possivel carregar parametros gerais.");
                    Servidor.mensagem(Conexao.getUltimoErro());
                } else {
                    Estacoes est = Estacoes.decodificar(ParametrosGerais.getEstacoes());
                    if (est == null) {
                        Servidor.mensagem("Erro ao decodificar chave do numero de estacoes.");
                    } else if (est.getCodigoCliente() != ParametrosGerais.getCodigoCliente()) {
                        Servidor.mensagem("O numero de cliente da chave e do banco de dados nao conferem.");
                    } else if (!Servidor.validaCodigoClienteCriptografado()) {
                        System.out.println("O numero de cliente da chave e do banco de dados nao conferem.");
                        System.exit(0);
                    } else {
                        limite = est.getQuantidadeEstacoes();
                        Servidor s = new Servidor(limite);
                        if (iniciarMonitoramento) {
                            Servidor.tratarMonitor();
                        }
                        if (importadorPardini) {
                            Servidor.tratarImportadorPardini(codigoFilialHP);
                        }
                        if (!Funcoes.isLinux()) {
                            while (!Thread.interrupted()) {
                                Thread.sleep(100L);
                            }
                        }
                    }
                    if (Conexao.getConnected()) {
                        Conexao.shutdown();
                    }
                }
            } else if (atualizarServidor) {
                SocketEstacao se = new SocketEstacao(numeroIP, 5000L);
                se.escreverMensagem(new Mensagem("servidor", "atualizar"));
                System.exit(0);
            } else if (exibirStatus) {
                Servidor.tratarStatus();
                System.exit(0);
            } else if (informacoes) {
                Servidor.tratarInformacoes();
                System.exit(0);
            } else if (fecharEstacao) {
                Servidor.tratarFecharEstacao();
                System.exit(0);
            } else if (atualizarLicenca) {
                System.out.println("...\nBuscando quantidade de licen\u00e7as dispon\u00edveis para o cliente informado.");
                ConsultaLicencaAPI api = new ConsultaLicencaAPI();
                String retorno = api.montaObjetoConsulta(codigoThread, codigoJalis);
                if (Servidor.trataRetornoConsultaAPI(retorno)) {
                    Servidor.atualizarServidor();
                    System.out.println("Licen\u00e7a atualizada com Sucesso!");
                    System.exit(0);
                } else {
                    System.exit(0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Servidor.escreveLog(e.getMessage() + "(733)");
        }
    }

    private static void atualizarServidor() {
        try {
            SocketEstacao estacao = new SocketEstacao(numeroIP, 5000L);
            estacao.escreverMensagem(new Mensagem("servidor", "atualizar"));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validarUso() {
        boolean retorno = true;
        Variaveis.caminhoBanco = "jdbc:postgresql://" + numeroIP + "/jalis";
        Statement st = Conexao.getStatementTratandoShutdown();
        try {
            StringBuilder buf = new StringBuilder("select par_dataatualizacao from parametros where par_dataatualizacao is null");
            ResultSet rs = Conexao.executeQuery(st, buf);
            boolean bl = retorno = !rs.next();
            if (retorno) {
                URL url = new URL("https://zero.thread.com.br/api.php?action=validaJalis&ect_id=1&hash=" + StringUtil.encriptar(ParametrosGerais.getCodigoCliente()) + "&v=" + ConstantesGerais.NRVERSAO);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String xml = "";
                while (rd.ready()) {
                    xml = xml + rd.readLine();
                }
                if (xml != null && xml.trim().length() > 0 && xml.indexOf("</rect>") > 0) {
                    retorno = false;
                    this.gravarParametros(st, null);
                } else {
                    this.gravarParametros(st, new java.util.Date());
                    retorno = true;
                }
            }
        }
        catch (Exception e) {
            retorno = true;
        }
        finally {
            if (Conexao.getConnected()) {
                Conexao.shutdown();
            }
        }
        return retorno;
    }

    private void gravarParametros(Statement st, java.util.Date data) {
        try {
            String sql = "update parametros set par_dataatualizacao = ";
            sql = data == null ? sql + "null" : sql + StringUtil.textoDBEscape(Funcoes.formataData("MM/dd/yyyy", data));
            Conexao.executeUpdate(Variaveis.filialPadrao, st, sql);
            Conexao.arquivaSQL();
        }
        catch (SQLException sqlex) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            System.out.println("Falha ao validar atualizacao");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTodosOIDs() {
        String comando = " delete from usuarioconectado ";
        Statement st = Conexao.getStatementTratandoShutdown();
        try {
            Conexao.executeUpdate(Variaveis.filialPadrao, st, comando);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                if (Conexao.getConnected()) {
                    Conexao.shutdown();
                }
                throw throwable;
            }
            Conexao.fecharStatement(st);
            if (Conexao.getConnected()) {
                Conexao.shutdown();
            }
        }
        Conexao.fecharStatement(st);
        if (Conexao.getConnected()) {
            Conexao.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adicionaOIDConectado(String oid, String usuario, String estacao, String filial) {
        if (oid == null || Funcoes.textoVazio(usuario)) {
            return;
        }
        StringBuilder bufUpdate = new StringBuilder();
        bufUpdate.append(" update usuarioconectado ");
        bufUpdate.append("    set usc_login = '").append(usuario).append("' ");
        bufUpdate.append("       ,usc_estacao = ").append(estacao);
        bufUpdate.append("       ,usc_datahora = null ");
        bufUpdate.append("       ,usc_filial = ").append(Funcoes.textoVazio(filial) ? "null" : filial);
        bufUpdate.append("  where usc_oid = ").append(oid);
        StringBuilder bufInsert = new StringBuilder();
        bufInsert.append(" insert into usuarioconectado ");
        bufInsert.append("            (usc_oid ");
        bufInsert.append("            ,usc_login ");
        bufInsert.append("            ,usc_estacao ");
        bufInsert.append("            ,usc_datahora ");
        bufInsert.append("            ,usc_filial) ");
        bufInsert.append("      values(").append(oid);
        bufInsert.append("            ,'").append(usuario).append("' ");
        bufInsert.append("            ,").append(estacao);
        bufInsert.append("            ,null ");
        bufInsert.append("            ,").append(Funcoes.textoVazio(filial) ? "null" : filial).append(") ");
        Statement st = Conexao.getStatementTratandoShutdown();
        try {
            int qtde = Conexao.executeUpdate(Variaveis.filialPadrao, st, bufUpdate.toString());
            if (qtde == 0) {
                Conexao.executeUpdate(Variaveis.filialPadrao, st, bufInsert.toString());
            }
            this.removeOIDsDesconectados(st);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                if (Conexao.getConnected()) {
                    Conexao.shutdown();
                }
                throw throwable;
            }
            Conexao.fecharStatement(st);
            if (Conexao.getConnected()) {
                Conexao.shutdown();
            }
        }
        Conexao.fecharStatement(st);
        if (Conexao.getConnected()) {
            Conexao.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOIDTabelaUsuarioConectado(String oid) {
        Statement st;
        block14: {
            if (oid == null) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" delete from usuarioconectado ");
            buf.append("  where usc_oid = ").append(oid);
            st = Conexao.getStatementTratandoShutdown();
            try {
                Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                Servidor.logar(e.getMessage(), e.getStackTrace());
                Servidor.debug("Erro ao remover OID do usuario:" + e.getMessage());
                if (!Conexao.getConnected()) break block14;
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception e1) {
                    Servidor.logar(e1.getMessage(), e1.getStackTrace());
                }
            }
        }
        try {
            this.removeOIDsDesconectados(st);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            block15: {
                try {
                    Servidor.logar(e.getMessage(), e.getStackTrace());
                    Servidor.debug("Erro OID conectados do usuario:" + e.getMessage());
                    if (!Conexao.getConnected()) break block15;
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception e1) {
                        Servidor.logar(e1.getMessage(), e1.getStackTrace());
                    }
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    if (Conexao.getConnected()) {
                        Conexao.shutdown();
                    }
                    throw throwable;
                }
            }
            Conexao.fecharStatement(st);
            if (Conexao.getConnected()) {
                Conexao.shutdown();
            }
        }
        Conexao.fecharStatement(st);
        if (Conexao.getConnected()) {
            Conexao.shutdown();
        }
    }

    private static void logar(String message, StackTraceElement[] e) {
        String arquivo = "/var/log/ServidorJalis" + Funcoes.formataData("ddMMyyyykkmmss", new java.util.Date()) + ".error";
        try {
            StringUtil.escreverArquivoTexto(arquivo, Servidor.stackToText(message, e));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String stackToText(String message, StackTraceElement[] e) {
        StringBuilder b = new StringBuilder(message == null ? "" : message);
        b.append("\n");
        for (StackTraceElement ee : e) {
            b.append(ee.getClassName()).append(".").append(ee.getMethodName()).append("(").append(ee.getLineNumber()).append(")\n");
        }
        return b.toString();
    }

    private void removeOIDsDesconectados(Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from usuarioconectado ");
        buf.append("  where usc_oid not in (select ").append(nomeColunaTabelaProcessos);
        buf.append("                          from pg_catalog.pg_stat_get_activity(null::integer)) ");
        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
    }

    private void verificaColunaTabelaProcessos() throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select * ");
        buf.append("   from pg_catalog.pg_stat_get_activity(null::integer) ");
        Statement st = Conexao.getStatementTratandoShutdown();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        block0: while (rs.next()) {
            ResultSetMetaData rsMetadata = rs.getMetaData();
            for (int i = 1; i <= rsMetadata.getColumnCount(); ++i) {
                if (rsMetadata.getColumnName(i).equalsIgnoreCase(COLUNA_PID)) {
                    nomeColunaTabelaProcessos = COLUNA_PID;
                    continue block0;
                }
                if (!rsMetadata.getColumnName(i).equalsIgnoreCase(COLUNA_PROCPID)) continue;
                nomeColunaTabelaProcessos = COLUNA_PROCPID;
                continue block0;
            }
        }
    }

    public static int getPorta() {
        return porta;
    }

    public static void setPorta(int p) {
        porta = p;
    }

    static {
        executar = true;
        iniciarMonitoramento = false;
        tempo_monitor = 10;
        limite_monitor = -1;
        proximaPosicao = -1;
        timerMonitor = null;
        importadorPardini = false;
        horaImportar = 0;
        minutoImportar = 0;
        codigoFilialHP = "";
        usuarioAvisar = "";
        timerImportador = null;
        intervalo = null;
        timerEnvio = null;
        diaUltimaExecucaoHP = 0;
        diaUltimaExecucaoVerficacaoLote = 0;
        codigoThread = "";
        codigoJalis = "";
        verificaMensagens = false;
        modoDebug = true;
        horarioVerao = false;
        porta = 4444;
        nomeColunaTabelaProcessos = null;
        validado = true;
    }

    class Agendamento {
        private java.util.Date dataHoraAgendamento = null;
        private ArrayList<String> estacoes = new ArrayList();

        public Agendamento(java.util.Date dataHoraAgendamento) {
            this.dataHoraAgendamento = dataHoraAgendamento;
        }

        public ArrayList<String> getEstacoes() {
            return this.estacoes;
        }

        public void adicionaEstacao(String estacao) {
            this.estacoes.add(estacao);
        }

        public void removeEstacao(String estacao) {
            for (String estacaoIt : this.estacoes) {
                if (!estacaoIt.equalsIgnoreCase(estacao)) continue;
                this.estacoes.remove(estacaoIt);
                break;
            }
        }

        public int getQuantidadeAgendamentos(String estacao) {
            int qtde = 0;
            for (String aux : this.estacoes) {
                if (aux.equalsIgnoreCase(estacao)) continue;
                ++qtde;
            }
            return qtde;
        }
    }

    class SalaAtendimento {
        private Integer codigoSalaAtendimento = null;
        private ArrayList<Agendamento> agendamentos = new ArrayList();

        public SalaAtendimento(Integer codigoSalaAtendimento) {
            this.codigoSalaAtendimento = codigoSalaAtendimento;
        }

        public ArrayList<Agendamento> getAgendamentos() {
            return this.agendamentos;
        }

        public void adicionaAgendamento(Agendamento agendamento) {
            this.agendamentos.add(agendamento);
        }
    }

    class ControleAgendamentos {
        ArrayList<SalaAtendimento> salasAtendimento = new ArrayList();

        ControleAgendamentos() {
        }

        /*
         * WARNING - void declaration
         */
        public void bloqueiaAgendamento(Integer codigoSalaAtendimento, java.util.Date dataHoraAgendamento, String estacao) {
            void var7_11;
            boolean adicionado = false;
            SalaAtendimento salaAux = null;
            for (SalaAtendimento salaAtendimento : this.salasAtendimento) {
                if (salaAtendimento.codigoSalaAtendimento.intValue() != codigoSalaAtendimento.intValue()) continue;
                salaAux = salaAtendimento;
                break;
            }
            if (salaAux == null) {
                salaAux = new SalaAtendimento(codigoSalaAtendimento);
                this.salasAtendimento.add(salaAux);
            }
            Agendamento agendamentoAux = null;
            for (Agendamento agendamento : salaAux.getAgendamentos()) {
                if (agendamento.dataHoraAgendamento.compareTo(dataHoraAgendamento) != 0) continue;
                agendamentoAux = agendamento;
                break;
            }
            if (agendamentoAux == null) {
                agendamentoAux = new Agendamento(dataHoraAgendamento);
                salaAux.adicionaAgendamento(agendamentoAux);
            }
            Object var7_9 = null;
            for (String estacaoIt : agendamentoAux.getEstacoes()) {
                if (!estacaoIt.equalsIgnoreCase(estacao)) continue;
                String string = estacaoIt;
                break;
            }
            if (var7_11 == null) {
                agendamentoAux.adicionaEstacao(estacao);
            }
        }

        public void liberaAgendamento(Integer codigoSalaAtendimento, java.util.Date dataHoraAgendamento, String estacao) {
            SalaAtendimento salaAux = null;
            for (SalaAtendimento sala : this.salasAtendimento) {
                if (sala.codigoSalaAtendimento.intValue() != codigoSalaAtendimento.intValue()) continue;
                salaAux = sala;
                break;
            }
            if (salaAux == null) {
                return;
            }
            Agendamento agendamentoAux = null;
            for (Agendamento agendamento : salaAux.getAgendamentos()) {
                if (agendamento.dataHoraAgendamento.compareTo(dataHoraAgendamento) != 0) continue;
                agendamentoAux = agendamento;
                break;
            }
            if (agendamentoAux == null) {
                return;
            }
            agendamentoAux.removeEstacao(estacao);
        }

        public void liberarTudoEstacao(String estacao) {
            for (SalaAtendimento sala : this.salasAtendimento) {
                for (Agendamento agendamento : sala.getAgendamentos()) {
                    agendamento.removeEstacao(estacao);
                }
            }
        }

        public int getQuantidadeAgendamentos(Integer codigoSalaAtendimento, java.util.Date dataHoraAgendamento, String estacao) {
            SalaAtendimento salaAux = null;
            for (SalaAtendimento sala : this.salasAtendimento) {
                if (sala.codigoSalaAtendimento.intValue() != codigoSalaAtendimento.intValue()) continue;
                salaAux = sala;
                break;
            }
            if (salaAux == null) {
                return 0;
            }
            for (Agendamento agendamento : salaAux.getAgendamentos()) {
                if (agendamento.dataHoraAgendamento.compareTo(dataHoraAgendamento) != 0) continue;
                return agendamento.getQuantidadeAgendamentos(estacao);
            }
            return 0;
        }
    }
}

