/*
 * Decompiled with CFR 0.152.
 */
package jalis.servidor;

import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Mensagem
implements Cloneable {
    private String id = "";
    private String acao = "";
    private Map<String, List<String>> itens = new LinkedHashMap<String, List<String>>();

    public static boolean validarPadrao(String str) {
        int estado = 0;
        block9: for (char c : str.toCharArray()) {
            switch (estado) {
                case 0: {
                    if (c == '[') {
                        estado = 1;
                        continue block9;
                    }
                    return false;
                }
                case 1: {
                    if (c == ']') {
                        estado = 2;
                        continue block9;
                    }
                    if (Character.isLetterOrDigit(c)) continue block9;
                    return false;
                }
                case 2: {
                    if (c == '!') {
                        estado = 3;
                        continue block9;
                    }
                    if (Character.isLetterOrDigit(c)) continue block9;
                    return false;
                }
                case 3: {
                    if (Character.isLetterOrDigit(c)) {
                        estado = 4;
                        continue block9;
                    }
                    return false;
                }
                case 4: {
                    if (c == '=') {
                        estado = 5;
                        continue block9;
                    }
                    if (Character.isLetterOrDigit(c)) continue block9;
                    return false;
                }
                case 5: {
                    if (c == '\\') {
                        estado = 6;
                        continue block9;
                    }
                    if (c == ';') {
                        estado = 3;
                        continue block9;
                    }
                    if (c != '[' && c != ']' && c != '=') continue block9;
                    return false;
                }
                case 6: {
                    estado = 5;
                }
            }
        }
        return estado == 3;
    }

    public static Mensagem parse(String str) {
        Mensagem msn = new Mensagem(null);
        if (Mensagem.validarPadrao(str)) {
            StringBuilder lex = new StringBuilder();
            String prop = "";
            ArrayList<String> vlrs = new ArrayList<String>();
            int estado = 0;
            block4: for (char c : str.toCharArray()) {
                switch (estado) {
                    case 0: {
                        if ("!]=,;".indexOf(c) > -1) {
                            if (c == ']') {
                                msn.id = lex.toString();
                            } else if (c == '!') {
                                msn.acao = lex.toString();
                            } else if (c == '=') {
                                prop = lex.toString();
                            } else if (c == ',' || c == ';') {
                                vlrs.add(lex.toString());
                                if (c == ';') {
                                    msn.itens.put(prop, vlrs);
                                    vlrs = new ArrayList();
                                }
                            }
                            lex.delete(0, lex.length());
                            continue block4;
                        }
                        if (c == '\\') {
                            estado = 1;
                            continue block4;
                        }
                        if (c == '[') continue block4;
                        lex.append(c);
                        continue block4;
                    }
                    case 1: {
                        lex.append(c);
                        estado = 0;
                    }
                }
            }
        }
        return msn;
    }

    public Mensagem(String id) {
        if (id != null && id.matches("\\w*")) {
            this.id = id;
        }
    }

    public Mensagem(String id, String acao) {
        if (id != null && id.matches("\\w*") && acao != null && acao.matches("\\w*")) {
            this.id = id;
            this.acao = acao;
        }
    }

    public void limpar() {
        this.itens.clear();
        this.acao = "";
    }

    public void limpar(String id) {
        if (id != null && id.matches("\\w*")) {
            this.id = id;
        }
        this.itens.clear();
        this.acao = "";
    }

    public void limpar(String id, String acao) {
        if (id != null && id.matches("\\w*") && acao != null && acao.matches("\\w*")) {
            this.id = id;
            this.acao = acao;
        }
        this.itens.clear();
    }

    public void setAcao(String acao) {
        if (acao != null && acao.matches("\\w*")) {
            this.acao = acao;
        }
    }

    public boolean mesmoID(String id) {
        return id == null ? false : this.id.equals(id);
    }

    public boolean mesmaAcao(String acao) {
        return acao == null ? false : this.acao.equals(acao);
    }

    public boolean contemItem(String item) {
        return this.itens.containsKey(item);
    }

    public Set<String> getItens() {
        return this.itens.keySet();
    }

    public List<String> getList(String item) {
        ArrayList valor = this.itens.get(item);
        return valor == null ? new ArrayList() : valor;
    }

    public String getString(String item) {
        List<String> list = this.itens.get(item);
        return list != null && list.size() > 0 ? list.get(0) : "";
    }

    public List<String> setList(String item, List<String> valores) {
        ArrayList<String> list = new ArrayList<String>(valores);
        if (item != null) {
            this.itens.put(item, list);
        }
        return list;
    }

    public void setString(String item, String valor) {
        if (item != null && valor != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(valor);
            this.itens.put(item, tmp);
        }
    }

    public String toString() {
        StringBuilder bui = new StringBuilder("[");
        bui.append(this.id);
        bui.append(']');
        bui.append(this.acao);
        bui.append('!');
        for (String item : this.itens.keySet()) {
            bui.append(item);
            bui.append('=');
            List<String> list = this.itens.get(item);
            if (list != null) {
                ListIterator<String> itr = list.listIterator();
                while (itr.hasNext()) {
                    if (itr.hasPrevious()) {
                        bui.append(',');
                    }
                    bui.append(StringUtil.adicionarBarrasEscape(itr.next(), "[]=,;\\"));
                }
            }
            bui.append(';');
        }
        return bui.toString();
    }
}

