/*
 * Decompiled with CFR 0.152.
 */
package jalis.servidor;

import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.laboratorio.Laboratorio;
import jalis.servidor.ConsultaLicencaObject;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class ConsultaLicencaAPI {
    private final String URL = "https://zero.thread.com.br/api/licenca";

    private String executarConsultaLicenca(ConsultaLicencaObject consulta) throws IOException {
        HttpURLConnection conn = null;
        StringBuilder response = new StringBuilder();
        try {
            String inputLine;
            URL url = new URL("https://zero.thread.com.br/api/licenca");
            ObjectMapper mapper = new ObjectMapper();
            String jsonLicenca = mapper.writeValueAsString((Object)consulta);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            OutputStream os = conn.getOutputStream();
            os.write(jsonLicenca.getBytes());
            os.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        catch (MalformedURLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "URL de envio de Consulta inv\u00e1lida. Favor verificar.\n" + e.getMessage(), e.getStackTrace());
        }
        catch (ConnectException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar ao servi\u00e7o. \n" + e.getMessage(), e.getStackTrace());
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Ocorreu uma situa\u00e7\u00e3o inesperada ao fazer a consulta.\n" + e.getMessage(), e.getStackTrace());
        }
        return response.toString();
    }

    public String montaObjetoConsulta(String codigoThread, String codigoJalis) throws IOException {
        ConsultaLicencaObject consulta = new ConsultaLicencaObject();
        consulta.setCodigoThread(codigoThread);
        consulta.setCodigoJalis(Funcoes.preencheZero(codigoJalis, 3));
        return this.executarConsultaLicenca(consulta);
    }
}

