/*
 * Decompiled with CFR 0.152.
 */
package jalis.servidor;

import jalis.servidor.ConexaoListener;
import jalis.servidor.Mensagem;
import jalis.servidor.SocketEstacao;
import jalis.servidor.SocketEstacaoListener;
import jalis.util.Funcoes;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;

public class ClienteWeb
implements SocketEstacaoListener,
Runnable,
Serializable {
    private Connection connection;
    private HashMap<String, String> hashMapPropsJalis = null;
    private SocketEstacao estacao;
    private String erroValidacao = "";
    private boolean online;
    private boolean revalidar = true;
    private final Object bloqueio = new Object();
    private EventListenerList listenerList = new EventListenerList();
    private String retorno = null;
    private boolean finalizaSistema = false;
    private static final int TIMEOUT = 5000;
    private static final int MAXIMO_TENTATIVAS_RECONEXAO = 18;

    public ClienteWeb(Connection connection, HashMap<String, String> hashMapPropsJalis) {
        this.connection = connection;
        this.hashMapPropsJalis = hashMapPropsJalis;
    }

    public void addLoginListener(ConexaoListener ouvinte) {
        this.listenerList.add(ConexaoListener.class, ouvinte);
    }

    public void removeLoginListener(ConexaoListener ouvinte) {
        this.listenerList.remove(ConexaoListener.class, ouvinte);
    }

    public boolean conectado() {
        return this.estacao != null;
    }

    public String getChaveEstacao() {
        return this.estacao == null ? "" : this.estacao.getChave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validar() throws UnknownHostException, IOException, SQLException {
        if (this.estacao != null) {
            SocketEstacao socketEstacao = this.estacao;
            synchronized (socketEstacao) {
                this.estacao.escreverMensagem(new Mensagem("conexao", "desconectar"));
                this.estacao.fechar();
            }
        }
        this.estacao = new SocketEstacao(this.hashMapPropsJalis.get("caminhoBanco"), 10000L);
        Mensagem msn = new Mensagem("conexao", "fechar");
        msn.setString("codigoestacao", this.hashMapPropsJalis.get("codigoEstacaoDescriptografado") == null ? "0" : this.hashMapPropsJalis.get("codigoEstacaoDescriptografado"));
        msn.setString("origem", this.hashMapPropsJalis.get("nomeEstacao") == null ? "" : this.hashMapPropsJalis.get("nomeEstacao"));
        this.estacao.escreverMensagem(msn);
        msn = this.estacao.lerMensagem();
        String oid = null;
        Connection connection = this.connection;
        Statement st = connection.createStatement();
        ResultSet rs = st.executeQuery(" select pg_backend_pid() as oid ");
        if (rs.next()) {
            oid = rs.getString("oid");
        }
        st.close();
        msn = new Mensagem("conexao", "validar");
        msn.setString("nomeestacao", this.hashMapPropsJalis.get("nomeEstacao") == null ? "" : this.hashMapPropsJalis.get("nomeEstacao"));
        msn.setString("chave", this.hashMapPropsJalis.get("chaveConexaoEstacao") == null ? "" : this.hashMapPropsJalis.get("chaveConexaoEstacao"));
        msn.setString("versaojalis", this.hashMapPropsJalis.get("versaoJalisWeb") + "-Web");
        msn.setString("versaojava", System.getProperty("java.version"));
        msn.setString("descricaoestacao", this.hashMapPropsJalis.get("nomeEstacao"));
        msn.setString("codigoestacao", this.hashMapPropsJalis.get("codigoEstacaoDescriptografado"));
        msn.setString("oid", oid == null ? "" : oid);
        this.estacao.escreverMensagem(msn);
        msn = this.estacao.lerMensagem();
        if (msn.mesmoID("conexao") && msn.mesmaAcao("validado")) {
            this.estacao.setChave(msn.getString("chave"));
            this.estacao.addSocketEstacaoListener(this);
            this.estacao.setLerEntrada(true);
        } else {
            if (msn.mesmaAcao("negado")) {
                this.erroValidacao = "O nome da esta\u00e7\u00e3o n\u00e3o foi definido";
            } else if (msn.mesmaAcao("excedido")) {
                this.erroValidacao = "O limite de conex\u00f5es simult\u00e2neas contratado foi excedido.";
            } else if (msn.mesmaAcao("duplicado")) {
                this.erroValidacao = "A esta\u00e7\u00e3o \"" + this.hashMapPropsJalis.get("nomeEstacao") + "\" j\u00e1 est\u00e1 conectada.";
            }
            this.estacao.fechar();
            this.estacao = null;
        }
        return this.estacao != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logar() {
        if (this.conectado() && this.hashMapPropsJalis.get("nomeUsuario") != null && this.hashMapPropsJalis.get("nomeUsuario").trim().length() > 0) {
            Object object = this.bloqueio;
            synchronized (object) {
                this.online = true;
                Mensagem msn = new Mensagem("usuario", "login");
                msn.setString("usuario", this.hashMapPropsJalis.get("nomeUsuario"));
                msn.setString("filial", this.hashMapPropsJalis.get("filialPadrao"));
                this.estacao.escreverMensagem(msn);
                msn.limpar("usuario", "estacoes");
                this.estacao.escreverMensagem(msn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deslogar() {
        if (this.conectado()) {
            Object object = this.bloqueio;
            synchronized (object) {
                this.online = false;
                this.hashMapPropsJalis.put("nomeUsuario", null);
                this.estacao.escreverMensagem(new Mensagem("usuario", "logout"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean desconectar() {
        if (this.estacao != null) {
            SocketEstacao socketEstacao = this.estacao;
            synchronized (socketEstacao) {
                try {
                    this.estacao.escreverMensagem(new Mensagem("conexao", "desconectar"));
                    this.estacao.wait(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return this.retorno != null && this.retorno.equalsIgnoreCase("desconectar");
                {
                }
            }
        }
        return false;
    }

    public void atualizarServidor() {
        try {
            if (this.estacao == null) {
                this.estacao = new SocketEstacao(this.hashMapPropsJalis.get("caminhoBanco"), 10000L);
            }
            this.estacao.escreverMensagem(new Mensagem("servidor", "atualizar"));
        }
        catch (Exception e) {
            this.estacao = null;
        }
    }

    public String getErroValidacao() {
        return this.erroValidacao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void estacaoDesconectou(SocketEstacao estacao) {
        Object object = this.bloqueio;
        synchronized (object) {
            estacao.removeSocketEstacaoListener(this);
            estacao.fechar();
            this.estacao = null;
        }
        if (this.revalidar) {
            new Thread(this).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leuMensagem(SocketEstacao estacao, Mensagem msn) {
        if (msn.mesmoID("bloquear")) {
            estacao.avisarBloqueio();
        } else if (msn.mesmoID("liberar")) {
            estacao.avisarLiberacao();
        } else if (msn.mesmoID("usuario")) {
            Object list;
            if (msn.mesmaAcao("estacoes")) {
                list = msn.getList("estacoes");
                while (list.size() > 0 && list.get(0).length() == 0) {
                    list.remove(0);
                }
                if (list.size() > 0) {
                    this.fireUsuarioLogadoEmOutraEstacao((List<String>)list);
                }
            } else if (msn.mesmaAcao("offline")) {
                list = this.bloqueio;
                synchronized (list) {
                    this.online = false;
                }
            }
        } else if (msn.mesmoID("conexao")) {
            if (msn.mesmaAcao("fechar")) {
                this.revalidar = false;
                this.desconectar();
                StringBuilder bui = new StringBuilder("O sistema ser\u00e1 fechado");
                String origem = msn.getString("origem");
                if (origem.equals("nomeestacao")) {
                    bui.append(": A esta\u00e7\u00e3o ").append(this.hashMapPropsJalis.get("nomeEstacao")).append(" foi conectada em outro computador.");
                } else if (origem.equals("administrador")) {
                    bui.append(": Opera\u00e7\u00e3o solicitada pelo administrador.");
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.finalizaSistema = true;
            } else if (msn.mesmaAcao("desconectar")) {
                this.retorno = "desconectar";
            }
        } else if (msn.mesmoID("agendamento")) {
            if (msn.mesmaAcao("acaoquantidade")) {
                this.retorno = msn.getString("quantidade");
            }
        } else if (msn.mesmoID("dataHoraServidor")) {
            this.retorno = msn.getString("valor");
        }
        SocketEstacao socketEstacao = estacao;
        synchronized (socketEstacao) {
            estacao.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQuantidadeAgendamentos(Integer codigoSalaAtendimento, Date dataHoraAgendamento) {
        this.retorno = null;
        if (this.conectado() && codigoSalaAtendimento != null && dataHoraAgendamento != null) {
            Mensagem msn = new Mensagem("agendamento", "acaoquantidade");
            msn.setString("sala", codigoSalaAtendimento.toString());
            msn.setString("datahora", Funcoes.formataData("dd/MM/yyyy HH:mm", dataHoraAgendamento));
            SocketEstacao socketEstacao = this.estacao;
            synchronized (socketEstacao) {
                try {
                    this.estacao.escreverMensagem(msn);
                    this.estacao.wait(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.retorno == null || !Funcoes.isNumeric(this.retorno)) {
                this.retorno = "0";
            }
            Integer qtde = Integer.parseInt(this.retorno);
            return qtde;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataServidor() {
        this.retorno = null;
        if (this.conectado()) {
            Mensagem msn = new Mensagem("dataHoraServidor", "getData");
            msn.setString("valor", Funcoes.formataData("dd/MM/yyyy", new Date()));
            SocketEstacao socketEstacao = this.estacao;
            synchronized (socketEstacao) {
                try {
                    this.estacao.escreverMensagem(msn);
                    this.estacao.wait(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return this.retorno;
        }
        return this.retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHoraServidor() {
        this.retorno = null;
        if (this.conectado()) {
            Mensagem msn = new Mensagem("dataHoraServidor", "getHora");
            msn.setString("valor", Funcoes.formataData("HH:mm:ss", new Date()));
            SocketEstacao socketEstacao = this.estacao;
            synchronized (socketEstacao) {
                try {
                    this.estacao.escreverMensagem(msn);
                    this.estacao.wait(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return this.retorno;
        }
        return this.retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataHoraServidor() {
        if (this.conectado()) {
            Mensagem msn = new Mensagem("dataHoraServidor", "getDataHora");
            msn.setString("valor", Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date()));
            SocketEstacao socketEstacao = this.estacao;
            synchronized (socketEstacao) {
                try {
                    this.estacao.escreverMensagem(msn);
                    this.estacao.wait(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (Funcoes.textoVazio(this.retorno)) {
                return Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date());
            }
            return this.retorno;
        }
        return this.retorno;
    }

    public void bloqueiaHorario(Integer codigoSalaAtendimento, Date dataHoraAgendamento) {
        if (this.conectado() && codigoSalaAtendimento != null && dataHoraAgendamento != null) {
            Mensagem msn = new Mensagem("agendamento", "acaobloqueia");
            msn.setString("sala", codigoSalaAtendimento.toString());
            msn.setString("datahora", Funcoes.formataData("dd/MM/yyyy HH:mm", dataHoraAgendamento));
            this.estacao.escreverMensagem(msn);
        }
    }

    public void liberaHorario(Integer codigoSalaAtendimento, Date dataHoraAgendamento) {
        if (this.conectado() && codigoSalaAtendimento != null && dataHoraAgendamento != null) {
            Mensagem msn = new Mensagem("agendamento", "acaolibera");
            msn.setString("sala", codigoSalaAtendimento.toString());
            msn.setString("datahora", Funcoes.formataData("dd/MM/yyyy HH:mm", dataHoraAgendamento));
            this.estacao.escreverMensagem(msn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int tentativas = 1;
            while (!Thread.interrupted() && this.estacao == null && tentativas <= 18) {
                try {
                    this.estacao = new SocketEstacao(this.hashMapPropsJalis.get("caminhoBanco"), 10000L);
                }
                catch (Exception e) {
                    ++tentativas;
                }
                Thread.sleep(10000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.estacao == null) {
            this.fireErroAoRestabelecerConexao();
        } else if (!this.finalizaSistema) {
            Object object = this.bloqueio;
            synchronized (object) {
                String oid = null;
                Statement st = null;
                try {
                    st = this.connection.createStatement();
                    ResultSet rs = st.executeQuery(" select pg_backend_pid() as oid ");
                    if (rs.next()) {
                        oid = rs.getString("oid");
                    }
                }
                catch (Exception rs) {
                }
                finally {
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException rs) {}
                }
                Mensagem msn = new Mensagem("conexao", "revalidar");
                msn.setString("nomeestacao", this.hashMapPropsJalis.get("nomeEstacao"));
                msn.setString("chave", this.estacao.getChave());
                msn.setString("versaojalis", this.hashMapPropsJalis.get("versaoJalisWeb"));
                msn.setString("versaojava", System.getProperty("java.version"));
                msn.setString("descricaoestacao", this.hashMapPropsJalis.get("nomeEstacao"));
                msn.setString("codigoestacao", this.hashMapPropsJalis.get("codigoEstacaoDescriptografado"));
                msn.setString("oid", oid);
                if (this.hashMapPropsJalis.get("nomeUsuario") != null) {
                    List<String> list = msn.setList("usuario", new ArrayList<String>());
                    list.add(this.hashMapPropsJalis.get("nomeUsuario"));
                    if (this.online) {
                        list.add("online");
                    }
                }
                this.estacao.escreverMensagem(msn);
                msn = this.estacao.lerMensagem();
                if (msn.mesmoID("conexao") && msn.mesmaAcao("validado")) {
                    this.estacao.addSocketEstacaoListener(this);
                    this.estacao.setLerEntrada(true);
                } else {
                    this.fireErroAoRevalidarEstacao();
                }
            }
        }
    }

    private void fireUsuarioLogadoEmOutraEstacao(List<String> estacoes) {
        for (ConexaoListener ouvinte : (ConexaoListener[])this.listenerList.getListeners(ConexaoListener.class)) {
            ouvinte.usuarioLogadoEmOutraEstacao(estacoes);
        }
    }

    private void fireErroAoRevalidarEstacao() {
        for (ConexaoListener ouvinte : (ConexaoListener[])this.listenerList.getListeners(ConexaoListener.class)) {
            ouvinte.erroAoRevalidarEstacao();
        }
    }

    private void fireErroAoRestabelecerConexao() {
        for (ConexaoListener ouvinte : (ConexaoListener[])this.listenerList.getListeners(ConexaoListener.class)) {
            ouvinte.erroAoRestabelecerConexao();
        }
    }

    public SocketEstacao getSocketEstacao() {
        return this.estacao;
    }
}

