/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.util.parsers.pardini;

import br.com.hermespardini.b2b.apoio.schemas.XMLServerSoapProxy;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.pardini.FiltroDataPardini;
import jalis.model.dao.util.parsers.pardini.ImportacaoResultadoHPardiniDao;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.model.vo.consultas.ConfiguracaoExameHPardiniVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JFileChooser;
import org.apache.axis.AxisFault;
import org.w3c.dom.Element;

public class ImportacaoResultadoHPardiniService {
    private ImportacaoResultadoHPardiniDao dao = new ImportacaoResultadoHPardiniDao();
    private boolean conferirAutomatico;
    private String codigoUsuarioConferenciaAutomatica;

    public String importarResultadoPDFWebServiceEmBase64(String xmlConfigLabExterno, String dataEmissaoLotePardini, ConfiguracaoExameHPardiniVO exame) {
        String codigoWebservice = StringUtil.getValor(xmlConfigLabExterno, "codigoProtocolo");
        String senhaWebservice = StringUtil.getValor(xmlConfigLabExterno, "senhaWeb");
        String ano = dataEmissaoLotePardini.substring(0, 4);
        long anoCodPedApoio = Long.valueOf(ano);
        String codPedApoio = exame.getCodPedApoio();
        String codExmApoio = this.convertConfigDeParaToCodExmApoio(exame.getConfigExameHPardini());
        String retornoHPardiniPDF = "";
        XMLServerSoapProxy proxy = new XMLServerSoapProxy();
        if (!Funcoes.textoVazio(codPedApoio) && !Funcoes.textoVazio(codExmApoio)) {
            try {
                retornoHPardiniPDF = proxy.getResultadoPedido(codigoWebservice, senhaWebservice, anoCodPedApoio, codPedApoio, codExmApoio, 2L);
            }
            catch (AxisFault e) {
                String mensagem = "";
                if (null != e.getFaultDetails()) {
                    Element[] elements;
                    for (Element el : elements = e.getFaultDetails()) {
                        if (null == el.getFirstChild() || el.getFirstChild().toString().length() <= 0) continue;
                        retornoHPardiniPDF = el.getFirstChild().toString();
                    }
                }
            }
            catch (RemoteException e) {
                retornoHPardiniPDF = e.getCause().toString();
            }
        }
        return retornoHPardiniPDF.contains("<PDF>") ? StringUtil.getValor(retornoHPardiniPDF, "PDF") : retornoHPardiniPDF;
    }

    private String convertConfigDeParaToCodExmApoio(String configExameDeParaHPardini) {
        String codExameHPardini = StringUtil.getValor(configExameDeParaHPardini, "codigo-exame");
        String codMaterialHPardini = StringUtil.getValor(configExameDeParaHPardini, "codigo-material");
        String numAmostraHPardini = StringUtil.getValor(configExameDeParaHPardini, "numero-amostra");
        numAmostraHPardini = Funcoes.textoVazio(numAmostraHPardini) ? "1" : numAmostraHPardini;
        return codMaterialHPardini.trim().concat("|").concat(codExameHPardini.trim()).concat("|").concat(numAmostraHPardini);
    }

    public void salvarResultadoPDF(ConfiguracaoExameHPardiniVO configExameHPardini, String resultadoPDFEmBase64, boolean conferirAutomatico, String codigoUsuarioConferenciaAutomatica) throws SQLException {
        if (!Funcoes.textoVazio(resultadoPDFEmBase64)) {
            this.dao.salvarResultadoPDF(configExameHPardini, resultadoPDFEmBase64);
            this.dao.atualizarExameRequisicao(configExameHPardini, conferirAutomatico, codigoUsuarioConferenciaAutomatica);
        }
    }

    public LabExternoVO pesquisarPorCodLabExterno(int codigoLabExterno) throws Exception {
        return this.dao.pesquisarPorCodLabExterno(codigoLabExterno);
    }

    public List<ConfiguracaoExameHPardiniVO> getExamesDesmembradosPDF(Registro reg) throws SQLException {
        return this.dao.pesquisarExamesDesmembradosNoLote(reg);
    }

    public String getResultadosWebServicePardini(LaboratorioExterno labExterno, FiltroDataPardini filtroDataPardini) throws Exception {
        String codigoWebservice = labExterno.configuracao.indexOf("codigoProtocolo") > 0 ? StringUtil.getValor(labExterno.configuracao, "codigoProtocolo") : null;
        String senhaWebservice = labExterno.configuracao.indexOf("senhaWeb") > 0 ? StringUtil.getValor(labExterno.configuracao, "senhaWeb") : null;
        String descricaoLabExterno = StringUtil.removerAcentos(labExterno.descricao).replaceAll(" ", "");
        XMLServerSoapProxy proxy = new XMLServerSoapProxy();
        XMLStringBuilder xml = this.gerarXML("1", codigoWebservice, filtroDataPardini);
        String retornoHPardini = proxy.getResultado(codigoWebservice, senhaWebservice, xml.toString());
        return retornoHPardini;
    }

    public void salvarArquivoImportadoNoDiretorioDoUsuario(String descricaoLabExterno, String retornoHPardini) throws Exception {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser("Salvar");
        chooser.setApproveButtonText("Salvar");
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("XML (*.xml)", "xml"));
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd HH-mm-ss");
        String nomeArquivo = sf.format(new Date());
        if (!Funcoes.diretorioExiste(System.getProperty("user.home") + "/resultados" + descricaoLabExterno)) {
            new File(System.getProperty("user.home") + "/resultados" + descricaoLabExterno).mkdirs();
        }
        File arquivo = new File(System.getProperty("user.home").toString() + "/resultados" + descricaoLabExterno + "/" + nomeArquivo + ".xml");
        chooser.setSelectedFile(arquivo);
        StringUtil.escreverArquivoTexto(chooser.getSelectedFile().getPath(), retornoHPardini);
    }

    private XMLStringBuilder gerarXML(String codigoID, String codigoConvenio, FiltroDataPardini filtroDataPardini) throws XMLStringBuilderException, ParseException {
        XMLStringBuilder xml = new XMLStringBuilder(true);
        xml.escreveHeader("1.0", "ISO-8859-1");
        xml.abrir("Consulta");
        xml.escrever("ID", codigoID);
        xml.escrever("Protocolo", "1");
        xml.abrir("SolicitaResultado");
        xml.escrever("CodLab", codigoConvenio);
        xml.escrever("Operacao", "Resultados");
        xml.escrever("Acao", "Mostra");
        xml.escrever("DataInicial", Funcoes.formataData("yyyy-MM-dd", filtroDataPardini.getDataInicial()));
        xml.escrever("HoraInicial", filtroDataPardini.getHoraInicial() + ":00");
        xml.escrever("DataFinal", Funcoes.formataData("yyyy-MM-dd", filtroDataPardini.getDataFinal()));
        xml.escrever("HoraFinal", filtroDataPardini.getHoraFinal() + ":00");
        xml.escrever("Grafico", filtroDataPardini.getGrafico());
        xml.escrever("UnidadeNoValor", filtroDataPardini.getUnidadeValor());
        xml.escrever("DadosConstantes", filtroDataPardini.getDadosConstante());
        xml.escrever("examesNaoEstruturadosLiberados", "1");
        xml.fechar("SolicitaResultado");
        xml.fechar("Consulta");
        return xml;
    }

    public void setConferirAutomatico(boolean conferirAutomatico) {
        this.conferirAutomatico = conferirAutomatico;
    }

    public void setCodigoUsuarioConferenciaAutomatica(String codigoUsuarioConferenciaAutomatica) {
        this.codigoUsuarioConferenciaAutomatica = codigoUsuarioConferenciaAutomatica;
    }

    public ExameDesmembrado getExameDesmembrado(String filial, String reqCodigo, String laeCodigo, String exaFilho, String mcoFilho) {
        ExameDesmembrado exmDesm = null;
        try {
            exmDesm = this.dao.pesquisarExameDesmembradoNoLote(filial, reqCodigo, laeCodigo, exaFilho, mcoFilho);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 261");
        }
        return exmDesm;
    }
}

