/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.util.parsers.db2;

import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.model.dao.util.parsers.db2.ImportacaoResultadoDBDao;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ImportacaoResultadoDBService {
    private final ImportacaoResultadoDBDao dao = new ImportacaoResultadoDBDao();

    public List<ExameDesmembrado> getExamesDesmembradosDB(String filial, String reqCodigo, String laeCodigo, String exaFilho, String mcoFilho) {
        return this.dao.pesquisarExamesDesmembradosDB(filial, reqCodigo, laeCodigo, exaFilho, mcoFilho);
    }

    public List<ExameDesmembrado> getExamesDesmembradosDBWS(String filial, String reqCodigo, String laeCodigo, String exaFilho, String mcoFilho) {
        return this.dao.pesquisarExamesDesmembradosDBWS(filial, reqCodigo, laeCodigo, exaFilho, mcoFilho);
    }

    public List<ExameDesmembrado> carregarDesmembradosPorLabExterno(String codFilial, int codigoLabExterno, List<ExameDesmembrado> desmembradosRequisicao) throws SQLException {
        ArrayList<ExameDesmembrado> desmembradosJalis = new ArrayList<ExameDesmembrado>();
        for (ExameDesmembrado exameDesmembrado : desmembradosRequisicao) {
            ExameDesmembrado desmembrado = this.dao.pesquisarExameDesmembradoPorExamePrincipal(codFilial, codigoLabExterno, exameDesmembrado);
            if (desmembrado.getFilhos().isEmpty()) continue;
            desmembradosJalis.add(desmembrado);
        }
        return desmembradosJalis;
    }

    public boolean removerResultadoParcial(Registro registroExame, Statement st) throws SQLException {
        FilialVO filial = new FilialVO();
        filial.setCodigo(registroExame.getInt("fil_codigo"));
        ExameVO exame = new ExameVO();
        exame.setCodigo(registroExame.getString("examePai"));
        MaterialColetaVO material = new MaterialColetaVO();
        material.setCodigo(registroExame.getInt("materialPai"));
        ExameRequisicaoVO exameReq = new ExameRequisicaoVO();
        exameReq.setFilial(filial);
        exameReq.setExame(exame);
        exameReq.setMaterial(material);
        exameReq.setRequisicao(registroExame.getInt("req_codigo"));
        return this.dao.atualizarExameRequisicaoRemoveResultadoParcial(st, exameReq);
    }

    public String pesquisarSituacaoExame(String codFilial, String codLabExterno, Integer[] multiguias, String codExame, String codMaterial) throws Exception {
        return this.dao.pesquisarSituacaoExame(codFilial, codLabExterno, multiguias, codExame, codMaterial);
    }

    public String buscaCodigoExameAssociado(String filCodigo, Integer[] multiguias, Registro exame) throws SQLException {
        return this.dao.buscaCodigoExameAssociado(filCodigo, multiguias, exame);
    }

    public String buscaCodigoExameAssociadoComDesm(String filCodigo, Integer[] multiguias, Registro exame) throws SQLException {
        return this.dao.buscaCodigoExameAssociadoComDesm(filCodigo, multiguias, exame);
    }
}

