/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.util.parsers.alvaro;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.parsers.alvaro.resultado.InformaPeriodoImportacaoAlvaro;
import jalis.model.dao.util.parsers.alvaro.ImportacaoResultadoAlvaroDao;
import jalis.model.vo.consultas.ConfiguracaoExameAlvaroVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFileChooser;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class ImportacaoResultadoAlvaroService {
    private final String TAG_RESULTADOS = "resultados";
    private final String TAG_ENTIDADE = "entidade";
    private final String TAG_SOLICITACAO = "solicitacao";
    private final String TAG_EXAME = "exame";
    private boolean conferirAutomatico;
    private String codigoUsuarioConferenciaAutomatica;
    private final ImportacaoResultadoAlvaroDao dao = new ImportacaoResultadoAlvaroDao();

    public String adicionarEnterNatagResultado(boolean adicionarEnterNaTagResultado, JFileChooser chooser) throws Exception {
        StringBuilder novoArquivo = new StringBuilder();
        String arquivo = StringUtil.lerArquivoTexto(chooser.getSelectedFile());
        if (adicionarEnterNaTagResultado) {
            String[] linhas = arquivo.split("/>");
            StringBuilder b = new StringBuilder();
            for (int j = 0; j < linhas.length; ++j) {
                b.setLength(0);
                b.append(linhas[j]);
                if (j != linhas.length - 1) {
                    b.append("/>");
                }
                int pos = -1;
                int pos2 = -1;
                pos = b.indexOf("<resultado");
                if (pos > 0 && (pos2 = b.indexOf(" resultado", pos)) > pos) {
                    String tmp;
                    int posAspasInicio = -1;
                    int posAspasFim = -1;
                    for (int i = pos2; i < b.length(); ++i) {
                        if (b.toString().charAt(i) != '\"') continue;
                        if (posAspasInicio == -1) {
                            posAspasInicio = i;
                            continue;
                        }
                        posAspasFim = i;
                        break;
                    }
                    if ((tmp = b.substring(posAspasInicio + 1, posAspasFim)).indexOf("&#xD;") < 0) {
                        tmp = tmp.replaceAll("\n", "&#xD;").replaceAll("\r", "");
                        b.delete(posAspasInicio + 1, posAspasFim);
                        b.insert(posAspasInicio + 1, tmp);
                    }
                }
                novoArquivo.append((CharSequence)b);
            }
        } else {
            novoArquivo.append(arquivo);
        }
        return novoArquivo.toString();
    }

    public List<ConfiguracaoExameAlvaroVO> getExamesPorPeriodo(InformaPeriodoImportacaoAlvaro periodoImportacao, boolean importaExameEmPDF) throws SQLException {
        return this.dao.pesquisarExamesLoteExterno(periodoImportacao, importaExameEmPDF);
    }

    public boolean exameImportadoEmPDFWebService(Registro reg) {
        return this.conferirAutomatico;
    }

    public byte[] solicitarResultadoAlvaro(LaboratorioExterno lab, String idAlvaro, boolean pdf, String codExameAlvaro, boolean solicitarValorRefencia) throws Exception {
        String agente = StringUtil.getValor(lab.configuracao, "agente");
        String senha = StringUtil.getValor(lab.configuracao, "senha");
        String codigo = StringUtil.getValor(lab.configuracao, "codigo");
        String urlResultados = StringUtil.getValor(lab.configuracao, "enderecoResultado");
        CloseableHttpClient httpClient = HttpClients.createDefault();
        URIBuilder uri = new URIBuilder(urlResultados, StandardCharsets.UTF_8);
        String autenticacao = this.getAutenticacao(agente, senha);
        HttpEntity entity = null;
        if (pdf) {
            String pathPDF = urlResultados.endsWith("/") ? "pdf" : "/pdf";
            urlResultados = urlResultados + pathPDF;
            uri = new URIBuilder(urlResultados, StandardCharsets.UTF_8);
            uri.addParameter("idEntidade", codigo);
            uri.addParameter("idOrdemServico", idAlvaro);
            uri.addParameter("exames", codExameAlvaro);
            HttpGet get = new HttpGet(uri.build());
            get.setHeader("Authorization", "Basic " + autenticacao);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            entity = response.getEntity();
        } else {
            uri.addParameter("anexoFormato", "PNG");
            uri.addParameter("responsavelTecnicoAssinatura", "true");
            uri.addParameter("referenciaResultado", "true");
            uri.addParameter("habilitaLocalCNES", "true");
            if (solicitarValorRefencia) {
                uri.addParameter("habilitaInformacoesComplementares", "true");
            }
            HttpPut put = new HttpPut(uri.build());
            put.setHeader("Authorization", "Basic " + autenticacao);
            put.setHeader("Content-type", "text/xml; charset=UTF-8");
            XMLStringBuilder xml = this.getXmlEnvio(Integer.valueOf(lab.codigoLab), idAlvaro);
            StringEntity jsonEntity = new StringEntity(xml.getXML(), "UTF-8");
            put.setEntity((HttpEntity)jsonEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)put);
            entity = response.getEntity();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (null != entity) {
            int bytesRead;
            InputStream inputStream = entity.getContent();
            byte[] documentoEmBytes = new byte[8192];
            baos = new ByteArrayOutputStream();
            while ((bytesRead = inputStream.read(documentoEmBytes)) != -1) {
                baos.write(documentoEmBytes, 0, bytesRead);
            }
        }
        return baos.toByteArray();
    }

    private String getAutenticacao(String agenteWebService, String passwd) {
        String autenticacao = agenteWebService.concat(":").concat(passwd);
        String autenticacaoCodificada = DatatypeConverter.printBase64Binary((byte[])autenticacao.getBytes(StandardCharsets.UTF_8));
        return autenticacaoCodificada;
    }

    public boolean resultadoSalvoEmPDF(Integer codFil, Integer codReq, String codExame, String codMaterial, byte[] resultado) throws SQLException {
        String situacaoExame = this.dao.pesquisarSituacaoExame(codFil, codReq, codExame, codMaterial);
        if (resultado.length > 0 && Funcoes.textoVazio(situacaoExame)) {
            this.dao.salvarResultadoPDF(codFil, codReq, codExame, codMaterial, resultado);
            this.dao.atualizarExameRequisicao(codFil, codReq, codExame, codMaterial, this.conferirAutomatico, this.codigoUsuarioConferenciaAutomatica);
            return true;
        }
        return false;
    }

    public String pesquisarSituacaoExame(String codFilial, String codLabExterno, Integer[] multiguias, String codExame, String codMaterial) throws Exception {
        return this.dao.pesquisarSituacaoExame(codFilial, codLabExterno, multiguias, codExame, codMaterial);
    }

    public HashMap<String, Integer> contarExamesDesmembradosComResultado(List<ConfiguracaoExameAlvaroVO> examesDesmPDF) {
        HashMap<String, Integer> examesDesmPDfComResultado = new HashMap<String, Integer>();
        String exameMaterial = "";
        Integer contadorExamesComResultado = 0;
        for (ConfiguracaoExameAlvaroVO exameDesm : examesDesmPDF) {
            String codReq = Funcoes.preencheZero(exameDesm.getCodFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(exameDesm.getCodRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            String codExameMaterial = codReq + "|" + exameDesm.getCodExame() + "|" + exameDesm.getCodMaterial();
            if (!exameMaterial.equals(codExameMaterial)) {
                contadorExamesComResultado = 0;
                exameMaterial = codExameMaterial;
            }
            Integer n = contadorExamesComResultado;
            Integer n2 = contadorExamesComResultado = Integer.valueOf(contadorExamesComResultado + 1);
            examesDesmPDfComResultado.put(codExameMaterial, contadorExamesComResultado);
        }
        return examesDesmPDfComResultado;
    }

    private XMLStringBuilder getXmlEnvio(int codLaboratorioExterno, String idAlvaro) throws XMLStringBuilderException {
        LaboratorioExterno lab = LaboratorioExterno.getLabExterno(String.valueOf(codLaboratorioExterno));
        String idAgente = StringUtil.getValor(lab.configuracao, "agente");
        String codigo = StringUtil.getValor(lab.configuracao, "codigo");
        String senha = StringUtil.getValor(lab.configuracao, "senha");
        XMLStringBuilder xml = new XMLStringBuilder();
        HashMap<String, String> atributosResultados = new HashMap<String, String>();
        atributosResultados.put("idagente", idAgente);
        atributosResultados.put("lis", "Jalis");
        atributosResultados.put("operador", Variaveis.login);
        atributosResultados.put("senha", senha);
        atributosResultados.put("padrao", "");
        HashMap<String, String> atributosEntidade = new HashMap<String, String>();
        atributosEntidade.put("codigo", codigo);
        HashMap<String, String> atributosSolicitacao = new HashMap<String, String>();
        atributosSolicitacao.put("idAlvaro", idAlvaro);
        HashMap<String, String> atributosExame = new HashMap<String, String>();
        atributosExame.put("codigo", "");
        xml.escreveHeaderAlvaro("1.0", "UTF-8");
        xml.abrir("resultados", atributosResultados);
        xml.abrir("entidade", atributosEntidade);
        xml.abrir("solicitacao", atributosSolicitacao);
        xml.abrirTagAlvaro("exame", atributosExame);
        xml.fecharTagAlvaro("solicitacao");
        xml.fecharTagAlvaro("entidade");
        xml.fecharTagAlvaro("resultados");
        return xml;
    }

    public File salvarArquivoResultado(String xmlResultado, LaboratorioExterno lab) throws Exception {
        if (!Funcoes.diretorioExiste(System.getProperty("user.home") + "/resultados" + lab.descricao)) {
            new File(System.getProperty("user.home") + "/resultados" + lab.descricao).mkdirs();
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd HH-mm-ss-SSS");
        String nomeArquivo = sf.format(new Date());
        File arquivo = new File(System.getProperty("user.home").toString() + "/resultados" + lab.descricao.trim() + "/" + nomeArquivo + ".xml");
        OutputStreamWriter bufferOut = new OutputStreamWriter((OutputStream)new FileOutputStream(arquivo.getAbsoluteFile()), "UTF-8");
        bufferOut.write(xmlResultado);
        bufferOut.close();
        return arquivo;
    }

    public void setConferirAutomatico(boolean conferirAutomatico) {
        this.conferirAutomatico = conferirAutomatico;
    }

    public void setCodigoUsuarioConferenciaAutomatica(String codigoUsuarioConferenciaAutomatica) {
        this.codigoUsuarioConferenciaAutomatica = codigoUsuarioConferenciaAutomatica;
    }
}

