/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.triagem.externo;

import br.com.diagnosticosdobrasil.Ct_EnviaAmostrasProcedimentosPendentesRequest_v2;
import br.com.diagnosticosdobrasil.Ct_PedidoMPP_v2;
import br.com.diagnosticosdobrasil.Ct_ProcedimentoMPP_v2;
import br.com.diagnosticosdobrasil.WsrvProtocoloDBSyncProxy;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.db2.DBComunicacao;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.model.dao.triagem.externo.ImprimirEtiquetasRecoletaDao;
import jalis.service.triagem.externo.DBCamposRetornoAmostraProcedimentos;
import jalis.service.triagem.externo.ExameEnviaAmostra;
import jalis.service.triagem.externo.GeradorXmlAmostraPendentes;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ImprimirEtiquetasRecoletaService {
    private static final Component ImprimirEtiquetasRecoleta = null;
    private final ImprimirEtiquetasRecoletaDao dao = new ImprimirEtiquetasRecoletaDao();
    private String codigoDB = null;
    private String senhaDB = null;
    private String enderecoWS = null;

    public HashMap<String, Boolean> validarRequisicao(String codFilial, String codRequisicao, String codLabExterno) {
        HashMap<String, Boolean> requisicaoValida = new HashMap<String, Boolean>();
        if (!this.dao.requisicaoExiste(codFilial, codRequisicao).booleanValue()) {
            requisicaoValida.put(String.format("Requisi\u00e7\u00e3o \"%s\" n\u00e3o encontrada", codRequisicao), Boolean.FALSE);
            return requisicaoValida;
        }
        if (!this.dao.requisicaoVinculadaAoLaboratorioExterno(codFilial, codRequisicao, codLabExterno).booleanValue()) {
            requisicaoValida.put(String.format("A requisi\u00e7\u00e3o \"%s\" n\u00e3o cont\u00e9m exames para o laborat\u00f3rio selecionado.", codRequisicao), Boolean.FALSE);
            return requisicaoValida;
        }
        if (!this.dao.requisicaoEmRecoleta(codFilial, codRequisicao).booleanValue()) {
            requisicaoValida.put(String.format("A requisi\u00e7\u00e3o \"%s\" n\u00e3o cont\u00e9m exames com situa\u00e7\u00e3o em Recoleta.", codRequisicao), Boolean.FALSE);
            return requisicaoValida;
        }
        if (!this.dao.verificaRastreioLote(codFilial, codRequisicao, codLabExterno)) {
            requisicaoValida.put(String.format("A requisi\u00e7\u00e3o \"%s\" n\u00e3o possui exames com pend\u00eancias para impress\u00e3o de etiquetas.", codRequisicao), Boolean.FALSE);
            return requisicaoValida;
        }
        requisicaoValida.put("Em Recoleta", Boolean.TRUE);
        return requisicaoValida;
    }

    public ArrayList<Registro> buscaDadosRequisicao(String codFilial, String codRequisicao) {
        return this.dao.buscaDadosRequisicao(codFilial, codRequisicao);
    }

    public ArrayList<Registro> getExamesRequisicao(String codFilial, String codRequisicao, String codigoLabExterno) {
        return this.dao.getExamesRequisicao(codFilial, codRequisicao, codigoLabExterno);
    }

    public String getNumeroAtendimento(String codFilial, String codRequisicao, String codigoLabExterno, String numLote) {
        return this.dao.getNumeroAtendimento(codFilial, codRequisicao, codigoLabExterno, numLote);
    }

    public String getExameDB(String codFilial, String codExame, String codigoLabExterno, String matExame) {
        return this.dao.getExameDB(codFilial, codExame, codigoLabExterno, matExame);
    }

    public String getEtiquetaRecoleta(String codFilial, String codRequisicao, String codigoLabExterno, String numLote) {
        return this.dao.getEtiquetaRecoleta(codFilial, codRequisicao, codigoLabExterno, numLote);
    }

    public ArrayList<String> getRastreioLote(String codFilial, String codRequisicao, String codigoLabExterno, String numLote) {
        return this.dao.getRastreioLote(codFilial, codRequisicao, codigoLabExterno, numLote);
    }

    public boolean validaReimpressaoEtiqueta(Registro requisicao) {
        StringBuilder impressao = new StringBuilder();
        String etiquetaReenvio = this.getEtiquetaRecoleta(requisicao.getString("fil_codigo"), requisicao.getString("req_codigo"), requisicao.getString("lae_codigo"), requisicao.getString("lex_codigo"));
        int index = etiquetaReenvio.indexOf("<etiquetaReenvio>");
        if (index == -1) {
            return false;
        }
        etiquetaReenvio = etiquetaReenvio.substring(index);
        impressao.append(etiquetaReenvio);
        this.imprimirAmostra(impressao);
        return true;
    }

    public void imprimirEtiquetasDB(LaboratorioExterno lab, List<Registro> exames) {
        String numAtendimentoDB = "";
        String codigoExameDB = "";
        ArrayList<Object> examesParaEnviar = new ArrayList();
        this.codigoDB = StringUtil.getValor(lab.configuracao, "codigo");
        this.senhaDB = StringUtil.getValor(lab.configuracao, "senha");
        this.enderecoWS = StringUtil.getValor(lab.configuracao, "enderecoWebService");
        WsrvProtocoloDBSyncProxy proxy = new WsrvProtocoloDBSyncProxy();
        Ct_EnviaAmostrasProcedimentosPendentesRequest_v2 request = new Ct_EnviaAmostrasProcedimentosPendentesRequest_v2();
        Ct_ProcedimentoMPP_v2[] listaProcedimento = new Ct_ProcedimentoMPP_v2[exames.size()];
        Ct_PedidoMPP_v2 amostrasPendentes = new Ct_PedidoMPP_v2();
        request.setCodigoApoiado(this.codigoDB);
        request.setCodigoSenhaIntegracao(this.senhaDB);
        try {
            int j = 0;
            String nomePaciente = "";
            String numeroApoiado = "";
            String dataHora = "";
            ArrayList<ExameEnviaAmostra> examesEnviaAmostra = new ArrayList<ExameEnviaAmostra>();
            for (Registro exa : exames) {
                codigoExameDB = this.getExameDB(exa.getString("fil_codigo"), exa.getString("exa_codigo"), exa.getString("lae_codigo"), exa.getString("mco_codigo"));
                numAtendimentoDB = this.getNumeroAtendimento(exa.getString("fil_codigo"), exa.getString("req_codigo"), exa.getString("lae_codigo"), exa.getString("lex_codigo"));
                examesParaEnviar = this.getRastreioLote(exa.getString("fil_codigo"), exa.getString("req_codigo"), exa.getString("lae_codigo"), exa.getString("lex_codigo"));
                nomePaciente = exa.getString("pac_nome");
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                dataHora = LocalDate.now().format(formatter);
                numeroApoiado = this.getCodigo(exa.getString("fil_codigo"), exa.getString("req_codigo"));
                ExameEnviaAmostra amostra = new ExameEnviaAmostra();
                amostra.setCodigoExameDB(StringUtil.getValor(codigoExameDB, "cd_db"));
                amostra.setSequenciaExameDB((String)examesParaEnviar.get(0));
                amostra.setStatus((String)examesParaEnviar.get(1));
                examesEnviaAmostra.add(amostra);
                ++j;
            }
            amostrasPendentes.setListaProcedimentoMPP(listaProcedimento);
            request.setAmostras(amostrasPendentes);
            String xml = GeradorXmlAmostraPendentes.geraXmlEnviaAmostrasProcedimentosPendentes(lab.configuracao, nomePaciente, numeroApoiado, numAtendimentoDB, dataHora, examesEnviaAmostra);
            DBComunicacao comunicacao = new DBComunicacao(lab.configuracao);
            String retorno = comunicacao.enviaAmostraProcedimentosPendentes(xml);
            String[] valores = StringUtil.getValores(retorno, DBCamposRetornoAmostraProcedimentos.TAG_AMOSTRAS.getTag());
            if (valores != null && valores.length > 0) {
                this.processaRetornoWS(retorno, exames);
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("java.net.UnknownHostException")) {
                Funcoes.mensagem(ImprimirEtiquetasRecoleta, "N\u00e3o foi poss\u00edvel obter a comunica\u00e7\u00e3o com Webservice do Diagn\u00f3stico Brasil. (Verifique sua conex\u00e3o com a internet)", 2);
            } else {
                Funcoes.mensagem(ImprimirEtiquetasRecoleta, e.getMessage(), 2);
            }
            return;
        }
    }

    private void processaRetornoWS(String retorno, List<Registro> requisicoes) throws SQLException {
        String[] pedidosAmostras;
        for (String registro : pedidosAmostras = StringUtil.getValores(retorno, DBCamposRetornoAmostraProcedimentos.TAG_AMOSTRAS.getTag())) {
            String[] amostras = StringUtil.getValores(registro, DBCamposRetornoAmostraProcedimentos.TAG_CT_AMOSTRA_ETIQUETA_V2.getTag());
            if (amostras == null) continue;
            StringBuilder impressao = new StringBuilder();
            for (String amostra : amostras) {
                String etiquetaDB = StringUtil.getValor(amostra, DBCamposRetornoAmostraProcedimentos.TAG_ETIQUETA_AMOSTRA.getTag());
                impressao.append(etiquetaDB);
                String codigoExmApoio = StringUtil.getValor(amostra, DBCamposRetornoAmostraProcedimentos.TAG_NUMERO_AMOSTRA.getTag());
                if (!codigoExmApoio.isEmpty()) {
                    Conexao.arquivaSQL();
                    for (Registro req : requisicoes) {
                        this.dao.processaRetornoWS(req, etiquetaDB);
                    }
                }
                this.imprimirAmostra(impressao);
            }
        }
    }

    private void imprimirAmostra(StringBuilder impressao) {
        if (!Funcoes.textoVazio(impressao.toString())) {
            String impressora = ParametrosLocais.getParametro("impressoraWebServiceDb");
            ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora), false);
            termica.imprimirDireto(impressao.toString());
        }
    }

    private String getCodigo(String filial, String id) {
        return String.format("%s%s", Funcoes.preencheZero(filial, ParametrosGerais.getDigitosTuboFilial()), Funcoes.preencheZero(id, ParametrosGerais.getDigitosTuboRequisicao()));
    }
}

