/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.triagem.externo;

import jalis.laboratorio.triagem.externo.exportadores.db2.EscreverXmlDB;
import jalis.service.triagem.externo.DBCamposEnviaAmostraProcedimentos;
import jalis.service.triagem.externo.ExameEnviaAmostra;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilderException;
import java.util.List;

public class GeradorXmlAmostraPendentes {
    private GeradorXmlAmostraPendentes() {
    }

    public static String geraXmlEnviaAmostrasProcedimentosPendentes(String configuracaoLabExterno, String nomePaciente, String numeroApoiado, String numeroDB, String dataHora, List<ExameEnviaAmostra> exames) throws XMLStringBuilderException {
        String codigoConfiguracao = StringUtil.getValor(configuracaoLabExterno, "codigo");
        String senhaIntegracao = StringUtil.getValor(configuracaoLabExterno, "senha");
        EscreverXmlDB xml = new EscreverXmlDB();
        GeradorXmlAmostraPendentes.comecoArquivoSQL(xml);
        xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_ENVIA_AMOSTRAS_PROCEDIMENTOS_PENDENTES.getTag());
        xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_REQUEST.getTag());
        xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_CODIGO_APOIADO.getTag());
        xml.escrever(codigoConfiguracao);
        xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_CODIGO_APOIADO.getTag());
        xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_CODIGO_SENHA_INTEGRACAO.getTag());
        xml.escrever(senhaIntegracao);
        xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_CODIGO_SENHA_INTEGRACAO.getTag());
        xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_AMOSTRAS.getTag());
        xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_NOME_PACIENTES.getTag());
        xml.escrever(nomePaciente);
        xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_NOME_PACIENTES.getTag());
        xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag());
        xml.escrever(numeroApoiado);
        xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag());
        xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_NUMERO_ATENDIMENTO_DB.getTag());
        xml.escrever(numeroDB);
        xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_NUMERO_ATENDIMENTO_DB.getTag());
        xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_DATA_HORA_PEDIDO.getTag());
        xml.escrever(dataHora);
        xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_DATA_HORA_PEDIDO.getTag());
        xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_LISTA_PROCEDIMENTO_MPP.getTag());
        for (ExameEnviaAmostra exame : exames) {
            xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_CT_PROCEDIMENTO_MPP_V2.getTag());
            xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_CODIGO_EXAME_DB.getTag());
            xml.escrever(exame.getCodigoExameDB());
            xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_CODIGO_EXAME_DB.getTag());
            xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_SEQUENCIA_EXAME_DB.getTag());
            xml.escrever(exame.getSequenciaExameDB());
            xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_SEQUENCIA_EXAME_DB.getTag());
            xml.abrir(DBCamposEnviaAmostraProcedimentos.TAG_STATUS.getTag());
            xml.escrever(exame.getStatus());
            xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_STATUS.getTag());
            xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_CT_PROCEDIMENTO_MPP_V2.getTag());
        }
        xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_LISTA_PROCEDIMENTO_MPP.getTag());
        xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_AMOSTRAS.getTag());
        xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_REQUEST.getTag());
        xml.fechar(DBCamposEnviaAmostraProcedimentos.TAG_ENVIA_AMOSTRAS_PROCEDIMENTOS_PENDENTES.getTag());
        GeradorXmlAmostraPendentes.fecharArquivoSQL(xml);
        return xml.getXML();
    }

    private static void fecharArquivoSQL(EscreverXmlDB xml) {
        xml.escrever("</soapenv:Body>");
        xml.escrever("</soapenv:Envelope>");
    }

    private static void comecoArquivoSQL(EscreverXmlDB xml) {
        xml.escrever("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:diag=\"http://diagnosticosdobrasil.com.br\">");
        xml.escrever("<soapenv:Header/>");
        xml.escrever("<soapenv:Body>");
    }
}

