/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.triagem;

import jalis.model.AbstractThreadBean;
import jalis.model.bean.triagem.MaterialEnviadoBean;
import jalis.model.bean.triagem.MaterialEnviadoMaterialBean;
import jalis.model.bean.triagem.MaterialIdentificadoBean;
import jalis.model.dao.triagem.MaterialEnviadoDao;
import jalis.model.dao.triagem.MaterialEnviadoMaterialDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.triagem.MaterialEnviadoVO;
import jalis.service.AbstractThreadService;
import jalis.service.triagem.MaterialEnviadoMaterialService;
import jalis.service.triagem.MaterialIdentificadoService;
import java.util.ArrayList;
import java.util.Set;

public class MaterialEnviadoService
extends AbstractThreadService {
    public MaterialEnviadoService() {
        this.dao = new MaterialEnviadoDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((MaterialEnviadoBean)bean).setCodigo((Integer)codigo);
        ((MaterialEnviadoDao)this.dao).insert(bean, filialPadrao);
        MaterialEnviadoBean matBean = (MaterialEnviadoBean)bean;
        ArrayList<MaterialEnviadoMaterialBean> lista = matBean.getListaMateriais();
        if (lista != null) {
            MaterialEnviadoMaterialDao daoMat = new MaterialEnviadoMaterialDao();
            MaterialIdentificadoService matIdentService = new MaterialIdentificadoService();
            for (int i = 0; i < lista.size(); ++i) {
                MaterialEnviadoMaterialBean mat = lista.get(i);
                mat.setMaterialEnviado((MaterialEnviadoVO)matBean.toVO());
                daoMat.insert(mat, filialPadrao);
                int j = 1;
                while ((double)j <= mat.getQuantidade()) {
                    MaterialIdentificadoBean matIdent = new MaterialIdentificadoBean();
                    matIdent.setCelula(matBean.getCelulaDestino());
                    matIdent.setDataEnvio(matBean.getDataHora());
                    matIdent.setFilial(matBean.getFilial());
                    matIdent.setInutilizado(false);
                    matIdent.setMaterial(mat.getMaterial());
                    matIdent.setMaterialEnviado((MaterialEnviadoVO)matBean.toVO());
                    matIdent.setUsuarioEnvio(matBean.getUsuario());
                    matIdentService.gravaAutoCopiaSemCommit(matIdent, 0, filialPadrao, filiais);
                    ++j;
                }
            }
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((MaterialEnviadoDao)this.dao).update(bean, filialPadrao);
        MaterialEnviadoBean matBean = (MaterialEnviadoBean)bean;
        new MaterialEnviadoMaterialService().removerTodosMateriais(filialPadrao, matBean.getCodigo().toString());
        ArrayList<MaterialEnviadoMaterialBean> lista = matBean.getListaMateriais();
        if (lista != null) {
            MaterialEnviadoMaterialDao daoMat = new MaterialEnviadoMaterialDao();
            for (int i = 0; i < lista.size(); ++i) {
                MaterialEnviadoMaterialBean mat = lista.get(i);
                mat.setMaterialEnviado((MaterialEnviadoVO)matBean.toVO());
                daoMat.insert(lista.get(i), filialPadrao);
            }
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((MaterialEnviadoDao)this.dao).delete(bean, filialPadrao);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return ((MaterialEnviadoDao)this.dao).getBean(codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return ((MaterialEnviadoDao)this.dao).getVO(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((MaterialEnviadoDao)this.dao).getBean(filial, codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((MaterialEnviadoDao)this.dao).getVO(filial, codigo);
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }
}

