/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.relatorio.recepcao;

import jalis.laboratorio.relatorios.recepcao.RelatorioRequisicoes;
import jalis.model.dao.relatorio.recepcao.RelatorioRequisicoesDao;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.util.PGInterval;

public class RelatorioRequisicoesService {
    private RelatorioRequisicoesDao dao = new RelatorioRequisicoesDao();
    private static String campoData = "";
    private static String TIPO_CAMPODATA_COLETA = "Coleta";
    private static String[] ordem = new String[]{"C\u00f3digo", "Data + Hora", "Nome Paciente", "Conv\u00eanio", "M\u00e9dico", "Esta\u00e7\u00e3o", "Usu\u00e1rio", "Setor", "Filial + Requisi\u00e7\u00e3o", "Esta\u00e7\u00e3o + Usu\u00e1rio", "Cod.Paciente", "Req. + Adi\u00e7\u00e3o"};
    private static final long SEG_MINUTO = 60L;
    private static final long SEG_HORA = 3600L;
    private static final long SEG_DIA = 86400L;
    private static final long SEG_MES = 2592000L;
    private static final long SEG_ANO = 31104000L;
    public static final int TIPO_ABERTAS = 1;
    public static final int TIPO_A_COLETAR = 2;
    public static final int TIPO_SEM_MATERIAL = 3;
    public static final int TIPO_COLETADAS = 4;
    public static final int TIPO_ENTREGUES = 5;
    public static final int TIPO_AGRUPADO_MEDICO = 6;
    public static final int TIPO_AGRUPADO_CONVENIO = 7;
    public static final int TIPO_IMPRESSAS = 8;
    public static final int TIPO_AVISAR_PACIENTE = 9;
    public static final int TIPO_AGRUPADO_USUARIO = 10;
    public static final int TIPO_RECOLETA = 11;
    public static final int TIPO_NAO_TRIADOS = 12;
    public static final int TIPO_AGRUPADO_PACIENTE = 13;
    public static final int TIPO_REPETICAO = 14;
    public static final int TIPO_EXCLUIDAS = 15;
    public static final int TIPO_AUDITORIA_DE_PRODUCAO = 16;
    public static final int TIPO_CONFERIR_DIGITADA = 17;
    public static final int TIPO_CONFERIDA = 18;
    public static final int TIPO_TRANSPORTE = 19;

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0821100100");
        }
        if (tipoRelatorio == 2) {
            return Long.parseLong("0821300100");
        }
        if (tipoRelatorio == 3) {
            return Long.parseLong("0821500100");
        }
        if (tipoRelatorio == 4) {
            return Long.parseLong("0821700100");
        }
        if (tipoRelatorio == 7) {
            return Long.parseLong("0822500100");
        }
        if (tipoRelatorio == 6) {
            return Long.parseLong("0822400100");
        }
        if (tipoRelatorio == 8) {
            return Long.parseLong("0822600100");
        }
        if (tipoRelatorio == 5) {
            return Long.parseLong("0821900100");
        }
        if (tipoRelatorio == 10) {
            return Long.parseLong("0822800100");
        }
        if (tipoRelatorio == 11) {
            return Long.parseLong("0823000100");
        }
        if (tipoRelatorio == 14) {
            return Long.parseLong("0823100100");
        }
        if (tipoRelatorio == 12) {
            return Long.parseLong("0890100100");
        }
        if (tipoRelatorio == 13) {
            return Long.parseLong("0822900100");
        }
        if (tipoRelatorio == 15) {
            return Long.parseLong("0823200100");
        }
        if (tipoRelatorio == 16) {
            return Long.parseLong("0822600300");
        }
        if (tipoRelatorio == 17) {
            return Long.parseLong("0823400100");
        }
        if (tipoRelatorio == 18) {
            return Long.parseLong("0823600100");
        }
        if (tipoRelatorio == 19) {
            return Long.parseLong("0823800100");
        }
        return Long.parseLong("0822700100");
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0821100101");
        }
        if (tipoRelatorio == 2) {
            return Long.parseLong("0821300101");
        }
        if (tipoRelatorio == 3) {
            return Long.parseLong("0821500100");
        }
        if (tipoRelatorio == 4) {
            return Long.parseLong("0821700101");
        }
        if (tipoRelatorio == 7) {
            return Long.parseLong("0822500101");
        }
        if (tipoRelatorio == 6) {
            return Long.parseLong("0822400101");
        }
        if (tipoRelatorio == 8) {
            return Long.parseLong("0822600101");
        }
        if (tipoRelatorio == 5) {
            return Long.parseLong("0821900101");
        }
        if (tipoRelatorio == 10) {
            return Long.parseLong("0822800101");
        }
        if (tipoRelatorio == 11) {
            return Long.parseLong("0823000101");
        }
        if (tipoRelatorio == 14) {
            return Long.parseLong("0823100101");
        }
        if (tipoRelatorio == 12) {
            return Long.parseLong("890100101");
        }
        if (tipoRelatorio == 13) {
            return Long.parseLong("822900101");
        }
        if (tipoRelatorio == 15) {
            return Long.parseLong("823200101");
        }
        if (tipoRelatorio == 16) {
            return Long.parseLong("822600301");
        }
        if (tipoRelatorio == 18) {
            return Long.parseLong("0823600101");
        }
        if (tipoRelatorio == 19) {
            return Long.parseLong("0823800101");
        }
        return Long.parseLong("0822700101");
    }

    public static PGInterval justificaIntervalo(PGInterval interval) {
        if (interval == null) {
            return null;
        }
        long intervaloSegundos = RelatorioRequisicoesService.getSegundosIntervalo(interval);
        int anos = (int)(intervaloSegundos / 31104000L);
        int meses = (int)((intervaloSegundos -= (long)anos * 31104000L) / 2592000L);
        int dias = (int)((intervaloSegundos -= (long)meses * 2592000L) / 86400L);
        int horas = (int)((intervaloSegundos -= (long)dias * 86400L) / 3600L);
        int minutos = (int)((intervaloSegundos -= (long)horas * 3600L) / 60L);
        return new PGInterval(anos, meses, dias, horas, minutos, (double)(intervaloSegundos -= (long)minutos * 60L));
    }

    public static String intervaloParaString(PGInterval interval) {
        if (interval == null) {
            return "";
        }
        interval = RelatorioRequisicoesService.justificaIntervalo(interval);
        StringBuilder buf = new StringBuilder();
        if (interval.getYears() > 0) {
            buf.append(Math.abs(interval.getYears())).append("a, ");
        }
        if (interval.getMonths() > 0) {
            buf.append(Math.abs(interval.getMonths())).append("m, ");
        }
        if (interval.getDays() > 0) {
            buf.append(Math.abs(interval.getDays())).append("d, ");
        }
        buf.append(Funcoes.preencheZero(Math.abs(interval.getHours()), 2)).append(":");
        buf.append(Funcoes.preencheZero(Math.abs(interval.getMinutes()), 2)).append(":");
        buf.append(Funcoes.preencheZero(Math.abs((int)interval.getSeconds()), 2));
        return buf.toString();
    }

    public static long getSegundosIntervalo(PGInterval interval) {
        if (interval == null) {
            return 0L;
        }
        long intervaloSegundos = 0L;
        intervaloSegundos += (long)interval.getSeconds();
        intervaloSegundos += (long)interval.getMinutes() * 60L;
        intervaloSegundos += (long)interval.getHours() * 3600L;
        intervaloSegundos += (long)interval.getDays() * 86400L;
        intervaloSegundos += (long)interval.getMonths() * 2592000L;
        if ((intervaloSegundos += (long)interval.getYears() * 31104000L) < 0L) {
            intervaloSegundos = 0L;
        }
        return intervaloSegundos;
    }

    public static PGInterval somaIntervalos(PGInterval intervalo1, PGInterval intervalo2) {
        intervalo2 = RelatorioRequisicoesService.justificaIntervalo(intervalo2);
        if (intervalo1 == null) {
            return intervalo2;
        }
        if (intervalo2 != null) {
            intervalo1.setYears(Math.abs(intervalo1.getYears()) + Math.abs(intervalo2.getYears()));
            intervalo1.setMonths(Math.abs(intervalo1.getMonths()) + Math.abs(intervalo2.getMonths()));
            intervalo1.setDays(Math.abs(intervalo1.getDays()) + Math.abs(intervalo2.getDays()));
            intervalo1.setHours(Math.abs(intervalo1.getHours()) + Math.abs(intervalo2.getHours()));
            intervalo1.setMinutes(Math.abs(intervalo1.getMinutes()) + Math.abs(intervalo2.getMinutes()));
            intervalo1.setSeconds((double)(Math.abs((int)intervalo1.getSeconds()) + Math.abs((int)intervalo2.getSeconds())));
            PGInterval interval = RelatorioRequisicoesService.justificaIntervalo(intervalo1);
            return interval;
        }
        return null;
    }

    public static PGInterval getMediaIntervalo(PGInterval interval, int qtdeExames) throws SQLException {
        if (interval == null) {
            return null;
        }
        long intervaloSegundos = RelatorioRequisicoesService.getSegundosIntervalo(interval);
        return new PGInterval(0, 0, 0, 0, 0, (double)(intervaloSegundos /= (long)qtdeExames));
    }

    public static long getMediaIntervaloMinutos(PGInterval interval, int qtdeExames) throws SQLException {
        if (interval == null) {
            return 0L;
        }
        long intervaloSegundos = RelatorioRequisicoesService.getMinutosIntervalo(interval);
        return intervaloSegundos /= (long)qtdeExames;
    }

    public static String getCampoOrdemData(int tipoRelatorio, int campoDataImpresso) {
        String retorno;
        switch (tipoRelatorio) {
            case 4: {
                if (RelatorioRequisicoesService.getComboCampoData().equals(TIPO_CAMPODATA_COLETA)) {
                    retorno = "b.exr_datamaterial";
                    break;
                }
                retorno = "a.req_data";
                break;
            }
            case 5: {
                retorno = "b.exr_dataentreguerst";
                break;
            }
            case 8: {
                retorno = RelatorioRequisicoes.getCampoImpressoPor(campoDataImpresso);
                break;
            }
            case 15: {
                retorno = "a.req_dataexcluida";
                break;
            }
            case 18: {
                retorno = "b.exr_dataassina";
                break;
            }
            default: {
                retorno = "a.req_data, a.req_hora";
            }
        }
        return retorno;
    }

    public static String getCampoFiltroHora(int tipoRelatorio, int campoDataImpresso) {
        String retorno;
        switch (tipoRelatorio) {
            case 4: {
                if (RelatorioRequisicoesService.getComboCampoData().equals(TIPO_CAMPODATA_COLETA)) {
                    retorno = "cast(b.exr_datamaterial as time)";
                    break;
                }
                retorno = "a.req_hora";
                break;
            }
            case 5: {
                retorno = "cast(b.exr_dataentreguerst as time)";
                break;
            }
            case 8: {
                retorno = "cast(".concat(RelatorioRequisicoes.getCampoImpressoPor(campoDataImpresso)).concat(" as time)");
                break;
            }
            case 15: {
                retorno = "cast(a.req_dataexcluida as time)";
                break;
            }
            case 18: {
                retorno = "date_trunc('minute',cast(b.exr_dataassina as time))";
                break;
            }
            case 11: {
                retorno = "cast(b.exr_datarecoleta as time)";
                break;
            }
            default: {
                retorno = "a.req_hora";
            }
        }
        return retorno;
    }

    public static String getCampoUsuario(int tipoRelatorio) {
        String campo;
        switch (tipoRelatorio) {
            case 2: {
                campo = "COALESCE(b.usr_codcoletar, a.usr_codabertura)";
                break;
            }
            case 4: {
                campo = "COALESCE(b.usr_codmaterial, a.usr_codabertura)";
                break;
            }
            case 5: {
                campo = "COALESCE(b.usr_codentrega, a.usr_codabertura)";
                break;
            }
            case 8: {
                campo = "COALESCE(b.usr_codimpressao, a.usr_codabertura)";
                break;
            }
            case 11: {
                campo = "COALESCE(b.usr_codrecoleta, a.usr_codabertura)";
                break;
            }
            case 14: {
                campo = "COALESCE(b.usr_codrepeticao, a.usr_codabertura)";
                break;
            }
            case 15: {
                campo = "b.usr_codexcluido";
                break;
            }
            case 17: {
                campo = "COALESCE(b.usr_coddigitador, a.usr_codabertura)";
                break;
            }
            case 18: {
                campo = "COALESCE(b.usr_codassina, a.usr_codabertura)";
                break;
            }
            case 19: {
                campo = "b.usr_codtransportesaida";
                break;
            }
            default: {
                campo = "a.usr_codabertura";
            }
        }
        return campo;
    }

    public static String getCampoFiltroData(int tipoRelatorio, int campoDataImpresso) {
        String retorno;
        switch (tipoRelatorio) {
            case 4: {
                if (RelatorioRequisicoesService.getComboCampoData().equals(TIPO_CAMPODATA_COLETA)) {
                    retorno = "cast(b.exr_datamaterial as date)";
                    break;
                }
                retorno = "cast(b.exr_data as date)";
                break;
            }
            case 5: {
                retorno = "cast(b.exr_dataentreguerst as date)";
                break;
            }
            case 8: {
                retorno = "cast(".concat(RelatorioRequisicoes.getCampoImpressoPor(campoDataImpresso)).concat(" as date)");
                break;
            }
            case 15: {
                retorno = "cast(a.req_dataexcluida as date)";
                break;
            }
            case 17: {
                retorno = "cast(b.exr_datadigita as date)";
                break;
            }
            case 18: {
                retorno = "cast(b.exr_dataassina as date)";
                break;
            }
            case 11: {
                retorno = "cast(b.exr_datarecoleta as date)";
                break;
            }
            default: {
                retorno = "a.req_data";
            }
        }
        return retorno;
    }

    public static long getMinutosIntervalo(PGInterval interval) {
        if (interval == null) {
            return 0L;
        }
        long intervaloSegundos = 0L;
        intervaloSegundos += (long)interval.getMinutes();
        intervaloSegundos += (long)(interval.getHours() * 60);
        intervaloSegundos += (long)(interval.getDays() * 1440);
        intervaloSegundos += (long)(interval.getMonths() * 43200);
        if ((intervaloSegundos += (long)(interval.getYears() * 525600)) < 0L) {
            intervaloSegundos = 0L;
        }
        return intervaloSegundos;
    }

    public static String tratarInterval(PGInterval interval) {
        if (interval != null) {
            StringBuilder bi = new StringBuilder();
            bi.append(interval.getYears()).append(" Anos, ");
            bi.append(interval.getMonths()).append(" Meses, ");
            bi.append(interval.getDays()).append(" Dias, ");
            bi.append(Funcoes.preencheZero(interval.getHours(), 2)).append(":");
            bi.append(Funcoes.preencheZero(interval.getMinutes(), 2)).append(":");
            bi.append(Funcoes.preencheZero((int)interval.getSeconds(), 2));
            return bi.toString();
        }
        return null;
    }

    public static Object getValorMinutosIntervalo(Object valor) throws SQLException {
        PGInterval interval = (PGInterval)valor;
        if (interval != null) {
            return RelatorioRequisicoesService.getMinutosIntervalo(interval);
        }
        return "";
    }

    public static boolean isTipoMaterialOrdemUsuario(int tipoDoRelatorio, String ordmeSelecionada) {
        return tipoDoRelatorio == 3 && ordem.length == 12 && ordem[11].equals(ordmeSelecionada);
    }

    public static String gravaParametro(String valor, String parametro) {
        return String.format("<%s>%s</%s>", parametro, valor, parametro);
    }

    public static boolean validaTipoRelatorioProdReq(int tipoRelatorio) {
        return tipoRelatorio == 16 || tipoRelatorio == 1;
    }

    public Object adicionaTaxasRequisicao(int filial, int requisicao, Statement st) {
        return this.dao.buscaTaxasRequisicao(filial, requisicao, st);
    }

    public String getLayoutRelatorio(int tipoRelatorio, Statement st) {
        return this.dao.getLayoutRelatorio(tipoRelatorio, st);
    }

    public static String getComboCampoData() {
        return campoData;
    }

    public void setComboCampoData(String campoData) {
        RelatorioRequisicoesService.campoData = campoData;
    }

    public String getDescricaoEspecie(int codEspecie, Statement st, String filial) {
        return this.dao.getDescricaoEspecie(codEspecie, filial, st);
    }

    public String getDescricaoRaca(int codRaca, Statement st, String filial) {
        return this.dao.getDescricaoRaca(codRaca, filial, st);
    }
}

