/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.recepcao.coletar;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExameRequisicao;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.coletar.salux.ColetarMaterialSalux;
import jalis.laboratorio.recepcao.coletar.salux.FiltroColetaSalux;
import jalis.laboratorio.recepcao.util.DadosRequisicao;
import jalis.model.dao.recepcao.coletar.ColetarMaterialSaluxDao;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class ColetarMaterialSaluxService {
    private ColetarMaterialSaluxDao dao = new ColetarMaterialSaluxDao();
    private String situacoesConsiderarUrgente;
    private FiltroColetaSalux filtroColetaSalux;
    private Boolean ordemPorDataAlteracao;
    private String convenios;

    public List<DadosRequisicao> buscaDadosSalux() {
        List<DadosRequisicao> listaDadosRequisicao = this.dao.buscaDados(this.getFiltros());
        return listaDadosRequisicao;
    }

    private Registro getFiltros() {
        Registro registro = new Registro();
        registro.setValor("filtroColetaSalux", (Object)this.filtroColetaSalux);
        registro.setValor("convenios", this.convenios);
        registro.setValor("ordenarPorAlteracao", this.ordemPorDataAlteracao);
        registro.setValor("acesso", Acesso.getAcesso(Long.parseLong("0200600119")));
        return registro;
    }

    public Registro pesquisarRequisicaoPorCodigo(String codigo) throws SQLException {
        return this.dao.pesquisarRequisicaoPorCodigo(codigo);
    }

    public String getSituacoesConsiderarUrgente() {
        return this.situacoesConsiderarUrgente;
    }

    public void setSituacoesConsiderarUrgente(String situacoesConsiderarUrgente) {
        this.situacoesConsiderarUrgente = situacoesConsiderarUrgente;
    }

    public String getConvenios() {
        return this.convenios;
    }

    public void setConvenios(String convenios) {
        this.convenios = convenios;
    }

    public FiltroColetaSalux getFiltroColetaSalux() {
        return this.filtroColetaSalux;
    }

    public void setFiltroColetaSalux(FiltroColetaSalux filtroColetaSalux) {
        this.filtroColetaSalux = filtroColetaSalux;
    }

    public DadosRequisicao carregarDadosExameRequisicao(DadosRequisicao requisicao, boolean acesso, boolean ordenarSetor) throws SQLException {
        return this.dao.carregarDadosExamesRequisicao(requisicao, acesso, ordenarSetor);
    }

    public void setOrdemPorDataAlteracao(Boolean ordemPorDataAlteracao) {
        this.ordemPorDataAlteracao = ordemPorDataAlteracao;
    }

    public DadosRequisicao getDadosRequisicao(Registro reg) throws SQLException, ParseException {
        DadosConvenios dadosConvenio = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, reg.getInt("con_codigo"));
        DadosRequisicao dadosRequisicao = this.registoToDadosRequisicao(dadosConvenio, reg);
        List<Registro> exames = this.dao.pesquisarExamesPorRequisicao(reg.getString("req_codigo"));
        for (Registro exame : exames) {
            DadosExameRequisicao exameRequisicao = this.exameToDadosExameRequisicao(exame, dadosRequisicao.getCodigo());
            dadosRequisicao.adicionaExame(exameRequisicao);
        }
        return dadosRequisicao;
    }

    private DadosExameRequisicao exameToDadosExameRequisicao(Registro exame, Integer codigoRequisicao) throws SQLException, ParseException {
        DadosExameRequisicao exameRequisicao = null;
        DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, exame.getInt("mco_codigo"));
        if (dadosMaterial != null) {
            String situacao = exame.getString("exr_situacao");
            DadosExames dadosExame = ExameUtil.getDadosExame(Variaveis.filialPadrao, exame.getString("exa_codigo"), dadosMaterial);
            exameRequisicao = new DadosExameRequisicao(dadosExame, dadosMaterial, exame.getString("usr_codmaterial"), exame.getDate("exr_datamaterial"), exame.getBoolean("exr_matexterno"), DBUtil.campoNull(exame.getString("exr_resposta")) ? "" : exame.getString("exr_resposta"), DBUtil.campoNull(exame.getString("exr_situacao")) ? "" : exame.getString("exr_situacao"), Acesso.getAcesso(ColetarMaterialSalux.ACESSO_DESMARCAR_COLETADO) ? true : !Funcoes.textoVazio(exame.getString("exr_situacao")), exame.getBoolean("exr_urgente"), exame.getBoolean("etiquetaImpressa"), exame.getString("descricaoMaterial"), codigoRequisicao, exame.getString("notificacao"));
            if (situacao != null && situacao.startsWith("T") || DBUtil.campoNull(exame.getString("exr_datamaterial"))) {
                exameRequisicao.setUsuarioColeta("");
                exameRequisicao.setDataHoraColeta(null);
                exameRequisicao.setSituacao(exame.getString("exr_situacao"));
                exameRequisicao.setPodeAlterar(true);
            }
        }
        return exameRequisicao;
    }

    private DadosRequisicao registoToDadosRequisicao(DadosConvenios conv, Registro reg) throws ParseException {
        DadosRequisicao dadosRequisicao = new DadosRequisicao(reg.getInt("req_codigo"), reg.getString("pac_nome"), reg.getString("pac_nomesocial"), reg.getString("req_idade") + " " + Tipos.tipoIdade(reg.getString("req_anomes")), Tipos.tipoSexo(reg.getString("pac_sexo")), reg.getString("usr_codabertura"), conv, reg.getString("med_nome"), reg.getString("req_obs"), reg.getString("req_integracaohospital"), reg.getString("pac_foto"), reg.getString("pac_digital"), reg.getString("pac_obscoleta"), this.getRequisicaoPossuiEtiquetaColetaImpressa(reg.getInt("req_codigo")), new Date(), reg.getString("sit_descricao"), reg.getString("des_codigo"), reg.getDate("pac_datanasc"), reg.getDate("req_data"), reg.getString("req_dclinicos"));
        dadosRequisicao.setIdRequisicaoSalux(reg.getString("req_idsolicitacaosalux"));
        return dadosRequisicao;
    }

    private boolean getRequisicaoPossuiEtiquetaColetaImpressa(int codigoRequisicao) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select (case when (a.exr_dataetqcoleta is not null and a.usr_codetqcoleta is not null) then true else false end) as etiquetaImpressa ");
            sql.append(" from examerequisicao a where a.req_codigo = ");
            sql.append(codigoRequisicao);
            ResultSet resultSet = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
            while (resultSet.next()) {
                if (resultSet.getBoolean("etiquetaImpressa")) continue;
                return false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro ao buscar informa\u00e7\u00e3o se a etiqueta de coleta j\u00e1 foi impressa.", e.getStackTrace());
        }
        return true;
    }
}

