/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.recepcao;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.Requisicao;
import jalis.laboratorio.resultados.IntegracaoIDSSaude;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.recepcao.AgendamentoBean;
import jalis.model.bean.recepcao.RequisicaoBean;
import jalis.model.dao.recepcao.RequisicaoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tempuri.IDSIntLabProxy;
import org.tempuri.IDSIntLab___ConsultarAgendamentoExames;
import org.tempuri.IDSIntLab___ConsultarAgendamentoExamesResponse;
import org.tempuri.IDSIntLab___RecepcionarAgendamentoExames;
import org.tempuri.IDSIntLab___RecepcionarAgendamentoExamesResponse;

public class RequisicaoService
extends AbstractThreadService {
    public RequisicaoService() {
        this.dao = new RequisicaoDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof RequisicaoBean) {
            this.dao.insert(bean, filialPadrao);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof RequisicaoBean) {
            this.dao.update(bean, filialPadrao);
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof RequisicaoBean) {
            this.dao.delete(bean, filialPadrao);
        }
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Requisicao.getModuloAcesso(), "Cadastro de requisi\u00e7\u00f5es");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("paciente.nome", "Paciente", 0, "", 2, 0);
        tela.adicionaCampo("guia", "Guia", 0, "", 3, 0);
        tela.adicionaCampo("data", "Data", 2, "", 3, 0);
        tela.adicionaCampo("medico.nome", "M\u00e9dico", 0, "", 2, 0);
        tela.adicionaCampo("convenios.fantasia", "Conv\u00eanio", 0, "", 2, 0);
        tela.adicionaCampo("matricula", "Matr\u00edcula", 0, "", 3, 0);
        tela.adicionaCampo("destino.descricao", "Destino", 0, "", 2, 0);
        tela.adicionaCampo("paciente.cpf", "CPF", 0, "", 3, 0);
        tela.adicionaCampo("paciente.dataNascimento", "Nascimento", 2, "", 3, 0);
        tela.setFiltroInicial("Paciente", 2);
        tela.setColunaOrdenacao("Paciente");
        tela.setService(this);
        tela.setFiltro(" not req_excluida and fil_codigo =  " + Variaveis.filialPadrao);
        tela.setExecutarAoAbrir(false);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaRequisicoesAgendamentoVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Requisicao.getModuloAcesso(), "Cadastro de requisi\u00e7\u00f5es");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("data", "Data", 2, "", 3, 75);
        String tipo = "Paciente";
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            tipo = "Empresa";
        } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            tipo = "Animal";
        }
        tela.adicionaCampo("paciente.nome", tipo, 8, "", 2, 0);
        boolean filialAnalisesClinicas = Variaveis.tipoFilialPadrao.equals("C");
        if (filialAnalisesClinicas) {
            tela.adicionaCampo("paciente.nomesocial", "Nome Social", 8, "", 2, 0);
        }
        tela.adicionaCampo("guia", "Guia", 0, "", 3, 0);
        tela.adicionaCampo("medico.nome", "M\u00e9dico", 0, "", 2, 0);
        tela.adicionaCampo("convenios.fantasia", "Conv\u00eanio", 0, "", 2, 0);
        tela.adicionaCampo("matricula", "Matr\u00edcula", 0, "", 3, 0);
        tela.adicionaCampo("destino.descricao", "Destino", 0, "", 2, 0);
        tela.adicionaCampo("paciente.cpf", "CPF", 0, "", 3, 0);
        tela.adicionaCampo("paciente.dataNascimento", "Nascimento", 2, "", 3, 0);
        tela.setFiltroInicial("Paciente", 2);
        tela.setColunaOrdenacao("Paciente");
        tela.setService(this);
        StringBuilder buf = new StringBuilder();
        buf.append("     fil_codigo =  ").append(Variaveis.filialPadrao);
        buf.append(" and NOT req_excluida ");
        buf.append(" and (select COUNT(1) ");
        buf.append("        from examerequisicao exr ");
        buf.append("       where exr.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("         and exr.req_codigo = requisicao.req_codigo ");
        buf.append("         and NOT exr.exr_excluido ");
        buf.append("         and ((exr.exr_situacao IS NULL or exr.exr_situacao = '') or exr.exr_situacao IN ('").append("T").append("', '").append("F").append("', '").append("R").append("')) ");
        buf.append("     ) > 0 ");
        tela.setFiltro(buf.toString());
        tela.setExecutarAoAbrir(false);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(RequisicaoBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(RequisicaoVO.class, where);
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((RequisicaoDao)this.dao).getBean(chaves);
    }

    public AbstractThreadBean getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return ((RequisicaoDao)this.dao).getVO(chaves);
    }

    public void atualizarSituacaoExamesSemResultadoAColetarSemCommit(String filial, String requisicao, String novaSituacao) throws SQLException {
        ((RequisicaoDao)this.dao).atualizarSituacaoExamesSemResultadoAColetarSemCommit(filial, requisicao, novaSituacao);
    }

    public void finalizarAgendamentoRequisicaoSemCommit(String filial, String requisicao, List<ExameRequisicaoVO> exameRequisicaoVOsAdendados, String usuario) throws SQLException {
        ((RequisicaoDao)this.dao).finalizarAgendamentoRequisicaoSemCommit(filial, requisicao, exameRequisicaoVOsAdendados, usuario);
    }

    public void atualizarSituacaoExamesSemResultadoFaltaMaterialSemCommit(String filial, String requisicao, String novaSituacao) throws SQLException {
        ((RequisicaoDao)this.dao).atualizarSituacaoExamesSemResultadoFaltaMaterialSemCommit(filial, requisicao, novaSituacao);
    }

    public void atualizarSituacaoExamesSemResultadoSemCommit(String filial, String requisicao, String novaSituacao) throws SQLException {
        ((RequisicaoDao)this.dao).atualizarSituacaoExamesSemResultadoSemCommit(filial, requisicao, novaSituacao);
    }

    public void marcarOrigemRequisicaoAgendamentoSemCommit(String filial, String requisicao, boolean agendamentoFinalizado) throws SQLException {
        ((RequisicaoDao)this.dao).marcarOrigemRequisicaoAgendamentoSemCommit(filial, requisicao, agendamentoFinalizado);
    }

    public void atualizaDatasAgendamentoFinalizadoSemCommit(String filial, String requisicao, Date data) throws SQLException {
        ((RequisicaoDao)this.dao).atualizaDatasAgendamentoFinalizadoSemCommit(filial, requisicao, data);
    }

    public void desvincularRequisicaoAgendamento(String filial, String codigoRequisicao) throws SQLException {
        ((RequisicaoDao)this.dao).desvincularRequisicaoAgendamento(filial, codigoRequisicao);
        Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(filial, codigoRequisicao);
        if (multiguias != null) {
            for (Integer requisicao : multiguias) {
                ((RequisicaoDao)this.dao).desvincularRequisicaoAgendamento(filial, requisicao.toString());
            }
        }
    }

    public void desvincularRequisicaoAgendamentoCancelar(String filial, String codigoRequisicao) throws SQLException {
        ((RequisicaoDao)this.dao).desvincularRequisicaoAgendamentoCancelamento(filial, codigoRequisicao);
    }

    public int getQuantidadeAgendamentos(String filial, String codigoRequisicao) throws SQLException {
        return ((RequisicaoDao)this.dao).getQuantidadeAgendamentos(filial, codigoRequisicao);
    }

    public int marcarRequisicaoExcluida(String filial, String codigoRequisicao) throws SQLException {
        return ((RequisicaoDao)this.dao).marcarRequisicaoExcluida(filial, codigoRequisicao);
    }

    public int marcarExamesRequisicaoExcluidos(String filial, String codigoRequisicao) throws SQLException {
        return ((RequisicaoDao)this.dao).marcarExamesRequisicaoExcluidos(filial, codigoRequisicao);
    }

    public void gravaMaiorDataEntregaSemCommit(RequisicaoVO requisicaoVO) throws SQLException {
        ((RequisicaoDao)this.dao).gravaMaiorDataEntregaSemCommit(requisicaoVO);
    }

    public BigDecimal valorExameCustoSimples(String codExame, String codMatCol, String codFilial) {
        return ((RequisicaoDao)this.dao).valorExameCustoSimples(codExame, codMatCol, codFilial);
    }

    public BigDecimal valorExameCustoSimples(String codExame, String codMatCol, int codFilial) {
        return ((RequisicaoDao)this.dao).valorExameCustoSimples(codExame, codMatCol, "" + codFilial);
    }

    public BigDecimal valorExameCustoSimples(String codExame, int codMatCol, String codFilial) {
        return ((RequisicaoDao)this.dao).valorExameCustoSimples(codExame, "" + codMatCol, codFilial);
    }

    public BigDecimal valorExameCustoSimples(String codExame, int codMatCol, int codFilial) {
        return ((RequisicaoDao)this.dao).valorExameCustoSimples(codExame, "" + codMatCol, "" + codFilial);
    }

    public int getCodigoConvenio(String filial, String codigoRequisicao) throws SQLException {
        return ((RequisicaoDao)this.dao).getCodigoConvenio(filial, codigoRequisicao);
    }

    public Integer getQuantidadeExames(String filial, String requisicao) throws Exception {
        return ((RequisicaoDao)this.dao).getQuantidadeExames(filial, requisicao);
    }

    public ArrayList<Registro> getExamesRequisicao(String filial, String requisicao) throws Exception {
        return ((RequisicaoDao)this.dao).getExamesRequisicao(filial, requisicao);
    }

    public IDSIntLab___ConsultarAgendamentoExamesResponse consultarAgendamentoIDS(String chave_acesso, String transacao) {
        IDSIntLabProxy proxy = new IDSIntLabProxy();
        if (!Funcoes.textoVazio(IntegracaoIDSSaude.getLinkComunicacaoIDS())) {
            String linkComunicacao = IntegracaoIDSSaude.getLinkComunicacaoIDS();
            proxy.setEndpoint(linkComunicacao);
        }
        IDSIntLab___ConsultarAgendamentoExames consultaAgendamento = new IDSIntLab___ConsultarAgendamentoExames(chave_acesso.trim(), transacao.trim());
        IDSIntLab___ConsultarAgendamentoExamesResponse responseConsultaAgendamento = null;
        try {
            responseConsultaAgendamento = proxy.consultarAgendamentoExames(consultaAgendamento);
        }
        catch (Exception ex) {
            String erro = ex.getMessage();
            try {
                Funcoes.geraLogErro(ex, "/ErrorIntegracaoIDS_");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (erro.contains("java.net.ConnectException") || erro.contains("java.net.SocketException") || erro.contains("java.net.UnknownHostException")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel se conectar ao agendamento do IDS Sa\u00fade.\nFavor entrar em contato com o suporte do IDS Sa\u00fade.", 1);
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Problemas na consulta do agendamento do IDS Sa\u00fade.\n" + ex.getMessage(), 1);
            }
            return null;
        }
        if (responseConsultaAgendamento == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Agendamento n\u00e3o encontrado.", 2);
            return null;
        }
        return responseConsultaAgendamento;
    }

    public String[] buscaRequisicaoAgendamentoIDS(String codigoTransacao) throws SQLException {
        return ((RequisicaoDao)this.dao).buscaRequisicaoAgendamentoIDS(codigoTransacao);
    }

    public boolean recepcionarAgendamento(String chave_acesso, String transacao) {
        IDSIntLabProxy proxy = new IDSIntLabProxy();
        if (!Funcoes.textoVazio(IntegracaoIDSSaude.getLinkComunicacaoIDS())) {
            String linkComunicacao = IntegracaoIDSSaude.getLinkComunicacaoIDS();
            proxy.setEndpoint(linkComunicacao);
        }
        Calendar dataAtual = Calendar.getInstance();
        IDSIntLab___RecepcionarAgendamentoExames recepcionaAgendamento = new IDSIntLab___RecepcionarAgendamentoExames(chave_acesso, transacao, dataAtual);
        IDSIntLab___RecepcionarAgendamentoExamesResponse responseRecepcionaAgendamento = null;
        try {
            responseRecepcionaAgendamento = proxy.recepcionarAgendamentoExames(recepcionaAgendamento);
        }
        catch (RemoteException e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel recepionar agendamento: " + e.getMessage(), 2);
            return false;
        }
        String agendamento = responseRecepcionaAgendamento.getResult();
        if (!Funcoes.textoVazio(agendamento) && agendamento.split(":")[1].trim().equalsIgnoreCase("RECEPCIONADO")) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Solicita\u00e7\u00e3o recepcionada com sucesso pelo IDS S\u00e1ude.", 2);
            return true;
        }
        Funcoes.mensagem(Laboratorio.getInstancia(), agendamento, 2);
        return false;
    }

    public boolean situacaoDoAgendamentoPermiteExclusaoDeRequisicao(String codigoRequisicao, String codigoFilial) {
        String tipo = ((RequisicaoDao)this.dao).buscaSituacaoDeAgendamento(codigoRequisicao, codigoFilial);
        switch (tipo = tipo == null ? "" : tipo) {
            case "A": {
                return false;
            }
            case "T": {
                return false;
            }
        }
        return true;
    }

    public void corrigirInformacoesDaIntegracaoHospital(String filial, String dataGuia, String guia, String matricula, String requisicao) throws SQLException {
        ((RequisicaoDao)this.dao).updateDadosGuiaEMatricula(filial, dataGuia, guia, matricula, requisicao);
    }

    public int getNumeroDeLotesParaARequisicao(String filial, String requisicao) throws SQLException {
        return ((RequisicaoDao)this.dao).getNumeroDeLotesPorRequisicao(filial, requisicao);
    }

    public void atualizarPeriodoGestacional(String codigoFilial, String codigoRequisicao, String periodoGestacional) throws SQLException {
        ((RequisicaoDao)this.dao).atualizarPeriodoGestacional(codigoFilial, codigoRequisicao, periodoGestacional);
    }

    public RequisicaoVO buscaPeriodoGestacional(String codigoFilial, String codigoRequisicao) throws SQLException {
        return ((RequisicaoDao)this.dao).buscaPeriodoGestacional(codigoFilial, codigoRequisicao);
    }

    public void atualizarDataSintoma(String codigoFilial, String codigoRequisicao, String dataSintoma) throws SQLException {
        ((RequisicaoDao)this.dao).atualizarDataSintoma(codigoFilial, codigoRequisicao, dataSintoma);
    }

    public void atualizarMunicipioResidencia(String codigoFilial, String codigoRequisicao, String municipioResidencia) throws SQLException {
        ((RequisicaoDao)this.dao).atualizarMunicipioResidencia(codigoFilial, codigoRequisicao, municipioResidencia);
    }

    public void atualizarApresentacaoSintoma(String codigoFilial, String codigoRequisicao, String apresentouSintoma) throws SQLException {
        ((RequisicaoDao)this.dao).atualizarApresentacaoSintoma(codigoFilial, codigoRequisicao, apresentouSintoma);
    }

    public void atualizarSenhaPainel(RequisicaoVO requisicao, String dataHoraEntrada, String dataHoraSolicitacao, String senha) throws SQLException {
        ((RequisicaoDao)this.dao).atualizarSenhaPainel(requisicao, dataHoraEntrada, dataHoraSolicitacao, senha);
    }

    public void atualizarSituacaoExamesSemResultadoSemCommit(AgendamentoBean agendamento, String novaSituacao) throws SQLException {
        ((RequisicaoDao)this.dao).atualizarSituacaoExamesSemResultadoSemCommit(agendamento, novaSituacao);
    }

    public void atualizarExameRequisicao(ExameRequisicaoVO exameRequisicaoVO, String situacaoFaltaMaterial, Statement statement) throws SQLException {
        ((RequisicaoDao)this.dao).atualizarExameRequisicao(exameRequisicaoVO, situacaoFaltaMaterial, statement);
    }
}

