/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.recepcao;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.recepcao.OrcamentoBean;
import jalis.model.bean.recepcao.OrcamentoConvenioBean;
import jalis.model.bean.recepcao.OrcamentoTaxaBean;
import jalis.model.dao.recepcao.OrcamentoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.recepcao.OrcamentoVO;
import jalis.relatorio.bean.ExameTerceirizadoBean;
import jalis.service.AbstractThreadService;
import jalis.service.recepcao.OrcamentoConvenioService;
import jalis.service.recepcao.OrcamentoTaxaService;
import jalis.util.Funcoes;
import java.util.ArrayList;
import java.util.Set;

public class OrcamentoService
extends AbstractThreadService {
    public OrcamentoService() {
        this.dao = new OrcamentoDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return ((OrcamentoDao)this.dao).getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((OrcamentoDao)this.dao).getBean(filial, codigo);
    }

    public AbstractThreadBean getBeanManual(String filial, String codigo) throws Exception {
        return ((OrcamentoDao)this.dao).getBeanManual(filial, codigo);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean != null) {
            ArrayList<OrcamentoConvenioBean> convenios = ((OrcamentoBean)bean).getConvenios();
            ArrayList<OrcamentoTaxaBean> taxas = ((OrcamentoBean)bean).getTaxas();
            if (convenios == null || convenios.size() <= 0) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 conv\u00eanios no or\u00e7amento", 2);
                return;
            }
            ((OrcamentoBean)bean).setCodigo((Integer)codigo);
            this.dao.insert(bean, filialPadrao);
            for (OrcamentoConvenioBean convenioBean : convenios) {
                convenioBean.setOrcamento((OrcamentoVO)bean.toVO());
                new OrcamentoConvenioService().insert(convenioBean, null, filialPadrao, filiais);
            }
            if (null != taxas) {
                for (OrcamentoTaxaBean taxaBean : taxas) {
                    taxaBean.setOrcamento((OrcamentoVO)bean.toVO());
                    new OrcamentoTaxaService().insert(taxaBean, null, filialPadrao, filiais);
                }
            }
        }
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(OrcamentoBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(" where fil_codigo = " + Variaveis.filialPadrao);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(OrcamentoVO.class, where);
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("dataHora", "Data", 4, "", 3, 100);
        tela.adicionaCampo("solicitante", Variaveis.tipoFilialPadrao.equals("V") ? "Animal" : "Solicitante", 0, "", 0, 0);
        tela.adicionaCampo("usuario", "Usu\u00e1rio", 0, "", 0, 100);
        tela.setFiltroInicial("solicitante", 2);
        StringBuilder filtro = new StringBuilder();
        filtro.append("fil_codigo = ").append(Variaveis.filialPadrao);
        tela.setFiltro(filtro.toString());
        tela.setColunaOrdenacao(Variaveis.tipoFilialPadrao.equals("V") ? "Animal" : "Solicitante");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean != null) {
            ArrayList<OrcamentoConvenioBean> convenios = ((OrcamentoBean)bean).getConvenios();
            ArrayList<OrcamentoTaxaBean> taxas = ((OrcamentoBean)bean).getTaxas();
            if (convenios == null || convenios.size() <= 0) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 conv\u00eanios no or\u00e7amento", 2);
                return;
            }
            this.dao.update(bean, filialPadrao);
            OrcamentoConvenioService orcamentoConvenioService = new OrcamentoConvenioService();
            orcamentoConvenioService.removeTodosConvenio(filialPadrao, String.valueOf(((OrcamentoBean)bean).getCodigo()));
            OrcamentoTaxaService orcamentoTaxaService = new OrcamentoTaxaService();
            orcamentoTaxaService.removeTodasTaxas(filialPadrao, String.valueOf(((OrcamentoBean)bean).getCodigo()));
            for (OrcamentoConvenioBean convenioBean : convenios) {
                convenioBean.setOrcamento((OrcamentoVO)bean.toVO());
                orcamentoConvenioService.insert(convenioBean, null, filialPadrao, filiais);
            }
            if (null != taxas) {
                for (OrcamentoTaxaBean taxaBean : taxas) {
                    taxaBean.setOrcamento((OrcamentoVO)bean.toVO());
                    orcamentoTaxaService.insert(taxaBean, null, filialPadrao, filiais);
                }
            }
        }
    }

    public boolean verificaOrcamentoUtilizado(OrcamentoBean bean) {
        return ((OrcamentoDao)this.dao).verificaOrcamentoUtilizado(bean);
    }

    public ArrayList<String> verificaOrcamentoUtilizadoLista(OrcamentoBean bean) {
        return ((OrcamentoDao)this.dao).verificaOrcamentoUtilizadoLista(bean);
    }

    public String consultaTerceirizazao(ExameTerceirizadoBean exameTerceirizadoBean) {
        return ((OrcamentoDao)this.dao).consultaTerceirizazao(exameTerceirizadoBean);
    }

    public Set<OrcamentoBean> loadAprovados(String textFieldDataFinal, String textFieldDataFinalAprovacao, String textFieldDataInicial, String textFieldDataInicialAprovacao, String textFieldSolicitante, String usuariosSelecionados, String solicitante, String clientes) throws ThreadDaoException {
        return ((OrcamentoDao)this.dao).loadAprovados(textFieldDataFinal, textFieldDataFinalAprovacao, textFieldDataInicial, textFieldDataInicialAprovacao, textFieldSolicitante, usuariosSelecionados, solicitante, clientes);
    }

    public void atualizarFormaPagamento(OrcamentoBean orcamento) {
        ((OrcamentoDao)this.dao).atualizarFormaPagamento(orcamento);
    }

    public int contadorAlteracoes(OrcamentoBean bean) {
        return ((OrcamentoDao)this.dao).contadorAlteracoes(bean);
    }
}

