/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.recepcao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.exame.MotivoRecoletaBean;
import jalis.model.bean.loteexterno.LoteExternoRequisicaoRastreioBean;
import jalis.model.bean.recepcao.ExameRequisicaoBean;
import jalis.model.dao.recepcao.ExameRequisicaoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.service.AbstractThreadService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExameRequisicaoService
extends AbstractThreadService {
    public ExameRequisicaoService() {
        this.dao = new ExameRequisicaoDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof ExameRequisicaoBean) {
            this.dao.insert(bean, filialPadrao);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof ExameRequisicaoBean) {
            this.dao.update(bean, filialPadrao);
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof ExameRequisicaoBean) {
            this.dao.delete(bean, filialPadrao);
        }
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(ExameRequisicaoBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ExameRequisicaoVO.class, where);
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ExameRequisicaoDao)this.dao).getBean(chaves);
    }

    public AbstractThreadBean getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ExameRequisicaoDao)this.dao).getVO(chaves);
    }

    public ArrayList<ExameRequisicaoBean> getBeans(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ExameRequisicaoDao)this.dao).getBeans(chaves, Conexao.getStatement());
    }

    public ArrayList<ExameRequisicaoBean> getBeans(Map<String, Object> chaves, Statement st) throws ThreadDaoException {
        return ((ExameRequisicaoDao)this.dao).getBeans(chaves, st);
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    public void marcarExameComoRecebidoTransporte(Registro registro) throws SQLException {
        ((ExameRequisicaoDao)this.dao).marcarExameComoRecebidoTransporte(registro);
    }

    public boolean examePossuiExameRequisicao(Statement st, String filial, String requisicao, String exame, String material) throws SQLException {
        return this.examePossuiExameRequisicaoPerformance(st, filial, requisicao, exame, material);
    }

    public boolean examePossuiExameRequisicaoPerformance(Statement st, String filial, String requisicao, String exame, String material) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select count(1) as quantidade from examerequisicao where fil_codigo = ").append(filial);
        query.append(" and req_codigo = ").append(requisicao);
        query.append(" and exa_codigo = '").append(exame).append("'");
        query.append(" and mco_codigo = ").append(material).append(";");
        ResultSet rs = Conexao.executeQueryPerformance(st, query.toString());
        if (rs.next()) {
            return rs.getInt("quantidade") > 0;
        }
        return false;
    }

    public boolean exameJaTemResultadoExameRequisicao(Statement st, String filial, String requisicao, String exame, String material) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exr_situacao from examerequisicao where fil_codigo = ").append(filial);
        query.append(" and req_codigo = ").append(requisicao);
        query.append(" and exa_codigo = '").append(exame).append("'");
        query.append(" and mco_codigo = ").append(material).append(";");
        ResultSet rs = Conexao.executeQuery(st, query.toString());
        if (rs.next()) {
            String sit = rs.getString("exr_situacao");
            return !Funcoes.textoVazio(sit) && (sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E"));
        }
        return false;
    }

    public void updateRequisicaoRecoleta(Statement st, MotivoRecoletaBean motivo, LoteExternoRequisicaoRastreioBean rastreio) throws SQLException {
        StringBuilder bui = new StringBuilder("update examerequisicao set ");
        bui.append("exr_situacao = '").append("R").append("', ");
        bui.append("exr_datarecoleta = '").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Funcoes.getDataHoraServidor())).append("', ");
        bui.append(" usr_codrecoleta = '").append(StringUtil.textoDB(Variaveis.login)).append("', ");
        bui.append(" exr_motivorecoleta = '").append(rastreio.getDescricaoStatus()).append("', ");
        bui.append(" mrc_codigo = ").append(motivo != null ? motivo.getCodigo() : "null");
        bui.append(" where fil_codigo = ").append(rastreio.getKodigoFilial());
        bui.append(" and req_codigo = ").append(rastreio.getCodigoRequisicao());
        bui.append(" and exa_codigo = '").append(rastreio.getCodigoExame()).append("'");
        bui.append(" and mco_codigo = ").append(rastreio.getCodigoMaterial());
        Conexao.execute(Variaveis.filialPadrao, st, bui.toString());
        DBUtil.gravaLogSituacaoExameRequisicao(st, rastreio.getKodigoFilial().toString(), rastreio.getCodigoRequisicao().toString(), rastreio.getCodigoExame(), rastreio.getCodigoMaterial().toString(), "R", false);
        Conexao.arquivaSQL();
    }

    public boolean getExameModificadoRetificado(Integer codigoFilial, Integer codigoRequisicao, String codigoExame, Integer codigoMaterial) throws SQLException {
        return ((ExameRequisicaoDao)this.dao).getExameModificadoRetificado(codigoFilial, codigoRequisicao, codigoExame, codigoMaterial);
    }

    public List<ExameRequisicaoVO> getVOs(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ExameRequisicaoDao)this.dao).getVOs(chaves);
    }

    public List<ExameRequisicaoVO> getVOsIn(Map<String, Object> chaves) throws ThreadDaoException, SQLException {
        return ((ExameRequisicaoDao)this.dao).getVOsIn(chaves, Conexao.getStatement(), Variaveis.filialPadrao, false);
    }

    public List<ExameRequisicaoVO> getVOsIn(Map<String, Object> chaves, Statement st, String filialPadrao, boolean isColetaWeb) throws ThreadDaoException, SQLException {
        return ((ExameRequisicaoDao)this.dao).getVOsIn(chaves, st, filialPadrao, isColetaWeb);
    }
}

