/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.recepcao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.recepcao.AgendamentoBean;
import jalis.model.bean.recepcao.AgendamentoExameRequisicaoBean;
import jalis.model.dao.recepcao.AgendamentoDao;
import jalis.model.dao.recepcao.ExameRequisicaoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.DestinoVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.SalaAtendimentoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.recepcao.AgendamentoVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AgendamentoService
extends AbstractThreadService {
    public AgendamentoService() {
        this.dao = new AgendamentoDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean != null) {
            AgendamentoBean tmp = (AgendamentoBean)bean;
            tmp.setCodigo((Integer)codigo);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(tmp.getDataHoraAgendamento());
            calendar.set(13, 0);
            tmp.setDataHoraAgendamento(calendar.getTime());
            this.dao.insert(tmp, filialPadrao);
        }
    }

    public void insertAgendamentoExame(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean != null) {
            AgendamentoExameRequisicaoBean tmp = (AgendamentoExameRequisicaoBean)bean;
            tmp.setCodigo((Integer)codigo);
            this.dao.insert(tmp, filialPadrao);
        }
    }

    public void deleteAgendamentoExame(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean != null) {
            AgendamentoExameRequisicaoBean tmp = (AgendamentoExameRequisicaoBean)bean;
            tmp.setCodigo((Integer)codigo);
            ((AgendamentoDao)this.dao).deleteExames(tmp, filialPadrao);
        }
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(AgendamentoBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(AgendamentoVO.class, where);
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean != null) {
            this.dao.update(bean, filialPadrao);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AgendamentoBean remarcarAgendamento(AgendamentoBean bean, String filial, Date dataHoraAnterior, boolean isDiferenciado) throws Exception {
        if (bean == null) return null;
        AgendamentoBean agendamento = bean;
        if (dataHoraAnterior == null) throw new Exception("N\u00e3o \u00e9 poss\u00edvel remarcar o agendamento sem informar a data/hora do agendamento original.");
        Calendar calAtual = Calendar.getInstance();
        calAtual.setTime(agendamento.getDataHoraAgendamento());
        Calendar calAnterior = Calendar.getInstance();
        calAnterior.setTime(dataHoraAnterior);
        if (calAtual.get(5) == calAnterior.get(5) && calAtual.get(2) == calAnterior.get(2) && calAtual.get(1) == calAnterior.get(1) && calAtual.get(11) == calAnterior.get(11) && calAtual.get(12) == calAnterior.get(12)) {
            this.dao.update(agendamento, filial);
            return null;
        } else {
            AgendamentoExameRequisicaoBean agendamentoExameRequisicaoBean;
            ExameRequisicaoVO exameRequisicaoVO;
            int i;
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            AgendamentoBean novoAgendamento = (AgendamentoBean)agendamento.clonar();
            novoAgendamento.setDataHora(new Date());
            novoAgendamento.setSalaAtendimento(agendamento.getSalaAtendimento());
            novoAgendamento.setAgendamentoOrigem(agendamento.getCodigo());
            novoAgendamento.setCodigo(null);
            novoAgendamento.setUsuarioEmColeta(null);
            novoAgendamento.setDataHoraEmColeta(null);
            novoAgendamento.setSituacao("A");
            novoAgendamento.setHorarioAberto(isDiferenciado);
            if (isDiferenciado) {
                novoAgendamento.setUsuarioHorarioAnexado(usuario);
                novoAgendamento.setDataHorarioAnexado(new Date());
            }
            this.gravaAutoCopiaSemCommit(novoAgendamento, 0, filial, null);
            for (i = 0; i < novoAgendamento.getRequisicao().getExames().size(); ++i) {
                exameRequisicaoVO = novoAgendamento.getRequisicao().getExames().get(i);
                agendamentoExameRequisicaoBean = new AgendamentoExameRequisicaoBean();
                agendamentoExameRequisicaoBean.setFilial(novoAgendamento.getFilial());
                agendamentoExameRequisicaoBean.setCodigo(novoAgendamento.getCodigo());
                agendamentoExameRequisicaoBean.setRequisicao(novoAgendamento.getRequisicao().getCodigo());
                agendamentoExameRequisicaoBean.setExame(exameRequisicaoVO.getExame().getCodigo());
                agendamentoExameRequisicaoBean.setMaterial(exameRequisicaoVO.getMaterial().getCodigo());
                new AgendamentoService().insertAgendamentoExame(agendamentoExameRequisicaoBean, novoAgendamento.getCodigo(), Variaveis.filialPadrao, null);
            }
            if (!Funcoes.objectIsNull(novoAgendamento.getRequisicao().getRequisicoesMultiguia())) {
                for (i = 0; i < novoAgendamento.getRequisicao().getExamesMultiguia().size(); ++i) {
                    exameRequisicaoVO = novoAgendamento.getRequisicao().getExamesMultiguia().get(i);
                    agendamentoExameRequisicaoBean = new AgendamentoExameRequisicaoBean();
                    agendamentoExameRequisicaoBean.setFilial(novoAgendamento.getFilial());
                    agendamentoExameRequisicaoBean.setCodigo(novoAgendamento.getCodigo());
                    agendamentoExameRequisicaoBean.setRequisicao(exameRequisicaoVO.getRequisicao());
                    agendamentoExameRequisicaoBean.setExame(exameRequisicaoVO.getExame().getCodigo());
                    agendamentoExameRequisicaoBean.setMaterial(exameRequisicaoVO.getMaterial().getCodigo());
                    new AgendamentoService().insertAgendamentoExame(agendamentoExameRequisicaoBean, novoAgendamento.getCodigo(), Variaveis.filialPadrao, null);
                }
            }
            agendamento.setSituacao("R");
            agendamento.setDataHoraRemarcado(new Date());
            agendamento.setUsuarioRemarcado(usuario);
            agendamento.setDataHoraAgendamento(dataHoraAnterior);
            this.dao.update(agendamento, filial);
            return novoAgendamento;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AgendamentoBean> buscaAgendamentosPorData(String filial, SalaAtendimentoVO salaAtendimento, Date data) throws Exception {
        HashSet<AgendamentoBean> agendamentos = new HashSet<AgendamentoBean>();
        Statement st = null;
        try (ResultSet resultSet = null;){
            StringBuilder buf = new StringBuilder();
            buf.append(" select distinct fil.fil_codigo as codigoFilialFilial ");
            buf.append(" \t\t\t ,fil.fil_descricao ");
            buf.append("  \t\t ,fil.fil_cnpj ");
            buf.append("  \t\t ,fil.fil_cnes ");
            buf.append("       ,req.fil_codigo ");
            buf.append("       ,req.req_codigo ");
            buf.append("       ,req.sit_codigo ");
            buf.append("       ,req.pac_codigo ");
            buf.append(" \t\t\t ,req.req_totpago ");
            buf.append(" \t\t\t ,req.req_origemagendamento ");
            buf.append(" \t\t\t ,req.con_codigo ");
            buf.append(" \t\t\t ,req.med_crm ");
            buf.append(" \t\t\t ,req.des_codigo ");
            buf.append(" \t\t\t ,req.req_idade ");
            buf.append(" \t\t\t ,req.req_anomes ");
            buf.append(" \t\t\t ,req.req_guia ");
            buf.append(" \t\t\t ,req.req_altura ");
            buf.append(" \t\t\t ,req.req_peso ");
            buf.append(" \t\t\t ,req.req_gestante ");
            buf.append(" \t\t\t ,req.req_neonato ");
            buf.append(" \t\t\t ,req.req_dum ");
            buf.append(" \t\t\t ,req.req_dclinicos ");
            buf.append(" \t\t\t ,req.req_obs ");
            buf.append(" \t\t\t ,req.req_data ");
            buf.append(" \t\t\t ,req.req_hora ");
            buf.append(" \t\t\t ,req.req_matricula ");
            buf.append(" \t\t\t ,req.req_origemagendamento ");
            buf.append(" \t\t\t ,req.req_excluida ");
            buf.append("       ,pac.fil_codigo ");
            buf.append("       ,pac.pac_codigo ");
            buf.append("       ,CASE WHEN pac_nomesocial is not null and pac_nomesocial <> '' then pac_nomesocial else pac_nome end AS pac_nome");
            buf.append("       ,pac.pac_cpf ");
            buf.append("       ,pac.pac_rg ");
            buf.append("       ,pac.cel_codigo ");
            buf.append("       ,pac.pac_tipopessoa ");
            buf.append("       ,pac.pac_datanasc ");
            buf.append("       ,pac.pac_idade ");
            buf.append("       ,pac.pac_anomes ");
            buf.append("       ,pac.pac_sexo ");
            buf.append("       ,pac.pac_altura ");
            buf.append("       ,pac.pac_peso ");
            buf.append("       ,pac.pac_endereco ");
            buf.append("       ,pac.pac_tipologradouroendereco ");
            buf.append("       ,pac.pac_numeroendereco ");
            buf.append("       ,pac.pac_codigoapoiado ");
            buf.append("       ,pac.pac_obscoleta ");
            buf.append("       ,pac.pac_fonecomercial ");
            buf.append("       ,pac.pac_fone ");
            buf.append("       ,pac.pac_fonecontato ");
            buf.append("       ,pac.pac_celular ");
            buf.append("       ,sal.fil_codigo ");
            buf.append("       ,sal.sal_codigo ");
            buf.append("       ,sal.sal_descricao ");
            buf.append("       ,sal.sal_apresentarcontador ");
            buf.append("       ,sal.sal_qtdecoletadores ");
            buf.append("       ,con.fil_codigo ");
            buf.append("       ,con.con_codigo ");
            buf.append("       ,con.con_fantasia ");
            buf.append("       ,con.con_imprimircomprovante ");
            buf.append("       ,con.con_imprimircapa ");
            buf.append("       ,con.con_imprimirrecibo ");
            buf.append("       ,con.con_imprimiretqcoleta ");
            buf.append("       ,con.con_imprimiretqtriagem ");
            buf.append("       ,con.con_imprimirtermo ");
            buf.append("       ,con.con_cnpjcpf ");
            buf.append("       ,con.con_cnpjintegralimposto ");
            buf.append("       ,con.cel_codigo as celulaEstoqueConvenio ");
            buf.append("       ,con.con_tipopessoa ");
            buf.append("       ,con.con_labapoio ");
            buf.append("       ,con.con_ordemfatura ");
            buf.append("       ,con.con_imprimiranexo ");
            buf.append("       ,con.con_filiaisproibidas ");
            buf.append("       ,agd.fil_codigo ");
            buf.append("       ,agd.agd_codigo ");
            buf.append("       ,agd.agd_datahoraagenda ");
            buf.append("\t\t\t ,agd.agd_situacao ");
            buf.append("       ,agd.agd_datahora ");
            buf.append("       ,agd.agd_bloqueado ");
            buf.append("       ,agd.agd_horarioaberto ");
            buf.append("       ,agd.agd_observacao ");
            buf.append("       ,agd.agd_datahoraemcoleta ");
            buf.append("       ,agd.agd_datahorafinalizado ");
            buf.append("       ,agd.agd_codigoorigem ");
            buf.append("       ,agd.agd_databloqueado ");
            buf.append("       ,agd.agd_datahorarioanexado ");
            buf.append("       ,agd.agd_datahoracancelamento ");
            buf.append("       ,agd.req_codigo ");
            buf.append("       ,agd.usr_codcancelamento ");
            buf.append("       ,agd.usr_codhorarioanexado ");
            buf.append("       ,agd.usr_codigo ");
            buf.append("       ,agd.usr_codremarcado ");
            buf.append("       ,agd.usr_codfinalizado ");
            buf.append("       ,agd.usr_codcancelamento ");
            buf.append("       ,agd.sal_codigo ");
            buf.append("       ,agd.usr_codbloqueado ");
            buf.append("       ,agd.usr_codemcoleta ");
            buf.append("       ,agd.usr_codcancelamento ");
            buf.append("       ,med.med_crm ");
            buf.append("       ,med.med_nome ");
            buf.append("       ,med.med_conselho ");
            buf.append("       ,med.med_uf ");
            buf.append("       ,dest.des_codigo ");
            buf.append("       ,dest.des_descricao ");
            buf.append("       ,usuario.usr_codigo as usuarioCodigo ");
            buf.append("       ,usuario.usr_nome as usuarioNome ");
            buf.append("       ,usuario.usr_nome as usuarioDescricao ");
            buf.append("       ,usuario.usr_assinatura as usuarioAss ");
            buf.append("       ,user_cancelamento.usr_codigo as user_cancelamentoCodigo ");
            buf.append("       ,user_cancelamento.usr_nome as user_cancelamentoNome ");
            buf.append("       ,user_cancelamento.usr_nome as user_cancelamentoDescricao ");
            buf.append("       ,user_cancelamento.usr_assinatura as user_cancelamentoAss ");
            buf.append("       ,user_finalizado.usr_codigo as user_finalizadoCodigo ");
            buf.append("       ,user_finalizado.usr_nome as user_finalizadoNome ");
            buf.append("       ,user_finalizado.usr_nome as user_finalizadoDescricao ");
            buf.append("       ,user_finalizado.usr_assinatura as user_finalizadoAss ");
            buf.append("       ,user_em_coleta.usr_codigo as user_em_coletaCodigo ");
            buf.append("       ,user_em_coleta.usr_nome as user_em_coletaNome ");
            buf.append("       ,user_em_coleta.usr_nome as user_em_coletaDescricao ");
            buf.append("       ,user_em_coleta.usr_assinatura as user_em_coletaAss ");
            buf.append("       ,user_remarcado.usr_codigo as user_remarcadoCodigo ");
            buf.append("       ,user_remarcado.usr_nome as user_remarcadoNome ");
            buf.append("       ,user_remarcado.usr_nome as user_remarcadoDescricao ");
            buf.append("       ,user_remarcado.usr_assinatura as user_remarcadoAss");
            buf.append("       ,user_anexado.usr_codigo as user_anexadoCodigo ");
            buf.append("       ,user_anexado.usr_nome as user_anexadoNome ");
            buf.append("       ,user_anexado.usr_nome as user_anexadoDescricao ");
            buf.append("       ,user_anexado.usr_assinatura as user_anexadoAss ");
            buf.append("       ,user_bloqueado.usr_codigo as user_bloqueadoCodigo ");
            buf.append("       ,user_bloqueado.usr_nome as user_bloqueadoNome ");
            buf.append("       ,user_bloqueado.usr_nome as user_bloqueadoDescricao ");
            buf.append("       ,user_bloqueado.usr_assinatura as user_bloqueadoAss ");
            buf.append("   from agendamento agd ");
            buf.append("   left join requisicao req on agd.fil_codigo = req.fil_codigo and agd.req_codigo = req.req_codigo ");
            buf.append("   left join agendamentoexamerequisicao aer on agd.fil_codigo = aer.fil_codigo and agd.agd_codigo = aer.agd_codigo and agd.req_codigo = aer.req_codigo ");
            buf.append("   left join paciente pac on agd.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
            buf.append("   left join convenios con on agd.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
            buf.append("   left join salaatendimento sal on agd.fil_codigo = sal.fil_codigo and agd.sal_codigo = sal.sal_codigo ");
            buf.append("   left join filiais_postocoleta fil on fil.fil_codigo = ").append(filial).append(" and fil.fil_codigo = agd.fil_codigo ");
            buf.append("   left join medico med on req.fil_codigo = med.fil_codigo and med.med_crm = req.med_crm and med.med_conselho = req.med_conselho and med.med_uf = req.med_uf ");
            buf.append("\t left join usuario usuario on agd.usr_codigo = usuario.usr_codigo and usuario.fil_codigo = agd.fil_codigo ");
            buf.append("\t left join usuario user_cancelamento on agd.usr_codcancelamento = user_cancelamento.usr_codigo and user_cancelamento.fil_codigo = agd.fil_codigo ");
            buf.append("\t left join usuario user_finalizado on agd.usr_codfinalizado = user_finalizado.usr_codigo and user_finalizado.fil_codigo = agd.fil_codigo  ");
            buf.append("\t left join usuario user_em_coleta on agd.usr_codemcoleta = user_em_coleta.usr_codigo and user_em_coleta.fil_codigo = agd.fil_codigo  ");
            buf.append("\t left join usuario user_remarcado on agd.usr_codremarcado = user_remarcado.usr_codigo and user_remarcado.fil_codigo = agd.fil_codigo  ");
            buf.append("\t left join usuario user_anexado on agd.usr_codhorarioanexado = user_anexado.usr_codigo and user_anexado.fil_codigo = agd.fil_codigo  ");
            buf.append("\t left join usuario user_bloqueado on agd.usr_codbloqueado = user_bloqueado.usr_codigo and user_bloqueado.fil_codigo = agd.fil_codigo  ");
            buf.append("   left join destino dest on agd.fil_codigo = dest.fil_codigo and req.des_codigo = dest.des_codigo ");
            buf.append("\t\twhere sal.sal_codigo = ").append(String.valueOf(salaAtendimento.getCodigo()));
            buf.append(" and agd.fil_codigo = ").append(filial);
            buf.append(" \t\t\t\tand cast(agd.agd_datahoraagenda as date) = '").append(Funcoes.formataData("MM/dd/yyyy", data)).append("' ");
            buf.append("  \t\t\tand agd.agd_situacao NOT IN ('").append("C");
            buf.append("','").append("R").append("');");
            st = Conexao.getStatement();
            if (st != null) {
                resultSet = Conexao.executeQuery(st, buf.toString());
            }
            if (resultSet != null && resultSet.next()) {
                do {
                    ArrayList<ExameRequisicaoVO> lista;
                    FilialVO filialVO = new FilialVO();
                    filialVO.setCodigo(resultSet.getInt("codigoFilialFilial"));
                    filialVO.setDescricao(resultSet.getString("fil_descricao"));
                    filialVO.setCnpj(resultSet.getString("fil_cnpj"));
                    filialVO.setCnes(resultSet.getString("fil_cnes"));
                    DestinoVO destinoVO = new DestinoVO();
                    if (Funcoes.textoVazio(resultSet.getString("des_codigo"))) {
                        destinoVO = null;
                    } else {
                        destinoVO.setFilial(filialVO);
                        destinoVO.setCodigo(resultSet.getString("des_codigo"));
                        destinoVO.setDescricao(resultSet.getString("des_descricao"));
                    }
                    MedicoVO medicoVO = new MedicoVO();
                    medicoVO.setFilial(filialVO);
                    medicoVO.setNome(resultSet.getString("med_nome"));
                    medicoVO.setCrm(resultSet.getString("med_crm"));
                    medicoVO.setConselho(resultSet.getString("med_conselho"));
                    medicoVO.setUf(resultSet.getString("med_uf"));
                    PacienteVO pacienteVO = new PacienteVO();
                    pacienteVO.setFilial(filialVO);
                    pacienteVO.setCodigo(resultSet.getInt("pac_codigo"));
                    pacienteVO.setNome(resultSet.getString("pac_nome"));
                    pacienteVO.setCpf(resultSet.getString("pac_cpf"));
                    pacienteVO.setRg(resultSet.getString("pac_rg"));
                    CelulaEstoqueVO celulaEstoqueVO = new CelulaEstoqueVO();
                    celulaEstoqueVO.setCodigo(resultSet.getInt("cel_codigo"));
                    pacienteVO.setCelulaEstoque(celulaEstoqueVO);
                    pacienteVO.setTipoPessoa(resultSet.getString("pac_tipopessoa"));
                    pacienteVO.setDataNascimento(resultSet.getDate("pac_datanasc"));
                    pacienteVO.setIdade(resultSet.getInt("pac_idade"));
                    pacienteVO.setTipoIdade(resultSet.getString("pac_anomes"));
                    pacienteVO.setSexo(resultSet.getString("pac_sexo"));
                    pacienteVO.setAltura(resultSet.getDouble("pac_altura"));
                    pacienteVO.setPeso(resultSet.getDouble("pac_peso"));
                    pacienteVO.setEndereco(resultSet.getString("pac_endereco"));
                    pacienteVO.setTipoLogradouro(resultSet.getString("pac_tipologradouroendereco"));
                    pacienteVO.setNumeroEndereco(resultSet.getString("pac_numeroendereco"));
                    pacienteVO.setCodigoApoiado(resultSet.getString("pac_codigoapoiado"));
                    pacienteVO.setObscoleta(resultSet.getString("pac_obscoleta"));
                    pacienteVO.setFoneComercial(resultSet.getString("pac_fonecomercial"));
                    pacienteVO.setFone(resultSet.getString("pac_fone"));
                    pacienteVO.setFoneContato(resultSet.getString("pac_fonecontato"));
                    pacienteVO.setCelular(resultSet.getString("pac_celular"));
                    SalaAtendimentoVO salaAtendimentoVO = new SalaAtendimentoVO();
                    salaAtendimentoVO.setFilial(filialVO);
                    salaAtendimentoVO.setCodigo(resultSet.getInt("sal_codigo"));
                    salaAtendimentoVO.setDescricao(resultSet.getString("sal_descricao"));
                    salaAtendimentoVO.setApresentarContador(resultSet.getBoolean("sal_apresentarcontador"));
                    salaAtendimentoVO.setQtdeColetadores(resultSet.getInt("sal_qtdecoletadores"));
                    ConvenioVO convenioVO = new ConvenioVO();
                    convenioVO.setFilial(filialVO);
                    convenioVO.setCodigo(resultSet.getInt("con_codigo"));
                    convenioVO.setFantasia(resultSet.getString("con_fantasia"));
                    convenioVO.setImprimirComprovante(resultSet.getBoolean("con_imprimircomprovante"));
                    convenioVO.setImprimirCapa(resultSet.getBoolean("con_imprimircapa"));
                    convenioVO.setImprimirRecibo(resultSet.getBoolean("con_imprimirrecibo"));
                    convenioVO.setImprimirEtiquetaColeta(resultSet.getBoolean("con_imprimiretqcoleta"));
                    convenioVO.setImprimirEtiquetaTriagem(resultSet.getBoolean("con_imprimiretqtriagem"));
                    convenioVO.setImprimirTermoConsentimento(resultSet.getBoolean("con_imprimirtermo"));
                    convenioVO.setCnpj(resultSet.getString("con_cnpjcpf"));
                    convenioVO.setCnpjIntegralImposto(resultSet.getBoolean("con_cnpjintegralimposto"));
                    CelulaEstoqueVO estoqueVO = new CelulaEstoqueVO();
                    estoqueVO.setCodigo(resultSet.getInt("celulaEstoqueConvenio"));
                    convenioVO.setCelulaEstoque(estoqueVO);
                    convenioVO.setTipoPessoa(resultSet.getString("con_tipopessoa"));
                    convenioVO.setLabApoio(resultSet.getBoolean("con_labapoio"));
                    convenioVO.setOrdemFatura(resultSet.getString("con_ordemfatura"));
                    convenioVO.setImprimirAnexo(resultSet.getBoolean("con_imprimiranexo"));
                    convenioVO.setFiliaisProibidas(resultSet.getString("con_filiaisproibidas"));
                    RequisicaoVO requisicaoVO = new RequisicaoVO();
                    requisicaoVO.setCodigo(resultSet.getInt("req_codigo"));
                    requisicaoVO.setFilial(filialVO);
                    requisicaoVO.setPaciente(pacienteVO);
                    requisicaoVO.setTotalPago(resultSet.getDouble("req_totpago"));
                    requisicaoVO.setOrigemAgendamento(resultSet.getBoolean("req_origemagendamento"));
                    requisicaoVO.setConvenio(convenioVO);
                    requisicaoVO.setMedico(medicoVO);
                    requisicaoVO.setDestino(destinoVO);
                    requisicaoVO.setIdade(resultSet.getInt("req_idade"));
                    requisicaoVO.setAnoMes(resultSet.getString("req_anomes"));
                    requisicaoVO.setGuia(resultSet.getString("req_guia"));
                    requisicaoVO.setAltura(resultSet.getDouble("req_altura"));
                    requisicaoVO.setPeso(resultSet.getDouble("req_peso"));
                    requisicaoVO.setGestante(resultSet.getBoolean("req_gestante"));
                    requisicaoVO.setNeonato(resultSet.getBoolean("req_neonato"));
                    requisicaoVO.setDum(resultSet.getDate("req_dum"));
                    requisicaoVO.setDadosClinicos(resultSet.getString("req_dclinicos"));
                    requisicaoVO.setObservacao(resultSet.getString("req_obs"));
                    requisicaoVO.setData(resultSet.getTimestamp("req_data"));
                    requisicaoVO.setHora(resultSet.getTimestamp("req_hora"));
                    requisicaoVO.setMatricula(resultSet.getString("req_matricula"));
                    requisicaoVO.setOrigemAgendamento(resultSet.getBoolean("req_origemagendamento"));
                    requisicaoVO.setExcluida(resultSet.getBoolean("req_excluida"));
                    Conexao.setSessaoConexao(true);
                    Integer[] reqs = RecepcaoUtil.verificaMultiGuias(requisicaoVO.getFilial().getCodigo().toString(), requisicaoVO.getCodigo().toString());
                    requisicaoVO.setRequisicoesMultiguia(reqs);
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("fil_codigo", filialVO.getCodigo());
                    chaves.put("req_codigo", requisicaoVO.getCodigo());
                    String codigoAgendamento = "";
                    ArrayList<ExameRequisicaoVO> exames = new ArrayList();
                    if (resultSet.getBoolean("agd_bloqueado")) {
                        exames = new ExameRequisicaoDao().getVOsAgendameto(chaves, null);
                        requisicaoVO.setExames(exames);
                        if (reqs != null && reqs.length > 0) {
                            lista = new ArrayList();
                            for (int i = 0; i < reqs.length; ++i) {
                                HashMap<String, Object> chaveMulti = new HashMap<String, Object>();
                                chaveMulti.put("fil_codigo", requisicaoVO.getFilial().getCodigo().toString());
                                chaveMulti.put("req_codigo", reqs[i]);
                                ArrayList<ExameRequisicaoVO> auxLista = new ExameRequisicaoDao().getVOsAgendameto(chaveMulti, null);
                                if (auxLista == null || auxLista.size() <= 0) continue;
                                lista.addAll(auxLista);
                            }
                            requisicaoVO.setExamesMultiguia(lista);
                        }
                    } else {
                        if (!Funcoes.textoVazio(resultSet.getString("agd_codigo"))) {
                            codigoAgendamento = resultSet.getString("agd_codigo");
                        }
                        lista = new ArrayList<ExameRequisicaoVO>();
                        String codigoAgendamentoConsulta = codigoAgendamento;
                        while (exames.isEmpty() && lista.isEmpty()) {
                            exames = new ExameRequisicaoDao().getVOsAgendameto(chaves, codigoAgendamentoConsulta);
                            requisicaoVO.setExames(exames);
                            if (reqs != null && reqs.length > 0) {
                                for (int i = 0; i < reqs.length; ++i) {
                                    HashMap<String, Object> chaveMulti = new HashMap<String, Object>();
                                    chaveMulti.put("fil_codigo", requisicaoVO.getFilial().getCodigo().toString());
                                    chaveMulti.put("req_codigo", reqs[i]);
                                    ArrayList<ExameRequisicaoVO> auxLista = new ExameRequisicaoDao().getVOsAgendameto(chaveMulti, codigoAgendamentoConsulta);
                                    if (auxLista == null || auxLista.size() <= 0) continue;
                                    lista.addAll(auxLista);
                                }
                                requisicaoVO.setExamesMultiguia(lista);
                            }
                            codigoAgendamentoConsulta = null;
                        }
                    }
                    Conexao.setSessaoConexao(false);
                    ArrayList<AgendamentoExameRequisicaoBean> agendamentoExameRequisicaoBean = new ArrayList<AgendamentoExameRequisicaoBean>();
                    AgendamentoBean agendamentoBean = new AgendamentoBean();
                    agendamentoBean.setFilial(filialVO);
                    agendamentoBean.setCodigo(resultSet.getInt("agd_codigo"));
                    agendamentoBean.setDataHoraAgendamento(resultSet.getTimestamp("agd_datahoraagenda"));
                    agendamentoBean.setSituacao(resultSet.getString("agd_situacao"));
                    agendamentoBean.setDataHora(resultSet.getTimestamp("agd_datahora"));
                    agendamentoBean.setBloqueado(resultSet.getBoolean("agd_bloqueado"));
                    agendamentoBean.setHorarioAberto(resultSet.getBoolean("agd_horarioaberto"));
                    agendamentoBean.setObservacao(resultSet.getString("agd_observacao"));
                    agendamentoBean.setDataHoraEmColeta(resultSet.getTimestamp("agd_datahoraemcoleta"));
                    agendamentoBean.setDataHoraFinalizado(resultSet.getTimestamp("agd_datahorafinalizado"));
                    agendamentoBean.setAgendamentoOrigem(resultSet.getInt("agd_codigoorigem"));
                    agendamentoBean.setDataBloqueado(resultSet.getTimestamp("agd_databloqueado"));
                    agendamentoBean.setDataHorarioAnexado(resultSet.getTimestamp("agd_datahorarioanexado"));
                    agendamentoBean.setRequisicao(requisicaoVO.getCodigo() > 0 ? requisicaoVO : null);
                    agendamentoBean.setSalaAtendimento(salaAtendimentoVO);
                    agendamentoBean.setDataHoraCancelamento(resultSet.getTimestamp("agd_datahoracancelamento"));
                    if (!resultSet.getBoolean("agd_bloqueado") && !Funcoes.textoVazio(codigoAgendamento)) {
                        agendamentoExameRequisicaoBean.addAll(this.getDadosAgendamentoExameRequisicao(exames, agendamentoBean));
                    }
                    agendamentoBean.setAgendamentoExameRequisicaoBean(agendamentoExameRequisicaoBean);
                    UsuarioVO usuarioVO = new UsuarioVO();
                    if (Funcoes.textoVazio(resultSet.getString("usuarioCodigo"))) {
                        usuarioVO = null;
                    } else {
                        usuarioVO.setFilial(filialVO);
                        usuarioVO.setCodigo(resultSet.getString("usuarioCodigo"));
                        usuarioVO.setNome(resultSet.getString("usuarioNome"));
                        usuarioVO.setDescricao(resultSet.getString("usuarioDescricao"));
                        usuarioVO.setAssinatura(resultSet.getString("usuarioAss"));
                    }
                    agendamentoBean.setUsuario(usuarioVO);
                    UsuarioVO usuarioVOCancelamento = new UsuarioVO();
                    if (Funcoes.textoVazio(resultSet.getString("user_cancelamentoCodigo"))) {
                        usuarioVOCancelamento = null;
                    } else {
                        usuarioVOCancelamento.setFilial(filialVO);
                        usuarioVOCancelamento.setCodigo(resultSet.getString("user_cancelamentoCodigo"));
                        usuarioVOCancelamento.setNome(resultSet.getString("user_cancelamentoNome"));
                        usuarioVOCancelamento.setDescricao(resultSet.getString("user_cancelamentoDescricao"));
                        usuarioVOCancelamento.setAssinatura(resultSet.getString("user_cancelamentoAss"));
                    }
                    agendamentoBean.setUsuarioCancelamento(usuarioVOCancelamento);
                    UsuarioVO usuarioVOFinalizado = new UsuarioVO();
                    if (Funcoes.textoVazio(resultSet.getString("user_finalizadoCodigo"))) {
                        usuarioVOFinalizado = null;
                    } else {
                        usuarioVOFinalizado.setFilial(filialVO);
                        usuarioVOFinalizado.setCodigo(resultSet.getString("user_finalizadoCodigo"));
                        usuarioVOFinalizado.setNome(resultSet.getString("user_finalizadoNome"));
                        usuarioVOFinalizado.setDescricao(resultSet.getString("user_finalizadoDescricao"));
                        usuarioVOFinalizado.setAssinatura(resultSet.getString("user_finalizadoAss"));
                    }
                    agendamentoBean.setUsuarioFinalizado(usuarioVOFinalizado);
                    UsuarioVO usuarioVOColeta = new UsuarioVO();
                    if (Funcoes.textoVazio(resultSet.getString("user_em_coletaCodigo"))) {
                        usuarioVOColeta = null;
                    } else {
                        usuarioVOColeta.setFilial(filialVO);
                        usuarioVOColeta.setCodigo(resultSet.getString("user_em_coletaCodigo"));
                        usuarioVOColeta.setNome(resultSet.getString("user_em_coletaNome"));
                        usuarioVOColeta.setDescricao(resultSet.getString("user_em_coletaDescricao"));
                        usuarioVOColeta.setAssinatura(resultSet.getString("user_em_coletaAss"));
                    }
                    agendamentoBean.setUsuarioEmColeta(usuarioVOColeta);
                    UsuarioVO usuarioVORemarcado = new UsuarioVO();
                    if (Funcoes.textoVazio(resultSet.getString("user_remarcadoCodigo"))) {
                        usuarioVORemarcado = null;
                    } else {
                        usuarioVORemarcado.setFilial(filialVO);
                        usuarioVORemarcado.setCodigo(resultSet.getString("user_remarcadoCodigo"));
                        usuarioVORemarcado.setNome(resultSet.getString("user_remarcadoNome"));
                        usuarioVORemarcado.setDescricao(resultSet.getString("user_remarcadoDescricao"));
                        usuarioVORemarcado.setAssinatura(resultSet.getString("user_remarcadoAss"));
                    }
                    agendamentoBean.setUsuarioRemarcado(usuarioVORemarcado);
                    UsuarioVO usuarioVOAnexado = new UsuarioVO();
                    if (Funcoes.textoVazio(resultSet.getString("user_anexadoCodigo"))) {
                        usuarioVOAnexado = null;
                    } else {
                        usuarioVOAnexado.setFilial(filialVO);
                        usuarioVOAnexado.setCodigo(resultSet.getString("user_anexadoCodigo"));
                        usuarioVOAnexado.setNome(resultSet.getString("user_anexadoNome"));
                        usuarioVOAnexado.setDescricao(resultSet.getString("user_anexadoDescricao"));
                        usuarioVOAnexado.setAssinatura(resultSet.getString("user_anexadoAss"));
                    }
                    agendamentoBean.setUsuarioHorarioAnexado(usuarioVOAnexado);
                    UsuarioVO usuarioVOBLoqueado = new UsuarioVO();
                    if (Funcoes.textoVazio(resultSet.getString("user_bloqueadoCodigo"))) {
                        usuarioVOBLoqueado = null;
                    } else {
                        usuarioVOBLoqueado.setFilial(filialVO);
                        usuarioVOBLoqueado.setCodigo(resultSet.getString("user_bloqueadoCodigo"));
                        usuarioVOBLoqueado.setNome(resultSet.getString("user_bloqueadoNome"));
                        usuarioVOBLoqueado.setDescricao(resultSet.getString("user_bloqueadoDescricao"));
                        usuarioVOBLoqueado.setAssinatura(resultSet.getString("user_bloqueadoAss"));
                    }
                    agendamentoBean.setUsuarioBloqueado(usuarioVOBLoqueado);
                    agendamentos.add(agendamentoBean);
                } while (resultSet.next());
            }
        }
        if (st != null) {
            st.close();
        }
        return agendamentos;
    }

    private ArrayList<AgendamentoExameRequisicaoBean> getDadosAgendamentoExameRequisicao(ArrayList<ExameRequisicaoVO> exames, AgendamentoBean agendamentoBean) {
        ArrayList<AgendamentoExameRequisicaoBean> agendamentoExameRequisicao = new ArrayList<AgendamentoExameRequisicaoBean>();
        RequisicaoVO requisicao = agendamentoBean.getRequisicao();
        for (int i = 0; i < requisicao.getExames().size(); ++i) {
            ExameRequisicaoVO exameRequisicaoVO = requisicao.getExames().get(i);
            AgendamentoExameRequisicaoBean agendamentoExameRequisicaoBean = new AgendamentoExameRequisicaoBean();
            agendamentoExameRequisicaoBean.setFilial(agendamentoBean.getFilial());
            agendamentoExameRequisicaoBean.setCodigo(agendamentoBean.getCodigo());
            agendamentoExameRequisicaoBean.setRequisicao(requisicao.getCodigo());
            agendamentoExameRequisicaoBean.setExame(exameRequisicaoVO.getExame().getCodigo());
            agendamentoExameRequisicaoBean.setMaterial(exameRequisicaoVO.getMaterial().getCodigo());
            agendamentoExameRequisicao.add(agendamentoExameRequisicaoBean);
        }
        Integer[] mult = requisicao.getRequisicoesMultiguia();
        if (mult != null) {
            for (int i = 0; i < requisicao.getExamesMultiguia().size(); ++i) {
                ExameRequisicaoVO exameRequisicaoVO = requisicao.getExamesMultiguia().get(i);
                AgendamentoExameRequisicaoBean agendamentoExameRequisicaoBean = new AgendamentoExameRequisicaoBean();
                agendamentoExameRequisicaoBean.setFilial(agendamentoBean.getFilial());
                agendamentoExameRequisicaoBean.setCodigo(agendamentoBean.getCodigo());
                agendamentoExameRequisicaoBean.setRequisicao(exameRequisicaoVO.getRequisicao());
                agendamentoExameRequisicaoBean.setExame(exameRequisicaoVO.getExame().getCodigo());
                agendamentoExameRequisicaoBean.setMaterial(exameRequisicaoVO.getMaterial().getCodigo());
                agendamentoExameRequisicao.add(agendamentoExameRequisicaoBean);
            }
        }
        return agendamentoExameRequisicao;
    }

    public int getQuantidadeAgendamentosDataHora(String filial, SalaAtendimentoVO salaAtendimento, Date data) throws Exception {
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, " select count(1) as quantidade from agendamento where fil_codigo = " + filial + " and sal_codigo = " + String.valueOf(salaAtendimento.getCodigo()) + " and agd_datahoraagenda = '" + Funcoes.formataData("yyyy-MM-dd HH:mm", data) + ":00' and agd_situacao NOT IN ('" + "C" + "', '" + "R" + "') ");
        if (!rs.next()) {
            return 0;
        }
        return rs.getInt("quantidade");
    }

    public void cancelarAgendamento(AbstractThreadBean bean, String filial, UsuarioVO usuario, Date dataCancelamento) throws Exception {
        if (bean != null) {
            AgendamentoBean tmp = (AgendamentoBean)bean;
            tmp.setUsuarioCancelamento(usuario);
            tmp.setDataHoraCancelamento(dataCancelamento);
            tmp.setSituacao("C");
            this.dao.update(bean, filial);
        }
    }

    public void finalizarAgendamento(AbstractThreadBean bean, String filial, UsuarioVO usuario) throws Exception {
        if (bean != null) {
            AgendamentoBean tmp = (AgendamentoBean)bean;
            tmp.setUsuario(usuario);
            tmp.setSituacao("F");
            this.dao.update(bean, filial);
        }
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((AgendamentoDao)this.dao).getBean(chaves);
    }

    public AbstractThreadBean getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return ((AgendamentoDao)this.dao).getVO(chaves);
    }

    public int pesquisaAgendamento(RequisicaoVO requisicaoVO) throws ThreadDaoException, SQLException {
        return ((AgendamentoDao)this.dao).buscaAgendamento(requisicaoVO);
    }

    public void adicionarExamesAgendamento(AgendamentoBean agendamento, ExameRequisicaoVO exameRequisicaoVO) throws Exception {
        AgendamentoExameRequisicaoBean agendamentoExameRequisicaoBean = new AgendamentoExameRequisicaoBean();
        agendamentoExameRequisicaoBean.setFilial(agendamento.getFilial());
        agendamentoExameRequisicaoBean.setCodigo(agendamento.getCodigo());
        agendamentoExameRequisicaoBean.setRequisicao(exameRequisicaoVO.getRequisicao());
        agendamentoExameRequisicaoBean.setExame(exameRequisicaoVO.getExame().getCodigo());
        agendamentoExameRequisicaoBean.setMaterial(exameRequisicaoVO.getMaterial().getCodigo());
        new AgendamentoService().insertAgendamentoExame(agendamentoExameRequisicaoBean, agendamento.getCodigo(), Variaveis.filialPadrao, null);
        Conexao.arquivaSQL();
    }

    public void deletarExamesAgendamento(AgendamentoBean agendamento, ExameRequisicaoVO exameRequisicaoVO) throws Exception {
        AgendamentoExameRequisicaoBean agendamentoExameRequisicaoBean = new AgendamentoExameRequisicaoBean();
        agendamentoExameRequisicaoBean.setFilial(agendamento.getFilial());
        agendamentoExameRequisicaoBean.setCodigo(agendamento.getCodigo());
        agendamentoExameRequisicaoBean.setRequisicao(exameRequisicaoVO.getRequisicao());
        agendamentoExameRequisicaoBean.setExame(exameRequisicaoVO.getExame().getCodigo());
        agendamentoExameRequisicaoBean.setMaterial(exameRequisicaoVO.getMaterial().getCodigo());
        new AgendamentoService().deleteAgendamentoExame(agendamentoExameRequisicaoBean, agendamento.getCodigo(), Variaveis.filialPadrao, null);
        Conexao.arquivaSQL();
    }
}

