/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.interfaceamento.liberacaoexame;

import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.model.dao.interfaceamento.liberacaoexame.AbaRecoletaDao;
import jalis.model.vo.cadastro.exame.InterfaceExameRequisicaoVO;
import jalis.model.vo.interfaceamento.liberacaoexame.AbaRecoletaVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AbaRecoletaService {
    private final AbaRecoletaDao dao = new AbaRecoletaDao();
    private ArrayList<String> colunasVisiveis;
    private ArrayList<String> colunasOcultas;

    public ArrayList pesquisarRecoletasInterface(String[] filiais, String[] coletas, String[] destinos, int equipamento, int quantidadeColunas, ArrayList<String> colunasVisiveis, ArrayList<String> colunasOcultas) throws SQLException {
        this.colunasVisiveis = colunasVisiveis;
        this.colunasOcultas = colunasOcultas;
        List<AbaRecoletaVO> recoletas = this.dao.pesquisarRecoletasInterface(filiais, coletas, destinos, equipamento);
        ArrayList<Object[]> linhas = new ArrayList<Object[]>();
        for (AbaRecoletaVO recoleta : recoletas) {
            Object[] linhaTabela = new Object[quantidadeColunas];
            RequisicaoVO requisicao = recoleta.getInterfaceExameRequisicao().getRequisicao();
            InterfaceExameRequisicaoVO ier = recoleta.getInterfaceExameRequisicao();
            String codFilial = Funcoes.preencheZero(requisicao.getFilial().getCodigo(), ParametrosGerais.getDigitosTuboFilial());
            String codRequisicao = Funcoes.preencheZero(requisicao.getCodigo(), ParametrosGerais.getDigitosTuboRequisicao());
            String codigo = codFilial.concat(codRequisicao);
            String idade = String.valueOf(requisicao.getIdade()) + " " + Tipos.tipoIdade(requisicao.getAnoMes());
            String nome = requisicao.getPaciente().getNome();
            if (Funcoes.textoVazio(nome.trim())) {
                nome = codigo.concat(" Nome n\u00e3o compativel com interfaceamento");
            }
            linhaTabela[this.getColIndice((String)"C\u00f3digo")] = codigo;
            linhaTabela[this.getColIndice((String)"Paciente")] = nome;
            linhaTabela[this.getColIndice((String)"Sexo")] = requisicao.getPaciente().getSexo();
            linhaTabela[this.getColIndice((String)"Idade")] = idade;
            linhaTabela[this.getColIndice((String)"Exame")] = ier.getExame().getCodigo();
            linhaTabela[this.getColIndice((String)"Usuario")] = ier.getUsuario().getCodigo();
            linhaTabela[this.getColIndice((String)"Sit")] = String.valueOf(ier.getSituacao());
            linhaTabela[this.getColIndice((String)"Mat.")] = ier.getMatColeta().getAbreviatura();
            linhaTabela[this.getColIndice((String)"C\u00f3d. Mat.")] = ier.getMatColeta().getCodigo();
            linhaTabela[this.getColIndice((String)"Tubo")] = ier.getRecipiente().getCodigo();
            linhaTabela[this.getColIndice((String)"Valor Alterado")] = ier.getResultadoAlterado();
            linhaTabela[this.getColIndice((String)"Valores")] = ier.getXmlValores();
            linhaTabela[this.getColIndice((String)"Previs\u00e3o")] = recoleta.getDataEntregaPrev();
            if (this.getColIndice("Contador") > -1) {
                linhaTabela[this.getColIndice((String)"Contador")] = ier.getRackPos();
            }
            if (this.getColIndice("Rack") > -1) {
                Object object = linhaTabela[this.getColIndice((String)"Rack")] = ier.getRackPos() == null || ier.getRackPos().isEmpty() ? null : Integer.valueOf(ier.getRackPos());
            }
            if (this.getColIndice("Urgente") > -1) {
                linhaTabela[this.getColIndice((String)"Urgente")] = requisicao.getUrgente();
            }
            linhaTabela[this.getColIndice((String)"Interface")] = ier.getInterfaceamento().getCodigo();
            linhaTabela[this.getColIndice((String)"Alternativo")] = recoleta == null || recoleta.getAlternativo() == null || recoleta.getAlternativo().isEmpty() ? null : recoleta.getAlternativo();
            Object object = linhaTabela[this.getColIndice((String)"Cod. M\u00e9todo")] = recoleta != null && recoleta.getMetodologia() != null ? recoleta.getMetodologia().getCodigo() : null;
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                String multiguia = Funcoes.preencheZero(requisicao.getFilial().getCodigo(), ParametrosGerais.getDigitosTuboFilial());
                multiguia = multiguia + Funcoes.preencheZero(recoleta.getMultiguia(), ParametrosGerais.getDigitosTuboRequisicao());
                linhaTabela[this.getColIndice((String)"Multiguia")] = multiguia;
                linhaTabela[this.getColIndice((String)"C\u00f3digo Temp.")] = codigo;
                if (codigo.equalsIgnoreCase(multiguia)) {
                    linhaTabela[this.getColIndice((String)"C\u00f3digo")] = "";
                }
            }
            if (BDUtil.isExameDesmembrado(codFilial, ier.getInterfaceamento().getCodigo().toString(), ier.getExame().getCodigo(), ier.getMatColeta().getCodigo().toString())) {
                linhaTabela[this.getColIndice((String)"Tubos Filhos")] = BDUtil.getExameDesmembradoTubos(codFilial, codRequisicao, ier.getRecipiente().getCodigo().toString(), ier.getExame().getCodigo(), ier.getMatColeta().getCodigo().toString(), ier.getInterfaceamento().getCodigo().toString());
            }
            if (ier.getXmlValores() != null) {
                Map<String, Object> dados = StringUtil.getMapDeXML(ier.getXmlValores());
                List<String> flags = StringUtil.getListDeXML(StringUtil.converteHtmlParaAcentos((String)dados.get("flag")));
                linhaTabela[this.getColIndice((String)"F")] = flags != null && !flags.isEmpty() ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            linhas.add(linhaTabela);
        }
        return linhas;
    }

    private int getColIndice(String nome_coluna) {
        int c = this.colunasVisiveis.indexOf(nome_coluna);
        if (c >= 0) {
            return c;
        }
        c = this.colunasOcultas.indexOf(nome_coluna);
        if (c >= 0) {
            return this.colunasVisiveis.size() + c;
        }
        return -1;
    }
}

