/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.integracaolaboratorioexterno;

import br.com.hermespardini.b2b.apoio.schemas.RastreabilidadeAmostra;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.db2.DBCamposRetornoLaudoAtendimento;
import jalis.model.bean.cadastro.exame.MotivoRecoletaBean;
import jalis.model.bean.loteexterno.LoteExternoRequisicaoRastreioBean;
import jalis.model.dao.integracaolaboratorioexterno.LoteExternoRequisicaoRastreioDao;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.joda.time.DateTime;

public class LoteExternoRequisicaoRastreioService {
    private final LoteExternoRequisicaoRastreioDao dao = new LoteExternoRequisicaoRastreioDao();

    public void registraRastreabilidade(RastreabilidadeAmostra[] registros, String codigoFilial) throws SQLException {
        LoteExternoRequisicaoRastreioDao loteExternoRequisicaoRastreioDao = new LoteExternoRequisicaoRastreioDao();
        for (RastreabilidadeAmostra rastreabilidadeAmostra : registros) {
            if (Funcoes.textoVazio(rastreabilidadeAmostra.getIdtuboLab())) continue;
            String codigoTubo = rastreabilidadeAmostra.getIdtuboLab();
            List<LoteExternoRequisicaoRastreioBean> listaRastreio = loteExternoRequisicaoRastreioDao.buscarDados(rastreabilidadeAmostra.getEtqCodBar(), codigoFilial);
            for (LoteExternoRequisicaoRastreioBean rastreio : listaRastreio) {
                SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                s.setTimeZone(TimeZone.getTimeZone("GMT"));
                String a = s.format(rastreabilidadeAmostra.getDataHoraStatusAmostra().getTime());
                rastreio.setDataHoraStatus(a);
                if (this.possuiLogs(codigoFilial, rastreio.getCodigoRequisicao().toString(), rastreio.getCodigoExame(), rastreio.getCodigoMaterial(), rastreio.getDataHoraStatus())) continue;
                rastreio.setCodigoStatus(Integer.valueOf(rastreabilidadeAmostra.getCodStatus()));
                rastreio.setCodigoRastreio(loteExternoRequisicaoRastreioDao.getMaiorCodigo());
                rastreio.setDescricaoStatus(rastreabilidadeAmostra.getDescricaoStatus());
                rastreio.setOrigemPedido(rastreabilidadeAmostra.getOrigemPed());
                rastreio.setCodigoTubo(codigoTubo);
                loteExternoRequisicaoRastreioDao.inserirLogs(rastreio);
            }
        }
    }

    public List<LoteExternoRequisicaoRastreioBean> getRastreabilidade(String codigoFilial, String codigoRequisicao, String codigoExame, Integer codigoMaterial) throws SQLException {
        return this.dao.getRastreabilidade(codigoFilial, codigoRequisicao, codigoExame, codigoMaterial);
    }

    public boolean possuiLogs(String codigoFilial, String codigoRequisicao, String codigoExame, Integer codigoMaterial, String dataHoraStatus) throws SQLException {
        return this.dao.possuiLogs(codigoFilial, codigoRequisicao, codigoExame, codigoMaterial, dataHoraStatus);
    }

    public List<LoteExternoRequisicaoRastreioBean> registraPendencias(List<String> amostrasPendentes, int codigoLabExterno, String codigoFilial, boolean marcarExameRecoleta, MotivoRecoletaBean motivo) throws SQLException {
        List<LoteExternoRequisicaoRastreioBean> listaRastreio = this.converterAmostrasPendentesParaLoteExternoRequisicaoRastreioBean(amostrasPendentes, codigoLabExterno, codigoFilial);
        for (LoteExternoRequisicaoRastreioBean rastreio : listaRastreio) {
            this.inserirLogs(rastreio);
            boolean podeAlterarParaRecoleta = this.dao.podeAlterarParaRecoleta(rastreio.getCodigoStatusTexto());
            rastreio.setPodeAlterarParaRecoleta(podeAlterarParaRecoleta);
            if (!marcarExameRecoleta) continue;
            this.atualizarRequisicaoRecoleta(rastreio, podeAlterarParaRecoleta, motivo);
        }
        return listaRastreio;
    }

    private LoteExternoRequisicaoRastreioBean inserirLogs(LoteExternoRequisicaoRastreioBean rastreio) throws SQLException {
        Integer[] guias;
        boolean agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExternoLote(Conexao.getStatement(), rastreio.getCodigoFilial().toString(), rastreio.getCodigoRequisicao().toString());
        ArrayList<Integer> multiguias = new ArrayList<Integer>();
        if (agruparMultiguias && (guias = RecepcaoUtil.verificaMultiGuias(rastreio.getCodigoFilial().toString(), rastreio.getCodigoRequisicao().toString())) != null) {
            Collections.addAll(multiguias, guias);
        }
        multiguias.add(rastreio.getCodigoRequisicao());
        for (Integer guia : multiguias) {
            ExameMatColetaVO vo = this.dao.pesquisarCodigoExameValidoNaMultiguia(rastreio, guia);
            if (vo.getExame() == null || vo.getMaterial() == null || !vo.getExame().getCodigo().equals(rastreio.getCodigoExame()) || !vo.getMaterial().getCodigo().equals(rastreio.getCodigoMaterial())) continue;
            rastreio.setCodigoRequisicao(guia);
            this.dao.inserirLogs(rastreio);
        }
        return rastreio;
    }

    private void atualizarRequisicaoRecoleta(LoteExternoRequisicaoRastreioBean rastreio, boolean podeAlterarParaRecoleta, MotivoRecoletaBean motivo) throws SQLException {
        ExameRequisicaoService serviceExameRequisicao = new ExameRequisicaoService();
        boolean exameTemResultado = serviceExameRequisicao.exameJaTemResultadoExameRequisicao(Conexao.getStatement(), rastreio.getKodigoFilial().toString(), rastreio.getCodigoRequisicao().toString(), rastreio.getCodigoExame(), rastreio.getCodigoMaterial().toString());
        rastreio.setExameComResultado(exameTemResultado);
        if (podeAlterarParaRecoleta && !exameTemResultado) {
            serviceExameRequisicao.updateRequisicaoRecoleta(Conexao.getStatement(), motivo, rastreio);
        }
    }

    public List<LoteExternoRequisicaoRastreioBean> converterAmostrasPendentesParaLoteExternoRequisicaoRastreioBean(List<String> amostrasPendentes, int codigoLabExterno, String codigoFilial) throws SQLException {
        ArrayList<LoteExternoRequisicaoRastreioBean> lista = new ArrayList<LoteExternoRequisicaoRastreioBean>();
        for (String consultaPendente : amostrasPendentes) {
            String atendimentoApoiado = StringUtil.getValor(consultaPendente, DBCamposRetornoLaudoAtendimento.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag());
            String filiaApoiado = this.getFiliaApoiado(atendimentoApoiado);
            String codigoRequisicao = this.getCodigoRequisicao(atendimentoApoiado);
            String codigoLote = this.dao.pesquisarCodigoLoteAtivo(filiaApoiado, codigoRequisicao, codigoLabExterno);
            if (consultaPendente == null || Funcoes.textoVazio(codigoLote)) continue;
            for (String consultaExame : StringUtil.getValores(consultaPendente, DBCamposRetornoLaudoAtendimento.TAG_PROCEDIMENTO_MMP_V2.getTag())) {
                LoteExternoRequisicaoRastreioBean rastreio = new LoteExternoRequisicaoRastreioBean();
                ExameMatColetaVO vo = this.dao.getExameEMaterialJalis(StringUtil.getValor(consultaExame, DBCamposRetornoLaudoAtendimento.TAG_CODIGO_EXAME_DB.getTag()), codigoFilial, codigoRequisicao, codigoLabExterno);
                DateTime dataHoraPedido = new DateTime((Object)StringUtil.getValor(consultaPendente, DBCamposRetornoLaudoAtendimento.TAG_DATA_HORA_PEDIDO.getTag()));
                rastreio.setCodigoFilial(Integer.valueOf(codigoFilial));
                rastreio.setKodigoFilial(Integer.valueOf(filiaApoiado));
                rastreio.setCodigoLoteExterno(Long.valueOf(codigoLote));
                rastreio.setCodigoLabExterno(codigoLabExterno);
                rastreio.setCodigoRequisicao(Integer.valueOf(codigoRequisicao));
                rastreio.setCodigoExame(vo.getExame().getCodigo());
                rastreio.setCodigoMaterial(vo.getMaterial().getCodigo());
                rastreio.setCodigoRastreio(Integer.valueOf(atendimentoApoiado));
                rastreio.setCodigoTubo("0");
                rastreio.setOrigemPedido("Webservice");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                rastreio.setDataHoraStatus(sdf.format(Funcoes.getDataHoraServidor()));
                rastreio.setDataHoraPedido(dataHoraPedido.toString());
                rastreio.setSequencialExame(Integer.valueOf(StringUtil.getValor(consultaExame, DBCamposRetornoLaudoAtendimento.TAG_SEQUENCIA_EXAME_DB.getTag())));
                rastreio.setCodigoStatusTexto(StringUtil.getValor(consultaExame, DBCamposRetornoLaudoAtendimento.TAG_STATUS.getTag()));
                rastreio.setCodigoStatus(0);
                rastreio.setDescricaoStatus(this.dao.getDescricaoStatusDB(StringUtil.getValor(consultaExame, DBCamposRetornoLaudoAtendimento.TAG_STATUS.getTag())));
                rastreio.setNumeroAtendimentoApoiado(atendimentoApoiado);
                rastreio.setNomePaciente(StringUtil.getValor(consultaPendente, DBCamposRetornoLaudoAtendimento.TAG_NOME_PACIENTE.getTag()));
                lista.add(rastreio);
            }
        }
        return lista;
    }

    private String getCodigoRequisicao(String atendimentoApoiado) {
        return atendimentoApoiado.substring(ParametrosGerais.getDigitosTuboFilial(), atendimentoApoiado.length());
    }

    private String getFiliaApoiado(String atendimentoApoiado) {
        return atendimentoApoiado.substring(0, ParametrosGerais.getDigitosTuboFilial());
    }
}

