/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.integracaolaboratorioexterno;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.impressao.exame.externo.saoMarcos.ConexaoSaoMarcos;
import jalis.laboratorio.util.parsers.saomarcos.ExameSaoMarcos;
import jalis.laboratorio.util.parsers.saomarcos.SaoMarcosException;
import jalis.model.dao.integracaolaboratorioexterno.ExameSaoMarcosDao;
import jalis.model.vo.cadastro.exame.ExameSaoMarcosVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExameSaoMarcosService {
    private ExameSaoMarcosDao exameSaoMarcosDAO;

    public Map<String, ExameSaoMarcosVO> loadExamesSaoMarcos(int codigoLabExterno, String codigoFilial) throws SQLException {
        this.exameSaoMarcosDAO = new ExameSaoMarcosDao();
        return this.exameSaoMarcosDAO.loadExamesSaoMarcos(codigoLabExterno, codigoFilial);
    }

    public Map<String, ExameSaoMarcosVO> loadExamesSaoMarcos(int codigoLabExterno, String codigoExame, String codigoFilial) throws SQLException {
        this.exameSaoMarcosDAO = new ExameSaoMarcosDao();
        return this.exameSaoMarcosDAO.loadExamesSaoMarcos(codigoLabExterno, codigoExame, codigoFilial);
    }

    public void atualizarXml(String codigoFilial, int codigoLabExterno, String codigoExame, String xml) throws SQLException {
        this.exameSaoMarcosDAO = new ExameSaoMarcosDao();
        this.exameSaoMarcosDAO.atualizarXml(codigoFilial, codigoLabExterno, codigoExame, xml);
    }

    public String getXml(String codigoLabExterno, String codigoExameLabApoio, String codigoFilial) throws SQLException {
        this.exameSaoMarcosDAO = new ExameSaoMarcosDao();
        return this.exameSaoMarcosDAO.getXml(codigoLabExterno, codigoExameLabApoio, codigoFilial);
    }

    public boolean buscaRequisicao(String filial, String requisicao) throws SQLException, SaoMarcosException {
        this.exameSaoMarcosDAO = new ExameSaoMarcosDao();
        if (!this.exameSaoMarcosDAO.buscaRequisicao(filial, requisicao)) {
            throw new SaoMarcosException("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o encontrado no sistema");
        }
        return true;
    }

    public boolean validarConexao(String filial, LaboratorioExterno labExterno, Statement st, boolean isColetaWeb) throws SaoMarcosException {
        ConexaoSaoMarcos conexao = new ConexaoSaoMarcos();
        if (!conexao.validaToken(filial, labExterno, st, isColetaWeb)) {
            throw new SaoMarcosException();
        }
        return true;
    }

    public String getRequisicaoResultado(String config, String dataInicial, String dataFinal) throws IOException {
        ConexaoSaoMarcos conexao = new ConexaoSaoMarcos();
        String retorno = "";
        String dataInicio = Funcoes.formataData("yyyy.MM.dd", dataInicial) + "T00P00";
        String dataFim = Funcoes.formataData("yyyy.MM.dd", dataFinal) + "T00P00";
        String endWS = StringUtil.getValor(config, "enderecoWebService");
        String url = endWS + "/amostra/lista/" + dataInicio + "/" + dataFim + "/LSMH";
        retorno = conexao.getRequisicaoResultado(config, url);
        return retorno;
    }

    public List<ExameSaoMarcos> getResultado(String configuracaoOriginal, String requisicao) throws IOException {
        ConexaoSaoMarcos conexao = new ConexaoSaoMarcos();
        String retorno = "";
        String endWS = StringUtil.getValor(configuracaoOriginal, "enderecoWebService");
        String url = endWS + "/amostra/" + requisicao + "/LSMH";
        retorno = conexao.getRequisicaoResultado(configuracaoOriginal, url);
        return this.extrairResultado(retorno);
    }

    private List<ExameSaoMarcos> extrairResultado(String xml) {
        String codigoLis = StringUtil.getValor(xml, "codigo_lis");
        if (!Funcoes.textoVazio(codigoLis)) {
            String[] listaExames;
            String[] amostras = StringUtil.getValores(xml, "amostras");
            ArrayList<ExameSaoMarcos> exames = new ArrayList<ExameSaoMarcos>();
            for (String exame : listaExames = StringUtil.getValores(xml, "exame")) {
                String[] listaResultados;
                String exameJalis = StringUtil.getValor(exame, "codigo");
                String dataResultado = StringUtil.getValor(exame, "dataresultado");
                String observacao = StringUtil.getValor(exame, "observacao");
                String resultados = exame.substring(exame.indexOf("<observacao>"), exame.length());
                for (String res : listaResultados = resultados.split("<amostra>")) {
                    String atributo = StringUtil.getValor(res, "atributo");
                    if (Funcoes.textoVazio(atributo)) continue;
                    String linhaResultado = StringUtil.getValor(res, "linharesultado");
                    String metodo = StringUtil.getValor(res, "metodo");
                    String resultado = StringUtil.getValor(res, "resultado");
                    String conclusao = StringUtil.getValor(res, "conclusao");
                    String observacaoExame = StringUtil.getValor(res, "observacao");
                    String valorReferencia = this.tratarValorReferencia(StringUtil.getValor(res, "vlr_referencia"));
                    String tubo = StringUtil.getValor(exame, "codigo");
                    String codigoFilial = codigoLis.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String codigoRequisicao = codigoLis.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                    ExameSaoMarcos exameSaoMarcos = new ExameSaoMarcos();
                    for (String amostra : amostras) {
                        if (!codigoLis.equals(StringUtil.getValor(amostra, "codigo"))) continue;
                        exameSaoMarcos.setAmostra(amostra);
                        break;
                    }
                    exameSaoMarcos.setCodigoLis(codigoLis);
                    exameSaoMarcos.setCodigoRequisicao(codigoRequisicao);
                    exameSaoMarcos.setCodigoFilial(codigoFilial);
                    exameSaoMarcos.setTuboId(tubo);
                    exameSaoMarcos.setCodigoExame(exameJalis);
                    exameSaoMarcos.setDataResultado(dataResultado);
                    exameSaoMarcos.setLinhaResultado(linhaResultado);
                    exameSaoMarcos.setResultado(resultado);
                    exameSaoMarcos.setValorReferencia(valorReferencia);
                    exameSaoMarcos.setAtributo(atributo);
                    exameSaoMarcos.setConclusao(conclusao);
                    exameSaoMarcos.setObservacao(observacao);
                    exameSaoMarcos.setObservacaoResultado(observacaoExame);
                    exameSaoMarcos.setMetodo(metodo);
                    exames.add(exameSaoMarcos);
                }
            }
            return exames;
        }
        return null;
    }

    private String tratarValorReferencia(String valor) {
        String valorReferencia = "";
        if (!Funcoes.textoVazio(valor)) {
            valorReferencia = valor.substring(valor.indexOf("\\pard") + 6);
            valorReferencia = valorReferencia.substring(0, valorReferencia.indexOf("\\par}}"));
            valorReferencia = valorReferencia.replaceAll("\\\\line", "\\\n");
        }
        return valorReferencia;
    }

    public ExameSaoMarcos localizaExameRelacionado(ExameSaoMarcos exameSaoMarcos) throws SQLException {
        this.exameSaoMarcosDAO = new ExameSaoMarcosDao();
        List<Registro> listaRegistro = this.exameSaoMarcosDAO.consultaRelacionamentoMatColeta(exameSaoMarcos);
        Object registroSelecionado = null;
        for (Registro registro : listaRegistro) {
            exameSaoMarcos.setCodigoExameJalis(registro.getString("exa_codigo"));
            exameSaoMarcos.setCodigoMaterialJalis(registro.getString("mco_codigo"));
        }
        return exameSaoMarcos;
    }

    public Registro localizaExame(ExameSaoMarcos exameSaoMarcos, String codigoExame, String codigoMaterial) throws SQLException {
        this.exameSaoMarcosDAO = new ExameSaoMarcosDao();
        Registro registroSelecionado = null;
        registroSelecionado = this.exameSaoMarcosDAO.localizaExame(exameSaoMarcos, codigoExame, codigoMaterial);
        return registroSelecionado;
    }
}

