/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.integracaoaplicativo;

import jalis.laboratorio.Laboratorio;
import jalis.model.dao.integracaoaplicativo.IntegracaoAplicativoDao;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.model.vo.integracaojalis.LogsPushAppVO;
import jalis.service.cadastro.FilialService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class IntegracaoAplicativoService {
    private IntegracaoAplicativoDao dao = new IntegracaoAplicativoDao();
    private static String CHAVE = "threadsysapp";
    private final String URL = "http://app.jalis.com.br/api/envia_push.php?";

    public void inserirLogs(LogsPushAppVO logsPushApp) throws SQLException {
        logsPushApp.setDataHora(Funcoes.getDataHoraAtual());
        logsPushApp.setEnviado(false);
        this.dao.inserirLogs(logsPushApp);
    }

    public List<LogsPushAppVO> buscaLogs(boolean situacao) throws SQLException {
        return this.dao.buscarLogs(situacao);
    }

    public int quantidadeLogs() {
        return this.dao.quantidadeLogs();
    }

    public void atualizarLog(Integer codigoFilial, Long codigoLog, boolean enviado, String retorno) throws SQLException {
        String ret = "-";
        if (retorno.length() > 50) {
            ret = retorno.substring(retorno.indexOf("id_push") + 27, retorno.indexOf("id_push") + 27 + 36);
        }
        this.dao.atualizarLogs(codigoFilial, codigoLog, true, ret);
    }

    public void enviarMensagem(LogsPushAppVO logsPushAppVO) {
        String codigo = this.encript(logsPushAppVO.getCodigoPaciente().toString());
        HttpsURLConnection conn = null;
        StringBuilder response = new StringBuilder();
        if (null != logsPushAppVO) {
            try {
                String inputLine;
                FilialVOAux filialVO = this.buscaFilial(logsPushAppVO.getCodigoFilial());
                String id = "";
                StringBuilder buf = new StringBuilder();
                buf.append("https://app.jalis.com.br/api/envia_push.php?codigo=");
                buf.append(codigo);
                buf.append("&id=").append(id);
                URL url = new URL(buf.toString());
                TrustManager[] trustAllCertificates = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCertificates, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                conn = (HttpsURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                OutputStream os = conn.getOutputStream();
                os.flush();
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                this.atualizarLog(logsPushAppVO.getCodigoFilial(), logsPushAppVO.getCodigoLog(), logsPushAppVO.isEnviado(), response.toString());
            }
            catch (MalformedURLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "URL do aplicativo inv\u00e1lido. Favor verificar.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private FilialVOAux buscaFilial(Integer codigoFilial) throws Exception {
        FilialService filialService = new FilialService();
        FilialVOAux filialAux = filialService.buscaFilial(codigoFilial.toString());
        return filialAux;
    }

    public String encript(String texto) {
        StringBuilder temp = new StringBuilder();
        int ctr = 0;
        for (int i = 0; i < texto.length(); ++i) {
            if (ctr == CHAVE.length()) {
                ctr = 0;
            }
            temp.append(CHAVE.charAt(ctr)).append((char)(texto.charAt(i) ^ CHAVE.charAt(ctr++)));
            ++ctr;
        }
        String hash = this.getEncryptionKeyer(temp.toString());
        StringBuilder retorno = new StringBuilder();
        for (int i = 0; i < hash.length(); ++i) {
            retorno.append(StringUtil.preencheString(this.base_convert(String.valueOf(this.ord(hash.charAt(i))), 10, 16), 2, "0".charAt(0), 1));
        }
        return retorno.toString();
    }

    public String decript(String texto) {
        StringBuilder hash = new StringBuilder();
        StringBuilder retorno = new StringBuilder();
        for (int i = 0; i < texto.length(); i += 2) {
            String tmpHexa = texto.substring(i, i + 2);
            String tmpOrd = this.base_convert(tmpHexa, 16, 10);
            hash.append(String.valueOf((char)Integer.parseInt(tmpOrd)));
        }
        String chave = this.getEncryptionKeyer(hash.toString());
        for (int i = 0; i < chave.length(); i += 2) {
            retorno.append(String.valueOf((char)(chave.charAt(i + 1) ^ chave.charAt(i))));
        }
        return retorno.toString();
    }

    private String base_convert(String inputValue, int fromBase, int toBase) {
        if (Funcoes.textoVazio(inputValue)) {
            return inputValue;
        }
        if (fromBase < 2 || fromBase > 36 || toBase < 2 || toBase > 36) {
            return null;
        }
        String ret = null;
        String numberInputValue = inputValue;
        try {
            Integer in = Integer.parseInt(numberInputValue, fromBase);
            ret = Integer.toString(in, toBase);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private String getEncryptionKeyer(String texto) {
        StringBuilder retorno = new StringBuilder();
        int ctr = 0;
        int txt_len = texto.length();
        for (int i = 0; i < txt_len; ++i) {
            if (ctr == CHAVE.length()) {
                ctr = 0;
            }
            retorno.append((char)(texto.charAt(i) ^ CHAVE.charAt(ctr++)));
        }
        return retorno.toString();
    }

    private int ord(String s) {
        return s.length() > 0 ? s.getBytes(StandardCharsets.ISO_8859_1)[0] & 0xFF : 0;
    }

    private int ord(char c) {
        return c < 128 ? c : this.ord(Character.toString((char)c));
    }
}

