/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.impressao;

import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.impressao.Impressao;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.RetornoTermoConsentimento;
import jalis.model.dao.impressao.ImprimirTermoConsentimentoDao;
import jalis.model.dao.recepcao.RequisicaoTermoConsentimentoVO;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.service.impressao.TelaTermo;
import jalis.util.ArraysUtil;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.JFrame;
import org.apache.commons.codec.binary.Base64;
import org.postgresql.util.PGInterval;

public class ImprimirTermoConsentimentoService {
    private static final String[] CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO = new String[]{"cartaoSUSPaciente", "cartaoSUSRequisicao", "numeroEnderecoCobrancaPaciente", "numeroEnderecoResponsavelRequisicao", "numeroEnderecoPaciente", "numeroEnderecoConvenioRepasse", "whatsAppPaciente", "numeroEnderecoConvenio", "numeroEnderecoMedico", "tipoLogradouroMedico", "tipoLogradouroResponsavelRequisicao", "tipoLogradouroPaciente", "tipoLogradouroCobrancaPaciente", "tipoLogradouroConvenio", "tipoLogradouroConvenioRepasse", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "obsRequisicao", "totalPagoRequisicao", "horaEntregaRequisicao", "totalRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "idadeRequisicao", "anoMesRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "pesoRequisicao", "alturaRequisicao", "descontoRequisicao", "valorDescontoRequisicao", "acrescimoRequisicao", "valorAcrescimoRequisicao", "valorExamesRequisicao", "valorMateriaisRequisicao", "guiaRequisicao", "notaCaixaRequisicao", "complementoDestinoRequisicao", "multiguiasRequisicao", "imprimirSeparadoRequisicao", "datasEntregaParcialRequisicao", "existeExamesSemMaterial", "codigoSituacao", "descricaoSituacao", "tipoUltimoPagamentoRequisicao", "prontuarioRequisicao", "codigoUsuario", "nomeUsuario", "assinaturaUsuario", "codigoUsuarioAbertura", "nomeUsuarioAbertura", "assinaturaUsuarioAbertura", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoCidadeUnidadeSaude", "descricaoCidadeUnidadeSaude", "estadoCidadeUnidadeSaude", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoBairroMedico", "descricaoBairroMedico", "codigoBairroDestino", "descricaoBairroDestino", "codigoBairroColeta", "descricaoBairroColeta", "perguntasRequisicao", "codigoBairroUnidadeSaude", "descricaoBairroUnidadeSaude", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoDestino", "descricaoDestino", "enderecoDestino", "complementoDestino", "cepDestino", "foneDestino", "enviarParaWebDestino", "codigoColeta", "descricaoColeta", "enderecoColeta", "complementoColeta", "cepColeta", "foneColeta", "codigoUnidadeSaude", "descricaoUnidadeSaude", "enderecoUnidadeSaude", "complementoUnidadeSaude", "cepUnidadeSaude", "foneUnidadeSaude", "codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "integracaoEntreFiliais", "tipoIntegracaoEntreFiliais", "conselhoMedico", "crmMedico", "estadoCrmMedico", "nomeMedico", "nomeMedicoSemAcentos", "tratamentoMedico", "enderecoMedico", "complementoMedico", "cepMedico", "foneMedico", "celularMedico", "faxMedico", "emailMedico", "siteMedico", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "enderecoConvenio", "complementoConvenio", "cepConvenio", "foneConvenio", "email1Convenio", "email2Convenio", "siteConvenio", "codigoConvenioRepasse", "fantasiaConvenioRepasse", "razaoSocialConvenioRepasse", "enderecoConvenioRepasse", "complementoConvenioRepasse", "cepConvenioRepasse", "foneConvenioRepasse", "email1ConvenioRepasse", "email2ConvenioRepasse", "siteConvenioRepasse", "codigoPaciente", "nomePaciente", "nomePacienteSemAcentos", "sexoPaciente", "dataNascimentoPaciente", "grupoSanguineoPaciente", "fatorRHPaciente", "fatorDUPaciente", "corPaciente", "profissaoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "dumPaciente", "fonePaciente", "celularPaciente", "faxPaciente", "foneComercialPaciente", "nomePagadorPaciente", "cpfPagadorPaciente", "enderecoPaciente", "complementoPaciente", "cepPaciente", "emailPaciente", "foneContatoPaciente", "contatoPaciente", "senhaWebPaciente", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "codigoTabelaPreco", "descricaoTabelaPreco", "moedaTabelaPreco", "fumantePaciente", "diabeticoPaciente", "periodoGestacionalRequisicao", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "areaProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "descricaoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao", "foneResponsavelRequisicao", "anoPRPProdutoRequisicao", "cicloPRPProdutoRequisicao", "amostraPRPProdutoRequisicao", "amostraSupervisaoPRPProdutoRequisicao", "horaInicioTurnoPRPProdutoRequisicao", "turnoPRPProdutoRequisicao", "linhaPRPProdutoRequisicao", "volumeAbatePRPProdutoRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "razaoSocialResponsavelRequisicao", "enderecoResponsavelRequisicao", "complementoResponsavelRequisicao", "cepResponsavelRequisicao", "cpfCnpjResponsavelRequisicao", "descricaoCidadeResponsavelRequisicao", "estadoCidadeResponsavelRequisicao", "descricaoBairroResponsavelRequisicao", "dataRecebimentoProdutoRequisicao", "horaRecebimentoProdutoRequisicao", "localColetaProdutoRequisicao", "numeroSolicitacaoProdutoRequisicao", "fornecedorProdutoRequisicao", "codigoProdutoAlimento", "descricaoProdutoAlimento", "codigoCategoriaProdutoAlimento", "descricaoCategoriaProdutoAlimento", "procedenciaRequisicao", "suplementoRequisicao", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "pelagemPaciente", "codigoEspecie", "descricaoEspecie", "cientificoEspecie", "codigoRaca", "descricaoRaca", "cientificoRaca", "codigoEmpresaPaciente", "fantasiaEmpresaPaciente", "razaoSocialEmpresaPaciente", "foneEmpresaPaciente", "codigoPais", "nomePais", "dataCertificado", "numeroCertificado", "termoColetaAmostra", "totalTaxaRequisicao", "quantidadeExameSemMaterial", "nomeSocialPaciente", "responsavelPacienteRequisicao", "cpfResponsavelPacienteRequisicao", "incapacitadoPacienteRequisicao", "responsavelPaciente", "cpfResponsavelPaciente", "incapacitadoPaciente", "idadeRequisicaoPaciente", "chaveAcessoRequisicao", "passaportePaciente"};
    private static String[] CAMPOS_ADICIONAIS = new String[]{"descricaoExameSemAcento", "codigoExame", "descricaoExame", "ambExame", "chExame", "valorExame", "valorMateriaisExame", "tempoJejumExame", "descricaoMaterial", "codigoMaterial", "abreviaturaMaterial", "dataColetaExame", "horaColetaExame", "usuarioColetaExame", "descricaoPrazo", "codigoPrazo", "codigoMetodo", "situacaoExame", "descricaoSituacaoExame", "descricaoMetodo", "materialInformadoExame", "dataEntregaExame", "horaEntregaExame", "valorCH", "autorizacaoExame", "observacaoPrazoCarenciaExame", "valorExameConvenio", "codigoSetorExame", "custoCBHPMExame", "ucoCBHPMExame", "valorPorteCBHPMExame", "porteCHBPMExame", "materialExternoExame", "descricaoSetorExame", "abreviaturaSetorExame", "soaExame", "coaExame", "urgenteExame", "certificadoInmetroExame", "valorExameProposta"};
    private static final String[] CAMPOS_ADICIONAIS_RODAPE = new String[]{"codigoTuboRodape", "codigosExamesRodape", "codigoMaterialRodape", "nomePacienteRodape", "descricaoMaterialRodape", "abreviaturaMaterialRodape", "codigoRequisicaoRodape", "descricaoRecipienteRodape", "descricaoEstacaoRodape", "nomeSocialPacienteRodape"};
    public static final String[] CAMPOS_LANCAMENTO_CAIXA = new String[]{"codigoUltimoPagamentoRequisicao", "debitoCreditoUltimoPagamentoRequisicao", "dataHoraUltimoPagamentoRequisicao", "valorUltimoPagamentoRequisicao", "bancoUltimoPagamentoRequisicao", "agenciaUltimoPagamentoRequisicao", "documentoUltimoPagamentoRequisicao", "observacaoUltimoPagamentoRequisicao", "tipoDocumentoUltimoPagamentoRequisicao", "tipoPagamentoUltimoPagamentoRequisicao", "numeroChequeUltimoPagamentoRequisicao", "validadeCartaoUltimoPagamentoRequisicao", "numeroCartaoUltimoPagamentoRequisicao", "cartaoCreditoUltimoPagamentoRequisicao", "contaUltimoPagamentoRequisicao", "dataConciliacaoUltimoPagamentoRequisicao", "dataVencimentoUltimoPagamentoRequisicao", "codigoUsuarioUltimoPagamentoRequisicao", "codigoEstacaoUltimoPagamentoRequisicao", "codigoContaCorrenteUltimoPagamentoRequisicao", "contaContaCorrenteUltimoPagamentoRequisicao", "titularContaCorrenteUltimoPagamentoRequisicao", "nomePagadorPagamentoRequisicao", "cpfPagadorPagamentoRequisicao", "nomeDoPlano"};
    private static final String[] CAMPOS_AGENDAMENTO = new String[]{"codigoAgendamento", "dataHoraAgendamento", "situacaoAgendamento", "observacaoAgendamento", "codigoSalaAtendimento", "descricaoSalaAtendimento"};
    private static final int QUANTIDADE_AGENDAMENTOS = 10;
    private static final int CAMPO_MAIOR_DATA = 1;
    private static final int CAMPO_MENOR_DATA = 2;
    private static final String TERMO_TIPO_RELATORIO = "R";
    private static final String TERMO_TIPO_EXAME = "E";
    private static BigDecimal totalRequisicaoProposta = new BigDecimal(0);
    private final ImprimirTermoConsentimentoDao dao;
    private List<String> campos = new ArrayList<String>();
    private ModeloGridTable modeloDados;
    private String codigoFilial;
    private String codigoRequisicao;
    private String codigoPaciente;
    private Integer codigoLayout;
    private String codTermo;
    private String layout;
    private String tipoTermo;
    private String[] retorno;

    public ImprimirTermoConsentimentoService() {
        this.dao = new ImprimirTermoConsentimentoDao();
    }

    public String[] getCampos(int qtdeExamesCC, int colunasRodapeComprovante) {
        this.campos = new ArrayList<String>();
        this.adicionarCamposAdicionaisFilialAlimentos();
        this.adicionarCamposDoArray(CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO);
        this.adicionarCamposAdicionais(qtdeExamesCC);
        this.adicionarCamposRodape(colunasRodapeComprovante);
        this.adicionarCamposDoArray(jalis.laboratorio.util.impressao.Impressao.getCamposMedicamento());
        this.adicionarCamposDoArray(CAMPOS_LANCAMENTO_CAIXA);
        this.adicionarCamposAgendamento();
        return (String[])this.campos.stream().toArray(String[]::new);
    }

    private void adicionarCamposAdicionaisFilialAlimentos() {
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            CAMPOS_ADICIONAIS = ArraysUtil.concatenar(CAMPOS_ADICIONAIS, new String[]{"codigoGrupoPrincipal", "descricaoGrupoPrincipal"});
        }
    }

    private void adicionarCamposDoArray(String[] camposArray) {
        for (String campo : camposArray) {
            this.campos.add(campo);
        }
    }

    private void adicionarCamposAdicionais(int qtdeExamesCC) {
        if (qtdeExamesCC <= 1) {
            for (int i = 0; i < CAMPOS_ADICIONAIS.length; ++i) {
                this.campos.add(CAMPOS_ADICIONAIS[i]);
            }
        } else {
            for (int contador = 1; contador <= qtdeExamesCC; ++contador) {
                for (int i = 0; i < CAMPOS_ADICIONAIS.length; ++i) {
                    this.campos.add(CAMPOS_ADICIONAIS[i] + String.valueOf(contador));
                }
            }
        }
    }

    private void adicionarCamposRodape(int colunasRodapeComprovante) {
        if (colunasRodapeComprovante <= 1) {
            for (int i = 0; i < CAMPOS_ADICIONAIS_RODAPE.length; ++i) {
                this.campos.add(CAMPOS_ADICIONAIS_RODAPE[i]);
            }
        } else {
            for (int contador = 1; contador <= colunasRodapeComprovante; ++contador) {
                for (int i = 0; i < CAMPOS_ADICIONAIS_RODAPE.length; ++i) {
                    this.campos.add(CAMPOS_ADICIONAIS_RODAPE[i] + String.valueOf(contador));
                }
            }
        }
    }

    private void adicionarCamposAgendamento() {
        String[] camposAgendamento = new String[]{};
        for (int i = 0; i < 10; ++i) {
            String[] camposTemp = new String[CAMPOS_AGENDAMENTO.length];
            for (int posicao = 0; posicao < CAMPOS_AGENDAMENTO.length; ++posicao) {
                camposTemp[posicao] = CAMPOS_AGENDAMENTO[posicao] + (i + 1);
            }
            camposAgendamento = ArraysUtil.concatenar(camposAgendamento, camposTemp);
        }
        this.adicionarCamposDoArray(camposAgendamento);
    }

    public RetornoTermoConsentimento imprimir(String codigoFilial, String codigoRequisicao, String codTermo, Integer codigoLayout, String codigoPaciente, Statement st, Statement st2, boolean agruparImpressaoTermo, boolean isColetaWeb, String impressoraTermo, String tamanhoNomeImpressora, String[] impressorasLocais, boolean isAlimentos, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, boolean precoMetodologia, boolean ocultarApenasFaturamento, boolean ordenarSetor, String ordemComprovante, int qtdeExamesCC, String tipoIntegracao, int colunasRodapeComprovante, boolean agruparGuiasInterface, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        RetornoTermoConsentimento retorno = new RetornoTermoConsentimento();
        totalRequisicaoProposta = new BigDecimal(0);
        this.codigoFilial = codigoFilial;
        this.codigoRequisicao = codigoRequisicao;
        this.codigoLayout = codigoLayout;
        this.codigoPaciente = codigoPaciente;
        this.codTermo = codTermo;
        boolean modeloPreenchido = this.preencherModelo(codTermo, codigoLayout, st, st2, agruparImpressaoTermo, isAlimentos, casasPrecoExame, arredondamentoPrecoExame, precoMetodologia, ocultarApenasFaturamento, ordenarSetor, ordemComprovante, qtdeExamesCC, tipoIntegracao, colunasRodapeComprovante, agruparGuiasInterface, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, isColetaWeb, tuboPrimario);
        if (modeloPreenchido && this.getTipoTermo().equals(TERMO_TIPO_RELATORIO)) {
            retorno.setTipoTermo(TERMO_TIPO_RELATORIO);
            Relatorio termo = this.gerarTermo(agruparImpressaoTermo, impressoraTermo, tamanhoNomeImpressora, impressorasLocais, casasPrecoExame, arredondamentoPrecoExame);
            retorno.setLayoutRelatorio(this.layout);
            retorno.setTermoRelatorio(termo);
            String pdf = this.converterRelatorioParaPDFEncode64(termo);
            String codigos = codigoRequisicao;
            Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(st, codigoFilial, codigoRequisicao, true, false);
            if (agruparImpressaoTermo && multiguias != null && multiguias.length != 0) {
                for (Integer req : multiguias) {
                    if (codigoRequisicao.equals(String.valueOf(req))) continue;
                    codigos = codigos.concat(", ").concat(String.valueOf(req));
                }
            }
            this.salvarHistoricoDeImpressao(pdf, codigos, st, isColetaWeb, arquivar, anular);
            return retorno;
        }
        if (modeloPreenchido && this.getTipoTermo().equals(TERMO_TIPO_EXAME)) {
            return this.imprimirTermoTipoExame(codigoFilial, codigoRequisicao, codTermo, codigoLayout, st, st2, agruparImpressaoTermo, isColetaWeb, impressoraTermo, tamanhoNomeImpressora, impressorasLocais);
        }
        return null;
    }

    private Boolean preencherModelo(String codTermo, Integer codigoLayout, Statement st, Statement st2, boolean agruparImpressaoTermo, boolean isAlimentos, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, boolean precoMetodologia, boolean ocultarApenasFaturamento, boolean ordenarSetor, String ordemComprovante, int qtdeExamesCC, String tipoIntegracao, int colunasRodapeComprovante, boolean agruparGuiasInterface, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean isColetaWeb, boolean tuboPrimario) throws SQLException {
        ResultSet rs;
        Integer[] guias = RecepcaoUtil.verificaMultiGuias(st, this.codigoFilial, this.codigoRequisicao, true, false);
        int qtdeExames = RecepcaoUtil.getQtdeExamesSituacao(st, this.codigoFilial, this.codigoRequisicao, "F");
        if (guias.length > 1 && agruparImpressaoTermo) {
            StringBuilder bui = new StringBuilder();
            for (Integer guia : guias) {
                bui.append(", ");
                bui.append(String.valueOf(guia));
            }
            String requisicoes = bui.toString().substring(1);
            rs = this.dao.recuperarDados(st, this.codigoFilial, requisicoes, isAlimentos, casasPrecoExame, arredondamentoPrecoExame, precoMetodologia, ocultarApenasFaturamento, ordenarSetor, ordemComprovante);
        } else {
            rs = this.dao.recuperarDados(st, this.codigoFilial, this.codigoRequisicao, isAlimentos, casasPrecoExame, arredondamentoPrecoExame, precoMetodologia, ocultarApenasFaturamento, ordenarSetor, ordemComprovante);
        }
        this.modeloDados = new ModeloGridTable(this.getCampos(qtdeExamesCC, colunasRodapeComprovante));
        if (rs.next()) {
            this.retorno = ImprimirTermoConsentimentoDao.pesquisarTermoConsentimentoPorCodigoLayout(this.codigoFilial, codTermo, codigoLayout, st2);
            this.layout = this.retorno[0];
            this.setTipoTermo(this.retorno[1]);
            if (this.getTipoTermo().equals(TERMO_TIPO_RELATORIO)) {
                int ultimaPosicao = CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO.length;
                this.preencherCampos(rs, ultimaPosicao, qtdeExames, st2, qtdeExamesCC, agruparImpressaoTermo, tipoIntegracao, precoMetodologia, arredondamentoPrecoExame, casasPrecoExame);
                int ultimaPosicaoAux = ultimaPosicao = CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO.length + CAMPOS_ADICIONAIS.length * qtdeExamesCC;
                this.geraColunaRodape(ultimaPosicao, qtdeExames, ultimaPosicaoAux, colunasRodapeComprovante, agruparGuiasInterface, st, st2, ocultarApenasFaturamento, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, isColetaWeb, tuboPrimario);
            }
        }
        rs.close();
        return true;
    }

    private void adicionarHash(Statement st) throws SQLException {
        HashMap<String, Object> hash = jalis.laboratorio.util.impressao.Impressao.buscaDadosLancamentoRequisicao(this.codigoFilial, this.codigoRequisicao, st);
        if (!hash.isEmpty()) {
            Set<String> set = hash.keySet();
            for (String s : set) {
                Object value = hash.get(s);
                int pos = this.modeloDados.findColumn(s);
                if (pos <= -1) continue;
                this.modeloDados.setValueAt(value, this.modeloDados.getRowCount() - 1, pos);
            }
        }
    }

    private void preencherCampos(ResultSet rs, int ultimaPosicao, int qtdeExames, Statement st, int qtdeExamesCC, boolean agruparImpressaoTermo, String tipoIntegracao, boolean precoMetodologia, RoundingMode arredondamentoPrecoExame, int parametrosCasasPrecoExame) throws SQLException {
        String multiguias = this.getMultiguias(st);
        boolean fimTabela = false;
        while (!fimTabela) {
            int contador;
            this.modeloDados.addLine(new Object[this.modeloDados.getColumnCount()]);
            this.adicionarHash(st);
            this.preencheValorCamposTermoConsentimento(multiguias, rs, st, agruparImpressaoTermo, tipoIntegracao);
            for (contador = 1; contador <= qtdeExamesCC && !fimTabela; ++contador) {
                ultimaPosicao = this.preencheCamposAdicionais(rs, ultimaPosicao, qtdeExames, st, precoMetodologia, arredondamentoPrecoExame, parametrosCasasPrecoExame);
                fimTabela = !rs.next();
            }
            if (fimTabela) continue;
            contador = 1;
            ultimaPosicao = CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO.length;
        }
    }

    private Relatorio gerarTermo(boolean agruparImpressaoTermo, String impressoraTermo, String tamanhoNomeImpressora, String[] impressorasLocais, int casas, RoundingMode round) {
        Relatorio relatorio = new Relatorio(this.modeloDados, null, casas, round);
        relatorio.setConfiguracao(this.layout);
        relatorio.gerarRelatorio();
        this.imprimirRelatorio(relatorio, agruparImpressaoTermo, impressoraTermo, tamanhoNomeImpressora, impressorasLocais);
        return relatorio;
    }

    private void imprimirRelatorio(Relatorio relatorio, boolean agruparImpressaoTermo, String impressoraTermo, String tamanhoNomeImpressora, String[] impressorasLocais) {
        Gerador gerador;
        if (!agruparImpressaoTermo) {
            gerador = new Gerador(jalis.laboratorio.util.impressao.Impressao.comparaNomeImpressoraReduzido(impressoraTermo, tamanhoNomeImpressora, impressorasLocais));
            gerador.executar(relatorio);
        }
        if (agruparImpressaoTermo) {
            gerador = new Gerador(jalis.laboratorio.util.impressao.Impressao.comparaNomeImpressoraReduzido(impressoraTermo, tamanhoNomeImpressora, impressorasLocais));
            gerador.executar(relatorio);
        }
    }

    private String converterRelatorioParaPDFEncode64(Relatorio relatorio) {
        String PDFEncode64 = "";
        try {
            byte[] pdf = ImpressaoResultados.imprimirPdf(relatorio, relatorio.getFormatoPagina(), relatorio.getQuantidadePaginas());
            PDFEncode64 = Base64.encodeBase64String((byte[])pdf);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha ao converter relatorio para PDF - ".concat(e.getMessage()), e.getStackTrace());
        }
        return PDFEncode64;
    }

    private String converterDocumentoParaPDFEncode64(Documento relatorio, Integer quantidadePagina) {
        String PDFEncode64 = "";
        try {
            byte[] pdf = ImpressaoResultados.imprimirPdf(relatorio, relatorio.getFormatoPagina(), quantidadePagina);
            PDFEncode64 = Base64.encodeBase64String((byte[])pdf);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha ao converter documento para PDF - ".concat(e.getMessage()), e.getStackTrace());
        }
        return PDFEncode64;
    }

    private void salvarHistoricoDeImpressao(String PDFEncode64, String codigos, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        this.dao.salvarHistoricoImpressao(this.codigoFilial, codigos, PDFEncode64, this.codigoPaciente, this.codTermo, st, isColetaWeb, arquivar, anular);
    }

    private String getMultiguias(Statement st) throws SQLException {
        String multiguias = Arrays.toString((Object[])RecepcaoUtil.verificaMultiGuias(st, this.codigoFilial, this.codigoRequisicao, false, false));
        return Objects.isNull(multiguias) || multiguias.equals("null") ? "" : multiguias;
    }

    private void preencheValorCamposTermoConsentimento(String multiguias, ResultSet rs, Statement st, boolean agruparImpressaoTermo, String tipoIntegracao) throws SQLException {
        for (int i = 0; i < CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO.length; ++i) {
            if (DBUtil.campoNull(rs.getString(CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i]))) {
                this.modeloDados.setValueAt("", this.modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equals("codigoRequisicao")) {
                Integer[] codigos = this.validaMultiguiasTermo(this.codigoFilial, this.codigoRequisicao, this.codigoLayout, st, agruparImpressaoTermo);
                String requisicao = this.codigoRequisicao;
                if (codigos == null || codigos.length == 0) {
                    requisicao = this.codigoRequisicao;
                } else {
                    for (Integer req : codigos) {
                        if (requisicao.contains(String.valueOf(req)) || !agruparImpressaoTermo) continue;
                        requisicao = requisicao.concat(",").concat(String.valueOf(req));
                    }
                }
                this.modeloDados.setValueAt(requisicao, this.modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equalsIgnoreCase("tipoLogradouroConvenioRepasse") || CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equalsIgnoreCase("tipoLogradouroConvenio") || CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equalsIgnoreCase("tipoLogradouroCobrancaPaciente") || CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equalsIgnoreCase("tipoLogradouroPaciente") || CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equalsIgnoreCase("tipoLogradouroResponsavelRequisicao") || CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equalsIgnoreCase("tipoLogradouroMedico")) {
                this.modeloDados.setValueAt(Tipos.tipoLogradouroDescricao(rs.getString(CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i])), this.modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equals("sexoPaciente")) {
                this.modeloDados.setValueAt(Tipos.tipoSexo(rs.getString(CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i])), this.modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equals("corPaciente")) {
                this.modeloDados.setValueAt(Tipos.tipoCor(rs.getString(CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i])), this.modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equalsIgnoreCase("estadoCivilPaciente")) {
                this.modeloDados.setValueAt(Tipos.tipoEstadoCivil(rs.getString(CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i])), this.modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equalsIgnoreCase("descricaoSituacaoExame")) {
                this.modeloDados.setValueAt(Tipos.tipoSituacaoExame(rs.getString(CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i])), this.modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equalsIgnoreCase("tipoUltimoPagamentoRequisicao")) {
                this.modeloDados.setValueAt(Tipos.tipoPagamento(rs.getString("tipoUltimoPagamentoRequisicao")), this.modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equals("multiguiasRequisicao")) {
                this.modeloDados.setValueAt(multiguias, this.modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equals("tipoIntegracaoEntreFiliais")) {
                this.modeloDados.setValueAt(Tipos.tipoIntegracao(tipoIntegracao), this.modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equals("perguntasrequisicao")) {
                this.preencherPerguntasRequisicao(rs, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equals("idadeRequisicaoPaciente")) {
                this.modeloDados.setValueAt(Funcoes.getIntervaloParaString((PGInterval)rs.getObject(CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i]), null), this.modeloDados.getRowCount() - 1, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equals("chaveAcessoRequisicao")) {
                this.preencherPerguntasRequisicao(rs, i);
                continue;
            }
            if (CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i].equals("passaportePaciente")) {
                this.modeloDados.setValueAt(rs.getString(CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i]), this.modeloDados.getRowCount() - 1, i);
                continue;
            }
            this.modeloDados.setValueAt(rs.getObject(CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i]), this.modeloDados.getRowCount() - 1, i);
        }
    }

    public Integer[] validaMultiguiasTermo(String filial, String codigoReq, Integer codigoLayout, Statement st, boolean agruparImpressaoTermo) throws SQLException {
        Object[] guias = RecepcaoUtil.verificaMultiGuias(st, filial, codigoReq, true, false);
        Arrays.sort(guias);
        ArrayList<Object> guiasAgrupadasPorLayout = new ArrayList<Object>();
        if (agruparImpressaoTermo && guias.length > 1) {
            for (Object guia : guias) {
                Integer codLayout;
                RequisicaoTermoConsentimentoVO requisicao = this.getDadosRequisicao(filial, ((Integer)guia).toString(), st);
                Registro reg = new Registro();
                if (requisicao != null) {
                    reg = this.validarImpressaoPorConvenioEDestino(filial, requisicao.getCodigoConvenio(), requisicao.getCodigoDestino(), st);
                }
                if (!codigoLayout.equals(codLayout = this.getCodigoLayout(requisicao, this.codTermo, reg.getInt("codLayout"), st))) continue;
                guiasAgrupadasPorLayout.add(guia);
            }
            guias = (Integer[])guiasAgrupadasPorLayout.stream().toArray(Integer[]::new);
        }
        return guias;
    }

    public Integer getCodigoLayout(RequisicaoTermoConsentimentoVO requisicao, String codTermo, Integer codLayoutDestinoConvenio, Statement st) throws SQLException {
        String codFilial = String.valueOf(requisicao.getCodigoFilial());
        String codConvenio = String.valueOf(requisicao.getCodigoConvenio());
        int layoutConvenio = ConvenioUtil.getCodigoLayout(codFilial, codConvenio, st);
        if (codLayoutDestinoConvenio > 0 && this.termoPossuiLayoutConfigurado(codFilial, codTermo, codLayoutDestinoConvenio, st)) {
            return codLayoutDestinoConvenio;
        }
        Integer codLayout = 0;
        if (this.termoPossuiLayoutConfigurado(codFilial, codTermo, layoutConvenio, st)) {
            return layoutConvenio;
        }
        codLayout = this.getCodigoLayoutPadraoPorTermo(codFilial, codTermo, st);
        return codLayout;
    }

    public RequisicaoTermoConsentimentoVO getDadosRequisicao(String filial, String codigoReq, Statement st) throws SQLException {
        return this.dao.getDadosRequisicao(filial, codigoReq, st);
    }

    private void preencherPerguntasRequisicao(ResultSet rs, int i) throws SQLException {
        int coluna = this.procurarColuna("perguntasRequisicao");
        Map<String, Object> perguntasRequisicao = null;
        if (coluna > -1) {
            perguntasRequisicao = Resultado.getCamposResultado(rs.getObject(CAMPOS_TERMO_CONSENTIMENTO_TIPO_RELATORIO[i]).toString());
        }
        for (Object perguntas : perguntasRequisicao.keySet()) {
            String p = (String)perguntas;
            this.modeloDados.insertColumn(p);
            String resposta = (String)perguntasRequisicao.get(perguntas);
            this.modeloDados.setValueAt(resposta, this.modeloDados.getRowCount() - 1, this.modeloDados.findColumn(p));
        }
    }

    private int preencheCamposAdicionais(ResultSet rs, int ultimaPosicao, int qtdeExames, Statement st, boolean precoMetodologia, RoundingMode arredondamentoPrecoExame, int parametrosCasasPrecoExame) throws SQLException {
        for (int j = 0; j < CAMPOS_ADICIONAIS.length; ++j) {
            if (CAMPOS_ADICIONAIS[j].indexOf("ambExame") > -1) {
                this.modeloDados.setValueAt(jalis.laboratorio.util.impressao.Impressao.pegaAMB(st, this.codigoFilial, rs.getString("codigoExame"), rs.getString("codigoMaterial"), rs.getString("codigoConvenio"), rs.getString("codigoMetodo"), precoMetodologia), this.modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            if (CAMPOS_ADICIONAIS[j].indexOf("descricaoSituacaoExame") > -1) {
                this.modeloDados.setValueAt(Tipos.tipoSituacaoExame(rs.getString("descricaoSituacaoExame")), this.modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            if (CAMPOS_ADICIONAIS[j].indexOf("valorExameConvenio") > -1) {
                this.modeloDados.setValueAt(ExameUtil.calculaPrecoExameConvenio(st, this.codigoFilial, rs.getString("codigoExame"), rs.getInt("codigoMaterial"), rs.getInt("codigoConvenio"), Integer.parseInt(this.codigoRequisicao), null, rs.getInt("codigoMetodo"), precoMetodologia, arredondamentoPrecoExame, parametrosCasasPrecoExame), this.modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            if (CAMPOS_ADICIONAIS[j].indexOf("quantidadeExameSemMaterial") > -1) {
                this.modeloDados.setValueAt(qtdeExames, this.modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            if (this.isAlimentos() && ImprimirTermoConsentimentoService.possuiCampos(CAMPOS_ADICIONAIS[j], "codigoGrupoPrincipal")) {
                this.modeloDados.setValueAt(rs.getString("codigoGrupoPrincipal"), this.modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            if (this.isAlimentos() && ImprimirTermoConsentimentoService.possuiCampos(CAMPOS_ADICIONAIS[j], "descricaoGrupoPrincipal")) {
                this.modeloDados.setValueAt(rs.getString("descricaoGrupoPrincipal"), this.modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            if (this.isAlimentos() && ImprimirTermoConsentimentoService.possuiCampos(CAMPOS_ADICIONAIS[j], "valorExameProposta")) {
                totalRequisicaoProposta = totalRequisicaoProposta.add(rs.getBigDecimal("valorExameProposta"));
                this.modeloDados.setValueAt(rs.getString("valorExameProposta"), this.modeloDados.getRowCount() - 1, ultimaPosicao++);
                continue;
            }
            this.modeloDados.setValueAt(rs.getObject(CAMPOS_ADICIONAIS[j]), this.modeloDados.getRowCount() - 1, ultimaPosicao++);
        }
        return ultimaPosicao;
    }

    private void geraColunaRodape(int ultimaPosicao, int qtdeExames, int ultimaPosicaoAux, int colunasRodapeComprovante, boolean agruparGuiasInterface, Statement st, Statement st2, boolean ocultarApenasFaturamento, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean isColetaWeb, boolean tuboPrimario) throws SQLException {
        int colunas = colunasRodapeComprovante;
        if (colunas >= 1) {
            ArrayList listaRodape = this.preencherRodape(this.codigoFilial, this.codigoRequisicao, agruparGuiasInterface, st, st2, ocultarApenasFaturamento, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, isColetaWeb, tuboPrimario);
            for (int linha = 0; linha < this.modeloDados.getRowCount(); ++linha) {
                for (int i = 0; i < colunas && listaRodape.size() > 0; ++i) {
                    String[] c = (String[])listaRodape.remove(0);
                    for (int j = 0; j < CAMPOS_ADICIONAIS_RODAPE.length; ++j) {
                        if (CAMPOS_ADICIONAIS_RODAPE[j].equals("codigoTuboRodape")) {
                            this.modeloDados.setValueAt(c[Rodape.COLUNA_CODIGO.ordinal()], linha, ultimaPosicao++);
                            continue;
                        }
                        if (CAMPOS_ADICIONAIS_RODAPE[j].equals("codigosExamesRodape")) {
                            this.modeloDados.setValueAt(c[Rodape.COLUNA_EXAME.ordinal()], linha, ultimaPosicao++);
                            continue;
                        }
                        if (CAMPOS_ADICIONAIS_RODAPE[j].equals("nomePacienteRodape")) {
                            this.modeloDados.setValueAt(c[Rodape.COLUNA_PACIENTE.ordinal()], linha, ultimaPosicao++);
                            continue;
                        }
                        if (CAMPOS_ADICIONAIS_RODAPE[j].equals("nomeSocialPacienteRodape")) {
                            this.modeloDados.setValueAt(c[Rodape.COLUNA_PACIENTE_NOME_SOCIAL.ordinal()], linha, ultimaPosicao++);
                            continue;
                        }
                        if (CAMPOS_ADICIONAIS_RODAPE[j].equals("codigoMaterialRodape")) {
                            this.modeloDados.setValueAt(c[Rodape.COLUNA_CODIGO_MATERIAL.ordinal()], linha, ultimaPosicao++);
                            continue;
                        }
                        if (CAMPOS_ADICIONAIS_RODAPE[j].equals("descricaoMaterialRodape")) {
                            this.modeloDados.setValueAt(c[Rodape.COLUNA_DESCRICAO_MATERIAL.ordinal()], linha, ultimaPosicao++);
                            continue;
                        }
                        if (CAMPOS_ADICIONAIS_RODAPE[j].equals("abreviaturaMaterialRodape")) {
                            this.modeloDados.setValueAt(c[Rodape.COLUNA_ABREVIATURA.ordinal()], linha, ultimaPosicao++);
                            continue;
                        }
                        if (CAMPOS_ADICIONAIS_RODAPE[j].equals("codigoRequisicaoRodape")) {
                            this.modeloDados.setValueAt(c[Rodape.COLUNA_REQUISICAO_TUBO.ordinal()], linha, ultimaPosicao++);
                            continue;
                        }
                        if (CAMPOS_ADICIONAIS_RODAPE[j].equals("descricaoRecipienteRodape")) {
                            this.modeloDados.setValueAt(c[Rodape.COLUNA_RECIPIENTE.ordinal()], linha, ultimaPosicao++);
                            continue;
                        }
                        if (CAMPOS_ADICIONAIS_RODAPE[j].equals("descricaoEstacaoRodape")) {
                            this.modeloDados.setValueAt(c[Rodape.COLUNA_ESTACAO.ordinal()], linha, ultimaPosicao++);
                            continue;
                        }
                        if (CAMPOS_ADICIONAIS_RODAPE[j].equals("quantidadeExameSemMaterial")) {
                            this.modeloDados.setValueAt(qtdeExames, linha, ultimaPosicao++);
                            continue;
                        }
                        this.modeloDados.setValueAt("", linha, ultimaPosicao++);
                    }
                }
                ultimaPosicao = ultimaPosicaoAux;
            }
        }
        if (this.modeloDados.findColumn("totalRequisicaoProposta") != -1) {
            this.modeloDados.setValueAt(totalRequisicaoProposta, this.modeloDados.getRowCount() - 1, this.modeloDados.findColumn("totalRequisicaoProposta"));
        }
    }

    private ArrayList preencherRodape(String filial, String requisicao, boolean agruparGuiasInterface, Statement st, Statement st2, boolean ocultarApenasFaturamento, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean isColetaWeb, boolean tuboPrimario) throws SQLException {
        boolean agruparMultiguia = agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, requisicao);
        String multiguias = this.agruparMultiguias(requisicao, filial, st);
        ResultSet rsRodape = this.dao.recuperarCamposRodape(st2, filial, agruparMultiguia ? multiguias : requisicao, ocultarApenasFaturamento);
        ArrayList<String[]> lista = new ArrayList<String[]>();
        try {
            while (rsRodape.next()) {
                int qtde = DBUtil.campoNull(rsRodape.getString("rco_qtde")) ? 1 : rsRodape.getInt("rco_qtde");
                LinkedHashMap<Integer, String> tubosParaImprimir = new LinkedHashMap<Integer, String>();
                tubosParaImprimir.put(rsRodape.getInt("rec_codigo"), rsRodape.getString("rec_descricao"));
                ResultSet rsCurva = this.dao.recuperarCurvaDeExameInterface(st, filial, rsRodape.getString("exa_codigo"), rsRodape.getString("mco_codigo"), tipoExportacaoInterface);
                ArrayList<Integer> interfacesParaCurvaTemp = new ArrayList<Integer>();
                while (rsCurva.next()) {
                    if (!rsCurva.getBoolean("emi_curva")) continue;
                    interfacesParaCurvaTemp.add(rsCurva.getInt("int_codigo"));
                }
                if (!interfacesParaCurvaTemp.isEmpty()) {
                    tubosParaImprimir.clear();
                }
                for (Integer int_codigo : interfacesParaCurvaTemp) {
                    rsCurva = this.dao.recuperarDadosDeExameMatIntDesmembrar(st, filial, rsRodape.getString("exa_codigo"), rsRodape.getString("mco_codigo"), int_codigo);
                    while (rsCurva.next()) {
                        ResultSet rsTubos = this.dao.recuperarDadosDeRecipColeta(st, filial, rsCurva.getString("exa_kodigo"), rsCurva.getString("mco_kodigo"), agruparInterface);
                        while (rsTubos.next()) {
                            if (tubosParaImprimir.containsKey(rsTubos.getInt("rec_codigo"))) continue;
                            tubosParaImprimir.put(rsTubos.getInt("rec_codigo"), rsTubos.getString("rec_descricao"));
                        }
                    }
                }
                Iterator<Object> iterator = tubosParaImprimir.keySet().iterator();
                while (iterator.hasNext()) {
                    int tuboParaImprimir = (Integer)iterator.next();
                    String descricaoTubo = (String)tubosParaImprimir.get(tuboParaImprimir);
                    int pos = -1;
                    for (int i = 0; i < qtde; ++i) {
                        pos = ImprimirTermoConsentimentoService.localizar(0, rsRodape.getInt("set_codigo"), String.valueOf(tuboParaImprimir), lista, Rodape.COLUNA_CODIGO.ordinal(), tuboPrimario);
                        String codigoRequisicaoMultiguia = agruparGuiasInterface ? requisicao : null;
                        String codigoTubo = Funcoes.preencheZero(filial, digitosTuboFilial) + Funcoes.preencheZero(codigoRequisicaoMultiguia == null ? rsRodape.getString("req_codigo") : codigoRequisicaoMultiguia, digitosTuboRequisicao) + Funcoes.preencheZero(DBUtil.campoNull(String.valueOf(tuboParaImprimir)) ? "0" : String.valueOf(tuboParaImprimir), digitosTuboTubo);
                        if (pos > -1) {
                            ImprimirTermoConsentimentoService.adicionarTubo(lista, pos, String.valueOf(tuboParaImprimir), rsRodape.getString("exa_codigo"), rsRodape.getString("mco_codigo"), rsRodape.getString("mco_descricao"), rsRodape.getString("mco_abreviatura"), String.valueOf(qtde), rsRodape.getString("rco_volume"), rsRodape.getString("rec_capacidade"), codigoTubo, rsRodape.getString("pac_nome"), descricaoTubo, rsRodape.getString("est_descricao"), rsRodape.getString("set_codigo"), rsRodape.getString("pac_nomesocial"), tuboPrimario);
                            continue;
                        }
                        lista.add(new String[]{String.valueOf(tuboParaImprimir), rsRodape.getString("exa_codigo"), rsRodape.getString("mco_codigo"), rsRodape.getString("mco_descricao"), rsRodape.getString("mco_abreviatura"), String.valueOf(qtde), rsRodape.getString("rco_volume"), rsRodape.getString("rec_capacidade"), codigoTubo, rsRodape.getString("pac_nome"), descricaoTubo, rsRodape.getString("est_descricao"), rsRodape.getString("set_codigo"), rsRodape.getString("pac_nomesocial")});
                    }
                }
            }
            if (!isColetaWeb) {
                Conexao.arquivaSQL();
            }
        }
        catch (Exception e) {
            if (!isColetaWeb) {
                Conexao.anulaSQL();
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ImprimirComprovante: 627");
        }
        return lista;
    }

    private String agruparMultiguias(String codRequisicao, String codFilial, Statement st) throws SQLException {
        Integer[] multiguia = RecepcaoUtil.verificaMultiGuias(st, codFilial, codRequisicao, true, false);
        StringBuilder multiguias = new StringBuilder("");
        for (Integer i : multiguia) {
            if (i < Integer.parseInt(codRequisicao)) {
                codRequisicao = String.valueOf(i);
            }
            multiguias.append(multiguias.length() > 0 ? ", " : "");
            multiguias.append(String.valueOf(i));
        }
        return multiguias.toString();
    }

    private static ArrayList adicionarTubo(ArrayList lista, int pos, String tubo, String exame, String codigoMaterial, String descricaoMaterial, String abrv, String qtde, String volume, String capacidade, String codigoRequisicaoTubo, String nomePaciente, String recipiente, String descricaoEstacao, String setor, String nomeSocialPaciente, boolean tuboPrimario) {
        String[] s = (String[])lista.get(pos);
        double capacity = 0.0;
        double volumeUtilizado = 0.0;
        double novoVolume = 0.0;
        if (Funcoes.isNumeric(s[Rodape.COLUNA_CAPACIDADE.ordinal()])) {
            capacity = Double.parseDouble(Funcoes.limpaDecimal(s[Rodape.COLUNA_CAPACIDADE.ordinal()]));
        }
        if (Funcoes.isNumeric(s[Rodape.COLUNA_VOLUME.ordinal()])) {
            volumeUtilizado = Double.parseDouble(Funcoes.limpaDecimal(s[Rodape.COLUNA_VOLUME.ordinal()]));
        }
        if (Funcoes.isNumeric(volume)) {
            novoVolume = Double.parseDouble(volume);
        }
        if (capacity == 0.0 || capacity > 0.0 && capacity - volumeUtilizado >= novoVolume) {
            s[Rodape.COLUNA_VOLUME.ordinal()] = String.valueOf(volumeUtilizado + novoVolume);
            int n = Rodape.COLUNA_EXAME.ordinal();
            s[n] = s[n] + " " + exame;
        } else if ((pos = ImprimirTermoConsentimentoService.localizar(pos + 1, Integer.parseInt(setor), tubo, lista, Rodape.COLUNA_CODIGO.ordinal(), tuboPrimario)) < 0) {
            lista.add(new String[]{tubo, exame, codigoMaterial, descricaoMaterial, abrv, qtde, volume, capacidade, codigoRequisicaoTubo, nomePaciente, recipiente, descricaoEstacao, setor, nomeSocialPaciente});
        } else {
            lista = ImprimirTermoConsentimentoService.adicionarTubo(lista, pos, tubo, exame, codigoMaterial, descricaoMaterial, abrv, qtde, volume, capacidade, codigoRequisicaoTubo, nomePaciente, recipiente, descricaoEstacao, setor, nomeSocialPaciente, tuboPrimario);
        }
        return lista;
    }

    private static int localizar(int posini, int setor, String tubo, ArrayList lista, int coluna, boolean tuboPrimario) {
        int retorno = -1;
        if (posini < lista.size() && lista.size() > 0) {
            for (int i = posini; i < lista.size(); ++i) {
                String[] o = (String[])lista.get(i);
                if (o[coluna] == null || !o[coluna].equals(tubo) || !tuboPrimario && (!Funcoes.isNumeric(o[Rodape.COLUNA_SETOR.ordinal()]) || Integer.parseInt(o[Rodape.COLUNA_SETOR.ordinal()]) != setor)) continue;
                retorno = i;
                break;
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preencherCamposAgendamento(Statement st) throws SQLException {
        try (ResultSet rs = this.dao.recuperarCamposAgendamento(st, this.codigoFilial, this.codigoRequisicao);){
            int i = 1;
            while (rs.next()) {
                for (int k = 0; k < this.modeloDados.getRowCount(); ++k) {
                    for (int j = 0; j < CAMPOS_AGENDAMENTO.length; ++j) {
                        this.modeloDados.setValueAt(rs.getObject(CAMPOS_AGENDAMENTO[j]), k, this.modeloDados.findColumn(CAMPOS_AGENDAMENTO[j] + i));
                    }
                }
                ++i;
            }
        }
    }

    private int procurarColuna(String coluna) {
        int retorno = -1;
        for (int i = 0; i < this.modeloDados.getColumnCount(); ++i) {
            if (!this.modeloDados.getColumnName(i).equalsIgnoreCase(coluna)) continue;
            retorno = i;
            break;
        }
        return retorno;
    }

    private boolean isAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    private static boolean possuiCampos(String linha, String campo) {
        return linha.indexOf(campo) > -1;
    }

    public String getTipoTermo() {
        return this.tipoTermo;
    }

    public void setTipoTermo(String tipoTermo) {
        this.tipoTermo = tipoTermo;
    }

    private RetornoTermoConsentimento imprimirTermoTipoExame(String filial, String requisicao, String codTermo, Integer codigoLayout, Statement st, Statement st2, boolean agruparImpressaoTermo, boolean isColetaWeb, String impressoraTermo, String tamanhoNomeImpressora, String[] impressorasLocais) throws Exception {
        ResultSet rs = this.dao.recuperarCamposTipoExame(filial, requisicao, st2);
        HashMap<String, Object> hash = new HashMap<String, Object>();
        String codigos = requisicao;
        if (rs.next()) {
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                String campo = rs.getMetaData().getColumnName(i);
                if (campo.equals("sexoPaciente")) {
                    hash.put(campo, Tipos.tipoSexo(rs.getString(campo)));
                    continue;
                }
                if (campo.equalsIgnoreCase("tipoLogradouroPaciente") || campo.equalsIgnoreCase("tipoLogradouroConvenio") || campo.equalsIgnoreCase("tipoLogradouroMedico")) {
                    hash.put(campo, Tipos.tipoLogradouroDescricao(rs.getString(campo)));
                    continue;
                }
                if (campo.equals("corPaciente")) {
                    hash.put(campo, Tipos.tipoCor(rs.getString(campo)));
                    continue;
                }
                if (campo.equalsIgnoreCase("estadoCivilPaciente")) {
                    hash.put(campo, Tipos.tipoEstadoCivil(rs.getString(campo)));
                    continue;
                }
                if (campo.equalsIgnoreCase("dataPrimeiraColetaExameRequisicao")) {
                    hash.put(campo, ImprimirTermoConsentimentoDao.getDataColetasMaxMin(rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), 2, st));
                    continue;
                }
                if (campo.equalsIgnoreCase("dataUltimaColetaExameRequisicao")) {
                    hash.put(campo, ImprimirTermoConsentimentoDao.getDataColetasMaxMin(rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), 1, st));
                    continue;
                }
                if (campo.equalsIgnoreCase("datasColetasExameRequisicao")) {
                    hash.put(campo, ImprimirTermoConsentimentoDao.getDataColetasLista(rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), st));
                    continue;
                }
                if (campo.equalsIgnoreCase("idadeRequisicaoPaciente")) {
                    hash.put(campo, Funcoes.getIntervaloParaString((PGInterval)rs.getObject("idadeRequisicaoPaciente"), null));
                    continue;
                }
                if (campo.equalsIgnoreCase("passaportePaciente")) {
                    hash.put(campo, rs.getString("passaportePaciente"));
                    continue;
                }
                if (campo.equalsIgnoreCase("codigoRequisicao")) {
                    Integer[] multiguias = this.validaMultiguiasTermo(filial, requisicao, codigoLayout, st, agruparImpressaoTermo);
                    if (agruparImpressaoTermo && multiguias != null && multiguias.length != 0) {
                        for (Integer req : multiguias) {
                            if (requisicao.equals(String.valueOf(req))) continue;
                            codigos = codigos.concat(", ").concat(String.valueOf(req));
                        }
                    }
                    hash.put(campo, codigos);
                    continue;
                }
                hash.put(campo, rs.getObject(campo));
            }
            hash.put("dataAtual", new Date());
        }
        rs.close();
        String[] retorno = ImprimirTermoConsentimentoDao.pesquisarTermoConsentimentoPorCodigoLayout(this.codigoFilial, codTermo, codigoLayout, st);
        this.layout = retorno[0];
        String cabecalho = ImprimirTermoConsentimentoService.removeTag(this.layout, "corpo");
        this.layout = ImprimirTermoConsentimentoService.removeTag(this.layout, "propriedades");
        this.layout = ImprimirTermoConsentimentoService.removeTag(this.layout, "cabecalho");
        if (isColetaWeb) {
            RetornoTermoConsentimento retornoTermo = new RetornoTermoConsentimento();
            retornoTermo.setTipoTermo("exame");
            retornoTermo.setHashCamposDoBanco(hash);
            Digitacao digitacao = new Digitacao();
            digitacao.carregarCampos(this.layout, hash);
            retornoTermo.setDigitacao(digitacao);
            retornoTermo.setXmlTermo(digitacao.getResultadoObj().gerarResultado("resultado", false, true));
            return retornoTermo;
        }
        TelaTermo tela = new TelaTermo(new JFrame());
        tela.setPerguntas(this.layout, hash);
        tela.setVisible(true);
        if (tela.getSalvarPressionado()) {
            Documento doc = new Documento();
            doc.setSempreReposicionarEntrePaginas(true);
            doc.setDadosBanco(hash);
            doc.addResultados(null, new String[]{tela.getTermo()});
            doc.setCabecalhoRodape(cabecalho);
            if (!Funcoes.textoVazio(impressoraTermo)) {
                Impressao imp = new Impressao(jalis.laboratorio.util.impressao.Impressao.comparaNomeImpressoraReduzido(impressoraTermo, tamanhoNomeImpressora, impressorasLocais));
                String[] contadores = StringUtil.getValores(tela.getTermo(), "contadorPagina");
                Integer contadorPagina = 1;
                for (String contador : contadores) {
                    Integer cont = Integer.valueOf(contador);
                    if (contadorPagina.compareTo(cont) >= 0) continue;
                    contadorPagina = cont;
                }
                String pdf = this.converterDocumentoParaPDFEncode64(doc, contadorPagina);
                this.salvarHistoricoDeImpressao(pdf, codigos, st, isColetaWeb, () -> {
                    try {
                        Conexao.arquivaSQL();
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }, () -> {
                    try {
                        Conexao.anulaSQL();
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                });
                imp.imprimir(doc);
            }
        }
        return null;
    }

    public boolean termoPossuiLayoutConfigurado(String codigoFilial, String codTermo, Integer codigoLayout, Statement st) throws SQLException {
        String[] retornoLayout = ImprimirTermoConsentimentoDao.pesquisarTermoConsentimentoPorCodigoLayout(codigoFilial, codTermo, codigoLayout, st);
        return retornoLayout != null && !Funcoes.textoVazio(retornoLayout[0]);
    }

    public Registro validarImpressaoPorConvenioEDestino(String codFilial, Integer codConvenio, String destinoRequisicao, Statement st) throws SQLException {
        return this.dao.pesquisarLayoutPorDestinoDoConvenio(codFilial, codConvenio, destinoRequisicao, st);
    }

    public Integer getCodigoLayoutPadraoPorTermo(String codFilial, String codTermo, Statement st) throws SQLException {
        return this.dao.pesquisarCodigoLayoutPadraoPorTermo(codFilial, codTermo, st);
    }

    public static String getTagValue(String xml, String tagName) {
        if (Funcoes.textoVazio(xml)) {
            return null;
        }
        return xml.split("<" + tagName + ">")[1].split("</" + tagName + ">")[0];
    }

    public static String removeTag(String xml, String tag) {
        StringBuilder sb = new StringBuilder(xml);
        StringUtil.setValor(sb, tag, "");
        return sb.toString();
    }

    public static String addValorTag(String xml, String tag, String valor) {
        StringBuilder sb = new StringBuilder(xml);
        StringUtil.setValor(sb, tag, valor);
        return sb.toString();
    }

    public Integer getTermo(String codigoFilial, String termoConsentimento, Statement st) throws SQLException {
        return this.dao.getTermo(codigoFilial, termoConsentimento, st);
    }

    private static enum Rodape {
        COLUNA_CODIGO,
        COLUNA_EXAME,
        COLUNA_CODIGO_MATERIAL,
        COLUNA_DESCRICAO_MATERIAL,
        COLUNA_ABREVIATURA,
        COLUNA_QTDE,
        COLUNA_VOLUME,
        COLUNA_CAPACIDADE,
        COLUNA_REQUISICAO_TUBO,
        COLUNA_PACIENTE,
        COLUNA_RECIPIENTE,
        COLUNA_ESTACAO,
        COLUNA_SETOR,
        COLUNA_PACIENTE_NOME_SOCIAL;

    }
}

