/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.financeiro.faturamento.enotas;

import jalis.comum.Conexao;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.validador.ErroCampoEnotas;
import jalis.model.dao.financeiro.faturamento.enotas.DialogoErrosEnotasDao;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseTable;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JComboBox;

public class DialogoErrosEnotasService {
    private final DialogoErrosEnotasDao dao = new DialogoErrosEnotasDao();

    public boolean salvar(ArrayList<ErroCampoEnotas> erros) throws Exception {
        Statement st = Conexao.getStatement();
        try {
            for (ErroCampoEnotas erro : erros) {
                Field campoFilial = null;
                String filial = null;
                String tabela = null;
                String coluna = null;
                String valor = null;
                JComboBox combo = null;
                if (erro.isNullCadastro()) {
                    tabela = erro.getCampoEnotas().getBeanPai().getClass().getAnnotation(DataBaseTable.class).value();
                    campoFilial = erro.getCampoEnotas().getBeanPai().getFieldByColumnName("fil_codigo");
                    campoFilial.setAccessible(true);
                    filial = campoFilial.get(erro.getCampoEnotas().getBeanPai()).toString();
                    coluna = erro.getCampoEnotas().getBean().getFieldPrimaryKey();
                    valor = erro.getVo().getValorPrimaryKey().toString();
                } else if (erro.isCombo()) {
                    tabela = erro.getCampoEnotas().getBean().getClass().getAnnotation(DataBaseTable.class).value();
                    campoFilial = erro.getCampoEnotas().getBean().getFieldByColumnName("fil_codigo");
                    campoFilial.setAccessible(true);
                    filial = campoFilial.get(erro.getCampoEnotas().getBean()).toString();
                    coluna = erro.getCampoEnotas().getField().getAnnotation(DataBaseField.class).value();
                    combo = erro.getListaCombo();
                } else {
                    tabela = erro.getCampoEnotas().getBean().getClass().getAnnotation(DataBaseTable.class).value();
                    campoFilial = erro.getCampoEnotas().getBean().getFieldByColumnName("fil_codigo");
                    campoFilial.setAccessible(true);
                    filial = campoFilial.get(erro.getCampoEnotas().getBean()).toString();
                    coluna = erro.getCampoEnotas().getField().getAnnotation(DataBaseField.class).value();
                    valor = erro.getTextCorrecao().getText();
                }
                this.dao.salvar(st, erro, filial, tabela, coluna, valor, combo);
            }
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return true;
    }
}

