/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.financeiro.faturamento;

import jalis.comum.Tipos;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.DialogNotaFiscalSaida;
import jalis.laboratorio.financeiro.NotaFiscalSaida;
import jalis.laboratorio.financeiro.faturamento.ExameBasico;
import jalis.laboratorio.financeiro.faturamento.PagadorBasico;
import jalis.laboratorio.financeiro.faturamento.PagamentoBasico;
import jalis.laboratorio.financeiro.faturamento.RequisicaoBasica;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.recepcao.RequisicaoBean;
import jalis.model.dao.financeiro.faturamento.ImprimirNotaFiscalEmpresaDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.service.cadastro.PacienteService;
import jalis.service.recepcao.RequisicaoService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class ImprimirNotaFiscalEmpresaService {
    private final ImprimirNotaFiscalEmpresaDao dao = new ImprimirNotaFiscalEmpresaDao();

    public String getNomePacientePorRequisicao(String codFilial, String codRequisicao) throws SQLException {
        return this.dao.pesquisarNomePacientePorRequisicao(codFilial, codRequisicao);
    }

    public List<RequisicaoBasica> getRequisicoesPorEmpresa(String codFilial, String codEmpresa) throws Exception {
        List<RequisicaoBasica> requisicoes = this.dao.pesquisarRequisicoesPorEmpresa(codFilial, codEmpresa);
        for (RequisicaoBasica req : requisicoes) {
            ArrayList<ExameBasico> exames = this.dao.pesquisarExamesPorRequisicao(codFilial, req.getCodigoRequisicao());
            if (!exames.isEmpty()) {
                req.setExames(exames);
            }
            ArrayList<PagamentoBasico> pagamentos = this.getPagamentosPorRequisicao(codFilial, req.getCodigoRequisicao());
            pagamentos.forEach(pag -> req.addPagamento((PagamentoBasico)pag));
        }
        return requisicoes;
    }

    public List<RequisicaoBasica> getRequisicoesPorCodigo(String codFilial, Integer[] guias) throws SQLException {
        List<RequisicaoBasica> requisicoes = this.dao.pesquisarRequisicoesPorCodigo(codFilial, guias);
        ArrayList<Object> pagamentos = new ArrayList();
        for (RequisicaoBasica req : requisicoes) {
            ArrayList<ExameBasico> exames = this.dao.pesquisarExamesPorRequisicao(codFilial, req.getCodigoRequisicao());
            if (!exames.isEmpty()) {
                req.setExames(exames);
            }
            pagamentos = this.getPagamentosPorRequisicao(codFilial, req.getCodigoRequisicao());
            pagamentos.forEach((Consumer<Object>)((Consumer<PagamentoBasico>)pag -> req.addPagamento((PagamentoBasico)pag)));
        }
        return requisicoes;
    }

    private ArrayList<PagamentoBasico> getPagamentosPorRequisicao(String codFilial, Integer codrequisicao) throws SQLException {
        ArrayList<PagamentoBasico> pagamentos = this.dao.pesquisarPagamentosPorRequisicao(codFilial, codrequisicao);
        if (pagamentos.isEmpty()) {
            pagamentos = this.dao.pesquisarPagamentosSemNotaPorRequisicao(codFilial, codrequisicao);
        }
        return pagamentos;
    }

    public PacienteVO getEmpresaPorCodigo(Integer codigoEmpresa) {
        PacienteVO empresa = new PacienteVO();
        try {
            empresa = (PacienteVO)new PacienteService().getVO(codigoEmpresa.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return empresa;
    }

    public NotaFiscalBean gerarNotaFiscal(String codFilial, Integer[] requisicoes, PagadorBasico pagador) {
        DialogNotaFiscalSaida dialogNota = NotaFiscalSaida.novaInstancia(Laboratorio.getInstancia(), true, null, codFilial);
        NotaFiscalSaida nota = null;
        NotaFiscalBean notaBean = null;
        if (dialogNota != null) {
            nota = dialogNota.getNotaFiscalSaida();
        }
        if (nota != null) {
            nota.alterarBarraDescricao("Nota Fiscal para Empresa", "Imprime a nota fiscal para empresa", "financeiro/nota_fiscal_empresa.jpg");
            nota.setDataEmissao(new Date());
            nota.setSubTotal(pagador.getValorPago().doubleValue());
            nota.setCadastro("E", pagador.getRequisicao().getCodigoPaciente().toString());
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(codFilial));
            Set<LancamentoBean> lancamentos = this.getLancamentos(filial, pagador);
            nota.setRequisicaoBean(this.getRequisicoesBean(codFilial, requisicoes));
            nota.setLancamentosPagamentos(lancamentos);
            if (dialogNota.getNotaFiscalSaida().isCadastroValidado()) {
                dialogNota.setVisible(true);
            }
            notaBean = nota != null ? nota.getRetorno() : null;
        }
        return notaBean;
    }

    private List<RequisicaoBean> getRequisicoesBean(String codFilial, Integer[] requisicoes) {
        ArrayList<RequisicaoBean> requisicoesBean = new ArrayList<RequisicaoBean>();
        for (Integer req : requisicoes) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", codFilial);
            chaves.put("req_codigo", req);
            try {
                RequisicaoBean requisicao = (RequisicaoBean)new RequisicaoService().getBean(chaves);
                requisicoesBean.add(requisicao);
            }
            catch (ThreadDaoException threadDaoException) {
                // empty catch block
            }
        }
        return requisicoesBean;
    }

    private Set<LancamentoBean> getLancamentos(FilialVO filial, PagadorBasico pagador) {
        HashSet<LancamentoBean> lancamentos = new HashSet<LancamentoBean>();
        for (int i = 0; i < pagador.getPagamentos().size(); ++i) {
            PagamentoBasico pgto = pagador.getPagamentos().get(i);
            EstacaoVO estacao = new EstacaoVO();
            estacao.setCodigo(pgto.getCodigoEstacao());
            ContaCorrenteVO conta = new ContaCorrenteVO();
            conta.setFilial(filial);
            conta.setReduzido(pgto.getReduzidoContaCorrente());
            LancamentoBean lancto = new LancamentoBean();
            lancto.setFilial(filial);
            lancto.setCodigo(pgto.getCodigoLancamento());
            lancto.setEstacao(estacao);
            lancto.setContaCorrente(conta);
            lancto.setDataVencimento(pgto.getDataPagamento());
            lancto.setValor(pgto.getValorPagamento().doubleValue());
            lancto.setValorTotal(pgto.getValorPagamento().doubleValue());
            lancto.setTipo("C");
            lancto.setTipoPagamento(Tipos.getTipoPagamento(pgto.getTipoPagamento()));
            lancto.setTipoOrigem("C");
            lancamentos.add(lancto);
        }
        return lancamentos;
    }
}

