/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.util.SolicitarMotivoCancelamento;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.dao.financeiro.faturamento.EstornoCancelamentoNotaFiscalEmpresaDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;

public class EstornoCancelamentoNotaFiscalEmpresaService {
    private final EstornoCancelamentoNotaFiscalEmpresaDao dao;
    private final NotaFiscalService notaService;

    public EstornoCancelamentoNotaFiscalEmpresaService() {
        this.dao = new EstornoCancelamentoNotaFiscalEmpresaDao();
        this.notaService = new NotaFiscalService();
    }

    public EstornoCancelamentoNotaFiscalEmpresaService(EstornoCancelamentoNotaFiscalEmpresaDao dao, NotaFiscalService notaService) {
        this.dao = dao;
        this.notaService = notaService;
    }

    public RequisicaoVO getDadosRequisicao(NotaFiscalBean bean) throws SQLException {
        return bean == null ? null : this.dao.pesquisarDadosRequisicao(bean);
    }

    public String getMultiguiasRequisicao(int filial, int nfiCodigo) {
        try {
            return this.dao.getMultiguiasRequisicao(filial, nfiCodigo);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return "";
        }
    }

    public NotaFiscalBean pesquisar() {
        NotaFiscalBean ntFiscalBean = null;
        try {
            AbstractThreadVO vo = this.notaService.pesquisaEstornoCancelamentoPessoaFisicaVO(Laboratorio.getInstancia(), new NotaFiscalVO(), "Pesquisando Notas Fiscais", true, "E");
            if (vo != null && (ntFiscalBean = (NotaFiscalBean)this.notaService.get(((NotaFiscalVO)vo).getFilial().getCodigo().toString(), ((NotaFiscalVO)vo).getCodigo().toString())) != null && this.notaFiscalValida(ntFiscalBean)) {
                return ntFiscalBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return ntFiscalBean;
    }

    public void cancelarEstornaNF(NotaFiscalBean notaFiscalBean, boolean cancelaNF) {
        if (Funcoes.mensagem(Laboratorio.getInstancia(), "Voc\u00ea realmente deseja" + (cancelaNF ? " cancelar " : " estornar ") + "a nota fiscal?", 4) == 0) {
            SolicitarMotivoCancelamento telaMotivoCancelamento = new SolicitarMotivoCancelamento(Laboratorio.getInstancia(), "Motivo de Cancelamento", false);
            telaMotivoCancelamento.setVisible(true);
            if (!telaMotivoCancelamento.getOK()) {
                return;
            }
            if (telaMotivoCancelamento == null || telaMotivoCancelamento.getCodigoMotivo() == -1 || telaMotivoCancelamento.getCancelado()) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O Motivo de Cancelamento da Nota Fiscal n\u00e3o foi selecionado.\nO" + (cancelaNF ? " cancelamento" : " estorno") + " ser\u00e1 abortado.", 2);
                return;
            }
            try {
                String codigoNotaFiscal = String.valueOf(notaFiscalBean.getCodigo());
                Long numeroRps = notaFiscalBean.getNumeroRps();
                String msg = new NotaFiscalService().cancelarEstornaNFPessoaFisica(cancelaNF, notaFiscalBean, telaMotivoCancelamento);
                if (msg == null) {
                    Conexao.arquivaSQL();
                    if (numeroRps == null || cancelaNF) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), this.showMensagemCanceladaOuEstornada(notaFiscalBean, cancelaNF, codigoNotaFiscal, numeroRps), 5);
                    }
                } else {
                    Conexao.anulaSQL();
                    Funcoes.mensagem(Laboratorio.getInstancia(), msg, 2);
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    public String showMensagemCanceladaOuEstornada(NotaFiscalBean notaFiscalBean, boolean cancelaNF, String codigoNotaFiscal, Long numeroRps) {
        String mensagem = "";
        if (numeroRps == null) {
            mensagem = "A nota fiscal n\u00famero: \"" + codigoNotaFiscal + "\" foi" + (cancelaNF ? " cancelada " : " estornada ") + "com sucesso.";
        } else if (cancelaNF) {
            mensagem = "Requisitado cancelamento da  nota fiscal (RPS = \"" + notaFiscalBean.getNumeroRps() + "\").";
        }
        return mensagem;
    }

    public boolean notaFiscalValida(NotaFiscalBean notaFiscalBean) {
        if (notaFiscalBean.getNumeroRps() == null) {
            if (notaFiscalBean.getSituacao().equals("C")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal j\u00e1 foi \"Cancelada\".", 2);
                return false;
            }
            if (notaFiscalBean.getSituacao().equals("E")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal j\u00e1 foi \"Estornada\".", 2);
                return false;
            }
        } else {
            if (notaFiscalBean.getSituacao().equals("C")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal j\u00e1 foi \"Cancelada\".", 2);
                return false;
            }
            if (!notaFiscalBean.getSituacao().equals("A")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Somente notas fiscais \"Autorizadas\" podem ser canceladas.", 2);
            }
        }
        return true;
    }
}

