/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosExamePaiAgrupamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.financeiro.faturamento.ListaValoresExamesPai;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.convenio.DetalheTabelaPrecoBean;
import jalis.model.bean.cadastro.convenio.DetalheTabelaPrecoMetodologiaBean;
import jalis.model.bean.cadastro.convenio.TabelaPrecoExameBean;
import jalis.model.bean.financeiro.FaturaBean;
import jalis.model.dao.financeiro.faturamento.ConferenciaFaturaDao;
import jalis.util.DBUtil;
import jalis.util.tabela.Registro;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ConferenciaFaturaService {
    private final ConferenciaFaturaDao dao = new ConferenciaFaturaDao();

    public FaturaBean pesquisarFaturaPorCodigo(String codFatura, Integer codFilial) throws SQLException {
        return this.dao.pesquisarFaturaPorCodigo(codFatura, codFilial);
    }

    public void processarRequisicoesSemPedidoGuia(List<Registro> requisicoesSemPedidoGuia) throws Exception {
        if (!requisicoesSemPedidoGuia.isEmpty()) {
            Statement st = Conexao.getStatement();
            Statement stAux = Conexao.getStatement();
            for (Registro reg : requisicoesSemPedidoGuia) {
                this.dao.atualizarDeveGuiaNaRequisicao(reg.getInt("codigoFilial"), reg.getInt("codigoRequisicao"), reg.getBoolean("deveGuia"));
                if (!Variaveis.exportarWebFilial) continue;
                if (reg.getBoolean("deveGuia")) {
                    String[] comandoRequisicao = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoRequisicao", IntegracaoUtil.formataCodigoRequisicao(String.valueOf(reg.getInt("codigoFilial")), String.valueOf(reg.getInt("codigoRequisicao")), st)};
                    DBUtil.insereExportaWeb(String.valueOf(reg.getInt("codigoFilial")), st, "requisicao", "D", comandoRequisicao);
                    continue;
                }
                if (!reg.getBoolean("deviaGuia")) continue;
                FuncoesGerais.reenviarRequisicaoWeb(st, stAux, String.valueOf(reg.getInt("codigoFilial")), String.valueOf(reg.getInt("codigoFilial")));
            }
        }
    }

    public void processarExamesAlterados(List<DadosFaturamento> requisicoesfaturadas) throws SQLException {
        if (!requisicoesfaturadas.isEmpty()) {
            for (DadosFaturamento requisicao : requisicoesfaturadas) {
                ArrayList<DadosExameFaturamento> exames = requisicao.getExames();
                for (DadosExameFaturamento exame : requisicao.getExames()) {
                    this.dao.atualizarExameRequisicao(requisicao.getCodigoFilial(), requisicao.getRequisicao(), exame);
                }
            }
        }
    }

    public void processarRequisicoesComGuiaAlterada(List<DadosFaturamento> requisicoesComGuiaAlterada) throws SQLException {
        if (!requisicoesComGuiaAlterada.isEmpty()) {
            for (DadosFaturamento dados : requisicoesComGuiaAlterada) {
                if (!requisicoesComGuiaAlterada.contains(dados)) continue;
                this.dao.atualizarDadosGuiaRequisicao(dados);
                for (DadosExameFaturamento exame : dados.getExames()) {
                    if (exame.getCodigoExame().equalsIgnoreCase(exame.getExamePai().getCodigo())) {
                        this.dao.atualizarDadosGuiaExameRequisicao(dados.getCodigoFilial(), dados.getRequisicao(), exame);
                        continue;
                    }
                    this.dao.atualizarDadosGuiaExameRequisicaoGuiaAgrupada(dados.getCodigoFilial(), dados.getRequisicao(), exame);
                }
            }
        }
    }

    public void processarRequisicoesComDataDeFaturaAlterada(List<DadosFaturamento> requisicoesComDataFaturaAlterada, List<DadosFaturamento> requisicoesfaturadas, String codigoFatura) throws SQLException {
        if (!requisicoesComDataFaturaAlterada.isEmpty()) {
            for (DadosFaturamento dados : requisicoesComDataFaturaAlterada) {
                if (!requisicoesfaturadas.contains(dados)) {
                    if (dados.getExames() != null) {
                        for (DadosExameFaturamento exame : dados.getExames()) {
                            this.dao.atualizarDatafaturaExameRequisicao(dados, exame);
                            if (!exame.getFaturar() || dados.requisicaoApenasSelecionada()) {
                                this.dao.excluirRegistroFaturaExameRequisicao(dados, exame, codigoFatura);
                                if (!dados.getFaturar() || dados.requisicaoApenasSelecionada()) {
                                    this.dao.excluirRegistroFaturaRequisicao(dados, codigoFatura);
                                }
                            }
                            DadosExamePaiAgrupamento examePai = exame.getExamePai();
                            if (!exame.isDadosAlterados()) continue;
                            this.dao.atualizarTotaisFaturaExameRequisicao(dados, examePai, exame, codigoFatura);
                            this.dao.atualizarExamesExameRequisicao(dados, exame, examePai);
                            if (examePai == null || examePai.getCodigo().equalsIgnoreCase(exame.getCodigoExame())) continue;
                            this.dao.atualizarGuiaExameRequisicaoGuiaAgrupada(dados, exame, examePai);
                        }
                    }
                    for (int i = 0; i < dados.getExamesCount(); ++i) {
                        DadosExameFaturamento exm = dados.getExame(i);
                        ExportaFiliais.gravaRequisicao(dados.getCodigoFilial(), dados.getRequisicao(), exm.getCodigoExame(), exm.getCodigoMaterial(), "U", "U");
                    }
                }
                this.dao.atualizarDataFaturaRequisicao(dados);
                this.dao.inserirRegistroRequisicaoUsuario(dados);
            }
        }
    }

    public void atualizarExamesNoBancoDeDados(DadosFaturamento dados, String codigoFatura, Statement st) throws SQLException {
        ListaValoresExamesPai listaExamesPai = new ListaValoresExamesPai();
        listaExamesPai.clear();
        for (int j = 0; j < dados.getExamesCount(); ++j) {
            DadosExameFaturamento exame = dados.getExame(j);
            if (!exame.getFaturar()) {
                this.dao.apagarExameDafatura(st, dados, exame, codigoFatura);
            }
            DadosExamePaiAgrupamento examePai = exame.getExamePai();
            if (exame.isDadosAlterados()) {
                TabelaPrecoExameBean tabelaPreco = this.dao.pesquisarTabelaPrecoExame(dados.getCodigoFilial(), dados.getCodigoTabelaPreco());
                AbstractThreadBean detalheTabelaPreco = this.getDetalheTabelapreco(tabelaPreco, exame);
                this.atualizarExamesTabelaCbhpm(tabelaPreco, detalheTabelaPreco, exame);
                this.dao.atualizarFaturaExameRequisicao(j, st, exame, dados, codigoFatura);
                if (exame.getExamePai() == null || exame.getExamePai().getCodigo().equalsIgnoreCase(exame.getCodigoExame())) {
                    this.dao.atualizarExameRequisicao(st, dados, exame);
                } else {
                    listaExamesPai.adicionaValorExame(exame.getExamePai().getCodigo(), exame.getExamePai().getMaterial(), exame.getValorCHExame(), exame.getValorCH());
                }
                if (examePai != null && !examePai.getCodigo().equalsIgnoreCase(exame.getCodigoExame())) {
                    this.dao.atualizarExameRequisicaoGuiaAgrupada(exame, dados, st);
                }
            }
            if (!dados.isDadosAlterados() && !exame.isDadosAlterados()) continue;
            if (examePai != null) {
                ExportaFiliais.gravaRequisicao(dados.getCodigoFilial(), dados.getRequisicao(), examePai.getCodigo(), examePai.getMaterial(), "U", "U");
                continue;
            }
            ExportaFiliais.gravaRequisicao(dados.getCodigoFilial(), dados.getRequisicao(), exame.getCodigoExame(), exame.getCodigoMaterial(), "U", "U");
        }
        this.dao.atualizarExameRequisicaoExamePaiAgrupamento(dados, listaExamesPai.getLista(), st);
    }

    private AbstractThreadBean getDetalheTabelapreco(TabelaPrecoExameBean tabelaPreco, DadosExameFaturamento exame) throws SQLException {
        AbstractThreadBean detalheTabelaPreco = null;
        detalheTabelaPreco = ParametrosGerais.getPrecoMetodologia() ? this.dao.pesquisarDetalheTabelaPrecoMetodologia(tabelaPreco, exame.getCodigoExame(), exame.getCodigoMaterial(), exame.getCodigoMetodologia()) : this.dao.pesquisarDetalheTabelaPreco(tabelaPreco, exame.getCodigoExame(), exame.getCodigoMaterial());
        return detalheTabelaPreco;
    }

    private void atualizarExamesTabelaCbhpm(TabelaPrecoExameBean tabelaPreco, AbstractThreadBean detalheTabelaPreco, DadosExameFaturamento exame) {
        if (tabelaPreco.getTipoCbhpm().booleanValue()) {
            if (detalheTabelaPreco instanceof DetalheTabelaPrecoMetodologiaBean) {
                DetalheTabelaPrecoMetodologiaBean detalheTabelaPrecoMetodologia = (DetalheTabelaPrecoMetodologiaBean)detalheTabelaPreco;
                exame.setCustoCBHPM(BigDecimal.valueOf(detalheTabelaPrecoMetodologia.getValorCh()));
                exame.setUcoCBHPM(BigDecimal.valueOf(tabelaPreco.getUco()));
                exame.setPorteCBHPM(detalheTabelaPrecoMetodologia.getPorte().getCodigo());
                exame.setValorPorteCBHPM(BigDecimal.valueOf(detalheTabelaPrecoMetodologia.getPorte().getValor()));
            }
            if (detalheTabelaPreco instanceof DetalheTabelaPrecoBean) {
                DetalheTabelaPrecoBean dtpBean = (DetalheTabelaPrecoBean)detalheTabelaPreco;
                exame.setCustoCBHPM(BigDecimal.valueOf(dtpBean.getValorCh()));
                exame.setUcoCBHPM(BigDecimal.valueOf(tabelaPreco.getUco()));
                exame.setPorteCBHPM(dtpBean.getPorte().getCodigo());
                exame.setValorPorteCBHPM(BigDecimal.valueOf(dtpBean.getPorte().getValor()));
            }
        }
    }
}

