/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.financeiro.lancamentos.ReceberPagar;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.financeiro.BaixaBean;
import jalis.model.bean.financeiro.BaixaReceberPagarBean;
import jalis.model.bean.financeiro.FaturaBean;
import jalis.model.bean.financeiro.FaturaReceberPagarBean;
import jalis.model.bean.financeiro.ParcelamentoBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.bean.financeiro.ReceberPagarPlanoContaBean;
import jalis.model.bean.financeiro.ReceberPagarRPBean;
import jalis.model.dao.financeiro.ReceberPagarDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.financeiro.BaixaVO;
import jalis.model.vo.financeiro.FaturaVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.service.AbstractThreadService;
import jalis.service.financeiro.AgrupamentoService;
import jalis.service.financeiro.BaixaReceberPagarService;
import jalis.service.financeiro.BaixaService;
import jalis.service.financeiro.FaturaReceberPagarService;
import jalis.service.financeiro.FaturaService;
import jalis.service.financeiro.ParcelamentoService;
import jalis.service.financeiro.ReceberPagarPlanoContaService;
import jalis.service.financeiro.ReceberPagarRPService;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ReceberPagarService
extends AbstractThreadService {
    public ReceberPagarService() {
        this.dao = new ReceberPagarDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        Set planos = ((ReceberPagarBean)bean).getPlanosContas();
        if (planos != null) {
            Iterator it = planos.iterator();
            ReceberPagarPlanoContaService planoService = new ReceberPagarPlanoContaService();
            while (it.hasNext()) {
                ReceberPagarPlanoContaBean receber = (ReceberPagarPlanoContaBean)it.next();
                planoService.delete(receber, 2, filial, filiais);
            }
        }
        this.dao.delete(bean, filial);
    }

    public boolean isTituloAgrupador(String filial, String codigo) throws SQLException {
        return new AgrupamentoService().isTituloAgrupador(filial, codigo);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((ReceberPagarDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((ReceberPagarDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (((ReceberPagarBean)bean).getCodigo() == null) {
            ((ReceberPagarBean)bean).setCodigo((Integer)codigo);
        }
        if (((ReceberPagarBean)bean).getObservacao() != null) {
            ((ReceberPagarBean)bean).setObservacao(((ReceberPagarBean)bean).getObservacao().substring(0, ((ReceberPagarBean)bean).getObservacao().length() > 300 ? 300 : ((ReceberPagarBean)bean).getObservacao().length()));
        }
        this.dao.insert(bean, filial);
        Set planos = ((ReceberPagarBean)bean).getPlanosContas();
        if (planos != null) {
            Iterator it = planos.iterator();
            ReceberPagarPlanoContaService planoService = new ReceberPagarPlanoContaService();
            while (it.hasNext()) {
                ReceberPagarPlanoContaBean recpag = (ReceberPagarPlanoContaBean)it.next();
                recpag.setReceberPagar((ReceberPagarVO)((ReceberPagarBean)bean).toVO());
                if (recpag.isRemover()) {
                    planoService.delete(recpag, 2, filial, filiais);
                    continue;
                }
                if (recpag.isInserir()) {
                    planoService.insert(recpag, 0, filial, filiais);
                    continue;
                }
                if (!recpag.isAlterar()) continue;
                planoService.update(recpag, 1, filial, filiais);
            }
        }
        FinanceiroUtil.insertCentroCusto((AbstractThreadBean)((ReceberPagarBean)bean), filial, filiais);
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(ReceberPagarBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ReceberPagarVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return this.pesquisaVO(owner, bean, titulo, null, null, mostrarCadastro);
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, String tipo, String situacao, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(ReceberPagar.getModuloAcesso(), "Manuten\u00e7\u00e3o dos T\u00edtulos de Receber e Pagar");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("razaoSocial", "Raz\u00e3o Social / Nome", 0, "", 2, 0);
        tela.adicionaCampo("numeroDocumento", "N\u00famero Documento", 0, "", 2, 0);
        tela.adicionaCampo("vencimento", "Vencimento", 2, "", 3, 0);
        tela.adicionaCampo("valor", "Valor", 1, "", 3, 0);
        tela.setFiltroInicial("N\u00famero Documento", 2);
        StringBuilder filtro = new StringBuilder();
        filtro.append("fil_codigo = ").append(Variaveis.filialPadrao);
        if (!Funcoes.textoVazio(tipo)) {
            filtro.append(" and rpg_tipo = '").append(tipo).append("'");
        }
        if (!Funcoes.textoVazio(situacao)) {
            filtro.append(" and rpg_situacao = '").append(situacao).append("'");
        }
        tela.setFiltro(filtro.toString());
        tela.setColunaOrdenacao("Vencimento");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public Set pesquisaVOs(Object owner, AbstractThreadVO bean, String titulo, String tipo, String situacao, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.setTelaCadastro(ReceberPagar.getModuloAcesso(), "Manuten\u00e7\u00e3o dos T\u00edtulos de Receber e Pagar");
        tela.adicionaCampo("codigo", "Codigo", 1, "", 3, 75);
        tela.adicionaCampo("razaoSocial", "Raz\u00e3o Social / Nome", 0, "", 2, 0);
        tela.adicionaCampo("numeroDocumento", "N\u00famero Documento", 0, "", 2, 0);
        tela.adicionaCampo("vencimento", "Vencimento", 2, "", 3, 0);
        tela.adicionaCampo("valor", "Valor", 1, "", 3, 0);
        tela.setFiltroInicial("N\u00famero Documento", 2);
        StringBuilder filtro = new StringBuilder();
        filtro.append("fil_codigo = ").append(Variaveis.filialPadrao);
        if (!Funcoes.textoVazio(tipo)) {
            filtro.append(" and rpg_tipo = '").append(tipo).append("'");
        }
        if (!Funcoes.textoVazio(situacao)) {
            filtro.append(" and rpg_situacao = '").append(situacao).append("'");
        }
        tela.setFiltro(filtro.toString());
        tela.setColunaOrdenacao("Vencimento");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistrosSelecionados();
    }

    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais, boolean tituloRenegociado) throws Exception {
        this.updateComRetorno(bean, codigo, filial, filiais, tituloRenegociado);
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        this.updateComRetorno(bean, codigo, filial, filiais, false);
    }

    public AbstractThreadBean updateComRetorno(AbstractThreadBean bean, Object codigo, String filial, String filiais, boolean tituloRenegociado) throws Exception {
        ReceberPagarRPBean recPagRP;
        Integer codigoBaixa;
        ReceberPagarBean tituloAgrupador;
        ReceberPagarRPBean recPagRP2;
        ParcelamentoBean parcelaOriginal;
        ReceberPagarBean aux = (ReceberPagarBean)bean;
        ReceberPagarBean verificador = (ReceberPagarBean)this.get(filial, aux.getCodigo().toString());
        if (!aux.verificaCamposAlterados(verificador, filial)) {
            return aux;
        }
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        ReceberPagarBean clone = (ReceberPagarBean)aux.clonar();
        clone.setUsuario(usuario);
        clone.setNotaFiscal(aux.getNotaFiscal());
        clone.setCodigo(null);
        this.gravaAutoCopiaSemCommit(clone, 0, filial, filiais);
        Integer codigoAux = new ParcelamentoService().getCodigoTituloOriginal(String.valueOf(aux.getFilial().getCodigo()), String.valueOf(aux.getCodigo()));
        if (codigoAux != null) {
            ReceberPagarRPBean recPagRP3 = new ReceberPagarRPBean();
            ReceberPagarVO recPagVo = new ReceberPagarVO();
            recPagVo.setCodigo(codigoAux);
            recPagRP3.setFilialOrigem(aux.getFilial());
            recPagRP3.setReceberPagarOrigem(recPagVo);
            recPagRP3.setFilialDestino(clone.getFilial());
            recPagRP3.setReceberPagarDestino((ReceberPagarVO)clone.toVO());
            recPagRP3.setTipo("R");
            new ReceberPagarRPService().insert(recPagRP3, null, filial, filiais);
        }
        if ((parcelaOriginal = (ParcelamentoBean)new ParcelamentoService().get(String.valueOf(aux.getFilial().getCodigo()), String.valueOf(aux.getCodigo()))) != null) {
            recPagRP2 = new ReceberPagarRPBean();
            recPagRP2.setFilialOrigem(clone.getFilial());
            recPagRP2.setReceberPagarOrigem((ReceberPagarVO)clone.toVO());
            recPagRP2.setTipo("R");
            HashSet parcelas = (HashSet)new ParcelamentoService().getParcelas(String.valueOf(aux.getFilial().getCodigo()), String.valueOf(aux.getCodigo()));
            for (ReceberPagarBean auxBean : parcelas) {
                recPagRP2.setFilialDestino(auxBean.getFilial());
                recPagRP2.setReceberPagarDestino((ReceberPagarVO)auxBean.toVO());
                new ReceberPagarRPService().insert(recPagRP2, null, filial, filiais);
            }
        }
        if (new AgrupamentoService().isTituloAgrupador(String.valueOf(aux.getFilial().getCodigo()), String.valueOf(aux.getCodigo()))) {
            recPagRP2 = new ReceberPagarRPBean();
            recPagRP2.setFilialDestino(clone.getFilial());
            recPagRP2.setReceberPagarDestino((ReceberPagarVO)clone.toVO());
            recPagRP2.setTipo("R");
            HashSet titulosOriginais = (HashSet)new AgrupamentoService().getTitulosOriginais(String.valueOf(aux.getFilial().getCodigo()), String.valueOf(aux.getCodigo()));
            for (ReceberPagarBean auxBean : titulosOriginais) {
                recPagRP2.setFilialOrigem(auxBean.getFilial());
                recPagRP2.setReceberPagarOrigem((ReceberPagarVO)auxBean.toVO());
                new ReceberPagarRPService().insert(recPagRP2, 0, filial, filiais);
            }
        }
        if ((tituloAgrupador = new AgrupamentoService().getTituloAgrupador(String.valueOf(aux.getFilial().getCodigo()), String.valueOf(aux.getCodigo()))) != null) {
            ReceberPagarRPBean recPagRP4 = new ReceberPagarRPBean();
            recPagRP4.setFilialOrigem(clone.getFilial());
            recPagRP4.setReceberPagarOrigem((ReceberPagarVO)clone.toVO());
            recPagRP4.setFilialDestino(tituloAgrupador.getFilial());
            recPagRP4.setReceberPagarDestino((ReceberPagarVO)tituloAgrupador.toVO());
            recPagRP4.setTipo("R");
            new ReceberPagarRPService().insert(recPagRP4, 0, filial, filiais);
        }
        if ((codigoBaixa = new BaixaService().getCodigoBaixa(String.valueOf(aux.getFilial().getCodigo()), String.valueOf(aux.getCodigo()))) != null) {
            BaixaReceberPagarBean bxaTitulo = new BaixaReceberPagarBean();
            BaixaBean beanBaixa = new BaixaBean();
            beanBaixa.setFilial(aux.getFilial());
            beanBaixa.setCodigo(codigoBaixa);
            bxaTitulo.setFilial(clone.getFilial());
            bxaTitulo.setReceberPagar((ReceberPagarVO)clone.toVO());
            bxaTitulo.setBaixa((BaixaVO)beanBaixa.toVO());
            new BaixaReceberPagarService().insert(bxaTitulo, null, filial, filiais);
        }
        aux = verificador;
        if (tituloRenegociado) {
            recPagRP = new ReceberPagarRPBean();
            recPagRP.setFilialOrigem(aux.getFilial());
            recPagRP.setFilialDestino(clone.getFilial());
            recPagRP.setReceberPagarOrigem((ReceberPagarVO)aux.toVO());
            recPagRP.setReceberPagarDestino((ReceberPagarVO)clone.toVO());
            recPagRP.setTipo("R");
            new ReceberPagarRPService().insert(recPagRP, null, filial, filiais);
            aux.setSituacao("N");
            aux.setObservacao((aux.getObservacao() == null || Funcoes.textoVazio(aux.getObservacao()) ? "" : aux.getObservacao() + " - ") + "T\u00edtulo Cancelado por Renegocia\u00e7\u00e3o. Novo T\u00edtulo -> C\u00f3d:" + clone.getCodigo() + " Fil:" + clone.getFilial().getCodigo() + " - " + Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date()));
        } else {
            recPagRP = new ReceberPagarRPBean();
            recPagRP.setFilialOrigem(aux.getFilial());
            recPagRP.setFilialDestino(clone.getFilial());
            recPagRP.setReceberPagarOrigem((ReceberPagarVO)aux.toVO());
            recPagRP.setReceberPagarDestino((ReceberPagarVO)clone.toVO());
            recPagRP.setTipo("A");
            new ReceberPagarRPService().insert(recPagRP, null, filial, filiais);
            aux.setSituacao("R");
            aux.setObservacao((aux.getObservacao() == null || Funcoes.textoVazio(aux.getObservacao()) ? "" : aux.getObservacao() + " - ") + "T\u00edtulo Cancelado por Altera\u00e7\u00e3o. Novo T\u00edtulo -> C\u00f3d:" + clone.getCodigo() + " Fil:" + clone.getFilial().getCodigo() + " - " + Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date()));
        }
        if (aux.getObservacao().length() > 300) {
            aux.setObservacao(aux.getObservacao().substring(0, 300));
        }
        this.dao.update(aux, filial);
        if (((ReceberPagarBean)bean).getSituacao().equalsIgnoreCase("X") && aux.getOrigem().equalsIgnoreCase("C") && aux.getTipo().equalsIgnoreCase("P")) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select fat_codigo ");
            buf.append("   from faturareceberpagar ");
            buf.append("  where fil_codigo = ").append(aux.getFilial().getCodigo());
            buf.append("    and rpg_codigo = ").append(aux.getCodigo());
            buf.append("    and frp_tipo = '").append("C").append("' ");
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                String codigoFatura = rs.getString("fat_codigo");
                StringBuilder buf2 = new StringBuilder();
                buf2.append(" select rpg_codigo ");
                buf2.append("   from faturareceberpagar ");
                buf2.append("  where fil_codigo = ").append(aux.getFilial().getCodigo());
                buf2.append("    and fat_codigo = ").append(codigoFatura);
                buf2.append("    and frp_tipo = '").append("C").append("' ");
                ResultSet rsTit = Conexao.executeQuery(Conexao.getStatement(), buf2.toString());
                boolean podeDesmarcar = true;
                while (rsTit.next()) {
                    ReceberPagarVO titulo = new ReceberPagarService().getUltimoEstadoReceberPagar((ReceberPagarVO)new ReceberPagarService().getVO(aux.getFilial().getCodigo().toString(), rsTit.getString("rpg_codigo")));
                    if (titulo.getSituacao().equalsIgnoreCase("A") || titulo.getSituacao().equalsIgnoreCase("X")) continue;
                    podeDesmarcar = false;
                    break;
                }
                if (podeDesmarcar) {
                    rs.first();
                    FaturaService serviceFatura = new FaturaService();
                    do {
                        FaturaBean fatura = (FaturaBean)serviceFatura.get(aux.getFilial().getCodigo().toString(), rs.getString("fat_codigo"));
                        fatura.setCodigoUsuarioComissao(null);
                        fatura.setDataComissao(null);
                        serviceFatura.gravaAutoCopiaSemCommit(fatura, 1, fatura.getFilial().getCodigo().toString(), null);
                        FaturaReceberPagarBean fatRecPag = new FaturaReceberPagarBean();
                        fatRecPag.setFilial(fatura.getFilial());
                        fatRecPag.setFatura((FaturaVO)fatura.toVO());
                        fatRecPag.setReceberPagar((ReceberPagarVO)aux.toVO());
                        new FaturaReceberPagarService().delete(fatRecPag, null, fatRecPag.getFilial().getCodigo().toString(), null);
                    } while (rs.next());
                }
            }
        }
        return clone;
    }

    public String validaCamposPreenchidos(ReceberPagarBean bean) {
        if (bean != null) {
            if (bean.getTipo() == null) {
                return "tipo";
            }
            if (bean.getSerie() == null) {
                return "s\u00e9rie";
            }
            if (bean.getTipoCadastro() == null) {
                return "tipo cadastro";
            }
            if (bean.getEntidade() == null && bean.getConvenio() == null && bean.getPaciente() == null) {
                return "cadastro";
            }
            if (bean.getTipoDocumento() == null) {
                return "tipo documento";
            }
            if (bean.getDataCompetencia() == null) {
                return "data compet\u00eancia";
            }
            if (bean.getDataVencimento() == null) {
                return "data vencimento";
            }
            if (bean.getValor() == null) {
                return "valor";
            }
            if (bean.getParcela() == null) {
                return "parcela";
            }
            if (bean.getValorTotal() == null) {
                return "valor total";
            }
            return null;
        }
        return null;
    }

    public ReceberPagarVO getUltimoEstadoReceberPagar(ReceberPagarVO recPag) throws Exception {
        if (recPag != null && recPag.getSituacao() != null && (recPag.getSituacao().equalsIgnoreCase("R") || recPag.getSituacao().equalsIgnoreCase("N") || recPag.getSituacao().equalsIgnoreCase("E"))) {
            ArrayList<ReceberPagarRPBean> listaBean = new ReceberPagarRPService().get(recPag.getFilial().getCodigo().toString(), recPag.getCodigo().toString());
            if (listaBean == null) {
                return recPag;
            }
            ReceberPagarRPBean rpBean = null;
            for (int i = 0; i < listaBean.size(); ++i) {
                if (rpBean == null) {
                    rpBean = listaBean.get(i);
                    continue;
                }
                if (listaBean.get(i).getReceberPagarDestino().getSituacao().equalsIgnoreCase("L") || listaBean.get(i).getReceberPagarDestino().getSituacao().equalsIgnoreCase("G")) continue;
                rpBean = listaBean.get(i);
            }
            if (rpBean == null) {
                rpBean = listaBean.get(0);
            }
            return this.getUltimoEstadoReceberPagar(rpBean.getReceberPagarDestino());
        }
        return recPag;
    }

    public ArrayList<ReceberPagarBean> getPagarComissaoAssociado(ReceberPagarBean bean) throws Exception {
        ArrayList<ReceberPagarRPBean> lista = new ReceberPagarRPService().get(bean.getFilial().getCodigo().toString(), bean.getCodigo().toString());
        ArrayList<ReceberPagarBean> listaTitulos = null;
        if (lista != null) {
            listaTitulos = new ArrayList<ReceberPagarBean>();
            for (int i = 0; i < lista.size(); ++i) {
                ReceberPagarRPBean aux = lista.get(i);
                ReceberPagarBean recPag = (ReceberPagarBean)this.get(aux.getReceberPagarDestino().getFilial().getCodigo().toString(), aux.getReceberPagarDestino().getCodigo().toString());
                if (recPag == null || recPag.getTipo() == null || !recPag.getTipo().equalsIgnoreCase("P") || recPag.getOrigem() == null || !recPag.getOrigem().equalsIgnoreCase("C") || recPag.getSituacao() == null || recPag.getSituacao().equalsIgnoreCase("X") || !aux.getTipo().equalsIgnoreCase("C")) continue;
                listaTitulos.add(recPag);
            }
        }
        return listaTitulos;
    }

    public boolean isComissaoGerada(String filial, String codigoReceber, int codigoEntidade) throws Exception {
        ArrayList<ReceberPagarRPBean> lista = new ReceberPagarRPService().get(filial, codigoReceber);
        if (lista != null) {
            for (int i = 0; i < lista.size(); ++i) {
                ReceberPagarRPBean aux = lista.get(i);
                ReceberPagarBean recPag = (ReceberPagarBean)this.get(aux.getReceberPagarDestino().getFilial().getCodigo().toString(), aux.getReceberPagarDestino().getCodigo().toString());
                if (recPag == null || recPag.getTipo() == null || !recPag.getTipo().equalsIgnoreCase("P") || recPag.getOrigem() == null || !recPag.getOrigem().equalsIgnoreCase("C") || recPag.getSituacao() == null || recPag.getSituacao().equalsIgnoreCase("X") || !aux.getTipo().equalsIgnoreCase("C") || recPag.getEntidade() == null || recPag.getEntidade().getCodigo() != codigoEntidade) continue;
                return true;
            }
        }
        return false;
    }

    public Set<ReceberPagarBean> getReceberPagarNotaFiscal(String codigoFilial, String codigoNotaFiscal) throws ThreadDaoException {
        if (Funcoes.textoVazio(codigoFilial) || Funcoes.textoVazio(codigoNotaFiscal)) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" where fil_codigo = ").append(codigoFilial);
        buf.append("   and nfi_codigo = ").append(codigoNotaFiscal);
        buf.append("   and rpg_situacao NOT IN (");
        buf.append("'").append("N").append("', ");
        buf.append("'").append("C").append("', ");
        buf.append("'").append("R").append("', ");
        buf.append("'").append("L").append("', ");
        buf.append("'").append("G").append("', ");
        buf.append("'").append("E").append("', ");
        buf.append("'").append("X").append("') ");
        ReceberPagarDao cfr_ignored_0 = (ReceberPagarDao)this.dao;
        return ReceberPagarDao.load(ReceberPagarBean.class, buf.toString());
    }

    public boolean cancelarReceberPagar(String codigoFilial, String codigoReceberPagar, Date dataCancelamento, String usuarioCancelamento) throws SQLException {
        return ((ReceberPagarDao)this.dao).cancelarReceberPagar(codigoFilial, codigoReceberPagar, dataCancelamento, usuarioCancelamento);
    }
}

